/*
 * Decompiled with CFR 0.152.
 */
package lbms.plugins.mldht.kad.tasks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.SequencedCollection;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import lbms.plugins.mldht.kad.AnnounceNodeCache;
import lbms.plugins.mldht.kad.AnnounceResponseHandler;
import lbms.plugins.mldht.kad.DBItem;
import lbms.plugins.mldht.kad.DHT;
import lbms.plugins.mldht.kad.KBucketEntry;
import lbms.plugins.mldht.kad.KBucketEntryAndToken;
import lbms.plugins.mldht.kad.KClosestNodesSearch;
import lbms.plugins.mldht.kad.Key;
import lbms.plugins.mldht.kad.Node;
import lbms.plugins.mldht.kad.PeerAddressDBItem;
import lbms.plugins.mldht.kad.RPCCallBase;
import lbms.plugins.mldht.kad.RPCServerBase;
import lbms.plugins.mldht.kad.ScrapeResponseHandler;
import lbms.plugins.mldht.kad.messages.GetPeersRequest;
import lbms.plugins.mldht.kad.messages.GetPeersResponse;
import lbms.plugins.mldht.kad.messages.MessageBase;
import lbms.plugins.mldht.kad.tasks.Task;
import lbms.plugins.mldht.kad.utils.AddressUtils;
import lbms.plugins.mldht.kad.utils.PackUtil;

public class PeerLookupTask
extends Task {
    private boolean scrapeOnly;
    private boolean noSeeds;
    private boolean fastLookup;
    private List<KBucketEntryAndToken> announceCanidates = new ArrayList<KBucketEntryAndToken>(20);
    private AnnounceResponseHandler announceHandler;
    private ScrapeResponseHandler scrapeHandler;
    private Set<PeerAddressDBItem> returnedItems = new HashSet<PeerAddressDBItem>();
    private SortedSet<KBucketEntryAndToken> closestSet = new TreeSet<KBucketEntry>(new KBucketEntry.DistanceOrder(this.targetKey));
    private int validReponsesSinceLastClosestSetModification;
    AnnounceNodeCache cache;

    public PeerLookupTask(RPCServerBase rpc, Node node, Key info_hash) {
        super(info_hash, rpc, node);
        this.cache = rpc.getDHT().getCache();
        this.cache.register(this.targetKey);
        DHT.logDebug("PeerLookupTask started: " + this.getTaskID());
    }

    public void setScrapeHandler(ScrapeResponseHandler scrapeHandler) {
        this.scrapeHandler = scrapeHandler;
    }

    public void setAnounceHandler(AnnounceResponseHandler announceHandler) {
        this.announceHandler = announceHandler;
    }

    public void setNoSeeds(boolean avoidSeeds) {
        this.noSeeds = avoidSeeds;
    }

    public void setFastLookup(boolean isFastLookup) {
        if (!this.isQueued()) {
            throw new IllegalStateException("cannot change lookup mode after startup");
        }
        this.fastLookup = isFastLookup;
    }

    public void setScrapeOnly(boolean scrapeOnly) {
        this.scrapeOnly = scrapeOnly;
    }

    public boolean isScrapeOnly() {
        return this.scrapeOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void callFinished(RPCCallBase c, MessageBase rsp) {
        SequencedCollection<KBucketEntryAndToken> sequencedCollection;
        if (c.getMessageMethod() != MessageBase.Method.GET_PEERS) {
            return;
        }
        if (!(rsp instanceof GetPeersResponse)) {
            return;
        }
        GetPeersResponse gpr = (GetPeersResponse)rsp;
        DHT.DHTtype[] dHTtypeArray = DHT.DHTtype.values();
        int n = dHTtypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            DHT.DHTtype type = dHTtypeArray[n2];
            byte[] nodes = gpr.getNodes(type);
            if (nodes != null) {
                int nval = nodes.length / type.NODES_ENTRY_LENGTH;
                if (type == this.rpc.getDHT().getType()) {
                    SortedSet sortedSet = this.todo;
                    synchronized (sortedSet) {
                        int i = 0;
                        while (i < nval) {
                            KBucketEntry e = PackUtil.UnpackBucketEntry(nodes, i * type.NODES_ENTRY_LENGTH, type);
                            if (!(AddressUtils.isBogon(e.getAddress()) || this.node.allLocalIDs().contains(e.getID()) || this.visited.contains(e))) {
                                this.todo.add(e);
                            }
                            ++i;
                        }
                    }
                } else {
                    int i = 0;
                    while (i < nval) {
                        KBucketEntry e = PackUtil.UnpackBucketEntry(nodes, i * type.NODES_ENTRY_LENGTH, type);
                        DHT.getDHT(type).addDHTNode(e.getAddress().getAddress().getHostAddress(), e.getAddress().getPort());
                        ++i;
                    }
                }
            }
            ++n2;
        }
        List<DBItem> items = gpr.getPeerItems();
        boolean newItem = false;
        for (DBItem item : items) {
            PeerAddressDBItem it;
            if (!(item instanceof PeerAddressDBItem) || AddressUtils.isBogon(it = (PeerAddressDBItem)item) || !this.returnedItems.add(it)) continue;
            newItem = true;
        }
        KBucketEntry entry = new KBucketEntry(rsp.getOrigin(), rsp.getID());
        this.cache.add(entry);
        KBucketEntryAndToken toAdd = new KBucketEntryAndToken(entry, gpr.getToken());
        if (!items.isEmpty()) {
            if (this.scrapeHandler != null) {
                this.scrapeHandler.addGetPeersRespone(gpr);
            }
            if (this.announceHandler != null && newItem) {
                this.announceHandler.itemsUpdated(this);
            }
        }
        if (gpr.getToken() != null) {
            sequencedCollection = this.announceCanidates;
            synchronized (sequencedCollection) {
                this.announceCanidates.add(toAdd);
            }
        }
        if (this.scrapeOnly || gpr.getToken() != null) {
            sequencedCollection = this.closestSet;
            synchronized (sequencedCollection) {
                this.closestSet.add(toAdd);
                if (this.closestSet.size() > 8) {
                    KBucketEntryAndToken last = this.closestSet.last();
                    this.closestSet.remove(last);
                    this.validReponsesSinceLastClosestSetModification = toAdd == last ? ++this.validReponsesSinceLastClosestSetModification : 0;
                }
            }
        }
    }

    @Override
    void callTimeout(RPCCallBase c) {
        this.cache.removeEntry(c.getExpectedID());
    }

    @Override
    boolean canDoRequest() {
        if (this.scrapeOnly) {
            return this.getNumOutstandingRequestsExcludingStalled() < 3;
        }
        return super.canDoRequest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void update() {
        int waitingFor;
        SortedSet sortedSet = this.todo;
        synchronized (sortedSet) {
            this.todo.addAll(this.cache.get(this.targetKey, 3, this.visited));
            while (!this.todo.isEmpty() && this.canDoRequest() && this.validReponsesSinceLastClosestSetModification < 10) {
                KBucketEntry e = (KBucketEntry)this.todo.first();
                this.todo.remove(e);
                if (this.visited.contains(e)) continue;
                GetPeersRequest gpr = new GetPeersRequest(this.targetKey);
                gpr.setWant4(this.rpc.getDHT().getType() == DHT.DHTtype.IPV4_DHT || DHT.getDHT(DHT.DHTtype.IPV4_DHT).getNode().getNumEntriesInRoutingTable() < 30);
                gpr.setWant6(this.rpc.getDHT().getType() == DHT.DHTtype.IPV6_DHT || DHT.getDHT(DHT.DHTtype.IPV6_DHT).getNode().getNumEntriesInRoutingTable() < 30);
                gpr.setDestination(e.getAddress());
                gpr.setScrape(true);
                gpr.setNoSeeds(this.noSeeds);
                this.rpcCall(gpr, e.getID());
                this.visited.add(e);
            }
        }
        int n = waitingFor = this.fastLookup ? this.getNumOutstandingRequestsExcludingStalled() : this.getNumOutstandingRequests();
        if (this.todo.isEmpty() && waitingFor == 0 && !this.isFinished()) {
            this.done();
        } else if (waitingFor == 0 && this.validReponsesSinceLastClosestSetModification >= 10) {
            this.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void done() {
        super.done();
        if (this.validReponsesSinceLastClosestSetModification >= 10) {
            SortedSet<KBucketEntryAndToken> sortedSet = this.closestSet;
            synchronized (sortedSet) {
                TreeSet<Key> toEstimate = new TreeSet<Key>();
                for (KBucketEntryAndToken e : this.closestSet) {
                    toEstimate.add(e.getID());
                }
                this.rpc.getDHT().getEstimator().update(toEstimate);
            }
        }
    }

    public List<KBucketEntryAndToken> getAnnounceCanidates() {
        if (this.fastLookup) {
            throw new IllegalStateException("cannot use fast lookups for announces");
        }
        return this.announceCanidates;
    }

    public Set<PeerAddressDBItem> getReturnedItems() {
        return Collections.unmodifiableSet(this.returnedItems);
    }

    public Key getInfoHash() {
        return this.targetKey;
    }

    @Override
    public void start() {
        KClosestNodesSearch kns = new KClosestNodesSearch(this.targetKey, 32, this.rpc.getDHT());
        kns.fill();
        this.todo.addAll(kns.getEntries());
        this.cache.register(this.targetKey);
        this.todo.addAll(this.cache.get(this.targetKey, 20, Collections.EMPTY_SET));
        super.start();
    }
}

