/*
 * Decompiled with CFR 0.152.
 */
package lbms.plugins.mldht.kad.tasks;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import lbms.plugins.mldht.kad.DHT;
import lbms.plugins.mldht.kad.KBucketEntry;
import lbms.plugins.mldht.kad.Key;
import lbms.plugins.mldht.kad.Node;
import lbms.plugins.mldht.kad.RPCCall;
import lbms.plugins.mldht.kad.RPCCallBase;
import lbms.plugins.mldht.kad.RPCCallListener;
import lbms.plugins.mldht.kad.RPCServerBase;
import lbms.plugins.mldht.kad.messages.MessageBase;
import lbms.plugins.mldht.kad.tasks.TaskListener;

public abstract class Task
implements RPCCallListener {
    protected Set<KBucketEntry> visited;
    protected SortedSet<KBucketEntry> todo;
    protected Node node;
    protected Key targetKey;
    protected String info;
    protected RPCServerBase rpc;
    private AtomicInteger outstandingRequestsExcludingStalled = new AtomicInteger();
    private AtomicInteger outstandingRequests = new AtomicInteger();
    private int sentReqs;
    private int recvResponses;
    private int failedReqs;
    private int taskID;
    private boolean taskFinished;
    private boolean queued;
    private List<TaskListener> listeners;
    private ScheduledFuture<?> timeoutTimer;

    Task(Key target, RPCServerBase rpc, Node node) {
        this.targetKey = target;
        this.rpc = rpc;
        this.node = node;
        this.queued = true;
        this.todo = new TreeSet<KBucketEntry>(new KBucketEntry.DistanceOrder(this.targetKey));
        this.visited = new KBucketEntry.BucketSet();
        this.taskFinished = false;
    }

    Task(Key target, RPCServerBase rpc, Node node, String info) {
        this(target, rpc, node);
        this.info = info;
    }

    public RPCServerBase getRPC() {
        return this.rpc;
    }

    @Override
    public void onResponse(RPCCallBase c, MessageBase rsp) {
        if (!c.wasStalled()) {
            this.outstandingRequestsExcludingStalled.decrementAndGet();
        }
        this.outstandingRequests.decrementAndGet();
        ++this.recvResponses;
        if (!this.isFinished()) {
            this.callFinished(c, rsp);
            if (this.canDoRequest() && !this.isFinished()) {
                this.update();
            }
        }
    }

    @Override
    public void onStall(RPCCallBase c) {
        this.outstandingRequestsExcludingStalled.decrementAndGet();
        if (!this.isFinished()) {
            this.callStalled(c);
        }
        if (this.canDoRequest() && !this.isFinished()) {
            this.update();
        }
    }

    @Override
    public void onTimeout(RPCCallBase c) {
        if (!c.wasStalled()) {
            this.outstandingRequestsExcludingStalled.decrementAndGet();
        }
        this.outstandingRequests.decrementAndGet();
        ++this.failedReqs;
        if (!this.isFinished()) {
            this.callTimeout(c);
            if (this.canDoRequest() && !this.isFinished()) {
                this.update();
            }
        }
    }

    public void start() {
        if (this.queued) {
            DHT.logDebug("Starting Task: " + this.getClass().getSimpleName() + " TaskID:" + this.taskID);
            this.queued = false;
            this.startTimeout();
            try {
                this.update();
            }
            catch (Exception e) {
                DHT.log(e, DHT.LogLevel.Error);
            }
        }
    }

    abstract void update();

    abstract void callFinished(RPCCallBase var1, MessageBase var2);

    void callStalled(RPCCallBase c) {
    }

    abstract void callTimeout(RPCCallBase var1);

    boolean rpcCall(MessageBase req, Key expectedID) {
        if (!this.canDoRequest()) {
            return false;
        }
        RPCCall c = this.rpc.doCall(req);
        c.setExpectedID(expectedID);
        c.addListener(this);
        this.outstandingRequestsExcludingStalled.incrementAndGet();
        this.outstandingRequests.incrementAndGet();
        ++this.sentReqs;
        return true;
    }

    boolean canDoRequest() {
        return this.rpc.isRunning() && this.outstandingRequestsExcludingStalled.get() < 10;
    }

    boolean hasUnfinishedRequests() {
        return this.outstandingRequests.get() > 0;
    }

    public boolean isFinished() {
        return this.taskFinished;
    }

    void setTaskID(int tid) {
        this.taskID = tid;
    }

    public int getTaskID() {
        return this.taskID;
    }

    public int getFailedReqs() {
        return this.failedReqs;
    }

    public int getRecvResponses() {
        return this.recvResponses;
    }

    public int getSentReqs() {
        return this.sentReqs;
    }

    public int getTodoCount() {
        return this.todo.size();
    }

    public Key getTargetKey() {
        return this.targetKey;
    }

    public String getInfo() {
        return this.info;
    }

    public void setInfo(String info) {
        this.info = info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToTodo(KBucketEntry e) {
        SortedSet<KBucketEntry> sortedSet = this.todo;
        synchronized (sortedSet) {
            this.todo.add(e);
        }
    }

    public int getNumOutstandingRequestsExcludingStalled() {
        return this.outstandingRequestsExcludingStalled.get();
    }

    public int getNumOutstandingRequests() {
        return this.outstandingRequests.get();
    }

    public boolean isQueued() {
        return this.queued;
    }

    public void kill() {
        this.finished();
    }

    private void startTimeout() {
        this.timeoutTimer = DHT.getScheduler().schedule(new Runnable(){

            @Override
            public void run() {
                if (!Task.this.taskFinished) {
                    DHT.logDebug("Task was Killed by Timeout. TaskID: " + Task.this.taskID);
                    Task.this.kill();
                }
            }
        }, 120000L, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDHTNode(InetAddress ip, int port) {
        InetSocketAddress addr = new InetSocketAddress(ip, port);
        SortedSet<KBucketEntry> sortedSet = this.todo;
        synchronized (sortedSet) {
            this.todo.add(new KBucketEntry(addr, Key.createRandomKey()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finished() {
        Task task2 = this;
        synchronized (task2) {
            if (this.taskFinished) {
                return;
            }
            this.taskFinished = true;
        }
        DHT.logDebug("Task finished: " + this.getTaskID());
        if (this.timeoutTimer != null) {
            this.timeoutTimer.cancel(false);
        }
        if (this.listeners != null) {
            for (TaskListener tl : this.listeners) {
                tl.finished(this);
            }
        }
    }

    protected void done() {
        this.finished();
    }

    public void addListener(TaskListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<TaskListener>(1);
        }
        if (this.taskFinished) {
            listener.finished(this);
        }
        this.listeners.add(listener);
    }

    public void removeListener(TaskListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }
}

