/*
 * Decompiled with CFR 0.152.
 */
package lbms.plugins.mldht.kad.utils;

import java.util.Arrays;
import java.util.HashMap;
import org.gudy.azureus2.core3.util.BEncoder;

public abstract class Token {
    public abstract Object getValue();

    public static class OurToken
    extends Token {
        private final byte[] value;
        private final int hash;

        public OurToken(byte[] _value) {
            this.value = _value;
            this.hash = Arrays.hashCode(this.value);
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (obj instanceof OurToken) {
                byte[] other_value = ((OurToken)obj).value;
                return Arrays.equals(this.value, other_value);
            }
            return false;
        }
    }

    public static class TheirToken
    extends Token {
        private final Object value;
        private final int hash;

        public TheirToken(Object _value) {
            this.value = _value;
            if (this.value instanceof byte[]) {
                this.hash = Arrays.hashCode((byte[])this.value);
            } else {
                int _hash;
                HashMap<String, Object> temp = new HashMap<String, Object>();
                temp.put("v", this.value);
                try {
                    _hash = Arrays.hashCode(BEncoder.encode(temp));
                }
                catch (Throwable e) {
                    _hash = 0;
                }
                this.hash = _hash;
            }
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (obj instanceof TheirToken) {
                Object other_value = ((TheirToken)obj).value;
                if (this.value instanceof byte[] && other_value instanceof byte[]) {
                    return Arrays.equals((byte[])this.value, (byte[])other_value);
                }
                return BEncoder.objectsAreIdentical(this.value, other_value);
            }
            return false;
        }
    }
}

