/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.ipfilter.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.ipfilter.BadIps;
import org.gudy.azureus2.core3.ipfilter.IpFilter;
import org.gudy.azureus2.core3.ipfilter.IpFilterManager;
import org.gudy.azureus2.core3.ipfilter.IpRange;
import org.gudy.azureus2.core3.ipfilter.impl.BadIpsImpl;
import org.gudy.azureus2.core3.ipfilter.impl.IpFilterImpl;
import org.gudy.azureus2.core3.ipfilter.impl.IpRangeImpl;
import org.gudy.azureus2.core3.util.FileUtil;

public class IpFilterManagerImpl
implements IpFilterManager,
ParameterListener {
    protected static IpFilterManagerImpl singleton = new IpFilterManagerImpl();
    private RandomAccessFile rafDescriptions = null;

    public IpFilterManagerImpl() {
        COConfigurationManager.addAndFireParameterListener("Ip Filter Enable Description Cache", this);
    }

    @Override
    public Object addDescription(IpRange range, byte[] description) {
        int len;
        int start;
        block9: {
            block8: {
                if (this.rafDescriptions == null) {
                    return null;
                }
                try {
                    if (description != null && description.length != 0) break block8;
                    return null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
            start = (int)this.rafDescriptions.getFilePointer();
            len = (int)this.rafDescriptions.length();
            if (len + 61 < 0x1FFFFFF) break block9;
            return null;
        }
        if (start != len) {
            this.rafDescriptions.seek(len);
            start = (int)this.rafDescriptions.getFilePointer();
        }
        if (description.length <= 61) {
            this.rafDescriptions.write(description);
        } else {
            this.rafDescriptions.write(description, 0, 61);
        }
        int end = (int)this.rafDescriptions.getFilePointer();
        int info = start + (end - start << 25);
        return new Integer(info);
    }

    @Override
    public byte[] getDescription(Object info) {
        if (info instanceof Object[]) {
            return (byte[])((Object[])info)[0];
        }
        if (this.rafDescriptions == null || !(info instanceof Integer)) {
            return "".getBytes();
        }
        try {
            int posInfo = (Integer)info;
            int pos = posInfo & 0x1FFFFFF;
            int len = posInfo >> 25;
            if (len < 0) {
                throw new IllegalArgumentException(String.valueOf(this.getClass().getName()) + ": invalid posInfo [" + posInfo + "], pos [" + pos + "], len [" + len + "]");
            }
            if (this.rafDescriptions.getFilePointer() != (long)pos) {
                this.rafDescriptions.seek(pos);
            }
            byte[] bytes = new byte[len];
            this.rafDescriptions.read(bytes);
            return bytes;
        }
        catch (IOException e) {
            return "".getBytes();
        }
    }

    @Override
    public void cacheAllDescriptions() {
        IpRange[] ranges = this.getIPFilter().getRanges();
        int i = 0;
        while (i < ranges.length) {
            Object info = ((IpRangeImpl)ranges[i]).getDescRef();
            if (info instanceof Integer) {
                byte[] desc = this.getDescription(info);
                Object[] data = new Object[]{desc, info};
                ((IpRangeImpl)ranges[i]).setDescRef(data);
            }
            ++i;
        }
    }

    @Override
    public void clearDescriptionCache() {
        IpRange[] ranges = this.getIPFilter().getRanges();
        int i = 0;
        while (i < ranges.length) {
            Object info = ((IpRangeImpl)ranges[i]).getDescRef();
            if (info instanceof Object[]) {
                Integer data = (Integer)((Object[])info)[1];
                ((IpRangeImpl)ranges[i]).setDescRef(data);
            }
            ++i;
        }
    }

    @Override
    public void deleteAllDescriptions() {
        if (this.rafDescriptions != null) {
            try {
                this.rafDescriptions.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.rafDescriptions = null;
        }
        this.parameterChanged(null);
    }

    public static IpFilterManager getSingleton() {
        return singleton;
    }

    @Override
    public IpFilter getIPFilter() {
        return IpFilterImpl.getInstance();
    }

    @Override
    public BadIps getBadIps() {
        return BadIpsImpl.getInstance();
    }

    @Override
    public void parameterChanged(String parameterName) {
        boolean enable = COConfigurationManager.getBooleanParameter("Ip Filter Enable Description Cache");
        if (enable && this.rafDescriptions == null) {
            File fDescriptions = FileUtil.getUserFile("ipfilter.cache");
            try {
                if (fDescriptions.exists()) {
                    fDescriptions.delete();
                }
                this.rafDescriptions = new RandomAccessFile(fDescriptions, "rw");
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        } else if (!enable && this.rafDescriptions != null) {
            try {
                this.rafDescriptions.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.rafDescriptions = null;
        }
    }
}

