/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.client.impl.bt;

import com.aelitis.azureus.core.networkmanager.impl.udp.UDPNetworkManager;
import com.aelitis.azureus.core.proxy.AEProxyFactory;
import com.aelitis.azureus.util.MapUtils;
import com.aelitis.net.udp.uc.PRUDPPacketHandlerException;
import com.aelitis.net.udp.uc.PRUDPPacketHandlerFactory;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.security.SESecurityManager;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperClientResolver;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.core3.tracker.client.impl.TRTrackerScraperImpl;
import org.gudy.azureus2.core3.tracker.client.impl.TRTrackerScraperResponseImpl;
import org.gudy.azureus2.core3.tracker.client.impl.bt.TRTrackerBTAnnouncerImpl;
import org.gudy.azureus2.core3.tracker.client.impl.bt.TRTrackerBTScraperResponseImpl;
import org.gudy.azureus2.core3.tracker.client.impl.bt.TrackerChecker;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyConnect;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyError;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyScrape;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyScrape2;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketRequestConnect;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketRequestScrape;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketTracker;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPTrackerCodecs;
import org.gudy.azureus2.core3.tracker.util.TRTrackerUtils;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AddressUtils;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.BEncodingException;
import org.gudy.azureus2.core3.util.ByteEncodedKeyHashMap;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.StringInterner;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.ThreadPool;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.clientid.ClientIDException;
import org.gudy.azureus2.pluginsimpl.local.clientid.ClientIDManagerImpl;

public class TrackerStatus {
    private static final LogIDs LOGID = LogIDs.TRACKER;
    private static final String SS = "Scrape.status.";
    private static final String SSErr = "Scrape.status.error.";
    private static final int FAULTY_SCRAPE_RETRY_INTERVAL = 600000;
    private static final int NOHASH_RETRY_INTERVAL = 10800000;
    private static final int GROUP_SCRAPES_MS = 900000;
    private static final int GROUP_SCRAPES_LIMIT = 20;
    private static boolean tcpScrapeEnabled;
    private static boolean udpScrapeEnabled;
    private static boolean udpProbeEnabled;
    private byte autoUDPscrapeEvery = 1;
    private int scrapeCount;
    private static List logged_invalid_urls;
    private static ThreadPool thread_pool;
    private final URL tracker_url;
    private boolean az_tracker;
    private boolean enable_sni_hack;
    private boolean internal_error_hack;
    private boolean dh_hack;
    private String scrapeURL = null;
    private HashMap<HashWrapper, TRTrackerScraperResponseImpl> hashes;
    private TRTrackerScraperImpl scraper;
    private boolean bSingleHashScrapes = false;
    protected AEMonitor hashes_mon = new AEMonitor("TrackerStatus:hashes");
    private final TrackerChecker checker;
    private final AtomicInteger numActiveScrapes = new AtomicInteger(0);

    static {
        PRUDPTrackerCodecs.registerCodecs();
        COConfigurationManager.addAndFireParameterListeners(new String[]{"Tracker Client Enable TCP", "Server Enable UDP", "Tracker UDP Probe Enable"}, new ParameterListener(){

            @Override
            public void parameterChanged(String parameterName) {
                tcpScrapeEnabled = COConfigurationManager.getBooleanParameter("Tracker Client Enable TCP");
                udpScrapeEnabled = COConfigurationManager.getBooleanParameter("Server Enable UDP");
                udpProbeEnabled = COConfigurationManager.getBooleanParameter("Tracker UDP Probe Enable");
            }
        });
        logged_invalid_urls = new ArrayList();
        thread_pool = new ThreadPool("TrackerStatus", 10, true);
    }

    public TrackerStatus(TrackerChecker _checker, TRTrackerScraperImpl _scraper, URL _tracker_url) {
        this.checker = _checker;
        this.scraper = _scraper;
        this.tracker_url = _tracker_url;
        this.az_tracker = TRTrackerUtils.isAZTracker(this.tracker_url);
        this.bSingleHashScrapes = COConfigurationManager.getBooleanParameter("Tracker Client Scrape Single Only");
        String trackerUrl = this.tracker_url.toString();
        this.hashes = new HashMap();
        try {
            trackerUrl = trackerUrl.replaceAll(" ", "");
            String lc_trackerUrl = trackerUrl.toLowerCase(Locale.US);
            int position = trackerUrl.lastIndexOf(47);
            if (position >= 0 && trackerUrl.length() >= position + 9 && trackerUrl.substring(position + 1, position + 9).equals("announce")) {
                this.scrapeURL = String.valueOf(trackerUrl.substring(0, position + 1)) + "scrape" + trackerUrl.substring(position + 9);
            } else if (lc_trackerUrl.startsWith("udp:")) {
                this.scrapeURL = trackerUrl;
            } else if (lc_trackerUrl.startsWith("ws:") || lc_trackerUrl.startsWith("wss:")) {
                this.scrapeURL = trackerUrl;
                this.bSingleHashScrapes = true;
            } else if (position >= 0 && trackerUrl.lastIndexOf(46) < position) {
                this.scrapeURL = String.valueOf(trackerUrl) + (trackerUrl.endsWith("/") ? "" : "/") + "scrape";
            } else if (!logged_invalid_urls.contains(trackerUrl)) {
                logged_invalid_urls.add(trackerUrl);
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    protected boolean isTrackerScrapeUrlValid() {
        return this.scrapeURL != null;
    }

    protected TRTrackerScraperResponseImpl getHashData(HashWrapper hash) {
        try {
            this.hashes_mon.enter();
            TRTrackerScraperResponseImpl tRTrackerScraperResponseImpl = this.hashes.get(hash);
            return tRTrackerScraperResponseImpl;
        }
        finally {
            this.hashes_mon.exit();
        }
    }

    protected void updateSingleHash(HashWrapper hash, boolean force) {
        this.updateSingleHash(hash, force, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void updateSingleHash(HashWrapper hash, boolean force, boolean async) {
        if (this.scrapeURL == null) {
            if (!Logger.isEnabled()) return;
            Logger.log(new LogEvent(TorrentUtils.getDownloadManager(hash), LOGID, "TrackerStatus: " + this.scrapeURL + ": scrape cancelled.. url null"));
            return;
        }
        try {
            TRTrackerScraperResponseImpl response;
            ArrayList<TRTrackerScraperResponseImpl> responsesToUpdate = new ArrayList<TRTrackerScraperResponseImpl>();
            try {
                this.hashes_mon.enter();
                response = this.hashes.get(hash);
            }
            finally {
                this.hashes_mon.exit();
            }
            if (response == null) {
                response = this.addHash(hash);
            }
            long lMainNextScrapeStartTime = response.getNextScrapeStartTime();
            if (!force && lMainNextScrapeStartTime > SystemTime.getCurrentTime()) {
                if (!Logger.isEnabled()) return;
                Logger.log(new LogEvent(TorrentUtils.getDownloadManager(hash), LOGID, "TrackerStatus: " + this.scrapeURL + ": scrape cancelled.. not forced and still " + (lMainNextScrapeStartTime - SystemTime.getCurrentTime()) + "ms"));
                return;
            }
            response.setStatus(3, MessageText.getString("Scrape.status.scraping.queued"));
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(TorrentUtils.getDownloadManager(hash), LOGID, "TrackerStatus: " + this.scrapeURL + ": setting to scraping"));
            }
            responsesToUpdate.add(response);
            if (!this.bSingleHashScrapes) {
                try {
                    this.hashes_mon.enter();
                    Iterator<TRTrackerScraperResponseImpl> iterHashes = this.hashes.values().iterator();
                    while (iterHashes.hasNext() && responsesToUpdate.size() < 20) {
                        long lTimeDiff;
                        TRTrackerScraperResponseImpl r = iterHashes.next();
                        if (r.getHash().equals(hash) || (lTimeDiff = Math.abs(lMainNextScrapeStartTime - r.getNextScrapeStartTime())) > 900000L || r.getStatus() == 3) continue;
                        r.setStatus(3, MessageText.getString("Scrape.status.scraping.queued"));
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(TorrentUtils.getDownloadManager(r.getHash()), LOGID, "TrackerStatus:" + this.scrapeURL + ": setting to scraping via group scrape"));
                        }
                        responsesToUpdate.add(r);
                    }
                }
                finally {
                    this.hashes_mon.exit();
                }
            }
            this.runScrapes(responsesToUpdate, force, async);
            return;
        }
        catch (Throwable t) {
            Debug.out("updateSingleHash() exception", t);
        }
    }

    protected void runScrapes(final ArrayList<TRTrackerScraperResponseImpl> responses, final boolean force, boolean async) {
        this.numActiveScrapes.incrementAndGet();
        if (async) {
            thread_pool.run(new AERunnable(){

                @Override
                public void runSupport() {
                    TrackerStatus.this.runScrapesSupport(responses, force);
                }
            });
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "TrackerStatus: queuing '" + this.scrapeURL + "', for " + responses.size() + " of " + this.hashes.size() + " hashes" + ", single_hash_scrapes: " + (this.bSingleHashScrapes ? "Y" : "N") + ", queue size=" + thread_pool.getQueueSize()));
            }
        } else {
            this.runScrapesSupport(responses, force);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void runScrapesSupport(ArrayList<TRTrackerScraperResponseImpl> allResponses, boolean force) {
        block81: {
            block79: {
                block80: {
                    block77: {
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(TrackerStatus.LOGID, "TrackerStatus: scraping '" + this.scrapeURL + "', for " + allResponses.size() + " of " + this.hashes.size() + " hashes" + ", single_hash_scrapes: " + (this.bSingleHashScrapes != false ? "Y" : "N")));
                        }
                        original_bSingleHashScrapes = this.bSingleHashScrapes;
                        disable_all_scrapes = COConfigurationManager.getBooleanParameter("Tracker Client Scrape Enable") == false;
                        scrape_reply = null;
                        hashesInQuery = new ArrayList<HashWrapper>(allResponses.size());
                        responsesInQuery = new ArrayList<TRTrackerScraperResponseImpl>(allResponses.size());
                        hashesForUDP = new ArrayList<HashWrapper>();
                        responsesForUDP = new ArrayList<TRTrackerScraperResponseImpl>();
                        activeResponses = responsesInQuery;
                        one_of_the_hashes = null;
                        first_separator = this.scrapeURL.indexOf(63) == -1 ? '?' : '&';
                        info_hash = "";
                        flags = "";
                        for (TRTrackerScraperResponseImpl response : allResponses) {
                            hash = response.getHash();
                            if (Logger.isEnabled()) {
                                Logger.log(new LogEvent(TorrentUtils.getDownloadManager(hash), TrackerStatus.LOGID, "TrackerStatus: " + this.scrapeURL + ": scraping, single_hash_scrapes = " + this.bSingleHashScrapes));
                            }
                            if (!this.scraper.isNetworkEnabled(hash, this.tracker_url)) {
                                response.setNextScrapeStartTime(SystemTime.getCurrentTime() + 600000L);
                                response.setStatus(1, MessageText.getString("Scrape.status.networkdisabled"));
                                this.scraper.scrapeReceived(response);
                                continue;
                            }
                            if (!(force || !disable_all_scrapes && this.scraper.isTorrentScrapable(hash))) {
                                response.setNextScrapeStartTime(SystemTime.getCurrentTime() + 600000L);
                                response.setStatus(1, MessageText.getString("Scrape.status.disabled"));
                                this.scraper.scrapeReceived(response);
                                continue;
                            }
                            hashesInQuery.add(hash);
                            responsesInQuery.add(response);
                            response.setStatus(3, MessageText.getString("Scrape.status.scraping"));
                            this.scraper.scrapeReceived(response);
                            info_hash = String.valueOf(info_hash) + (one_of_the_hashes != null ? '&' : first_separator) + "info_hash=";
                            info_hash = String.valueOf(info_hash) + URLEncoder.encode(new String(hash.getBytes(), "ISO-8859-1"), "ISO-8859-1").replaceAll("\\+", "%20");
                            extensions = this.scraper.getExtensions(hash);
                            if (extensions != null) {
                                if (extensions[0] != null) {
                                    info_hash = String.valueOf(info_hash) + (String)extensions[0];
                                }
                                flags = String.valueOf(flags) + (Character)extensions[1];
                            } else {
                                flags = String.valueOf(flags) + TRTrackerScraperClientResolver.FL_NONE;
                            }
                            one_of_the_hashes = hash;
                            if (hashesForUDP.size() >= 70) continue;
                            hashesForUDP.add(hash);
                            responsesForUDP.add(response);
                        }
                        if (one_of_the_hashes != null) break block77;
                        this.numActiveScrapes.decrementAndGet();
                        return;
                    }
                    request = String.valueOf(this.scrapeURL) + (String)info_hash;
                    if (this.az_tracker) {
                        port_details = TRTrackerUtils.getPortsForURL();
                        request = String.valueOf(request) + port_details;
                        request = String.valueOf(request) + "&azsf=" + flags + "&azver=" + 3;
                    }
                    reqUrl = new URL(request);
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(TrackerStatus.LOGID, "Accessing scrape interface using url : " + reqUrl));
                    }
                    message = new ByteArrayOutputStream();
                    scrapeStartTime = SystemTime.getCurrentTime();
                    redirect_url = null;
                    protocol = reqUrl.getProtocol();
                    udpScrapeURL = null;
                    auto_probe = false;
                    if (!protocol.equalsIgnoreCase("udp")) ** GOTO lbl78
                    if (TrackerStatus.udpScrapeEnabled) {
                        udpScrapeURL = reqUrl;
                    } else {
                        throw new IOException("UDP Tracker protocol disabled");
lbl78:
                        // 1 sources

                        if (protocol.equalsIgnoreCase("http") && !this.az_tracker && this.scrapeCount % this.autoUDPscrapeEvery == 0 && TrackerStatus.udpProbeEnabled && TrackerStatus.udpScrapeEnabled && (tracker_network = AENetworkClassifier.categoriseAddress(reqUrl.getHost())) == "Public") {
                            udpScrapeURL = new URL(reqUrl.toString().replaceFirst("^http", "udp"));
                            auto_probe = true;
                        }
                    }
                    if (udpScrapeURL == null && !this.az_tracker && !TrackerStatus.tcpScrapeEnabled && (tracker_network = AENetworkClassifier.categoriseAddress(reqUrl.getHost())) == "Public") {
                        throw new IOException("HTTP Tracker protocol disabled");
                    }
                    try {
                        TorrentUtils.setTLSTorrentHash(one_of_the_hashes);
                        if (udpScrapeURL != null) {
                            activeResponses = responsesForUDP;
                            success = this.scrapeUDP(reqUrl, message, hashesForUDP, auto_probe == false);
                            if (!(success && message.size() != 0 || protocol.equalsIgnoreCase("udp"))) {
                                udpScrapeURL = null;
                                message.reset();
                                if (this.autoUDPscrapeEvery < 16) {
                                    this.autoUDPscrapeEvery = (byte)(this.autoUDPscrapeEvery << 1);
                                }
                                if (Logger.isEnabled()) {
                                    Logger.log(new LogEvent(TrackerStatus.LOGID, 0, "redirection of http scrape [" + this.scrapeURL + "] to udp failed, will retry in " + this.autoUDPscrapeEvery + " scrapes"));
                                }
                            } else if (success && !protocol.equalsIgnoreCase("udp")) {
                                if (Logger.isEnabled()) {
                                    Logger.log(new LogEvent(TrackerStatus.LOGID, 0, "redirection of http scrape [" + this.scrapeURL + "] to udp successful"));
                                }
                                this.autoUDPscrapeEvery = 1;
                                TRTrackerUtils.setUDPProbeResult(reqUrl, true);
                            }
                        }
                        ++this.scrapeCount;
                        if (udpScrapeURL == null) {
                            activeResponses = responsesInQuery;
                            redirect_url = this.scrapeHTTP(hashesInQuery, reqUrl, message);
                        }
                    }
                    finally {
                        TorrentUtils.setTLSTorrentHash(null);
                    }
                    scrape_reply = message.toByteArray();
                    map = BDecoder.decode(scrape_reply);
                    v0 = this_is_az_tracker = map.get("aztracker") != null;
                    if (this.az_tracker != this_is_az_tracker) {
                        this.az_tracker = this_is_az_tracker;
                        TRTrackerUtils.setAZTracker(this.tracker_url, this.az_tracker);
                    }
                    mapFiles = (Map)map.get("files");
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(TrackerStatus.LOGID, "Response from scrape interface " + this.scrapeURL + ": " + (mapFiles == null ? "null" : "" + mapFiles.size()) + " returned"));
                    }
                    iMinRequestInterval = 0;
                    if (map != null && (mapFlags = (Map)map.get("flags")) != null) {
                        longScrapeValue = (Long)mapFlags.get("min_request_interval");
                        if (longScrapeValue != null) {
                            iMinRequestInterval = longScrapeValue.intValue();
                        }
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(TrackerStatus.LOGID, "Received min_request_interval of " + iMinRequestInterval));
                        }
                    }
                    if (mapFiles != null && mapFiles.size() != 0) break block79;
                    if (!this.bSingleHashScrapes || !map.containsKey("complete") || !map.containsKey("incomplete")) break block80;
                    complete = MapUtils.getMapInt(map, "complete", 0);
                    incomplete = MapUtils.getMapInt(map, "incomplete", 0);
                    response = (TRTrackerScraperResponseImpl)activeResponses.get(0);
                    response.setPeers(incomplete);
                    response.setSeeds(complete);
                    minRequestInterval = MapUtils.getMapInt(map, "interval", 600000);
                    scrapeInterval = TRTrackerScraperResponseImpl.calcScrapeIntervalSecs(minRequestInterval, complete);
                    nextScrapeTime = SystemTime.getCurrentTime() + (long)(scrapeInterval * 1000);
                    response.setNextScrapeStartTime(nextScrapeTime);
                    response.setStatus(2, "Tracker returned Announce from scrape call");
                    response.setScrapeStartTime(scrapeStartTime);
                    this.scraper.scrapeReceived(response);
                    this.numActiveScrapes.decrementAndGet();
                    return;
                }
                v1 = failure_reason_bytes = map == null ? null : (byte[])map.get("failure reason");
                if (failure_reason_bytes != null) {
                    nextScrapeTime = SystemTime.getCurrentTime() + (long)(iMinRequestInterval == 0 ? 600000 : iMinRequestInterval * 1000);
                    for (TRTrackerScraperResponseImpl response : activeResponses) {
                        response.setNextScrapeStartTime(nextScrapeTime);
                        response.setStatus(1, String.valueOf(MessageText.getString("Scrape.status.error")) + new String(failure_reason_bytes, "UTF8"));
                        this.scraper.scrapeReceived(response);
                    }
                } else if (activeResponses.size() > 1) {
                    this.bSingleHashScrapes = true;
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(TrackerStatus.LOGID, 1, String.valueOf(this.scrapeURL) + " doesn't properly support " + "multi-hash scrapes"));
                    }
                    for (TRTrackerScraperResponseImpl response : activeResponses) {
                        response.setStatus(1, String.valueOf(MessageText.getString("Scrape.status.error")) + MessageText.getString("Scrape.status.error.invalid"));
                        this.scraper.scrapeReceived(response);
                    }
                } else {
                    nextScrapeTime = SystemTime.getCurrentTime() + (long)(iMinRequestInterval == 0 ? 10800000 : iMinRequestInterval * 1000);
                    response = (TRTrackerScraperResponseImpl)activeResponses.get(0);
                    response.setNextScrapeStartTime(nextScrapeTime);
                    response.setStatus(1, String.valueOf(MessageText.getString("Scrape.status.error")) + MessageText.getString("Scrape.status.error.nohash"));
                    this.scraper.scrapeReceived(response);
                }
                this.numActiveScrapes.decrementAndGet();
                return;
            }
            try {
                if (!this.bSingleHashScrapes && activeResponses.size() > 1 && mapFiles.size() == 1) {
                    this.bSingleHashScrapes = true;
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(TrackerStatus.LOGID, 1, String.valueOf(this.scrapeURL) + " only returned " + mapFiles.size() + " hash scrape(s), but we asked for " + activeResponses.size()));
                    }
                }
                for (TRTrackerScraperResponseImpl response : activeResponses) {
                    scrapeMap = (Map)mapFiles.get(new String(response.getHash().getBytes(), "ISO-8859-1"));
                    if (scrapeMap == null) {
                        if (activeResponses.size() == 1 || mapFiles.size() != 1) {
                            response.setNextScrapeStartTime(SystemTime.getCurrentTime() + 10800000L);
                            response.setStatus(1, String.valueOf(MessageText.getString("Scrape.status.error")) + MessageText.getString("Scrape.status.error.nohash"));
                            this.scraper.scrapeReceived(response);
                            continue;
                        }
                        if (!this.scraper.isTorrentScrapable(response.getHash())) continue;
                        response.revertStatus();
                        if (response.getStatus() == 3) {
                            response.setNextScrapeStartTime(SystemTime.getCurrentTime() + 600000L);
                            response.setStatus(1, String.valueOf(MessageText.getString("Scrape.status.error")) + MessageText.getString("Scrape.status.error.invalid"));
                        } else {
                            this.bSingleHashScrapes = true;
                            if (original_bSingleHashScrapes) {
                                response.setNextScrapeStartTime(SystemTime.getCurrentTime() + 600000L);
                            }
                        }
                        this.scraper.scrapeReceived(response);
                        continue;
                    }
                    l_seeds = (Long)scrapeMap.get("complete");
                    l_peers = (Long)scrapeMap.get("incomplete");
                    l_comp = (Long)scrapeMap.get("downloaded");
                    seeds = l_seeds == null ? 0 : l_seeds.intValue();
                    peers = l_peers == null ? 0 : l_peers.intValue();
                    v2 = completed = l_comp == null ? -1 : l_comp.intValue();
                    if (seeds < 0 || peers < 0 || completed < -1) {
                        if (Logger.isEnabled()) {
                            hash = response.getHash();
                            Logger.log(new LogEvent(TorrentUtils.getDownloadManager(hash), TrackerStatus.LOGID, "Invalid scrape response from '" + reqUrl + "': map = " + scrapeMap));
                        }
                        if (activeResponses.size() > 1 && this.bSingleHashScrapes) {
                            response.setStatus(1, String.valueOf(MessageText.getString("Scrape.status.error")) + MessageText.getString("Scrape.status.error.invalid"));
                            this.scraper.scrapeReceived(response);
                            continue;
                        }
                        response.setNextScrapeStartTime(SystemTime.getCurrentTime() + 600000L);
                        response.setStatus(1, String.valueOf(MessageText.getString("Scrape.status.error")) + MessageText.getString("Scrape.status.error.invalid") + " " + (seeds < 0 ? String.valueOf(MessageText.getString("MyTorrentsView.seeds")) + " == " + seeds + ". " : "") + (peers < 0 ? String.valueOf(MessageText.getString("MyTorrentsView.peers")) + " == " + peers + ". " : "") + (completed < 0 ? String.valueOf(MessageText.getString("MyTorrentsView.completed")) + " == " + completed + ". " : ""));
                        this.scraper.scrapeReceived(response);
                        continue;
                    }
                    scrapeInterval = TRTrackerScraperResponseImpl.calcScrapeIntervalSecs(iMinRequestInterval, seeds);
                    nextScrapeTime = SystemTime.getCurrentTime() + (long)(scrapeInterval * 1000);
                    response.setNextScrapeStartTime(nextScrapeTime);
                    response.setScrapeStartTime(scrapeStartTime);
                    response.setSeeds(seeds);
                    response.setPeers(peers);
                    response.setCompleted(completed);
                    response.setStatus(2, MessageText.getString("Scrape.status.ok"));
                    this.scraper.scrapeReceived(response);
                    try {
                        if (activeResponses.size() != 1 || redirect_url == null || (s_pos = (redirect_str = redirect_url.toString()).indexOf("/scrape")) == -1) continue;
                        new_url = new URL(String.valueOf(redirect_str.substring(0, s_pos)) + "/announce" + redirect_str.substring(s_pos + 7));
                        if (!this.scraper.redirectTrackerUrl(response.getHash(), this.tracker_url, new_url)) continue;
                        this.removeHash(response.getHash());
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
                break block81;
                {
                    catch (NoClassDefFoundError ignoreSSL) {
                        ** for (response : activeResponses)
                    }
                }
lbl-1000:
                // 1 sources

                {
                    response.setNextScrapeStartTime(SystemTime.getCurrentTime() + 600000L);
                    response.setStatus(1, String.valueOf(MessageText.getString("Scrape.status.error")) + ignoreSSL.getMessage());
                    this.scraper.scrapeReceived(response);
                    continue;
lbl240:
                    // 1 sources

                    break block81;
                }
                {
                    catch (FileNotFoundException e) {
                        ** for (response : activeResponses)
                    }
                }
lbl-1000:
                // 1 sources

                {
                    response.setNextScrapeStartTime(SystemTime.getCurrentTime() + 600000L);
                    response.setStatus(1, String.valueOf(MessageText.getString("Scrape.status.error")) + MessageText.getString("DownloadManager.error.filenotfound"));
                    this.scraper.scrapeReceived(response);
                    continue;
lbl247:
                    // 1 sources

                    break block81;
                }
                {
                    catch (SocketException e) {
                        this.setAllError(activeResponses, e);
                    }
                    catch (SocketTimeoutException e) {
                        this.setAllError(activeResponses, e);
                    }
                    catch (UnknownHostException e) {
                        this.setAllError(activeResponses, e);
                    }
                    catch (PRUDPPacketHandlerException e) {
                        this.setAllError(activeResponses, e);
                    }
                    catch (BEncodingException e) {
                        this.setAllError(activeResponses, e);
                    }
                    catch (Exception e) {
                        block82: {
                            error_message = e.getMessage();
                            if (error_message != null) {
                                if (error_message.indexOf(" 500 ") >= 0 || error_message.indexOf(" 400 ") >= 0 || error_message.indexOf(" 403 ") >= 0 || error_message.indexOf(" 404 ") >= 0 || error_message.indexOf(" 501 ") >= 0) {
                                    this.setAllError(activeResponses, e);
                                    this.numActiveScrapes.decrementAndGet();
                                    return;
                                }
                                if (error_message.indexOf("414") == -1 || this.bSingleHashScrapes) break block82;
                                this.bSingleHashScrapes = true;
                                this.numActiveScrapes.decrementAndGet();
                                return;
                            }
                        }
                        try {
                            msg = Debug.getNestedExceptionMessage(e);
                            if (scrape_reply != null) {
                                trace_data = scrape_reply.length <= 150 ? new String(scrape_reply) : String.valueOf(new String(scrape_reply, 0, 150)) + "...";
                                msg = String.valueOf(msg) + " [" + trace_data + "]";
                            }
                            for (TRTrackerScraperResponseImpl response : activeResponses) {
                                if (Logger.isEnabled()) {
                                    hash = response.getHash();
                                    Logger.log(new LogEvent((Object)TorrentUtils.getDownloadManager(hash), TrackerStatus.LOGID, 3, "Error from scrape interface " + this.scrapeURL + " : " + msg + " (" + e.getClass() + ")"));
                                }
                                response.setNextScrapeStartTime(SystemTime.getCurrentTime() + 600000L);
                                response.setStatus(1, String.valueOf(MessageText.getString("Scrape.status.error")) + msg);
                                this.scraper.scrapeReceived(response);
                            }
                        }
                        catch (Throwable t) {
                            Debug.out("runScrapesSupport failed", t);
                        }
                    }
                }
            }
            finally {
                this.numActiveScrapes.decrementAndGet();
            }
        }
    }

    private void setAllError(List<TRTrackerScraperResponseImpl> responses, Exception e) {
        String msg;
        msg = e instanceof BEncodingException ? ((msg = e.getLocalizedMessage()).indexOf("html") != -1 ? "Could not decode response, appears to be a website instead of tracker scrape: " + msg.replace('\n', ' ') : "Bencoded response malformed: " + msg) : Debug.getNestedExceptionMessage(e);
        for (TRTrackerScraperResponseImpl response : responses) {
            if (Logger.isEnabled()) {
                HashWrapper hash = response.getHash();
                Logger.log(new LogEvent((Object)TorrentUtils.getDownloadManager(hash), LOGID, 1, "Error from scrape interface " + this.scrapeURL + " : " + msg));
            }
            response.setNextScrapeStartTime(SystemTime.getCurrentTime() + 600000L);
            response.setStatus(1, StringInterner.intern(String.valueOf(MessageText.getString("Scrape.status.error")) + msg));
            this.scraper.scrapeReceived(response);
        }
    }

    /*
     * Unable to fully structure code
     */
    private URL scrapeHTTP(List<HashWrapper> hashesInQuery, URL reqUrl, ByteArrayOutputStream message) throws Exception {
        block19: {
            block20: {
                example_hash = hashesInQuery.get(0).getBytes();
                try {
                    return this.scrapeHTTPSupport(reqUrl, example_hash, null, message);
                }
                catch (Exception e) {
                    if (AENetworkClassifier.categoriseAddress(reqUrl.getHost()) == "Public") break block19;
                    opts = new HashMap<String, Object>();
                    if (hashesInQuery.size() == 1) {
                        opts.put("peer_networks", this.scraper.getEnabledNetworks(hashesInQuery.get(0)));
                        break block20;
                    }
                    current_nets = null;
                    ** for (hash : hashesInQuery)
                }
lbl-1000:
                // 1 sources

                {
                    nets = this.scraper.getEnabledNetworks(hash);
                    if (nets == null) {
                        nets = new String[]{};
                    }
                    if (current_nets == null) {
                        current_nets = nets;
                        continue;
                    }
                    ok = false;
                    if (nets.length == current_nets.length) {
                        ok = true;
                        var15_19 = nets;
                        var14_18 = nets.length;
                        var13_17 = 0;
                        while (var13_17 < var14_18) {
                            net1 = var15_19[var13_17];
                            match = false;
                            var20_24 = current_nets;
                            var19_23 = current_nets.length;
                            var18_22 = 0;
                            while (var18_22 < var19_23) {
                                net2 = var20_24[var18_22];
                                if (net1 == net2) {
                                    match = true;
                                    break;
                                }
                                ++var18_22;
                            }
                            if (!match) {
                                ok = false;
                                break;
                            }
                            ++var13_17;
                        }
                    } else {
                        ok = false;
                    }
                    if (ok) continue;
                    this.bSingleHashScrapes = true;
                    throw new Exception("Mixed networks, forcing single-hash scrapes");
                }
lbl49:
                // 1 sources

                if (current_nets != null) {
                    opts.put("peer_networks", current_nets);
                }
            }
            proxy = AEProxyFactory.getPluginProxy("Tracker scrape", reqUrl, opts, true);
            if (proxy != null) {
                ok = false;
                try {
                    result = this.scrapeHTTPSupport(proxy.getURL(), example_hash, proxy.getProxy(), message);
                    ok = true;
                    var11_15 = result;
                    return var11_15;
                }
                catch (Throwable var9_9) {
                }
                finally {
                    proxy.setOK(ok);
                }
            }
        }
        throw e;
    }

    private URL scrapeHTTPSupport(URL reqUrl, byte[] example_hash, Proxy proxy, ByteArrayOutputStream message) throws IOException {
        int connect_loop = 0;
        while (connect_loop < 3) {
            block53: {
                URL redirect_url = null;
                TRTrackerUtils.checkForBlacklistedURLs(reqUrl);
                reqUrl = TRTrackerUtils.adjustURLForHosting(reqUrl);
                reqUrl = AddressUtils.adjustURL(reqUrl);
                Properties http_properties = new Properties();
                http_properties.put("URL", reqUrl);
                if (proxy != null) {
                    http_properties.put("Proxy", proxy);
                }
                if (this.enable_sni_hack) {
                    http_properties.put("SNI-Hack", (Object)true);
                }
                try {
                    ClientIDManagerImpl.getSingleton().generateHTTPProperties(example_hash, http_properties);
                }
                catch (ClientIDException e) {
                    throw new IOException(e.getMessage());
                }
                reqUrl = (URL)http_properties.get("URL");
                InputStream is = null;
                try {
                    String encoding;
                    boolean gzip;
                    String marker;
                    int pos;
                    HttpURLConnection con = null;
                    if (reqUrl.getProtocol().equalsIgnoreCase("https")) {
                        HttpsURLConnection ssl_con = proxy == null ? (HttpsURLConnection)reqUrl.openConnection() : (HttpsURLConnection)reqUrl.openConnection(proxy);
                        if (!this.internal_error_hack) {
                            ssl_con.setHostnameVerifier(new HostnameVerifier(){

                                @Override
                                public boolean verify(String host, SSLSession session) {
                                    return true;
                                }
                            });
                        }
                        if (this.dh_hack) {
                            UrlUtils.DHHackIt(ssl_con);
                        }
                        if (connect_loop > 0) {
                            TrustManager[] trustAllCerts = SESecurityManager.getAllTrustingTrustManager();
                            try {
                                SSLContext sc = SSLContext.getInstance("SSL");
                                sc.init(null, trustAllCerts, RandomUtils.SECURE_RANDOM);
                                SSLSocketFactory factory = sc.getSocketFactory();
                                ssl_con.setSSLSocketFactory(factory);
                            }
                            catch (Throwable sc) {
                                // empty catch block
                            }
                        }
                        con = ssl_con;
                    } else {
                        con = proxy == null ? (HttpURLConnection)reqUrl.openConnection() : (HttpURLConnection)reqUrl.openConnection(proxy);
                    }
                    con.setInstanceFollowRedirects(true);
                    String user_agent = (String)http_properties.get("User-Agent");
                    if (user_agent != null) {
                        con.setRequestProperty("User-Agent", user_agent);
                    }
                    con.addRequestProperty("Accept-Encoding", "gzip");
                    con.setRequestProperty("Connection", "close");
                    try {
                        con.connect();
                    }
                    catch (AEProxyFactory.UnknownHostException e) {
                        throw new UnknownHostException(e.getMessage());
                    }
                    is = con.getInputStream();
                    String resulting_url_str = con.getURL().toString();
                    if (!reqUrl.toString().equals(resulting_url_str) && (pos = resulting_url_str.indexOf(marker = "permredirect=1")) != -1) {
                        --pos;
                        try {
                            redirect_url = new URL(resulting_url_str.substring(0, pos));
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                    boolean bl = gzip = (encoding = con.getHeaderField("content-encoding")) != null && encoding.equalsIgnoreCase("gzip");
                    if (gzip) {
                        is = new GZIPInputStream(is);
                    }
                    byte[] data = new byte[1024];
                    int num_read = 0;
                    try {
                        while (true) {
                            int len;
                            if ((len = is.read(data)) > 0) {
                                message.write(data, 0, len);
                                if ((num_read += len) <= 131072) continue;
                                message.reset();
                                throw new Exception("Tracker response invalid (too large)");
                            }
                            if (len == 0) {
                                Thread.sleep(20L);
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Exception e) {
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, 3, "Error from scrape interface " + this.scrapeURL + " : " + Debug.getNestedExceptionMessage(e)));
                        }
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        return null;
                    }
                }
                catch (SSLException e) {
                    if (connect_loop < 3) {
                        String msg = Debug.getNestedExceptionMessage(e);
                        boolean try_again = false;
                        if (msg.contains("unrecognized_name")) {
                            if (!this.enable_sni_hack) {
                                this.enable_sni_hack = true;
                                try_again = true;
                            }
                        } else if (msg.contains("internal_error")) {
                            if (!this.internal_error_hack) {
                                this.internal_error_hack = true;
                                try_again = true;
                            }
                        } else if (msg.contains("DH keypair") && !this.dh_hack) {
                            this.dh_hack = true;
                            try_again = true;
                        }
                        if (SESecurityManager.installServerCertificates(reqUrl) != null || connect_loop == 0) {
                            try_again = true;
                        }
                        if (try_again) break block53;
                    }
                    throw e;
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                return redirect_url;
            }
            ++connect_loop;
        }
        throw new IOException("Shouldn't get here");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean scrapeUDP(URL reqUrl, ByteArrayOutputStream message, List hashes, boolean do_auth_test) throws Exception {
        rootMap = new HashMap<String, Object>();
        files = new ByteEncodedKeyHashMap<T, S>();
        rootMap.put("files", files);
        reqUrl = TRTrackerUtils.adjustURLForHosting(reqUrl);
        auth = null;
        auth_ok = false;
        try {
            block21: {
                if (do_auth_test && UrlUtils.queryHasParameter(reqUrl.getQuery(), "auth", false)) {
                    auth = SESecurityManager.getPasswordAuthentication("UDP Tracker", reqUrl);
                }
                port = UDPNetworkManager.getSingleton().getUDPNonDataListeningPortNumber();
                handler = PRUDPPacketHandlerFactory.getHandler(port);
                destination = new InetSocketAddress(reqUrl.getHost(), reqUrl.getPort() == -1 ? 80 : reqUrl.getPort());
                handler = handler.openSession(destination);
                try {
                    failure_reason = null;
                    retry_loop = 0;
                }
                catch (Throwable var28_38) {
                    handler.closeSession();
                    throw var28_38;
                }
                {
                    while (retry_loop < 1) {
                        block20: {
                            try {
                                connect_request = new PRUDPPacketRequestConnect();
                                reply = handler.sendAndReceive(auth, connect_request, destination);
                                if (reply.getAction() != 0) ** GOTO lbl94
                                connect_reply = (PRUDPPacketReplyConnect)reply;
                                my_connection = connect_reply.getConnectionId();
                                scrape_request = new PRUDPPacketRequestScrape(my_connection, hashes);
                                if ((reply = handler.sendAndReceive(auth, scrape_request, destination)).getAction() != 2) ** GOTO lbl-1000
                                auth_ok = true;
                                if (PRUDPPacketTracker.VERSION == 1) {
                                    scrape_reply = (PRUDPPacketReplyScrape)reply;
                                    reply_hashes = scrape_reply.getHashes();
                                    complete = scrape_reply.getComplete();
                                    downloaded = scrape_reply.getDownloaded();
                                    incomplete = scrape_reply.getIncomplete();
                                    i = 0;
                                    while (true) {
                                        if (i >= reply_hashes.length) {
                                            data = BEncoder.encode(rootMap);
                                            message.write(data);
                                            break block20;
                                        }
                                        file = new HashMap<String, Long>();
                                        resp_hash = reply_hashes[i];
                                        files.put(new String(resp_hash, "ISO-8859-1"), file);
                                        file.put("complete", new Long(complete[i]));
                                        file.put("downloaded", new Long(downloaded[i]));
                                        file.put("incomplete", new Long(incomplete[i]));
                                        ++i;
                                    }
                                }
                                ** GOTO lbl-1000
                            }
                            catch (PRUDPPacketHandlerException e) {
                                if (e.getMessage() == null) throw e;
                                if (e.getMessage().indexOf("timed out") == -1) {
                                    throw e;
                                }
                                failure_reason = "Timeout";
                                ++retry_loop;
                                continue;
                            }
                        }
                        handler.closeSession();
                        return true;
lbl-1000:
                        // 1 sources

                        {
                            scrape_reply = (PRUDPPacketReplyScrape2)reply;
                            complete = scrape_reply.getComplete();
                            downloaded = scrape_reply.getDownloaded();
                            incomplete = scrape_reply.getIncomplete();
                            i = 0;
                            it = hashes.iterator();
                            while (it.hasNext() && i < complete.length) {
                                hash = (HashWrapper)it.next();
                                file = new HashMap<String, Long>();
                                file.put("complete", new Long(complete[i]));
                                file.put("downloaded", new Long(downloaded[i]));
                                file.put("incomplete", new Long(incomplete[i]));
                                files.put(new String(hash.getBytes(), "ISO-8859-1"), file);
                                ++i;
                            }
                            data = BEncoder.encode(rootMap);
                            message.write(data);
                        }
                        handler.closeSession();
                        return true;
lbl-1000:
                        // 1 sources

                        {
                            failure_reason = ((PRUDPPacketReplyError)reply).getMessage();
                            if (!Logger.isEnabled()) break;
                            Logger.log(new LogEvent(TrackerStatus.LOGID, 3, "Response from scrape interface " + reqUrl + " : " + failure_reason));
                            break;
lbl94:
                            // 1 sources

                            failure_reason = ((PRUDPPacketReplyError)reply).getMessage();
                            if (!Logger.isEnabled()) break;
                            Logger.log(new LogEvent(TrackerStatus.LOGID, 3, "Response from scrape interface " + reqUrl + " : " + ((PRUDPPacketReplyError)reply).getMessage()));
                            break;
                        }
                    }
                    if (failure_reason == null) break block21;
                    rootMap.put("failure reason", failure_reason.getBytes());
                    rootMap.remove("files");
                    data = BEncoder.encode(rootMap);
                    message.write(data);
                }
            }
            handler.closeSession();
            return false;
        }
        finally {
            if (auth != null) {
                SESecurityManager.setPasswordAuthenticationOutcome(TRTrackerBTAnnouncerImpl.UDP_REALM, reqUrl, auth_ok);
            }
        }
    }

    protected String getURLParam(String url, String param) {
        int p1 = url.indexOf(String.valueOf(param) + "=");
        if (p1 == -1) {
            return null;
        }
        int p2 = url.indexOf("&", p1);
        if (p2 == -1) {
            return url.substring(p1 + param.length() + 1);
        }
        return url.substring(p1 + param.length() + 1, p2);
    }

    protected TRTrackerScraperResponseImpl addHash(HashWrapper hash) {
        TRTrackerScraperResponseImpl response;
        try {
            this.hashes_mon.enter();
            response = this.hashes.get(hash);
            if (response == null) {
                response = new TRTrackerBTScraperResponseImpl(this, hash);
                if (this.scrapeURL == null) {
                    response.setStatus(1, String.valueOf(MessageText.getString("Scrape.status.error")) + MessageText.getString("Scrape.status.error.badURL"));
                } else {
                    response.setStatus(0, MessageText.getString("Scrape.status.initializing"));
                }
                response.setNextScrapeStartTime(this.checker.getNextScrapeCheckOn());
                this.hashes.put(hash, response);
            }
        }
        finally {
            this.hashes_mon.exit();
        }
        this.scraper.scrapeReceived(response);
        return response;
    }

    protected void removeHash(HashWrapper hash) {
        try {
            this.hashes_mon.enter();
            this.hashes.remove(hash);
        }
        finally {
            this.hashes_mon.exit();
        }
    }

    protected URL getTrackerURL() {
        return this.tracker_url;
    }

    protected Map getHashes() {
        return this.hashes;
    }

    protected AEMonitor getHashesMonitor() {
        return this.hashes_mon;
    }

    protected void scrapeReceived(TRTrackerScraperResponse response) {
        this.scraper.scrapeReceived(response);
    }

    public boolean getSupportsMultipeHashScrapes() {
        return !this.bSingleHashScrapes;
    }

    protected String getString() {
        return this.tracker_url + ", " + this.scrapeURL + ", multi-scrape=" + !this.bSingleHashScrapes;
    }

    public int getNumActiveScrapes() {
        return this.numActiveScrapes.get();
    }
}

