/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.ui.config;

import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.config.ConfigParameterListener;
import org.gudy.azureus2.plugins.ui.config.EnablerParameter;
import org.gudy.azureus2.plugins.ui.config.Parameter;
import org.gudy.azureus2.plugins.ui.config.ParameterListener;
import org.gudy.azureus2.pluginsimpl.local.PluginConfigImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.ParameterGroupImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.ParameterImplListener;

public class ParameterImpl
implements EnablerParameter,
org.gudy.azureus2.core3.config.ParameterListener {
    protected PluginConfigImpl config;
    private String key;
    private String labelKey;
    private String label;
    private int mode = 0;
    private boolean enabled = true;
    private boolean visible = true;
    private boolean generate_intermediate_events = true;
    private List toDisable = new ArrayList();
    private List toEnable = new ArrayList();
    private List listeners = new ArrayList();
    private List impl_listeners = new ArrayList();
    private ParameterGroupImpl parameter_group;

    public ParameterImpl(PluginConfigImpl _config, String _key, String _label) {
        this.config = _config;
        this.key = _key;
        this.labelKey = _label;
        if ("_blank".equals(this.labelKey)) {
            this.labelKey = "!!";
        }
        this.label = MessageText.getString(this.labelKey);
    }

    public String getKey() {
        return this.key;
    }

    @Override
    public void addDisabledOnSelection(Parameter parameter) {
        if (parameter instanceof ParameterGroupImpl) {
            ParameterImpl[] parameters;
            ParameterImpl[] parameterImplArray = parameters = ((ParameterGroupImpl)parameter).getParameters();
            int n = parameters.length;
            int n2 = 0;
            while (n2 < n) {
                ParameterImpl param = parameterImplArray[n2];
                this.toDisable.add(param);
                ++n2;
            }
            return;
        }
        this.toDisable.add(parameter);
    }

    @Override
    public void addEnabledOnSelection(Parameter parameter) {
        if (parameter instanceof ParameterGroupImpl) {
            ParameterImpl[] parameters;
            ParameterImpl[] parameterImplArray = parameters = ((ParameterGroupImpl)parameter).getParameters();
            int n = parameters.length;
            int n2 = 0;
            while (n2 < n) {
                ParameterImpl param = parameterImplArray[n2];
                this.toEnable.add(param);
                ++n2;
            }
            return;
        }
        this.toEnable.add(parameter);
    }

    public List getDisabledOnSelectionParameters() {
        return this.toDisable;
    }

    public List getEnabledOnSelectionParameters() {
        return this.toEnable;
    }

    @Override
    public void parameterChanged(String key) {
        this.fireParameterChanged();
    }

    protected void fireParameterChanged() {
        Object[] listenerArray = this.listeners.toArray();
        int i = 0;
        while (i < listenerArray.length) {
            try {
                Object o = listenerArray[i];
                if (o instanceof ParameterListener) {
                    ((ParameterListener)o).parameterChanged(this);
                } else {
                    ((ConfigParameterListener)o).configParameterChanged(this);
                }
            }
            catch (Throwable f) {
                Debug.printStackTrace(f);
            }
            ++i;
        }
    }

    @Override
    public void setEnabled(boolean e) {
        this.enabled = e;
        Object[] listenersArray = this.impl_listeners.toArray();
        int i = 0;
        while (i < listenersArray.length) {
            try {
                ParameterImplListener l = (ParameterImplListener)listenersArray[i];
                l.enabledChanged(this);
            }
            catch (Throwable f) {
                Debug.printStackTrace(f);
            }
            ++i;
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public int getMinimumRequiredUserMode() {
        return this.mode;
    }

    @Override
    public void setMinimumRequiredUserMode(int _mode) {
        this.mode = _mode;
    }

    @Override
    public void setVisible(boolean _visible) {
        this.visible = _visible;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setGenerateIntermediateEvents(boolean b) {
        this.generate_intermediate_events = b;
    }

    @Override
    public boolean getGenerateIntermediateEvents() {
        return this.generate_intermediate_events;
    }

    public void setGroup(ParameterGroupImpl _group) {
        this.parameter_group = _group;
    }

    public ParameterGroupImpl getGroup() {
        return this.parameter_group;
    }

    @Override
    public void addListener(ParameterListener l) {
        this.listeners.add(l);
        if (this.listeners.size() == 1) {
            COConfigurationManager.addParameterListener(this.key, (org.gudy.azureus2.core3.config.ParameterListener)this);
        }
    }

    @Override
    public void removeListener(ParameterListener l) {
        this.listeners.remove(l);
        if (this.listeners.size() == 0) {
            COConfigurationManager.removeParameterListener(this.key, this);
        }
    }

    public void addImplListener(ParameterImplListener l) {
        this.impl_listeners.add(l);
    }

    public void removeImplListener(ParameterImplListener l) {
        this.impl_listeners.remove(l);
    }

    @Override
    public void addConfigParameterListener(ConfigParameterListener l) {
        this.listeners.add(l);
        if (this.listeners.size() == 1) {
            COConfigurationManager.addParameterListener(this.key, (org.gudy.azureus2.core3.config.ParameterListener)this);
        }
    }

    @Override
    public void removeConfigParameterListener(ConfigParameterListener l) {
        this.listeners.remove(l);
        if (this.listeners.size() == 0) {
            COConfigurationManager.removeParameterListener(this.key, this);
        }
    }

    @Override
    public String getLabelText() {
        return this.label;
    }

    @Override
    public void setLabelText(String sText) {
        this.labelKey = null;
        this.label = sText;
        this.triggerLabelChanged(sText, false);
    }

    @Override
    public String getLabelKey() {
        return this.labelKey;
    }

    @Override
    public void setLabelKey(String sLabelKey) {
        this.labelKey = sLabelKey;
        this.label = MessageText.getString(sLabelKey);
        this.triggerLabelChanged(this.labelKey, true);
    }

    @Override
    public String getConfigKeyName() {
        return this.key;
    }

    @Override
    public boolean hasBeenSet() {
        return COConfigurationManager.doesParameterNonDefaultExist(this.key);
    }

    private void triggerLabelChanged(String text, boolean isKey) {
        Object[] listenersArray = this.impl_listeners.toArray();
        int i = 0;
        while (i < listenersArray.length) {
            try {
                ParameterImplListener l = (ParameterImplListener)listenersArray[i];
                l.labelChanged(this, text, isKey);
            }
            catch (Throwable f) {
                Debug.printStackTrace(f);
            }
            ++i;
        }
    }

    public void destroy() {
        this.listeners.clear();
        this.impl_listeners.clear();
        this.toDisable.clear();
        this.toEnable.clear();
        COConfigurationManager.removeParameterListener(this.key, this);
    }
}

