/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.console.commands;

import com.aelitis.azureus.core.tag.Tag;
import com.aelitis.azureus.core.tag.TagFeatureRSSFeed;
import com.aelitis.azureus.core.tag.TagManager;
import com.aelitis.azureus.core.tag.TagManagerFactory;
import com.aelitis.azureus.core.tag.TagType;
import com.aelitis.azureus.core.tag.Taggable;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.console.ConsoleInput;
import org.gudy.azureus2.ui.console.commands.IConsoleCommand;

public class Tags
extends IConsoleCommand {
    private List<Tag> current_tags;
    private Tag current_tag;

    public Tags() {
        super("tag", "tag");
    }

    @Override
    public String getCommandDescriptions() {
        return "tags\t\tAccess to tags.";
    }

    @Override
    public void printHelpExtra(PrintStream out, List<String> args) {
        out.println("> -----");
        out.println("Subcommands:");
        out.println("\tlist\t: List tags");
        out.println("\tcreate <name>\t: Create a new tag");
        out.println("\tselect <number>\t: Select tag <number> for further operations");
        out.println("The following commands operate on a selected tag");
        out.println("\ttorrents\t: List the tag's torrents");
        out.println("\tshow\t: Show tag properties");
        out.println("\tset_rssenable [yes|no]\t: Enable/disable RSS feed generation for the tag");
        out.println("\tdelete\t: Delete the tag");
        out.println("> -----");
    }

    @Override
    public void execute(String commandName, ConsoleInput ci, List<String> args) {
        if (args.isEmpty()) {
            this.printHelp(ci.out, args);
            return;
        }
        String cmd = args.get(0);
        TagManager tm = TagManagerFactory.getTagManager();
        TagType tt = tm.getTagType(3);
        if (cmd.equals("list")) {
            ci.out.println("> -----");
            this.current_tags = tt.getTags();
            int index = 1;
            for (Tag tag : this.current_tags) {
                String index_str = "" + index++;
                while (index_str.length() < 3) {
                    index_str = String.valueOf(index_str) + " ";
                }
                String str = String.valueOf(index_str) + tag.getTagName(true) + ", downloads=" + tag.getTaggedCount();
                ci.out.println(str);
            }
            if (this.current_tags.size() == 0) {
                ci.out.println("No Tags");
            }
        } else if (cmd.equals("create")) {
            if (args.size() < 2) {
                ci.out.println("Usage: tag create <name>");
            } else {
                String tag_name = args.get(1);
                if (tt.getTag(tag_name, true) != null) {
                    ci.out.println("Tag already exists");
                } else {
                    try {
                        tt.createTag(tag_name, true);
                        ci.out.println("Tag created");
                    }
                    catch (Throwable throwable) {
                        ci.out.println("Failed to create tag: " + Debug.getNestedExceptionMessage(throwable));
                    }
                }
            }
        } else if (cmd.equals("select")) {
            if (args.size() < 2) {
                ci.out.println("Usage: tag select <number>");
            } else {
                try {
                    int index = Integer.parseInt(args.get(1));
                    if (this.current_tags == null) {
                        throw new Exception("tags must be listed prior to being selected");
                    }
                    if (this.current_tags.size() == 0) {
                        throw new Exception("no tags exist");
                    }
                    if (index < 0 || index > this.current_tags.size()) {
                        throw new Exception("tag index '" + index + "' is out of range");
                    }
                    this.current_tag = this.current_tags.get(index - 1);
                    ci.out.println("Selected tag '" + this.current_tag.getTagName(true) + "'");
                }
                catch (Throwable e) {
                    ci.out.println("Failed to select tag: " + Debug.getNestedExceptionMessage(e));
                }
            }
        } else if (cmd.equals("torrents") || cmd.equals("show") || cmd.equals("delete") || cmd.equals("set_rssenable")) {
            if (this.current_tag == null) {
                ci.out.println("No current tag - select one!");
            } else if (cmd.equals("torrents")) {
                ci.out.println("Torrents for tag '" + this.current_tag.getTagName(true) + "'");
                ArrayList<Taggable> downloads = new ArrayList<Taggable>(this.current_tag.getTagged());
                Collections.sort(downloads, new IConsoleCommand.TorrentComparator());
                for (DownloadManager downloadManager : downloads) {
                    ci.out.println(this.getTorrentSummary(downloadManager));
                }
            } else if (cmd.equals("show")) {
                ci.out.println("Details for tag '" + this.current_tag.getTagName(true) + "'");
                ci.out.println("\tRSS Enable: " + ((TagFeatureRSSFeed)((Object)this.current_tag)).isTagRSSFeedEnabled());
            } else if (cmd.equals("set_rssenable")) {
                if (args.size() < 2) {
                    ci.out.println("Usage: " + cmd + " [yes|no]");
                } else {
                    String temp = args.get(1);
                    if (temp.equals("yes") || temp.equals("no")) {
                        ((TagFeatureRSSFeed)((Object)this.current_tag)).setTagRSSFeedEnabled(temp.equals("yes"));
                    } else {
                        ci.out.println("Usage: " + cmd + " [yes|no]");
                    }
                }
            } else if (cmd.equals("delete")) {
                this.current_tag.removeTag();
                this.current_tag = null;
                this.current_tags = null;
            }
        } else {
            ci.out.println("Unsupported sub-command: " + cmd);
        }
        ci.out.println("> -----");
    }
}

