/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.clientmessageservice.impl;

import com.aelitis.azureus.core.clientmessageservice.impl.ClientMessage;
import com.aelitis.azureus.core.networkmanager.OutgoingMessageQueue;
import com.aelitis.azureus.core.networkmanager.ProtocolEndpointFactory;
import com.aelitis.azureus.core.networkmanager.Transport;
import com.aelitis.azureus.core.networkmanager.impl.OutgoingMessageQueueImpl;
import com.aelitis.azureus.core.networkmanager.impl.tcp.ProtocolEndpointTCP;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPTransportImpl;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TransportEndpointTCP;
import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZMessageDecoder;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZMessageEncoder;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;

public class ClientConnection {
    private Transport parent_transport;
    private final Transport light_transport;
    private final OutgoingMessageQueue out_queue;
    private final AZMessageDecoder decoder;
    private static final AZMessageEncoder encoder = new AZMessageEncoder(0);
    private long last_activity_time;
    private final AEMonitor msg_mon = new AEMonitor("ClientConnection");
    private final ArrayList sending_msgs = new ArrayList();
    private Map user_data;
    private boolean close_pending;
    private boolean closed;
    private boolean last_write_made_progress;
    private String debug_string = "<>";
    private Throwable closing_reason;

    public ClientConnection(SocketChannel channel2) {
        this.decoder = new AZMessageDecoder();
        InetSocketAddress remote = null;
        ProtocolEndpointTCP pe = (ProtocolEndpointTCP)ProtocolEndpointFactory.createEndpoint(1, remote);
        this.light_transport = pe.connectLightWeight(channel2);
        this.out_queue = new OutgoingMessageQueueImpl(encoder);
        this.out_queue.setTransport(this.light_transport);
        this.last_activity_time = System.currentTimeMillis();
    }

    public ClientConnection(TCPTransportImpl transport) {
        this(transport.getSocketChannel());
        this.parent_transport = transport;
    }

    public Message[] readMessages() throws IOException {
        int bytes_read = this.decoder.performStreamDecode(this.light_transport, 0x100000);
        if (bytes_read > 0) {
            this.last_activity_time = System.currentTimeMillis();
        }
        return this.decoder.removeDecodedMessages();
    }

    public boolean getLastReadMadeProgress() {
        return this.decoder.getLastReadMadeProgress();
    }

    public boolean getLastWriteMadeProgress() {
        return this.last_write_made_progress;
    }

    public void sendMessage(final ClientMessage client_msg, final Message msg) {
        try {
            this.msg_mon.enter();
            this.sending_msgs.add(client_msg);
        }
        finally {
            this.msg_mon.exit();
        }
        this.out_queue.registerQueueListener(new OutgoingMessageQueue.MessageQueueListener(){

            @Override
            public boolean messageAdded(Message message) {
                return true;
            }

            @Override
            public void messageQueued(Message message) {
            }

            @Override
            public void messageRemoved(Message message) {
            }

            @Override
            public void protocolBytesSent(int byte_count) {
            }

            @Override
            public void dataBytesSent(int byte_count) {
            }

            @Override
            public void flush() {
            }

            @Override
            public void messageSent(Message message) {
                if (message.equals(msg)) {
                    try {
                        ClientConnection.this.msg_mon.enter();
                        ClientConnection.this.sending_msgs.remove(client_msg);
                    }
                    finally {
                        ClientConnection.this.msg_mon.exit();
                    }
                    client_msg.reportComplete();
                }
            }
        });
        this.out_queue.addMessage(msg, false);
    }

    public boolean writeMessages() throws IOException {
        int[] written = this.out_queue.deliverToTransport(0x100000, false, false);
        int bytes_written = written[0] + written[1];
        if (bytes_written > 0) {
            this.last_activity_time = System.currentTimeMillis();
        }
        boolean bl = this.last_write_made_progress = bytes_written > 0;
        return this.out_queue.getTotalSize() > 0;
    }

    public void close(Throwable reason) {
        ClientMessage[] messages = null;
        try {
            this.msg_mon.enter();
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (!this.sending_msgs.isEmpty()) {
                messages = this.sending_msgs.toArray(new ClientMessage[this.sending_msgs.size()]);
            }
        }
        finally {
            this.msg_mon.exit();
        }
        if (messages != null) {
            if (reason == null) {
                reason = new Exception("Connection closed");
            }
            int i = 0;
            while (i < messages.length) {
                ClientMessage msg = messages[i];
                msg.reportFailed(reason);
                ++i;
            }
        }
        this.decoder.destroy();
        this.out_queue.destroy();
        String x = "Tidy close" + (reason == null ? "" : ": " + Debug.getNestedExceptionMessage(reason));
        if (this.parent_transport != null) {
            this.parent_transport.close(x);
        } else {
            this.light_transport.close(x);
        }
    }

    public void closePending() {
        this.last_activity_time = System.currentTimeMillis();
        this.close_pending = true;
    }

    public boolean isClosePending() {
        return this.close_pending;
    }

    public SocketChannel getSocketChannel() {
        return ((TransportEndpointTCP)this.light_transport.getTransportEndpoint()).getSocketChannel();
    }

    public long getLastActivityTime() {
        return this.last_activity_time;
    }

    public void resetLastActivityTime() {
        this.last_activity_time = System.currentTimeMillis();
    }

    public void setClosingReason(Throwable r) {
        this.closing_reason = r;
    }

    public Throwable getClosingReason() {
        return this.closing_reason;
    }

    public Object getUserData(Object key) {
        Map m = this.user_data;
        if (m == null) {
            return null;
        }
        return m.get(key);
    }

    public void setUserData(Object key, Object data) {
        try {
            this.msg_mon.enter();
            HashMap<Object, Object> m = this.user_data == null ? new HashMap<Object, Object>() : new HashMap(this.user_data);
            m.put(key, data);
            this.user_data = m;
        }
        finally {
            this.msg_mon.exit();
        }
    }

    public void setDebugString(String debug) {
        this.debug_string = debug;
    }

    public String getDebugString() {
        return this.debug_string;
    }

    public void setMaximumMessageSize(int max_bytes) {
        if (this.decoder != null) {
            this.decoder.setMaximumMessageSize(max_bytes);
        }
    }
}

