/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.custom.impl;

import com.aelitis.azureus.core.custom.Customization;
import com.aelitis.azureus.core.custom.CustomizationException;
import com.aelitis.azureus.core.custom.CustomizationManager;
import com.aelitis.azureus.core.custom.impl.CustomizationImpl;
import com.aelitis.azureus.core.vuzefile.VuzeFile;
import com.aelitis.azureus.core.vuzefile.VuzeFileComponent;
import com.aelitis.azureus.core.vuzefile.VuzeFileHandler;
import com.aelitis.azureus.core.vuzefile.VuzeFileProcessor;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.utils.StaticUtilities;

public class CustomizationManagerImpl
implements CustomizationManager {
    private static final CustomizationManagerImpl singleton = new CustomizationManagerImpl();
    private boolean initialised;
    private final Map customization_file_map = new HashMap();
    private String current_customization_name;
    private CustomizationImpl current_customization;

    public static CustomizationManager getSingleton() {
        return singleton;
    }

    protected CustomizationManagerImpl() {
    }

    @Override
    public boolean preInitialize() {
        File user_dir = FileUtil.getUserFile("custom");
        File app_dir = FileUtil.getApplicationFile("custom");
        boolean changed = this.preInitialize(app_dir);
        if (!user_dir.equals(app_dir) && this.preInitialize(user_dir)) {
            changed = true;
        }
        return changed;
    }

    private boolean preInitialize(File dir) {
        File[] files;
        boolean changed = false;
        if (dir.isDirectory() && (files = dir.listFiles()) != null) {
            int i = 0;
            while (i < files.length) {
                block40: {
                    File file = files[i];
                    String name = file.getName();
                    if (name.endsWith(".config")) {
                        File rename_target;
                        FileInputStream fis = null;
                        boolean ok = false;
                        System.out.println("Processing config presets: " + file);
                        try {
                            try {
                                fis = new FileInputStream(file);
                                Properties props = new Properties();
                                props.load(fis);
                                ArrayList<String> errors = new ArrayList<String>();
                                for (Map.Entry<Object, Object> entry : props.entrySet()) {
                                    String config_name = (String)entry.getKey();
                                    String config_value = (String)entry.getValue();
                                    System.out.println("\t" + config_name + " -> " + config_value);
                                    try {
                                        int pos = config_value.indexOf(58);
                                        if (pos == -1) {
                                            throw new Exception("Value is invalid - missing type specification");
                                        }
                                        String config_type = config_value.substring(0, pos).trim().toLowerCase();
                                        config_value = config_value.substring(pos + 1);
                                        if (config_type.equals("bool")) {
                                            boolean b;
                                            if ((config_value = config_value.trim().toLowerCase()).equals("true")) {
                                                b = true;
                                            } else if (config_value.equals("false")) {
                                                b = false;
                                            } else {
                                                throw new Exception("Invalid boolean value");
                                            }
                                            COConfigurationManager.setParameter(config_name, b);
                                        } else if (config_type.equals("long")) {
                                            long l = Long.parseLong(config_value.trim());
                                            COConfigurationManager.setParameter(config_name, l);
                                        } else if (config_type.equals("float")) {
                                            float f = Float.parseFloat(config_value.trim());
                                            COConfigurationManager.setParameter(config_name, f);
                                        } else if (config_type.equals("string")) {
                                            COConfigurationManager.setParameter(config_name, config_value);
                                        } else if (config_type.equals("byte[]")) {
                                            COConfigurationManager.setParameter(config_name, ByteFormatter.decodeString(config_value));
                                        } else if (config_type.equals("list")) {
                                            COConfigurationManager.setParameter(config_name, (List)((Object)BDecoder.decode(ByteFormatter.decodeString(config_value))));
                                        } else if (config_type.equals("map")) {
                                            COConfigurationManager.setParameter(config_name, BDecoder.decode(ByteFormatter.decodeString(config_value)));
                                        } else {
                                            throw new Exception("Value is invalid - unknown type specifier");
                                        }
                                        changed = true;
                                    }
                                    catch (Throwable e) {
                                        errors.add(String.valueOf(e.getMessage()) + ": " + config_name + "=" + entry.getValue());
                                    }
                                }
                                if (errors.size() > 0) {
                                    throw new Exception("Found " + errors.size() + " errors: " + ((Object)errors).toString());
                                }
                                ok = true;
                                System.out.println("Presets applied");
                            }
                            catch (Throwable e) {
                                System.err.println("Failed to process custom .config file " + file);
                                e.printStackTrace();
                                if (fis != null) {
                                    try {
                                        fis.close();
                                    }
                                    catch (Throwable e2) {
                                        e2.printStackTrace();
                                    }
                                }
                                rename_target = new File(String.valueOf(file.getAbsolutePath()) + (ok ? ".applied" : ".bad"));
                                rename_target.delete();
                                file.renameTo(rename_target);
                                break block40;
                            }
                        }
                        catch (Throwable throwable) {
                            if (fis != null) {
                                try {
                                    fis.close();
                                }
                                catch (Throwable e) {
                                    e.printStackTrace();
                                }
                            }
                            rename_target = new File(String.valueOf(file.getAbsolutePath()) + (ok ? ".applied" : ".bad"));
                            rename_target.delete();
                            file.renameTo(rename_target);
                            throw throwable;
                        }
                        if (fis != null) {
                            try {
                                fis.close();
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                            }
                        }
                        rename_target = new File(String.valueOf(file.getAbsolutePath()) + (ok ? ".applied" : ".bad"));
                        rename_target.delete();
                        file.renameTo(rename_target);
                    }
                }
                ++i;
            }
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize() {
        String active;
        CustomizationManagerImpl customizationManagerImpl = this;
        synchronized (customizationManagerImpl) {
            if (this.initialised) {
                return;
            }
            this.initialised = true;
        }
        VuzeFileHandler.getSingleton().addProcessor(new VuzeFileProcessor(){

            @Override
            public void process(VuzeFile[] files, int expected_types) {
                int i = 0;
                while (i < files.length) {
                    VuzeFile vf = files[i];
                    VuzeFileComponent[] comps = vf.getComponents();
                    int j = 0;
                    while (j < comps.length) {
                        Map map;
                        VuzeFileComponent comp2 = comps[j];
                        if (comp2.getType() == 64) {
                            try {
                                map = comp2.getContent();
                                ((CustomizationManagerImpl)CustomizationManagerImpl.getSingleton()).importCustomization(map);
                                comp2.setProcessed();
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                        } else if (comp2.getType() == 1024) {
                            try {
                                map = comp2.getContent();
                                String name = new String((byte[])map.get("name"));
                                UIManager ui_manager = StaticUtilities.getUIManager(120000L);
                                String details = MessageText.getString("custom.settings.import", new String[]{name});
                                long res = ui_manager.showMessageBox("custom.settings.import.title", "!" + details + "!", 12L);
                                if (res == 4L) {
                                    Map config = (Map)map.get("settings");
                                    int num_set = 0;
                                    for (Map.Entry entry : config.entrySet()) {
                                        String key = (String)entry.getKey();
                                        Object value = entry.getValue();
                                        if (value instanceof Long) {
                                            COConfigurationManager.setParameter(key, (Long)value);
                                        } else if (value instanceof byte[]) {
                                            COConfigurationManager.setParameter(key, (byte[])value);
                                        } else if (value instanceof List) {
                                            COConfigurationManager.setParameter(key, (List)value);
                                        } else if (value instanceof Map) {
                                            COConfigurationManager.setParameter(key, (Map)value);
                                        } else {
                                            Debug.out("Unsupported entry: " + key + "=" + value);
                                        }
                                        ++num_set;
                                    }
                                    Long l_restart = (Long)map.get("restart");
                                    boolean restart = l_restart != null && l_restart != 0L;
                                    String restart_text = "";
                                    if (restart) {
                                        restart_text = "\r\n\r\n" + MessageText.getString("ConfigView.section.security.restart.title");
                                    }
                                    String res_details = MessageText.getString("custom.settings.import.res", new String[]{String.valueOf(num_set), restart_text});
                                    ui_manager.showMessageBox("custom.settings.import.res.title", "!" + res_details + "!", 1L);
                                }
                                comp2.setProcessed();
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        });
        File user_dir = FileUtil.getUserFile("custom");
        File app_dir = FileUtil.getApplicationFile("custom");
        this.loadCustomizations(app_dir);
        if (!user_dir.equals(app_dir)) {
            this.loadCustomizations(user_dir);
        }
        if (this.customization_file_map.get(active = COConfigurationManager.getStringParameter("customization.active.name", "")) == null) {
            for (String name : this.customization_file_map.keySet()) {
                String version_key = "customization.name." + name + ".version";
                String existing_version = COConfigurationManager.getStringParameter(version_key, "0");
                if (!existing_version.equals("0")) continue;
                active = name;
                String version = ((String[])this.customization_file_map.get(name))[0];
                COConfigurationManager.setParameter("customization.active.name", active);
                COConfigurationManager.setParameter(version_key, version);
                break;
            }
        }
        CustomizationManagerImpl customizationManagerImpl2 = this;
        synchronized (customizationManagerImpl2) {
            this.current_customization_name = active;
        }
    }

    protected void loadCustomizations(File dir) {
        File[] files;
        if (dir.isDirectory() && (files = dir.listFiles()) != null) {
            int i = 0;
            while (i < files.length) {
                File file = files[i];
                String name = file.getName();
                if (!name.endsWith(".zip")) {
                    if (!name.contains(".config")) {
                        this.logInvalid(file);
                    }
                } else {
                    String base = name.substring(0, name.length() - 4);
                    int u_pos = base.lastIndexOf(95);
                    if (u_pos == -1) {
                        this.logInvalid(file);
                    } else {
                        String lhs = base.substring(0, u_pos).trim();
                        String rhs = base.substring(u_pos + 1).trim();
                        if (lhs.length() == 0 || !Constants.isValidVersionFormat(rhs)) {
                            this.logInvalid(file);
                        } else {
                            String[] details = (String[])this.customization_file_map.get(lhs);
                            if (details == null) {
                                this.customization_file_map.put(lhs, new String[]{rhs, file.getAbsolutePath()});
                            } else {
                                String old_version = details[0];
                                if (Constants.compareVersions(old_version, rhs) < 0) {
                                    this.customization_file_map.put(lhs, new String[]{rhs, file.getAbsolutePath()});
                                }
                            }
                        }
                    }
                }
                ++i;
            }
        }
    }

    protected void logInvalid(File file) {
        Debug.out("Invalid customization file name '" + file.getAbsolutePath() + "' - format must be <name>_<version>.zip where version is numeric and dot separated");
    }

    protected void importCustomization(Map map) throws CustomizationException {
        try {
            File target;
            String name = new String((byte[])map.get("name"), "UTF-8");
            String version = new String((byte[])map.get("version"), "UTF-8");
            if (!Constants.isValidVersionFormat(version)) {
                throw new CustomizationException("Invalid version specification: " + version);
            }
            byte[] data = (byte[])map.get("data");
            File user_dir = FileUtil.getUserFile("custom");
            if (!user_dir.exists()) {
                user_dir.mkdirs();
            }
            if (!(target = new File(user_dir, String.valueOf(name) + "_" + version + ".zip")).exists() && !FileUtil.writeBytesAsFile2(target.getAbsolutePath(), data)) {
                throw new CustomizationException("Failed to save customization to " + target);
            }
        }
        catch (CustomizationException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CustomizationException("Failed to import customization", e);
        }
    }

    protected void exportCustomization(CustomizationImpl cust, File to_file) throws CustomizationException {
        if (to_file.isDirectory()) {
            to_file = new File(to_file, String.valueOf(cust.getName()) + "_" + cust.getVersion() + ".vuze");
        }
        if (!to_file.getName().endsWith(".vuze")) {
            to_file = new File(to_file.getParentFile(), String.valueOf(to_file.getName()) + ".vuze");
        }
        try {
            HashMap<String, Object> contents = new HashMap<String, Object>();
            byte[] data = FileUtil.readFileAsByteArray(cust.getContents());
            contents.put("name", cust.getName());
            contents.put("version", cust.getVersion());
            contents.put("data", data);
            VuzeFile vf = VuzeFileHandler.getSingleton().create();
            vf.addComponent(64, contents);
            vf.write(to_file);
        }
        catch (Throwable e) {
            throw new CustomizationException("Failed to export customization", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Customization getActiveCustomization() {
        CustomizationManagerImpl customizationManagerImpl = this;
        synchronized (customizationManagerImpl) {
            String[] entry;
            if (this.current_customization == null && this.current_customization_name != null && (entry = (String[])this.customization_file_map.get(this.current_customization_name)) != null) {
                try {
                    this.current_customization = new CustomizationImpl(this, this.current_customization_name, entry[0], new File(entry[1]));
                    SimpleTimer.addEvent("Custom:clear", SystemTime.getCurrentTime() + 120000L, new TimerEventPerformer(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void perform(TimerEvent event2) {
                            CustomizationManagerImpl customizationManagerImpl = CustomizationManagerImpl.this;
                            synchronized (customizationManagerImpl) {
                                CustomizationManagerImpl.this.current_customization = null;
                            }
                        }
                    });
                }
                catch (CustomizationException e) {
                    e.printStackTrace();
                }
            }
            return this.current_customization;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Customization[] getCustomizations() {
        ArrayList<CustomizationImpl> result = new ArrayList<CustomizationImpl>();
        CustomizationManagerImpl customizationManagerImpl = this;
        synchronized (customizationManagerImpl) {
            for (Map.Entry entry : this.customization_file_map.entrySet()) {
                String name = (String)entry.getKey();
                String[] bits = (String[])entry.getValue();
                String version = bits[0];
                File file = new File(bits[1]);
                try {
                    CustomizationImpl cust = new CustomizationImpl(this, name, version, file);
                    result.add(cust);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return result.toArray(new Customization[result.size()]);
    }

    public static void main(String[] args) {
        try {
            VuzeFile vf = VuzeFileHandler.getSingleton().create();
            HashMap<String, Object> config = new HashMap<String, Object>();
            ArrayList<Object> list = new ArrayList<Object>();
            list.add("trout");
            list.add(45);
            config.put("test.a10", "Hello mum");
            config.put("test.a11", new Long(100L));
            config.put("test.a13", list);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("name", "My Proxy Settings");
            map.put("settings", config);
            map.put("restart", new Long(1L));
            vf.addComponent(1024, map);
            vf.write(new File("C:\\temp\\p_config.vuze"));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

