/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.impl;

import com.aelitis.azureus.core.dht.DHT;
import com.aelitis.azureus.core.dht.DHTListener;
import com.aelitis.azureus.core.dht.DHTLogger;
import com.aelitis.azureus.core.dht.DHTOperationListener;
import com.aelitis.azureus.core.dht.DHTStorageAdapter;
import com.aelitis.azureus.core.dht.control.DHTControl;
import com.aelitis.azureus.core.dht.control.DHTControlAdapter;
import com.aelitis.azureus.core.dht.control.DHTControlFactory;
import com.aelitis.azureus.core.dht.db.DHTDB;
import com.aelitis.azureus.core.dht.impl.DHTLog;
import com.aelitis.azureus.core.dht.nat.DHTNATPuncher;
import com.aelitis.azureus.core.dht.nat.DHTNATPuncherAdapter;
import com.aelitis.azureus.core.dht.nat.DHTNATPuncherFactory;
import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPositionManager;
import com.aelitis.azureus.core.dht.router.DHTRouter;
import com.aelitis.azureus.core.dht.speed.DHTSpeedTester;
import com.aelitis.azureus.core.dht.speed.DHTSpeedTesterFactory;
import com.aelitis.azureus.core.dht.transport.DHTTransport;
import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.dht.transport.DHTTransportValue;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.gudy.azureus2.core3.util.AERunStateHandler;
import org.gudy.azureus2.core3.util.Debug;

public class DHTImpl
implements DHT,
AERunStateHandler.RunStateChangeListener {
    final DHTStorageAdapter storage_adapter;
    private DHTNATPuncherAdapter nat_adapter;
    private final DHTControl control;
    private DHTNATPuncher nat_puncher;
    private DHTSpeedTester speed_tester;
    private final Properties properties;
    private final DHTLogger logger;
    private final CopyOnWriteList<DHTListener> listeners = new CopyOnWriteList();
    private boolean runstate_startup = true;
    private boolean sleeping = false;

    public DHTImpl(DHTTransport _transport, Properties _properties, DHTStorageAdapter _storage_adapter, DHTNATPuncherAdapter _nat_adapter, DHTLogger _logger) {
        this.properties = _properties;
        this.storage_adapter = _storage_adapter;
        this.nat_adapter = _nat_adapter;
        this.logger = _logger;
        DHTNetworkPositionManager.initialise(this.storage_adapter);
        DHTLog.setLogger(this.logger);
        int K = this.getProp("EntriesPerNode", 20);
        int B = this.getProp("NodeSplitFactor", 4);
        int max_r = this.getProp("ReplacementsPerNode", 5);
        int s_conc = this.getProp("SearchConcurrency", 5);
        int l_conc = this.getProp("LookupConcurrency", 10);
        int o_rep = this.getProp("OriginalRepublishInterval", 28800000);
        int c_rep = this.getProp("CacheRepublishInterval", 1800000);
        int c_n = this.getProp("CacheClosestN", 1);
        boolean e_c = this.getProp("EncodeKeys", 1) == 1;
        boolean r_p = this.getProp("EnableRandomLookup", 1) == 1;
        this.control = DHTControlFactory.create(new DHTControlAdapter(){

            @Override
            public DHTStorageAdapter getStorageAdapter() {
                return DHTImpl.this.storage_adapter;
            }

            @Override
            public boolean isDiversified(byte[] key) {
                if (DHTImpl.this.storage_adapter == null) {
                    return false;
                }
                return DHTImpl.this.storage_adapter.isDiversified(key);
            }

            @Override
            public byte[][] diversify(String description, DHTTransportContact cause, boolean put_operation, boolean existing, byte[] key, byte type, boolean exhaustive, int max_depth) {
                boolean valid;
                if (existing) {
                    valid = type == 2 || type == 3 || type == 1;
                } else {
                    boolean bl = valid = type == 2 || type == 3;
                }
                if (DHTImpl.this.storage_adapter != null && valid) {
                    if (existing) {
                        return DHTImpl.this.storage_adapter.getExistingDiversification(key, put_operation, exhaustive, max_depth);
                    }
                    return DHTImpl.this.storage_adapter.createNewDiversification(description, cause, key, put_operation, type, exhaustive, max_depth);
                }
                if (!valid) {
                    Debug.out("Invalid diversification received: type = " + type);
                }
                if (existing) {
                    return new byte[][]{key};
                }
                return new byte[0][];
            }
        }, _transport, K, B, max_r, s_conc, l_conc, o_rep, c_rep, c_n, e_c, r_p, this.logger);
        if (this.nat_adapter != null) {
            this.nat_puncher = DHTNATPuncherFactory.create(this.nat_adapter, this);
        }
        AERunStateHandler.addListener(this, true);
    }

    public DHTImpl(DHTTransport _transport, DHTRouter _router, DHTDB _database, Properties _properties, DHTStorageAdapter _storage_adapter, DHTLogger _logger) {
        this.properties = _properties;
        this.storage_adapter = _storage_adapter;
        this.logger = _logger;
        DHTNetworkPositionManager.initialise(this.storage_adapter);
        DHTLog.setLogger(this.logger);
        int K = this.getProp("EntriesPerNode", 20);
        int B = this.getProp("NodeSplitFactor", 4);
        int max_r = this.getProp("ReplacementsPerNode", 5);
        int s_conc = this.getProp("SearchConcurrency", 5);
        int l_conc = this.getProp("LookupConcurrency", 10);
        int o_rep = this.getProp("OriginalRepublishInterval", 28800000);
        int c_rep = this.getProp("CacheRepublishInterval", 1800000);
        int c_n = this.getProp("CacheClosestN", 1);
        boolean e_c = this.getProp("EncodeKeys", 1) == 1;
        boolean r_p = this.getProp("EnableRandomLookup", 1) == 1;
        this.control = DHTControlFactory.create(new DHTControlAdapter(){

            @Override
            public DHTStorageAdapter getStorageAdapter() {
                return DHTImpl.this.storage_adapter;
            }

            @Override
            public boolean isDiversified(byte[] key) {
                if (DHTImpl.this.storage_adapter == null) {
                    return false;
                }
                return DHTImpl.this.storage_adapter.isDiversified(key);
            }

            @Override
            public byte[][] diversify(String description, DHTTransportContact cause, boolean put_operation, boolean existing, byte[] key, byte type, boolean exhaustive, int max_depth) {
                boolean valid;
                if (existing) {
                    valid = type == 2 || type == 3 || type == 1;
                } else {
                    boolean bl = valid = type == 2 || type == 3;
                }
                if (DHTImpl.this.storage_adapter != null && valid) {
                    if (existing) {
                        return DHTImpl.this.storage_adapter.getExistingDiversification(key, put_operation, exhaustive, max_depth);
                    }
                    return DHTImpl.this.storage_adapter.createNewDiversification(description, cause, key, put_operation, type, exhaustive, max_depth);
                }
                if (!valid) {
                    Debug.out("Invalid diversification received: type = " + type);
                }
                if (existing) {
                    return new byte[][]{key};
                }
                return new byte[0][];
            }
        }, _transport, _router, _database, K, B, max_r, s_conc, l_conc, o_rep, c_rep, c_n, e_c, r_p, this.logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runStateChanged(long run_state) {
        try {
            boolean is_sleeping = AERunStateHandler.isDHTSleeping();
            if (this.sleeping != is_sleeping) {
                this.sleeping = is_sleeping;
                if (!this.runstate_startup) {
                    System.out.println("DHT sleeping=" + this.sleeping);
                }
            }
            this.control.setSleeping(this.sleeping);
            DHTSpeedTester old_tester = null;
            DHTSpeedTester new_tester = null;
            DHTImpl dHTImpl = this;
            synchronized (dHTImpl) {
                if (this.sleeping) {
                    if (this.speed_tester != null) {
                        old_tester = this.speed_tester;
                        this.speed_tester = null;
                    }
                } else {
                    new_tester = this.speed_tester = DHTSpeedTesterFactory.create(this);
                }
            }
            if (old_tester != null) {
                if (!this.runstate_startup) {
                    System.out.println("    destroying speed tester");
                }
                old_tester.destroy();
            }
            if (new_tester != null) {
                if (!this.runstate_startup) {
                    System.out.println("    creating speed tester");
                }
                for (DHTListener l : this.listeners) {
                    try {
                        l.speedTesterAvailable(new_tester);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
        }
        finally {
            this.runstate_startup = false;
        }
    }

    @Override
    public boolean isSleeping() {
        return this.sleeping;
    }

    @Override
    public void setSuspended(boolean susp) {
        if (susp) {
            if (this.nat_puncher != null) {
                this.nat_puncher.setSuspended(true);
            }
            this.control.setSuspended(true);
        } else {
            this.control.setSuspended(false);
            if (this.nat_puncher != null) {
                this.nat_puncher.setSuspended(false);
            }
        }
    }

    protected int getProp(String name, int def) {
        Integer x = (Integer)this.properties.get(name);
        if (x == null) {
            this.properties.put(name, new Integer(def));
            return def;
        }
        return x;
    }

    @Override
    public int getIntProperty(String name) {
        return (Integer)this.properties.get(name);
    }

    @Override
    public boolean isDiversified(byte[] key) {
        return this.control.isDiversified(key);
    }

    @Override
    public void put(byte[] key, String description, byte[] value, short flags, DHTOperationListener listener) {
        this.control.put(key, description, value, flags, (byte)0, (byte)-1, true, listener);
    }

    @Override
    public void put(byte[] key, String description, byte[] value, short flags, boolean high_priority, DHTOperationListener listener) {
        this.control.put(key, description, value, flags, (byte)0, (byte)-1, high_priority, listener);
    }

    @Override
    public void put(byte[] key, String description, byte[] value, short flags, byte life_hours, boolean high_priority, DHTOperationListener listener) {
        this.control.put(key, description, value, flags, life_hours, (byte)-1, high_priority, listener);
    }

    @Override
    public void put(byte[] key, String description, byte[] value, short flags, byte life_hours, byte replication_control, boolean high_priority, DHTOperationListener listener) {
        this.control.put(key, description, value, flags, life_hours, replication_control, high_priority, listener);
    }

    @Override
    public DHTTransportValue getLocalValue(byte[] key) {
        return this.control.getLocalValue(key);
    }

    @Override
    public List<DHTTransportValue> getStoredValues(byte[] key) {
        return this.control.getStoredValues(key);
    }

    @Override
    public void get(byte[] key, String description, short flags, int max_values, long timeout, boolean exhaustive, boolean high_priority, DHTOperationListener listener) {
        this.control.get(key, description, flags, max_values, timeout, exhaustive, high_priority, listener);
    }

    @Override
    public byte[] remove(byte[] key, String description, DHTOperationListener listener) {
        return this.control.remove(key, description, listener);
    }

    @Override
    public byte[] remove(DHTTransportContact[] contacts, byte[] key, String description, DHTOperationListener listener) {
        return this.control.remove(contacts, key, description, listener);
    }

    @Override
    public DHTTransport getTransport() {
        return this.control.getTransport();
    }

    @Override
    public DHTRouter getRouter() {
        return this.control.getRouter();
    }

    @Override
    public DHTControl getControl() {
        return this.control;
    }

    @Override
    public DHTDB getDataBase() {
        return this.control.getDataBase();
    }

    @Override
    public DHTNATPuncher getNATPuncher() {
        return this.nat_puncher;
    }

    public DHTSpeedTester getSpeedTester() {
        return this.speed_tester;
    }

    @Override
    public DHTStorageAdapter getStorageAdapter() {
        return this.storage_adapter;
    }

    @Override
    public void integrate(boolean full_wait) {
        this.control.seed(full_wait);
        if (this.nat_puncher != null) {
            this.nat_puncher.start();
        }
    }

    @Override
    public void destroy() {
        if (this.nat_puncher != null) {
            this.nat_puncher.destroy();
        }
        DHTNetworkPositionManager.destroy(this.storage_adapter);
        AERunStateHandler.removeListener(this);
        if (this.control != null) {
            this.control.destroy();
        }
        if (this.speed_tester != null) {
            this.speed_tester.destroy();
        }
    }

    @Override
    public void exportState(DataOutputStream os, int max) throws IOException {
        this.control.exportState(os, max);
    }

    @Override
    public void importState(DataInputStream is) throws IOException {
        this.control.importState(is);
    }

    @Override
    public void setLogging(boolean on) {
        DHTLog.setLogging(on);
    }

    @Override
    public DHTLogger getLogger() {
        return this.logger;
    }

    @Override
    public void print(boolean full) {
        this.control.print(full);
    }

    @Override
    public void addListener(DHTListener listener) {
        this.listeners.add(listener);
        DHTSpeedTester st = this.speed_tester;
        if (st != null) {
            listener.speedTesterAvailable(st);
        }
    }

    @Override
    public void removeListener(DHTListener listener) {
        this.listeners.remove(listener);
    }
}

