/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.transport.loopback;

import com.aelitis.azureus.core.dht.transport.DHTTransport;
import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.dht.transport.DHTTransportException;
import com.aelitis.azureus.core.dht.transport.DHTTransportFindValueReply;
import com.aelitis.azureus.core.dht.transport.DHTTransportFullStats;
import com.aelitis.azureus.core.dht.transport.DHTTransportListener;
import com.aelitis.azureus.core.dht.transport.DHTTransportProgressListener;
import com.aelitis.azureus.core.dht.transport.DHTTransportReplyHandler;
import com.aelitis.azureus.core.dht.transport.DHTTransportRequestHandler;
import com.aelitis.azureus.core.dht.transport.DHTTransportStats;
import com.aelitis.azureus.core.dht.transport.DHTTransportStoreReply;
import com.aelitis.azureus.core.dht.transport.DHTTransportTransferHandler;
import com.aelitis.azureus.core.dht.transport.DHTTransportValue;
import com.aelitis.azureus.core.dht.transport.loopback.DHTTransportLoopbackContactImpl;
import com.aelitis.azureus.core.dht.transport.loopback.DHTTransportLoopbackStatsImpl;
import com.aelitis.azureus.core.dht.transport.util.DHTTransportRequestCounter;
import com.aelitis.azureus.core.dht.transport.util.DHTTransportStatsImpl;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.SHA1Simple;

public class DHTTransportLoopbackImpl
implements DHTTransport {
    public static final byte VERSION = 1;
    public static int LATENCY = 0;
    public static int FAIL_PERCENTAGE = 0;
    private static long node_id_seed_next = 0L;
    private static final Map node_map = new HashMap();
    static final List dispatch_queue = new ArrayList();
    static final AESemaphore dispatch_queue_sem = new AESemaphore("DHTTransportLoopback");
    static final AEMonitor class_mon = new AEMonitor("DHTTransportLoopback:class");
    private byte[] node_id;
    private DHTTransportContact local_contact;
    private final int id_byte_length;
    private DHTTransportRequestHandler request_handler;
    private final DHTTransportStatsImpl stats = new DHTTransportLoopbackStatsImpl(1);
    private final List listeners = new ArrayList();

    static {
        AEThread dispatcher = new AEThread("DHTTransportLoopback"){

            @Override
            public void runSupport() {
                while (true) {
                    Runnable r;
                    dispatch_queue_sem.reserve();
                    try {
                        class_mon.enter();
                        r = (Runnable)dispatch_queue.remove(0);
                    }
                    finally {
                        class_mon.exit();
                    }
                    if (LATENCY > 0) {
                        try {
                            Thread.sleep(LATENCY);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    r.run();
                }
            }
        };
        dispatcher.start();
    }

    @Override
    public byte getProtocolVersion() {
        return 1;
    }

    @Override
    public byte getMinimumProtocolVersion() {
        return 1;
    }

    @Override
    public int getNetwork() {
        return 0;
    }

    @Override
    public boolean isIPV6() {
        return false;
    }

    public static void setLatency(int _latency) {
        LATENCY = _latency;
    }

    public static void setFailPercentage(int p) {
        FAIL_PERCENTAGE = p;
    }

    public static DHTTransportStats getOverallStats() {
        try {
            class_mon.enter();
            DHTTransportLoopbackStatsImpl overall_stats = new DHTTransportLoopbackStatsImpl(1);
            Iterator it = node_map.values().iterator();
            while (it.hasNext()) {
                overall_stats.add((DHTTransportStatsImpl)((DHTTransportLoopbackImpl)it.next()).getStats());
            }
            DHTTransportLoopbackStatsImpl dHTTransportLoopbackStatsImpl = overall_stats;
            return dHTTransportLoopbackStatsImpl;
        }
        finally {
            class_mon.exit();
        }
    }

    public DHTTransportLoopbackImpl(int _id_byte_length) {
        this.id_byte_length = _id_byte_length;
        try {
            class_mon.enter();
            byte[] temp = new SHA1Simple().calculateHash(("" + node_id_seed_next++).getBytes());
            this.node_id = new byte[this.id_byte_length];
            System.arraycopy(temp, 0, this.node_id, 0, this.id_byte_length);
            node_map.put(new HashWrapper(this.node_id), this);
            this.local_contact = new DHTTransportLoopbackContactImpl(this, this.node_id);
        }
        finally {
            class_mon.exit();
        }
    }

    @Override
    public DHTTransportContact getLocalContact() {
        return this.local_contact;
    }

    @Override
    public void setPort(int port) {
    }

    @Override
    public int getPort() {
        return 0;
    }

    @Override
    public byte getGenericFlags() {
        return 0;
    }

    @Override
    public void setGenericFlag(byte flag, boolean value) {
    }

    @Override
    public void setSuspended(boolean susp) {
    }

    @Override
    public long getTimeout() {
        return 0L;
    }

    @Override
    public void setTimeout(long millis) {
    }

    @Override
    public boolean isReachable() {
        return true;
    }

    @Override
    public DHTTransportContact[] getReachableContacts() {
        return new DHTTransportContact[0];
    }

    @Override
    public DHTTransportContact[] getRecentContacts() {
        return new DHTTransportContact[0];
    }

    protected DHTTransportLoopbackImpl findTarget(byte[] id) {
        try {
            class_mon.enter();
            DHTTransportLoopbackImpl dHTTransportLoopbackImpl = (DHTTransportLoopbackImpl)node_map.get(new HashWrapper(id));
            return dHTTransportLoopbackImpl;
        }
        finally {
            class_mon.exit();
        }
    }

    @Override
    public void setRequestHandler(DHTTransportRequestHandler _request_handler) {
        this.request_handler = new DHTTransportRequestCounter(_request_handler, this.stats);
    }

    protected DHTTransportRequestHandler getRequestHandler() {
        return this.request_handler;
    }

    public Map<String, Object> exportContactToMap(DHTTransportContact contact) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("i", contact.getID());
        return result;
    }

    public void exportContact(DHTTransportContact contact, DataOutputStream os) throws IOException {
        os.writeInt(1);
        os.writeInt(this.id_byte_length);
        os.write(contact.getID());
    }

    @Override
    public DHTTransportContact importContact(DataInputStream is, boolean is_bootstrap) throws IOException {
        int version = is.readInt();
        if (version != 1) {
            throw new IOException("Unsuported version");
        }
        int id_len = is.readInt();
        if (id_len != this.id_byte_length) {
            throw new IOException("Imported contact has incorrect ID length");
        }
        byte[] id = new byte[this.id_byte_length];
        is.read(id);
        DHTTransportLoopbackContactImpl contact = new DHTTransportLoopbackContactImpl(this, id);
        this.request_handler.contactImported(contact, is_bootstrap);
        return contact;
    }

    public void removeContact(DHTTransportContact contact) {
    }

    protected void run(AERunnable r) {
        try {
            class_mon.enter();
            dispatch_queue.add(r);
        }
        finally {
            class_mon.exit();
        }
        dispatch_queue_sem.release();
    }

    @Override
    public DHTTransportStats getStats() {
        return this.stats;
    }

    public void sendPing(final DHTTransportContact contact, final DHTTransportReplyHandler handler) {
        AERunnable runnable = new AERunnable(){

            @Override
            public void runSupport() {
                DHTTransportLoopbackImpl.this.sendPingSupport(contact, handler);
            }
        };
        this.run(runnable);
    }

    public void sendPingSupport(DHTTransportContact contact, DHTTransportReplyHandler handler) {
        DHTTransportLoopbackImpl target = this.findTarget(contact.getID());
        this.stats.pingSent(null);
        if (target == null || this.triggerFailure()) {
            this.stats.pingFailed();
            handler.failed(contact, new Exception("failed"));
        } else {
            this.stats.pingOK();
            target.getRequestHandler().pingRequest(new DHTTransportLoopbackContactImpl(target, this.node_id));
            handler.pingReply(contact, 0);
        }
    }

    public void sendKeyBlock(final DHTTransportContact contact, final DHTTransportReplyHandler handler, final byte[] request2, final byte[] sig) {
        AERunnable runnable = new AERunnable(){

            @Override
            public void runSupport() {
                DHTTransportLoopbackImpl.this.sendKeyBlockSupport(contact, handler, request2, sig);
            }
        };
        this.run(runnable);
    }

    public void sendKeyBlockSupport(DHTTransportContact contact, DHTTransportReplyHandler handler, byte[] request2, byte[] sig) {
        DHTTransportLoopbackImpl target = this.findTarget(contact.getID());
        this.stats.keyBlockSent(null);
        if (target == null || this.triggerFailure()) {
            this.stats.keyBlockFailed();
            handler.failed(contact, new Exception("failed"));
        } else {
            this.stats.keyBlockOK();
            target.getRequestHandler().keyBlockRequest(new DHTTransportLoopbackContactImpl(target, this.node_id), request2, sig);
            handler.keyBlockReply(contact);
        }
    }

    public void sendStats(final DHTTransportContact contact, final DHTTransportReplyHandler handler) {
        AERunnable runnable = new AERunnable(){

            @Override
            public void runSupport() {
                DHTTransportLoopbackImpl.this.sendStatsSupport(contact, handler);
            }
        };
        this.run(runnable);
    }

    public void sendStatsSupport(DHTTransportContact contact, DHTTransportReplyHandler handler) {
        DHTTransportLoopbackImpl target = this.findTarget(contact.getID());
        this.stats.statsSent(null);
        if (target == null || this.triggerFailure()) {
            this.stats.statsFailed();
            handler.failed(contact, new Exception("failed"));
        } else {
            this.stats.statsOK();
            DHTTransportFullStats res = target.getRequestHandler().statsRequest(new DHTTransportLoopbackContactImpl(target, this.node_id));
            handler.statsReply(contact, res);
        }
    }

    public void sendStore(final DHTTransportContact contact, final DHTTransportReplyHandler handler, final byte[][] keys, final DHTTransportValue[][] value_sets, boolean immediate) {
        AERunnable runnable = new AERunnable(){

            @Override
            public void runSupport() {
                DHTTransportLoopbackImpl.this.sendStoreSupport(contact, handler, keys, value_sets);
            }
        };
        this.run(runnable);
    }

    public void sendStoreSupport(DHTTransportContact contact, DHTTransportReplyHandler handler, byte[][] keys, DHTTransportValue[][] value_sets) {
        DHTTransportLoopbackImpl target = this.findTarget(contact.getID());
        this.stats.storeSent(null);
        if (target == null || this.triggerFailure()) {
            this.stats.storeFailed();
            handler.failed(contact, new Exception("failed"));
        } else {
            this.stats.storeOK();
            DHTTransportLoopbackContactImpl temp = new DHTTransportLoopbackContactImpl(target, this.node_id);
            temp.setRandomID(contact.getRandomID());
            DHTTransportStoreReply rep = target.getRequestHandler().storeRequest(temp, keys, value_sets);
            if (rep.blocked()) {
                handler.keyBlockRequest(contact, rep.getBlockRequest(), rep.getBlockSignature());
                handler.failed(contact, new Throwable("key blocked"));
            } else {
                handler.storeReply(contact, rep.getDiversificationTypes());
            }
        }
    }

    public void sendQueryStore(DHTTransportContact contact, DHTTransportReplyHandler handler, int header_length, List<Object[]> key_details) {
        handler.failed(contact, new Throwable("not implemented"));
    }

    public void sendFindNode(final DHTTransportContact contact, final DHTTransportReplyHandler handler, final byte[] nid) {
        AERunnable runnable = new AERunnable(){

            @Override
            public void runSupport() {
                DHTTransportLoopbackImpl.this.sendFindNodeSupport(contact, handler, nid);
            }
        };
        this.run(runnable);
    }

    public void sendFindNodeSupport(DHTTransportContact contact, DHTTransportReplyHandler handler, byte[] nid) {
        DHTTransportLoopbackImpl target = this.findTarget(contact.getID());
        this.stats.findNodeSent(null);
        if (target == null || this.triggerFailure()) {
            this.stats.findNodeFailed();
            handler.failed(contact, new Exception("failed"));
        } else {
            this.stats.findNodeOK();
            DHTTransportLoopbackContactImpl temp = new DHTTransportLoopbackContactImpl(target, this.node_id);
            DHTTransportContact[] res = target.getRequestHandler().findNodeRequest(temp, nid);
            contact.setRandomID(temp.getRandomID());
            DHTTransportContact[] trans_res = new DHTTransportContact[res.length];
            int i = 0;
            while (i < res.length) {
                trans_res[i] = new DHTTransportLoopbackContactImpl(this, res[i].getID());
                ++i;
            }
            handler.findNodeReply(contact, trans_res);
        }
    }

    public void sendFindValue(final DHTTransportContact contact, final DHTTransportReplyHandler handler, final byte[] key, final int max, final short flags) {
        AERunnable runnable = new AERunnable(){

            @Override
            public void runSupport() {
                DHTTransportLoopbackImpl.this.sendFindValueSupport(contact, handler, key, max, flags);
            }
        };
        this.run(runnable);
    }

    public void sendFindValueSupport(DHTTransportContact contact, DHTTransportReplyHandler handler, byte[] key, int max, short flags) {
        DHTTransportLoopbackImpl target = this.findTarget(contact.getID());
        this.stats.findValueSent(null);
        if (target == null || this.triggerFailure()) {
            this.stats.findValueFailed();
            handler.failed(contact, new Exception("failed"));
        } else {
            this.stats.findValueOK();
            DHTTransportFindValueReply find_res = target.getRequestHandler().findValueRequest(new DHTTransportLoopbackContactImpl(target, this.node_id), key, max, flags);
            if (find_res.hit()) {
                handler.findValueReply(contact, find_res.getValues(), find_res.getDiversificationType(), false);
            } else if (find_res.blocked()) {
                handler.keyBlockRequest(contact, find_res.getBlockedKey(), find_res.getBlockedSignature());
                handler.failed(contact, new Throwable("key blocked"));
            } else {
                DHTTransportContact[] res = find_res.getContacts();
                DHTTransportContact[] trans_res = new DHTTransportContact[res.length];
                int i = 0;
                while (i < res.length) {
                    trans_res[i] = new DHTTransportLoopbackContactImpl(this, res[i].getID());
                    ++i;
                }
                handler.findValueReply(contact, trans_res);
            }
        }
    }

    protected boolean triggerFailure() {
        return Math.random() * 100.0 < (double)FAIL_PERCENTAGE;
    }

    @Override
    public void registerTransferHandler(byte[] handler_key, DHTTransportTransferHandler handler) {
    }

    @Override
    public void registerTransferHandler(byte[] handler_key, DHTTransportTransferHandler handler, Map<String, Object> options) {
    }

    @Override
    public void unregisterTransferHandler(byte[] handler_key, DHTTransportTransferHandler handler) {
    }

    @Override
    public byte[] readTransfer(DHTTransportProgressListener listener, DHTTransportContact target, byte[] handler_key, byte[] key, long timeout) throws DHTTransportException {
        throw new DHTTransportException("not imp");
    }

    @Override
    public void writeTransfer(DHTTransportProgressListener listener, DHTTransportContact target, byte[] handler_key, byte[] key, byte[] data, long timeout) throws DHTTransportException {
        throw new DHTTransportException("not imp");
    }

    @Override
    public byte[] writeReadTransfer(DHTTransportProgressListener listener, DHTTransportContact target, byte[] handler_key, byte[] data, long timeout) throws DHTTransportException {
        throw new DHTTransportException("not imp");
    }

    @Override
    public boolean supportsStorage() {
        return true;
    }

    @Override
    public void addListener(DHTTransportListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeListener(DHTTransportListener l) {
        this.listeners.remove(l);
    }
}

