/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.transport.udp.impl;

import com.aelitis.azureus.core.dht.DHTLogger;
import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPosition;
import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPositionManager;
import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPositionProvider;
import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPositionProviderListener;
import com.aelitis.azureus.core.dht.transport.DHTTransportAlternativeContact;
import com.aelitis.azureus.core.dht.transport.DHTTransportAlternativeNetwork;
import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.dht.transport.DHTTransportException;
import com.aelitis.azureus.core.dht.transport.DHTTransportFindValueReply;
import com.aelitis.azureus.core.dht.transport.DHTTransportFullStats;
import com.aelitis.azureus.core.dht.transport.DHTTransportListener;
import com.aelitis.azureus.core.dht.transport.DHTTransportProgressListener;
import com.aelitis.azureus.core.dht.transport.DHTTransportQueryStoreReply;
import com.aelitis.azureus.core.dht.transport.DHTTransportReplyHandler;
import com.aelitis.azureus.core.dht.transport.DHTTransportReplyHandlerAdapter;
import com.aelitis.azureus.core.dht.transport.DHTTransportRequestHandler;
import com.aelitis.azureus.core.dht.transport.DHTTransportStats;
import com.aelitis.azureus.core.dht.transport.DHTTransportStoreReply;
import com.aelitis.azureus.core.dht.transport.DHTTransportTransferHandler;
import com.aelitis.azureus.core.dht.transport.DHTTransportValue;
import com.aelitis.azureus.core.dht.transport.udp.DHTTransportUDP;
import com.aelitis.azureus.core.dht.transport.udp.DHTTransportUDPContact;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTTransportAlternativeNetworkImpl;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTTransportUDPContactImpl;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTTransportUDPStatsImpl;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketData;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketHelper;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketReply;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketReplyError;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketReplyFindNode;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketReplyFindValue;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketReplyKeyBlock;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketReplyPing;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketReplyQueryStorage;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketReplyStats;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketReplyStore;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketRequest;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketRequestFindNode;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketRequestFindValue;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketRequestKeyBlock;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketRequestPing;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketRequestQueryStorage;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketRequestStats;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketRequestStore;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPUtils;
import com.aelitis.azureus.core.dht.transport.udp.impl.packethandler.DHTUDPPacketHandler;
import com.aelitis.azureus.core.dht.transport.udp.impl.packethandler.DHTUDPPacketHandlerException;
import com.aelitis.azureus.core.dht.transport.udp.impl.packethandler.DHTUDPPacketHandlerFactory;
import com.aelitis.azureus.core.dht.transport.udp.impl.packethandler.DHTUDPPacketHandlerStub;
import com.aelitis.azureus.core.dht.transport.udp.impl.packethandler.DHTUDPPacketReceiver;
import com.aelitis.azureus.core.dht.transport.udp.impl.packethandler.DHTUDPRequestHandler;
import com.aelitis.azureus.core.dht.transport.util.DHTTransferHandler;
import com.aelitis.azureus.core.dht.transport.util.DHTTransportRequestCounter;
import com.aelitis.azureus.core.util.average.AverageFactory;
import com.aelitis.azureus.core.util.average.MovingImmediateAverage;
import com.aelitis.azureus.core.util.bloom.BloomFilter;
import com.aelitis.azureus.core.util.bloom.BloomFilterFactory;
import com.aelitis.azureus.core.versioncheck.VersionCheckClient;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.ipfilter.IpFilter;
import org.gudy.azureus2.core3.ipfilter.IpFilterManagerFactory;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Average;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DelayedEvent;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

public class DHTTransportUDPImpl
implements DHTTransportUDP,
DHTUDPRequestHandler {
    public static boolean TEST_EXTERNAL_IP = false;
    public static final int MIN_ADDRESS_CHANGE_PERIOD_INIT_DEFAULT = 300000;
    public static final int MIN_ADDRESS_CHANGE_PERIOD_NEXT_DEFAULT = 600000;
    public static final int STORE_TIMEOUT_MULTIPLIER = 2;
    private String external_address;
    private int min_address_change_period = 300000;
    private final byte protocol_version;
    private final int network;
    private final boolean v6;
    private final String ip_override;
    private int port;
    private final int max_fails_for_live;
    private final int max_fails_for_unknown;
    private long request_timeout;
    private long store_timeout;
    private boolean reachable;
    private boolean reachable_accurate;
    private final int dht_send_delay;
    private final int dht_receive_delay;
    final DHTLogger logger;
    private DHTUDPPacketHandler packet_handler;
    private DHTTransportRequestHandler request_handler;
    private DHTTransportUDPContactImpl local_contact;
    private long last_address_change;
    final List listeners = new ArrayList();
    private final IpFilter ip_filter = IpFilterManagerFactory.getSingleton().getIPFilter();
    private DHTTransportUDPStatsImpl stats;
    private boolean bootstrap_node = false;
    private byte generic_flags = 0;
    private byte generic_flags2 = VersionCheckClient.getSingleton().getDHTFlags();
    private static final int CONTACT_HISTORY_MAX = 32;
    private static final int CONTACT_HISTORY_PING_SIZE = 24;
    final Map<InetSocketAddress, DHTTransportContact> contact_history = new LinkedHashMap<InetSocketAddress, DHTTransportContact>(32, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<InetSocketAddress, DHTTransportContact> eldest) {
            return this.size() > 32;
        }
    };
    private static final int ROUTABLE_CONTACT_HISTORY_MAX = 128;
    final Map<InetSocketAddress, DHTTransportContact> routable_contact_history = new LinkedHashMap<InetSocketAddress, DHTTransportContact>(128, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<InetSocketAddress, DHTTransportContact> eldest) {
            return this.size() > 128;
        }
    };
    private long other_routable_total;
    private long other_non_routable_total;
    private final MovingImmediateAverage routeable_percentage_average = AverageFactory.MovingImmediateAverage(8);
    private static final int RECENT_REPORTS_HISTORY_MAX = 32;
    private final Map recent_reports = new LinkedHashMap(32, 0.75f, true){

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 32;
        }
    };
    private static final int STATS_PERIOD = 60000;
    private static final int STATS_DURATION_SECS = 600;
    private static final long STATS_INIT_PERIOD = 900000L;
    private long stats_start_time = SystemTime.getCurrentTime();
    private long last_alien_count;
    private long last_alien_fv_count;
    private final Average alien_average = Average.getInstance(60000, 600);
    private final Average alien_fv_average = Average.getInstance(60000, 600);
    private Random random;
    private static final int BAD_IP_BLOOM_FILTER_SIZE = 32000;
    private BloomFilter bad_ip_bloom_filter;
    private static final AEMonitor class_mon = new AEMonitor("DHTTransportUDP:class");
    final AEMonitor this_mon = new AEMonitor("DHTTransportUDP");
    private boolean initial_address_change_deferred;
    private boolean address_changing;
    private final DHTTransferHandler xfer_handler;
    private final Map<Integer, DHTTransportAlternativeNetworkImpl> alt_net_states = new HashMap<Integer, DHTTransportAlternativeNetworkImpl>();
    private volatile Map<Integer, DHTTransportAlternativeNetwork> alt_net_providers = new HashMap<Integer, DHTTransportAlternativeNetwork>();
    private final Object alt_net_providers_lock = new Object();

    public DHTTransportUDPImpl(byte _protocol_version, int _network, boolean _v6, String _ip, String _default_ip, int _port, int _max_fails_for_live, int _max_fails_for_unknown, long _timeout, int _dht_send_delay, int _dht_receive_delay, boolean _bootstrap_node, boolean _initial_reachability, DHTLogger _logger) throws DHTTransportException {
        int[] nArray = DHTTransportAlternativeNetwork.AT_ALL;
        int n = DHTTransportAlternativeNetwork.AT_ALL.length;
        int n2 = 0;
        while (n2 < n) {
            Integer net = nArray[n2];
            this.alt_net_states.put(net, new DHTTransportAlternativeNetworkImpl(net));
            ++n2;
        }
        this.protocol_version = _protocol_version;
        this.network = _network;
        this.v6 = _v6;
        this.ip_override = _ip;
        this.port = _port;
        this.max_fails_for_live = _max_fails_for_live;
        this.max_fails_for_unknown = _max_fails_for_unknown;
        this.request_timeout = _timeout;
        this.dht_send_delay = _dht_send_delay;
        this.dht_receive_delay = _dht_receive_delay;
        this.bootstrap_node = _bootstrap_node;
        this.reachable = _initial_reachability;
        this.logger = _logger;
        this.store_timeout = this.request_timeout * 2L;
        try {
            this.random = RandomUtils.SECURE_RANDOM;
        }
        catch (Throwable e) {
            this.random = new Random();
            this.logger.log(e);
        }
        this.xfer_handler = new DHTTransferHandler(new DHTTransferHandler.Adapter(){

            @Override
            public void sendRequest(DHTTransportContact _contact, DHTTransferHandler.Packet packet) {
                DHTTransportUDPContactImpl contact = (DHTTransportUDPContactImpl)_contact;
                DHTUDPPacketData request2 = new DHTUDPPacketData(DHTTransportUDPImpl.this, packet.getConnectionId(), DHTTransportUDPImpl.this.local_contact, contact);
                request2.setDetails(packet.getPacketType(), packet.getTransferKey(), packet.getRequestKey(), packet.getData(), packet.getStartPosition(), packet.getLength(), packet.getTotalLength());
                try {
                    DHTTransportUDPImpl.this.checkAddress(contact);
                    DHTTransportUDPImpl.this.stats.dataSent(request2);
                    DHTTransportUDPImpl.this.packet_handler.send(request2, contact.getTransportAddress());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }

            @Override
            public long getConnectionID() {
                return DHTTransportUDPImpl.this.getConnectionID();
            }
        }, 1317, 1.0f, this.logger);
        int last_pct = COConfigurationManager.getIntParameter("dht.udp.net" + this.network + ".routeable_pct", -1);
        if (last_pct > 0) {
            this.routeable_percentage_average.update(last_pct);
        }
        DHTUDPUtils.registerTransport(this);
        this.createPacketHandler();
        SimpleTimer.addPeriodicEvent("DHTUDP:stats", 60000L, new TimerEventPerformer(){
            private int tick_count;

            @Override
            public void perform(TimerEvent event2) {
                DHTTransportUDPImpl.this.updateStats(this.tick_count++);
                DHTTransportUDPImpl.this.checkAltContacts();
            }
        });
        String default_ip = _default_ip == null ? (this.v6 ? "::1" : "127.0.0.1") : _default_ip;
        this.getExternalAddress(default_ip, this.logger);
        InetSocketAddress address = new InetSocketAddress(this.external_address, this.port);
        DHTNetworkPositionManager.addProviderListener(new DHTNetworkPositionProviderListener(){

            @Override
            public void providerAdded(DHTNetworkPositionProvider provider2) {
                if (DHTTransportUDPImpl.this.local_contact != null) {
                    DHTTransportUDPImpl.this.local_contact.createNetworkPositions(true);
                    try {
                        DHTTransportUDPImpl.this.this_mon.enter();
                        for (DHTTransportContact c : DHTTransportUDPImpl.this.contact_history.values()) {
                            c.createNetworkPositions(false);
                        }
                        for (DHTTransportContact c : DHTTransportUDPImpl.this.routable_contact_history.values()) {
                            c.createNetworkPositions(false);
                        }
                    }
                    finally {
                        DHTTransportUDPImpl.this.this_mon.exit();
                    }
                    int i = 0;
                    while (i < DHTTransportUDPImpl.this.listeners.size()) {
                        try {
                            ((DHTTransportListener)DHTTransportUDPImpl.this.listeners.get(i)).resetNetworkPositions();
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                        ++i;
                    }
                }
            }

            @Override
            public void providerRemoved(DHTNetworkPositionProvider provider2) {
            }
        });
        this.logger.log("Initial external address: " + address);
        this.local_contact = new DHTTransportUDPContactImpl(true, this, address, address, this.protocol_version, this.random.nextInt(), 0L, 0);
    }

    protected void createPacketHandler() throws DHTTransportException {
        DHTUDPPacketHelper.registerCodecs();
        try {
            if (this.packet_handler != null && !this.packet_handler.isDestroyed()) {
                this.packet_handler.destroy();
            }
            this.packet_handler = DHTUDPPacketHandlerFactory.getHandler(this, this);
        }
        catch (Throwable e) {
            throw new DHTTransportException("Failed to get packet handler", e);
        }
        this.packet_handler.setDelays(this.dht_send_delay, this.dht_receive_delay, (int)this.request_timeout);
        this.stats_start_time = SystemTime.getCurrentTime();
        if (this.stats == null) {
            this.stats = new DHTTransportUDPStatsImpl(this, this.protocol_version, this.packet_handler.getStats());
        } else {
            this.stats.setStats(this.packet_handler.getStats());
        }
    }

    @Override
    public DHTUDPRequestHandler getRequestHandler() {
        return this;
    }

    @Override
    public DHTUDPPacketHandler getPacketHandler() {
        return this.packet_handler;
    }

    @Override
    public void setSuspended(boolean susp) {
        if (susp) {
            if (this.packet_handler != null) {
                this.packet_handler.destroy();
            }
        } else if (this.packet_handler == null || this.packet_handler.isDestroyed()) {
            try {
                this.createPacketHandler();
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    protected void updateStats(int tick_count) {
        this.generic_flags2 = VersionCheckClient.getSingleton().getDHTFlags();
        long alien_count = 0L;
        long[] aliens = this.stats.getAliens();
        int i = 0;
        while (i < aliens.length) {
            alien_count += aliens[i];
            ++i;
        }
        long alien_fv_count = aliens[1];
        this.alien_average.addValue((alien_count - this.last_alien_count) * 60000L / 1000L);
        this.alien_fv_average.addValue((alien_fv_count - this.last_alien_fv_count) * 60000L / 1000L);
        this.last_alien_count = alien_count;
        this.last_alien_fv_count = alien_fv_count;
        long now = SystemTime.getCurrentTime();
        if (now < this.stats_start_time) {
            this.stats_start_time = now;
        } else {
            if (Constants.isCVSVersion()) {
                long fv_average = this.alien_fv_average.getAverage();
                long all_average = this.alien_average.getAverage();
                this.logger.log("Aliens for net " + this.network + ": " + fv_average + "/" + all_average);
            }
            if (now - this.stats_start_time > 900000L) {
                this.reachable_accurate = true;
                boolean old_reachable = this.reachable;
                this.reachable = this.alien_fv_average.getAverage() > 1L ? true : this.alien_average.getAverage() > 3L;
                if (old_reachable != this.reachable) {
                    int i2 = 0;
                    while (i2 < this.listeners.size()) {
                        try {
                            ((DHTTransportListener)this.listeners.get(i2)).reachabilityChanged(this.reachable);
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                        ++i2;
                    }
                }
            }
        }
        int pct = this.getRouteablePercentage();
        if (pct > 0) {
            COConfigurationManager.setParameter("dht.udp.net" + this.network + ".routeable_pct", pct);
        }
    }

    protected void recordSkew(InetSocketAddress originator_address, long skew) {
        if (this.stats != null) {
            this.stats.recordSkew(originator_address, skew);
        }
    }

    protected int getNodeStatus() {
        if (this.bootstrap_node) {
            return 0;
        }
        if (this.reachable_accurate) {
            int status = this.reachable ? 1 : 0;
            return status;
        }
        return -1;
    }

    @Override
    public boolean isReachable() {
        return this.reachable;
    }

    @Override
    public byte getProtocolVersion() {
        return this.protocol_version;
    }

    @Override
    public byte getMinimumProtocolVersion() {
        return this.getNetwork() == 1 ? DHTTransportUDP.PROTOCOL_VERSION_MIN_CVS : DHTTransportUDP.PROTOCOL_VERSION_MIN;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void setPort(int new_port) throws DHTTransportException {
        if (new_port == this.port) {
            return;
        }
        this.port = new_port;
        this.createPacketHandler();
        this.setLocalContact();
    }

    @Override
    public long getTimeout() {
        return this.request_timeout;
    }

    @Override
    public void setTimeout(long timeout) {
        if (this.request_timeout == timeout) {
            return;
        }
        this.request_timeout = timeout;
        this.store_timeout = this.request_timeout * 2L;
        this.packet_handler.setDelays(this.dht_send_delay, this.dht_receive_delay, (int)this.request_timeout);
    }

    @Override
    public int getNetwork() {
        return this.network;
    }

    @Override
    public byte getGenericFlags() {
        return this.generic_flags;
    }

    public byte getGenericFlags2() {
        return this.generic_flags2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setGenericFlag(byte flag, boolean value) {
        DHTTransportUDPImpl dHTTransportUDPImpl = this;
        synchronized (dHTTransportUDPImpl) {
            this.generic_flags = value ? (byte)(this.generic_flags | flag) : (byte)(this.generic_flags & ~flag);
        }
    }

    @Override
    public boolean isIPV6() {
        return this.v6;
    }

    public void testInstanceIDChange() throws DHTTransportException {
        this.local_contact = new DHTTransportUDPContactImpl(true, this, this.local_contact.getTransportAddress(), this.local_contact.getExternalAddress(), this.protocol_version, this.random.nextInt(), 0L, 0);
    }

    public void testTransportIDChange() throws DHTTransportException {
        this.external_address = this.external_address.equals("127.0.0.1") ? "192.168.0.2" : "127.0.0.1";
        InetSocketAddress address = new InetSocketAddress(this.external_address, this.port);
        this.local_contact = new DHTTransportUDPContactImpl(true, this, address, address, this.protocol_version, this.local_contact.getInstanceID(), 0L, 0);
        int i = 0;
        while (i < this.listeners.size()) {
            try {
                ((DHTTransportListener)this.listeners.get(i)).localContactChanged(this.local_contact);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
    }

    public void testExternalAddressChange() {
        try {
            Iterator<DHTTransportContact> it = this.contact_history.values().iterator();
            DHTTransportUDPContactImpl c1 = (DHTTransportUDPContactImpl)it.next();
            DHTTransportUDPContactImpl c2 = (DHTTransportUDPContactImpl)it.next();
            this.externalAddressChange(c1, c2.getExternalAddress(), true);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public void testNetworkAlive(boolean alive) {
        this.packet_handler.testNetworkAlive(alive);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void getExternalAddress(String default_address, DHTLogger log) {
        try {
            class_mon.enter();
            String new_external_address = null;
            try {
                InetAddress public_address;
                block21: {
                    ArrayList<DHTTransportContact> contacts;
                    log.log("Obtaining external address");
                    if (TEST_EXTERNAL_IP) {
                        new_external_address = this.v6 ? "::1" : "127.0.0.1";
                        log.log("    External IP address obtained from test data: " + new_external_address);
                    }
                    if (this.ip_override != null) {
                        new_external_address = this.ip_override;
                        log.log("    External IP address explicitly overridden: " + new_external_address);
                    }
                    if (new_external_address != null) break block21;
                    try {
                        this.this_mon.enter();
                        contacts = new ArrayList<DHTTransportContact>(this.contact_history.values());
                    }
                    finally {
                        this.this_mon.exit();
                    }
                    String returned_address = null;
                    int returned_matches = 0;
                    int search_lim = Math.min(24, contacts.size());
                    log.log("    Contacts to search = " + search_lim);
                    int i = 0;
                    while (i < search_lim) {
                        block20: {
                            DHTTransportUDPContactImpl contact;
                            block22: {
                                contact = (DHTTransportUDPContactImpl)contacts.remove(RandomUtils.nextInt(contacts.size()));
                                InetSocketAddress a = this.askContactForExternalAddress(contact);
                                if (a == null || a.getAddress() == null) break block22;
                                String ip = a.getAddress().getHostAddress();
                                if (returned_address == null) {
                                    returned_address = ip;
                                    log.log("    : contact " + contact.getString() + " reported external address as '" + ip + "'");
                                    ++returned_matches;
                                    break block20;
                                } else if (returned_address.equals(ip)) {
                                    log.log("    : contact " + contact.getString() + " also reported external address as '" + ip + "'");
                                    if (++returned_matches == 3) {
                                        new_external_address = returned_address;
                                        log.log("    External IP address obtained from contacts: " + returned_address);
                                        break;
                                    }
                                    break block20;
                                } else {
                                    log.log("    : contact " + contact.getString() + " reported external address as '" + ip + "', abandoning due to mismatch");
                                    break;
                                }
                            }
                            log.log("    : contact " + contact.getString() + " didn't reply");
                        }
                        ++i;
                    }
                }
                if (new_external_address == null && (public_address = this.logger.getPluginInterface().getUtilities().getPublicAddress(this.v6)) != null) {
                    new_external_address = public_address.getHostAddress();
                    log.log("    External IP address obtained: " + new_external_address);
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            if (new_external_address == null) {
                new_external_address = default_address;
                log.log("    External IP address defaulted:  " + new_external_address);
            }
            if (this.external_address == null || !this.external_address.equals(new_external_address)) {
                this.informLocalAddress(new_external_address);
            }
            this.external_address = new_external_address;
            return;
        }
        finally {
            class_mon.exit();
        }
    }

    protected void informLocalAddress(String address) {
        int i = 0;
        while (i < this.listeners.size()) {
            try {
                ((DHTTransportListener)this.listeners.get(i)).currentAddress(address);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void externalAddressChange(final DHTTransportUDPContactImpl reporter, final InetSocketAddress new_address, boolean force) throws DHTTransportException {
        InetAddress ia = new_address.getAddress();
        if (ia == null) {
            Debug.out("reported new external address '" + new_address + "' is unresolved");
            throw new DHTTransportException("Address '" + new_address + "' is unresolved");
        }
        if (ia instanceof Inet4Address && this.v6 || ia instanceof Inet6Address && !this.v6) {
            return;
        }
        final String new_ip = ia.getHostAddress();
        if (new_ip.equals(this.external_address)) {
            return;
        }
        try {
            this.this_mon.enter();
            long now = SystemTime.getCurrentTime();
            if (now - this.last_address_change < (long)this.min_address_change_period) {
                return;
            }
            if (this.contact_history.size() < 32 && !force) {
                if (this.initial_address_change_deferred) return;
                this.initial_address_change_deferred = true;
                this.logger.log("Node " + reporter.getString() + " has reported that the external IP address is '" + new_address + "': deferring new checks");
                new DelayedEvent("DHTTransportUDP:delayAC", 30000L, new AERunnable(){

                    @Override
                    public void runSupport() {
                        try {
                            DHTTransportUDPImpl.this.externalAddressChange(reporter, new_address, true);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                });
                return;
            }
            this.logger.log("Node " + reporter.getString() + " has reported that the external IP address is '" + new_address + "'");
            if (this.invalidExternalAddress(ia)) {
                this.logger.log("     This is invalid as it is a private address.");
                return;
            }
            if (reporter.getExternalAddress().getAddress().getHostAddress().equals(new_ip)) {
                this.logger.log("     This is invalid as it is the same as the reporter's address.");
                return;
            }
            this.last_address_change = now;
            if (this.min_address_change_period == 300000) {
                this.min_address_change_period = 600000;
            }
        }
        finally {
            this.this_mon.exit();
        }
        final String old_external_address = this.external_address;
        new AEThread2("DHTTransportUDP:getAddress", true){

            @Override
            public void run() {
                try {
                    DHTTransportUDPImpl.this.this_mon.enter();
                    if (DHTTransportUDPImpl.this.address_changing) {
                        return;
                    }
                    DHTTransportUDPImpl.this.address_changing = true;
                }
                finally {
                    DHTTransportUDPImpl.this.this_mon.exit();
                }
                try {
                    DHTTransportUDPImpl.this.getExternalAddress(new_ip, DHTTransportUDPImpl.this.logger);
                    if (old_external_address.equals(DHTTransportUDPImpl.this.external_address)) {
                        return;
                    }
                    DHTTransportUDPImpl.this.setLocalContact();
                }
                finally {
                    try {
                        DHTTransportUDPImpl.this.this_mon.enter();
                        DHTTransportUDPImpl.this.address_changing = false;
                    }
                    finally {
                        DHTTransportUDPImpl.this.this_mon.exit();
                    }
                }
            }
        }.start();
    }

    protected void contactAlive(DHTTransportUDPContactImpl contact) {
        try {
            this.this_mon.enter();
            this.contact_history.put(contact.getTransportAddress(), contact);
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public DHTTransportContact[] getReachableContacts() {
        try {
            this.this_mon.enter();
            Collection<DHTTransportContact> vals = this.routable_contact_history.values();
            DHTTransportContact[] res = new DHTTransportContact[vals.size()];
            vals.toArray(res);
            DHTTransportContact[] dHTTransportContactArray = res;
            return dHTTransportContactArray;
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public DHTTransportContact[] getRecentContacts() {
        try {
            this.this_mon.enter();
            Collection<DHTTransportContact> vals = this.contact_history.values();
            DHTTransportContact[] res = new DHTTransportContact[vals.size()];
            vals.toArray(res);
            DHTTransportContact[] dHTTransportContactArray = res;
            return dHTTransportContactArray;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateContactStatus(DHTTransportUDPContactImpl contact, int status, boolean incoming) {
        block11: {
            try {
                boolean other_routable;
                this.this_mon.enter();
                contact.setNodeStatus(status);
                if (contact.getProtocolVersion() < 12 || status == -1) break block11;
                boolean bl = other_routable = (status & 1) != 0;
                if (other_routable) {
                    if (incoming) {
                        MovingImmediateAverage movingImmediateAverage = this.routeable_percentage_average;
                        synchronized (movingImmediateAverage) {
                            ++this.other_routable_total;
                        }
                    }
                    this.routable_contact_history.put(contact.getTransportAddress(), contact);
                    break block11;
                }
                if (!incoming) break block11;
                MovingImmediateAverage movingImmediateAverage = this.routeable_percentage_average;
                synchronized (movingImmediateAverage) {
                    ++this.other_non_routable_total;
                }
            }
            finally {
                this.this_mon.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRouteablePercentage() {
        MovingImmediateAverage movingImmediateAverage = this.routeable_percentage_average;
        synchronized (movingImmediateAverage) {
            int result;
            double average = this.routeable_percentage_average.getAverage();
            long both_total = this.other_routable_total + this.other_non_routable_total;
            int current_percent = both_total == 0L ? 0 : (int)(this.other_routable_total * 100L / both_total);
            if (both_total >= 300L) {
                if (current_percent > 0) {
                    average = this.routeable_percentage_average.update(current_percent);
                    this.other_non_routable_total = 0L;
                    this.other_routable_total = 0L;
                }
            } else if (both_total >= 100L) {
                if (average == 0.0) {
                    average = current_percent;
                } else {
                    int samples = this.routeable_percentage_average.getSampleCount();
                    if (samples > 0) {
                        average = ((double)samples * average + (double)current_percent) / (double)(samples + 1);
                    }
                }
            }
            if ((result = (int)average) == 0) {
                result = -1;
            }
            return result;
        }
    }

    protected boolean invalidExternalAddress(InetAddress ia) {
        return ia.isLinkLocalAddress() || ia.isLoopbackAddress() || ia.isSiteLocalAddress();
    }

    protected int getMaxFailForLiveCount() {
        return this.max_fails_for_live;
    }

    protected int getMaxFailForUnknownCount() {
        return this.max_fails_for_unknown;
    }

    @Override
    public DHTTransportContact getLocalContact() {
        return this.local_contact;
    }

    protected void setLocalContact() {
        InetSocketAddress s_address = new InetSocketAddress(this.external_address, this.port);
        try {
            this.local_contact = new DHTTransportUDPContactImpl(true, this, s_address, s_address, this.protocol_version, this.random.nextInt(), 0L, 0);
            this.logger.log("External address changed: " + s_address);
            Debug.out("DHTTransport: address changed to " + s_address);
            int i = 0;
            while (i < this.listeners.size()) {
                try {
                    ((DHTTransportListener)this.listeners.get(i)).localContactChanged(this.local_contact);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
                ++i;
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    @Override
    public DHTTransportContact importContact(DataInputStream is, boolean is_bootstrap) throws IOException, DHTTransportException {
        DHTTransportUDPContactImpl contact = DHTUDPUtils.deserialiseContact(this, is);
        this.importContact(contact, is_bootstrap);
        return contact;
    }

    @Override
    public DHTTransportUDPContact importContact(InetSocketAddress _address, byte _protocol_version, boolean is_bootstrap) throws DHTTransportException {
        DHTTransportUDPContactImpl contact = new DHTTransportUDPContactImpl(false, this, _address, _address, _protocol_version, 0, 0L, 0);
        this.importContact(contact, is_bootstrap);
        return contact;
    }

    protected void importContact(DHTTransportUDPContactImpl contact, boolean is_bootstrap) {
        try {
            this.this_mon.enter();
            if (this.contact_history.size() < 32) {
                this.contact_history.put(contact.getTransportAddress(), contact);
            }
        }
        finally {
            this.this_mon.exit();
        }
        this.request_handler.contactImported(contact, is_bootstrap);
    }

    public void exportContact(DHTTransportContact contact, DataOutputStream os) throws IOException, DHTTransportException {
        DHTUDPUtils.serialiseContact(os, contact);
    }

    public Map<String, Object> exportContactToMap(DHTTransportContact contact) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("v", contact.getProtocolVersion());
        InetSocketAddress address = contact.getExternalAddress();
        result.put("p", address.getPort());
        InetAddress ia = address.getAddress();
        if (ia == null) {
            result.put("h", address.getHostName());
        } else {
            result.put("a", ia.getAddress());
        }
        return result;
    }

    @Override
    public DHTTransportUDPContact importContact(Map<String, Object> map) {
        int version = ((Number)map.get("v")).intValue();
        int port = ((Number)map.get("p")).intValue();
        byte[] a = (byte[])map.get("a");
        try {
            InetSocketAddress address = a == null ? InetSocketAddress.createUnresolved(new String((byte[])map.get("h"), "UTF-8"), port) : new InetSocketAddress(InetAddress.getByAddress(a), port);
            DHTTransportUDPContactImpl contact = new DHTTransportUDPContactImpl(false, this, address, address, (byte)version, 0, 0L, 0);
            this.importContact(contact, false);
            return contact;
        }
        catch (Throwable e) {
            Debug.out(e);
            return null;
        }
    }

    public void removeContact(DHTTransportContact contact) {
        this.request_handler.contactRemoved(contact);
    }

    @Override
    public void setRequestHandler(DHTTransportRequestHandler _request_handler) {
        this.request_handler = new DHTTransportRequestCounter(_request_handler, this.stats);
    }

    @Override
    public DHTTransportStats getStats() {
        return this.stats;
    }

    protected void checkAddress(DHTTransportUDPContactImpl contact) throws DHTUDPPacketHandlerException {
        InetAddress ia;
        if (this.ip_filter.isEnabled() && (ia = contact.getTransportAddress().getAddress()) != null) {
            byte[] addr = ia.getAddress();
            if (this.bad_ip_bloom_filter == null) {
                this.bad_ip_bloom_filter = BloomFilterFactory.createAddOnly(32000);
            } else if (this.bad_ip_bloom_filter.contains(addr)) {
                throw new DHTUDPPacketHandlerException("IPFilter check fails (repeat)");
            }
            if (this.ip_filter.isInRange(contact.getTransportAddress().getAddress(), "DHT", null, this.logger.isEnabled(2))) {
                if (this.bad_ip_bloom_filter.getEntryCount() >= 3200) {
                    this.bad_ip_bloom_filter = BloomFilterFactory.createAddOnly(32000);
                }
                this.bad_ip_bloom_filter.add(addr);
                throw new DHTUDPPacketHandlerException("IPFilter check fails");
            }
        }
    }

    protected void sendPing(final DHTTransportUDPContactImpl contact, final DHTTransportReplyHandler handler, long timeout, int priority) {
        try {
            this.checkAddress(contact);
            final long connection_id = this.getConnectionID();
            DHTUDPPacketRequestPing request2 = new DHTUDPPacketRequestPing(this, connection_id, this.local_contact, contact);
            this.requestAltContacts(request2);
            this.stats.pingSent(request2);
            this.requestSendRequestProcessor(contact, request2);
            this.packet_handler.sendAndReceive(request2, contact.getTransportAddress(), new DHTUDPPacketReceiver(){

                @Override
                public void packetReceived(DHTUDPPacketReply packet, InetSocketAddress from_address, long elapsed_time) {
                    try {
                        if (packet.getConnectionId() != connection_id) {
                            throw new Exception("connection id mismatch");
                        }
                        contact.setInstanceIDAndVersion(packet.getTargetInstanceID(), packet.getProtocolVersion());
                        DHTTransportUDPImpl.this.requestSendReplyProcessor(contact, handler, packet, elapsed_time);
                        DHTTransportUDPImpl.this.receiveAltContacts((DHTUDPPacketReplyPing)packet);
                        DHTTransportUDPImpl.this.stats.pingOK();
                        long proc_time = packet.getProcessingTime();
                        if (proc_time > 0L && (elapsed_time -= proc_time) < 0L) {
                            elapsed_time = 0L;
                        }
                        handler.pingReply(contact, (int)elapsed_time);
                    }
                    catch (DHTUDPPacketHandlerException e) {
                        this.error(e);
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                        this.error(new DHTUDPPacketHandlerException("ping failed", e));
                    }
                }

                @Override
                public void error(DHTUDPPacketHandlerException e) {
                    DHTTransportUDPImpl.this.stats.pingFailed();
                    handler.failed(contact, e);
                }
            }, timeout, priority);
        }
        catch (Throwable e) {
            this.stats.pingFailed();
            handler.failed(contact, e);
        }
    }

    protected void sendPing(DHTTransportUDPContactImpl contact, DHTTransportReplyHandler handler) {
        this.sendPing(contact, handler, this.request_timeout, 1);
    }

    protected void sendImmediatePing(DHTTransportUDPContactImpl contact, DHTTransportReplyHandler handler, long timeout) {
        this.sendPing(contact, handler, timeout, 99);
    }

    protected void sendKeyBlockRequest(final DHTTransportUDPContactImpl contact, final DHTTransportReplyHandler handler, byte[] block_request, byte[] block_signature) {
        try {
            this.checkAddress(contact);
            final long connection_id = this.getConnectionID();
            DHTUDPPacketRequestKeyBlock request2 = new DHTUDPPacketRequestKeyBlock(this, connection_id, this.local_contact, contact);
            request2.setKeyBlockDetails(block_request, block_signature);
            this.stats.keyBlockSent(request2);
            request2.setRandomID(contact.getRandomID());
            this.requestSendRequestProcessor(contact, request2);
            this.packet_handler.sendAndReceive(request2, contact.getTransportAddress(), new DHTUDPPacketReceiver(){

                @Override
                public void packetReceived(DHTUDPPacketReply packet, InetSocketAddress from_address, long elapsed_time) {
                    try {
                        if (packet.getConnectionId() != connection_id) {
                            throw new Exception("connection id mismatch");
                        }
                        contact.setInstanceIDAndVersion(packet.getTargetInstanceID(), packet.getProtocolVersion());
                        DHTTransportUDPImpl.this.requestSendReplyProcessor(contact, handler, packet, elapsed_time);
                        DHTTransportUDPImpl.this.stats.keyBlockOK();
                        handler.keyBlockReply(contact);
                    }
                    catch (DHTUDPPacketHandlerException e) {
                        this.error(e);
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                        this.error(new DHTUDPPacketHandlerException("send key block failed", e));
                    }
                }

                @Override
                public void error(DHTUDPPacketHandlerException e) {
                    DHTTransportUDPImpl.this.stats.keyBlockFailed();
                    handler.failed(contact, e);
                }
            }, this.request_timeout, 1);
        }
        catch (Throwable e) {
            this.stats.keyBlockFailed();
            handler.failed(contact, e);
        }
    }

    protected void sendStats(final DHTTransportUDPContactImpl contact, final DHTTransportReplyHandler handler) {
        try {
            this.checkAddress(contact);
            final long connection_id = this.getConnectionID();
            DHTUDPPacketRequestStats request2 = new DHTUDPPacketRequestStats(this, connection_id, this.local_contact, contact);
            this.stats.statsSent(request2);
            this.requestSendRequestProcessor(contact, request2);
            this.packet_handler.sendAndReceive(request2, contact.getTransportAddress(), new DHTUDPPacketReceiver(){

                @Override
                public void packetReceived(DHTUDPPacketReply packet, InetSocketAddress from_address, long elapsed_time) {
                    try {
                        if (packet.getConnectionId() != connection_id) {
                            throw new Exception("connection id mismatch");
                        }
                        contact.setInstanceIDAndVersion(packet.getTargetInstanceID(), packet.getProtocolVersion());
                        DHTTransportUDPImpl.this.requestSendReplyProcessor(contact, handler, packet, elapsed_time);
                        DHTUDPPacketReplyStats reply = (DHTUDPPacketReplyStats)packet;
                        DHTTransportUDPImpl.this.stats.statsOK();
                        if (reply.getStatsType() == 1) {
                            handler.statsReply(contact, reply.getOriginalStats());
                        } else {
                            System.out.println("new stats reply:" + reply.getString());
                        }
                    }
                    catch (DHTUDPPacketHandlerException e) {
                        this.error(e);
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                        this.error(new DHTUDPPacketHandlerException("stats failed", e));
                    }
                }

                @Override
                public void error(DHTUDPPacketHandlerException e) {
                    DHTTransportUDPImpl.this.stats.statsFailed();
                    handler.failed(contact, e);
                }
            }, this.request_timeout, 2);
        }
        catch (Throwable e) {
            this.stats.statsFailed();
            handler.failed(contact, e);
        }
    }

    protected InetSocketAddress askContactForExternalAddress(DHTTransportUDPContactImpl contact) {
        try {
            this.checkAddress(contact);
            long connection_id = this.getConnectionID();
            DHTUDPPacketRequestPing request2 = new DHTUDPPacketRequestPing(this, connection_id, this.local_contact, contact);
            this.stats.pingSent(request2);
            final AESemaphore sem = new AESemaphore("DHTTransUDP:extping");
            final InetSocketAddress[] result = new InetSocketAddress[1];
            this.packet_handler.sendAndReceive(request2, contact.getTransportAddress(), new DHTUDPPacketReceiver(){

                @Override
                public void packetReceived(DHTUDPPacketReply _packet, InetSocketAddress from_address, long elapsed_time) {
                    try {
                        DHTUDPPacketReplyError packet;
                        if (_packet instanceof DHTUDPPacketReplyPing) {
                            result[0] = DHTTransportUDPImpl.this.local_contact.getExternalAddress();
                        } else if (_packet instanceof DHTUDPPacketReplyError && (packet = (DHTUDPPacketReplyError)_packet).getErrorType() == 1) {
                            result[0] = packet.getOriginatingAddress();
                        }
                    }
                    finally {
                        sem.release();
                    }
                }

                @Override
                public void error(DHTUDPPacketHandlerException e) {
                    try {
                        DHTTransportUDPImpl.this.stats.pingFailed();
                    }
                    finally {
                        sem.release();
                    }
                }
            }, 5000L, 0);
            sem.reserve(5000L);
            return result[0];
        }
        catch (Throwable e) {
            this.stats.pingFailed();
            return null;
        }
    }

    public void sendStore(final DHTTransportUDPContactImpl contact, final DHTTransportReplyHandler handler, byte[][] keys, DHTTransportValue[][] value_sets, int priority) {
        block9: {
            final long connection_id = this.getConnectionID();
            int packet_count = 0;
            try {
                this.checkAddress(contact);
                int current_key_index = 0;
                int current_value_index = 0;
                while (current_key_index < keys.length) {
                    int packet_entries;
                    ++packet_count;
                    int space = 1357;
                    ArrayList<byte[]> key_list = new ArrayList<byte[]>();
                    ArrayList values_list = new ArrayList();
                    key_list.add(keys[current_key_index]);
                    space -= keys[current_key_index].length + 1;
                    values_list.add(new ArrayList());
                    while (space > 0 && current_key_index < keys.length) {
                        if (current_value_index == value_sets[current_key_index].length) {
                            current_value_index = 0;
                            if (key_list.size() == 255 || ++current_key_index == keys.length) break;
                            key_list.add(keys[current_key_index]);
                            space -= keys[current_key_index].length + 1;
                            values_list.add(new ArrayList());
                        }
                        DHTTransportValue value = value_sets[current_key_index][current_value_index];
                        int entry_size = 26 + value.getValue().length + 1;
                        List values = (List)values_list.get(values_list.size() - 1);
                        if (space < entry_size || values.size() == 255) break;
                        values.add(value);
                        space -= entry_size;
                        ++current_value_index;
                    }
                    if ((packet_entries = key_list.size()) > 0 && ((List)values_list.get(packet_entries - 1)).size() == 0) {
                        --packet_entries;
                    }
                    if (packet_entries != 0) {
                        byte[][] packet_keys = new byte[packet_entries][];
                        DHTTransportValue[][] packet_value_sets = new DHTTransportValue[packet_entries][];
                        int i = 0;
                        while (i < packet_entries) {
                            packet_keys[i] = (byte[])key_list.get(i);
                            List values = (List)values_list.get(i);
                            packet_value_sets[i] = new DHTTransportValue[values.size()];
                            int j = 0;
                            while (j < values.size()) {
                                packet_value_sets[i][j] = (DHTTransportValue)values.get(j);
                                ++j;
                            }
                            ++i;
                        }
                        DHTUDPPacketRequestStore request2 = new DHTUDPPacketRequestStore(this, connection_id, this.local_contact, contact);
                        this.stats.storeSent(request2);
                        request2.setRandomID(contact.getRandomID());
                        request2.setKeys(packet_keys);
                        request2.setValueSets(packet_value_sets);
                        final int f_packet_count = packet_count;
                        this.requestSendRequestProcessor(contact, request2);
                        this.packet_handler.sendAndReceive(request2, contact.getTransportAddress(), new DHTUDPPacketReceiver(){

                            @Override
                            public void packetReceived(DHTUDPPacketReply packet, InetSocketAddress from_address, long elapsed_time) {
                                try {
                                    if (packet.getConnectionId() != connection_id) {
                                        throw new Exception("connection id mismatch: sender=" + from_address + ",packet=" + packet.getString());
                                    }
                                    contact.setInstanceIDAndVersion(packet.getTargetInstanceID(), packet.getProtocolVersion());
                                    DHTTransportUDPImpl.this.requestSendReplyProcessor(contact, handler, packet, elapsed_time);
                                    DHTUDPPacketReplyStore reply = (DHTUDPPacketReplyStore)packet;
                                    DHTTransportUDPImpl.this.stats.storeOK();
                                    if (f_packet_count == 1) {
                                        handler.storeReply(contact, reply.getDiversificationTypes());
                                    }
                                }
                                catch (DHTUDPPacketHandlerException e) {
                                    this.error(e);
                                }
                                catch (Throwable e) {
                                    Debug.printStackTrace(e);
                                    this.error(new DHTUDPPacketHandlerException("store failed", e));
                                }
                            }

                            @Override
                            public void error(DHTUDPPacketHandlerException e) {
                                DHTTransportUDPImpl.this.stats.storeFailed();
                                if (f_packet_count == 1) {
                                    handler.failed(contact, e);
                                }
                            }
                        }, this.store_timeout, priority);
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable e) {
                this.stats.storeFailed();
                if (packet_count > true) break block9;
                handler.failed(contact, e);
            }
        }
    }

    public void sendQueryStore(final DHTTransportUDPContactImpl contact, final DHTTransportReplyHandler handler, int header_size, List<Object[]> key_details) {
        try {
            this.checkAddress(contact);
            final long connection_id = this.getConnectionID();
            Iterator<Object[]> it = key_details.iterator();
            byte[] current_prefix = null;
            Iterator current_suffixes = null;
            ArrayList<DHTUDPPacketRequestQueryStorage> requests = new ArrayList<DHTUDPPacketRequestQueryStorage>();
            block2: while (it.hasNext()) {
                int space = 1354;
                DHTUDPPacketRequestQueryStorage request2 = new DHTUDPPacketRequestQueryStorage(this, connection_id, this.local_contact, contact);
                ArrayList<Object[]> packet_key_details = new ArrayList<Object[]>();
                while (space > 0 && it.hasNext()) {
                    if (current_prefix == null) {
                        Object[] entry = it.next();
                        current_prefix = (byte[])entry[0];
                        List l = (List)entry[1];
                        current_suffixes = l.iterator();
                    }
                    if (current_suffixes.hasNext()) {
                        int min_space = header_size + 3;
                        if (space < min_space) {
                            request2.setDetails(header_size, packet_key_details);
                            requests.add(request2);
                            continue block2;
                        }
                        ArrayList<byte[]> s = new ArrayList<byte[]>();
                        packet_key_details.add(new Object[]{current_prefix, s});
                        int prefix_size = current_prefix.length;
                        int suffix_size = header_size - prefix_size;
                        space -= 3 + prefix_size;
                        while (space >= suffix_size && current_suffixes.hasNext()) {
                            s.add((byte[])current_suffixes.next());
                        }
                        continue;
                    }
                    current_prefix = null;
                }
                if (it.hasNext()) continue;
                request2.setDetails(header_size, packet_key_details);
                requests.add(request2);
            }
            final Object[] replies = new Object[requests.size()];
            int i = 0;
            while (i < requests.size()) {
                DHTUDPPacketRequestQueryStorage request3 = (DHTUDPPacketRequestQueryStorage)requests.get(i);
                final int f_i = i++;
                this.stats.queryStoreSent(request3);
                this.requestSendRequestProcessor(contact, request3);
                this.packet_handler.sendAndReceive(request3, contact.getTransportAddress(), new DHTUDPPacketReceiver(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void packetReceived(DHTUDPPacketReply packet, InetSocketAddress from_address, long elapsed_time) {
                        try {
                            if (packet.getConnectionId() != connection_id) {
                                throw new Exception("connection id mismatch");
                            }
                            contact.setInstanceIDAndVersion(packet.getTargetInstanceID(), packet.getProtocolVersion());
                            DHTTransportUDPImpl.this.requestSendReplyProcessor(contact, handler, packet, elapsed_time);
                            DHTUDPPacketReplyQueryStorage reply = (DHTUDPPacketReplyQueryStorage)packet;
                            contact.setRandomID(reply.getRandomID());
                            DHTTransportUDPImpl.this.stats.queryStoreOK();
                            Object[] objectArray = replies;
                            synchronized (replies) {
                                replies[f_i] = reply;
                                this.checkComplete();
                                // ** MonitorExit[var6_7] (shouldn't be in output)
                            }
                        }
                        catch (DHTUDPPacketHandlerException e) {
                            this.error(e);
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                            this.error(new DHTUDPPacketHandlerException("queryStore failed", e));
                        }
                        {
                            return;
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void error(DHTUDPPacketHandlerException e) {
                        DHTTransportUDPImpl.this.stats.queryStoreFailed();
                        Object[] objectArray = replies;
                        synchronized (replies) {
                            replies[f_i] = e;
                            this.checkComplete();
                            // ** MonitorExit[var2_2] (shouldn't be in output)
                            return;
                        }
                    }

                    protected void checkComplete() {
                        DHTUDPPacketHandlerException last_error = null;
                        int i = 0;
                        while (i < replies.length) {
                            Object o = replies[i];
                            if (o == null) {
                                return;
                            }
                            if (o instanceof DHTUDPPacketHandlerException) {
                                last_error = (DHTUDPPacketHandlerException)o;
                            }
                            ++i;
                        }
                        if (last_error != null) {
                            handler.failed(contact, last_error);
                        } else if (replies.length == 1) {
                            handler.queryStoreReply(contact, ((DHTUDPPacketReplyQueryStorage)replies[0]).getResponse());
                        } else {
                            ArrayList<byte[]> response = new ArrayList<byte[]>();
                            int i2 = 0;
                            while (i2 < replies.length) {
                                response.addAll(((DHTUDPPacketReplyQueryStorage)replies[0]).getResponse());
                                ++i2;
                            }
                            handler.queryStoreReply(contact, response);
                        }
                    }
                }, this.request_timeout, 1);
            }
        }
        catch (Throwable e) {
            this.stats.queryStoreFailed();
            handler.failed(contact, e);
        }
    }

    public void sendFindNode(final DHTTransportUDPContactImpl contact, final DHTTransportReplyHandler handler, byte[] nid) {
        try {
            this.checkAddress(contact);
            final long connection_id = this.getConnectionID();
            DHTUDPPacketRequestFindNode request2 = new DHTUDPPacketRequestFindNode(this, connection_id, this.local_contact, contact);
            this.stats.findNodeSent(request2);
            request2.setID(nid);
            request2.setNodeStatus(this.getNodeStatus());
            request2.setEstimatedDHTSize(this.request_handler.getTransportEstimatedDHTSize());
            this.requestSendRequestProcessor(contact, request2);
            this.packet_handler.sendAndReceive(request2, contact.getTransportAddress(), new DHTUDPPacketReceiver(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void packetReceived(DHTUDPPacketReply packet, InetSocketAddress from_address, long elapsed_time) {
                    try {
                        if (packet.getConnectionId() != connection_id) {
                            throw new Exception("connection id mismatch");
                        }
                        contact.setInstanceIDAndVersion(packet.getTargetInstanceID(), packet.getProtocolVersion());
                        DHTTransportUDPImpl.this.requestSendReplyProcessor(contact, handler, packet, elapsed_time);
                        DHTUDPPacketReplyFindNode reply = (DHTUDPPacketReplyFindNode)packet;
                        contact.setRandomID(reply.getRandomID());
                        DHTTransportUDPImpl.this.updateContactStatus(contact, reply.getNodeStatus(), false);
                        DHTTransportUDPImpl.this.request_handler.setTransportEstimatedDHTSize(reply.getEstimatedDHTSize());
                        DHTTransportUDPImpl.this.stats.findNodeOK();
                        DHTTransportContact[] contacts = reply.getContacts();
                        try {
                            DHTTransportUDPImpl.this.this_mon.enter();
                            int i = 0;
                            while (DHTTransportUDPImpl.this.contact_history.size() < 32 && i < contacts.length) {
                                DHTTransportUDPContact c = (DHTTransportUDPContact)contacts[i];
                                DHTTransportUDPImpl.this.contact_history.put(c.getTransportAddress(), c);
                                ++i;
                            }
                        }
                        finally {
                            DHTTransportUDPImpl.this.this_mon.exit();
                        }
                        handler.findNodeReply(contact, contacts);
                        return;
                    }
                    catch (DHTUDPPacketHandlerException e) {
                        this.error(e);
                        return;
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                        this.error(new DHTUDPPacketHandlerException("findNode failed", e));
                    }
                }

                @Override
                public void error(DHTUDPPacketHandlerException e) {
                    DHTTransportUDPImpl.this.stats.findNodeFailed();
                    handler.failed(contact, e);
                }
            }, this.request_timeout, 1);
        }
        catch (Throwable e) {
            this.stats.findNodeFailed();
            handler.failed(contact, e);
        }
    }

    public void sendFindValue(final DHTTransportUDPContactImpl contact, final DHTTransportReplyHandler handler, byte[] key, int max_values, short flags) {
        block2: {
            try {
                this.checkAddress(contact);
                final long connection_id = this.getConnectionID();
                DHTUDPPacketRequestFindValue request2 = new DHTUDPPacketRequestFindValue(this, connection_id, this.local_contact, contact);
                this.stats.findValueSent(request2);
                request2.setID(key);
                request2.setMaximumValues(max_values);
                request2.setFlags((byte)flags);
                this.requestSendRequestProcessor(contact, request2);
                this.packet_handler.sendAndReceive(request2, contact.getTransportAddress(), new DHTUDPPacketReceiver(){

                    @Override
                    public void packetReceived(DHTUDPPacketReply packet, InetSocketAddress from_address, long elapsed_time) {
                        try {
                            if (packet.getConnectionId() != connection_id) {
                                throw new Exception("connection id mismatch");
                            }
                            contact.setInstanceIDAndVersion(packet.getTargetInstanceID(), packet.getProtocolVersion());
                            DHTTransportUDPImpl.this.requestSendReplyProcessor(contact, handler, packet, elapsed_time);
                            DHTUDPPacketReplyFindValue reply = (DHTUDPPacketReplyFindValue)packet;
                            DHTTransportUDPImpl.this.stats.findValueOK();
                            DHTTransportValue[] res = reply.getValues();
                            if (res != null) {
                                boolean continuation = reply.hasContinuation();
                                handler.findValueReply(contact, res, reply.getDiversificationType(), continuation);
                            } else {
                                handler.findValueReply(contact, reply.getContacts());
                            }
                        }
                        catch (DHTUDPPacketHandlerException e) {
                            this.error(e);
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                            this.error(new DHTUDPPacketHandlerException("findValue failed", e));
                        }
                    }

                    @Override
                    public void error(DHTUDPPacketHandlerException e) {
                        DHTTransportUDPImpl.this.stats.findValueFailed();
                        handler.failed(contact, e);
                    }
                }, this.request_timeout, 0);
            }
            catch (Throwable e) {
                if (e instanceof DHTUDPPacketHandlerException) break block2;
                this.stats.findValueFailed();
                handler.failed(contact, e);
            }
        }
    }

    protected DHTTransportFullStats getFullStats(DHTTransportUDPContactImpl contact) {
        if (contact == this.local_contact) {
            return this.request_handler.statsRequest(contact);
        }
        final DHTTransportFullStats[] res = new DHTTransportFullStats[1];
        final AESemaphore sem = new AESemaphore("DHTTransportUDP:getFullStats");
        this.sendStats(contact, new DHTTransportReplyHandlerAdapter(){

            @Override
            public void statsReply(DHTTransportContact _contact, DHTTransportFullStats _stats) {
                res[0] = _stats;
                sem.release();
            }

            @Override
            public void failed(DHTTransportContact _contact, Throwable _error) {
                sem.release();
            }
        });
        sem.reserve();
        return res[0];
    }

    @Override
    public void registerTransferHandler(byte[] handler_key, DHTTransportTransferHandler handler) {
        this.xfer_handler.registerTransferHandler(handler_key, handler);
    }

    @Override
    public void registerTransferHandler(byte[] handler_key, DHTTransportTransferHandler handler, Map<String, Object> options) {
        this.xfer_handler.registerTransferHandler(handler_key, handler, options);
    }

    @Override
    public void unregisterTransferHandler(byte[] handler_key, DHTTransportTransferHandler handler) {
        this.xfer_handler.unregisterTransferHandler(handler_key, handler);
    }

    @Override
    public byte[] readTransfer(DHTTransportProgressListener listener, DHTTransportContact target, byte[] handler_key, byte[] key, long timeout) throws DHTTransportException {
        InetAddress ia = target.getAddress().getAddress();
        if (ia instanceof Inet4Address && this.v6 || ia instanceof Inet6Address && !this.v6) {
            throw new DHTTransportException("Incompatible address");
        }
        return this.xfer_handler.readTransfer(listener, target, handler_key, key, timeout);
    }

    @Override
    public void writeTransfer(DHTTransportProgressListener listener, DHTTransportContact target, byte[] handler_key, byte[] key, byte[] data, long timeout) throws DHTTransportException {
        InetAddress ia = target.getAddress().getAddress();
        if (ia instanceof Inet4Address && this.v6 || ia instanceof Inet6Address && !this.v6) {
            throw new DHTTransportException("Incompatible address");
        }
        this.xfer_handler.writeTransfer(listener, target, handler_key, key, data, timeout);
    }

    @Override
    public byte[] writeReadTransfer(DHTTransportProgressListener listener, DHTTransportContact target, byte[] handler_key, byte[] data, long timeout) throws DHTTransportException {
        InetAddress ia = target.getAddress().getAddress();
        if (ia instanceof Inet4Address && this.v6 || ia instanceof Inet6Address && !this.v6) {
            throw new DHTTransportException("Incompatible address");
        }
        return this.xfer_handler.writeReadTransfer(listener, target, handler_key, data, timeout);
    }

    protected void dataRequest(DHTTransportUDPContactImpl originator, DHTUDPPacketData req) {
        this.stats.dataReceived();
        this.xfer_handler.receivePacket(originator, new DHTTransferHandler.Packet(req.getConnectionId(), req.getPacketType(), req.getTransferKey(), req.getRequestKey(), req.getData(), req.getStartPosition(), req.getLength(), req.getTotalLength()));
    }

    @Override
    public void process(DHTUDPPacketRequest request2, boolean alien) {
        this.process(this.packet_handler, request2, alien);
    }

    @Override
    public void process(DHTUDPPacketHandlerStub packet_handler_stub, DHTUDPPacketRequest request2, boolean alien) {
        if (this.request_handler == null) {
            this.logger.log("Ignoring packet as not yet ready to process");
            return;
        }
        try {
            boolean bad_originator;
            this.stats.incomingRequestReceived(request2, alien);
            InetSocketAddress transport_address = request2.getAddress();
            DHTTransportUDPContactImpl originating_contact = new DHTTransportUDPContactImpl(false, this, transport_address, request2.getOriginatorAddress(), request2.getOriginatorVersion(), request2.getOriginatorInstanceID(), request2.getClockSkew(), request2.getGenericFlags());
            try {
                this.checkAddress(originating_contact);
            }
            catch (DHTUDPPacketHandlerException e) {
                return;
            }
            this.requestReceiveRequestProcessor(originating_contact, request2);
            boolean bl = bad_originator = !originating_contact.addressMatchesID();
            if (bad_originator && !this.bootstrap_node) {
                String contact_string = originating_contact.getString();
                if (this.recent_reports.get(contact_string) == null) {
                    this.recent_reports.put(contact_string, "");
                    this.logger.log("Node " + contact_string + " has incorrect ID, reporting it to them");
                }
                DHTUDPPacketReplyError reply = new DHTUDPPacketReplyError(this, request2, this.local_contact, originating_contact);
                reply.setErrorType(1);
                reply.setOriginatingAddress(originating_contact.getTransportAddress());
                this.requestReceiveReplyProcessor(originating_contact, reply);
                packet_handler_stub.send(reply, request2.getAddress());
            } else {
                if (bad_originator) {
                    originating_contact = new DHTTransportUDPContactImpl(false, this, transport_address, transport_address, request2.getOriginatorVersion(), request2.getOriginatorInstanceID(), request2.getClockSkew(), request2.getGenericFlags());
                } else {
                    this.contactAlive(originating_contact);
                }
                if (request2 instanceof DHTUDPPacketRequestPing) {
                    if (!this.bootstrap_node) {
                        this.request_handler.pingRequest(originating_contact);
                        DHTUDPPacketRequestPing ping = (DHTUDPPacketRequestPing)request2;
                        DHTUDPPacketReplyPing reply = new DHTUDPPacketReplyPing(this, ping, this.local_contact, originating_contact);
                        this.sendAltContacts(ping, reply);
                        this.requestReceiveReplyProcessor(originating_contact, reply);
                        packet_handler_stub.send(reply, request2.getAddress());
                    }
                } else if (request2 instanceof DHTUDPPacketRequestKeyBlock) {
                    if (!this.bootstrap_node) {
                        DHTUDPPacketRequestKeyBlock kb_request = (DHTUDPPacketRequestKeyBlock)request2;
                        originating_contact.setRandomID(kb_request.getRandomID());
                        this.request_handler.keyBlockRequest(originating_contact, kb_request.getKeyBlockRequest(), kb_request.getKeyBlockSignature());
                        DHTUDPPacketReplyKeyBlock reply = new DHTUDPPacketReplyKeyBlock(this, kb_request, this.local_contact, originating_contact);
                        this.requestReceiveReplyProcessor(originating_contact, reply);
                        packet_handler_stub.send(reply, request2.getAddress());
                    }
                } else if (request2 instanceof DHTUDPPacketRequestStats) {
                    DHTUDPPacketRequestStats stats_request = (DHTUDPPacketRequestStats)request2;
                    DHTUDPPacketReplyStats reply = new DHTUDPPacketReplyStats(this, stats_request, this.local_contact, originating_contact);
                    int type = stats_request.getStatsType();
                    if (type == 1) {
                        DHTTransportFullStats full_stats = this.request_handler.statsRequest(originating_contact);
                        reply.setOriginalStats(full_stats);
                    } else if (type == 2) {
                        DHTNetworkPositionProvider prov = DHTNetworkPositionManager.getProvider((byte)5);
                        byte[] data = new byte[]{};
                        if (prov != null) {
                            ByteArrayOutputStream baos = new ByteArrayOutputStream();
                            DataOutputStream dos = new DataOutputStream(baos);
                            prov.serialiseStats(dos);
                            dos.flush();
                            data = baos.toByteArray();
                        }
                        reply.setNewStats(data, 5);
                    } else {
                        throw new IOException("Uknown stats type '" + type + "'");
                    }
                    this.requestReceiveReplyProcessor(originating_contact, reply);
                    packet_handler_stub.send(reply, request2.getAddress());
                } else if (request2 instanceof DHTUDPPacketRequestStore) {
                    if (!this.bootstrap_node) {
                        DHTUDPPacketRequestStore store_request = (DHTUDPPacketRequestStore)request2;
                        originating_contact.setRandomID(store_request.getRandomID());
                        DHTTransportStoreReply res = this.request_handler.storeRequest(originating_contact, store_request.getKeys(), store_request.getValueSets());
                        if (res.blocked()) {
                            if (originating_contact.getProtocolVersion() >= 14) {
                                DHTUDPPacketReplyError reply = new DHTUDPPacketReplyError(this, request2, this.local_contact, originating_contact);
                                reply.setErrorType(2);
                                reply.setKeyBlockDetails(res.getBlockRequest(), res.getBlockSignature());
                                this.requestReceiveReplyProcessor(originating_contact, reply);
                                packet_handler_stub.send(reply, request2.getAddress());
                            } else {
                                DHTUDPPacketReplyStore reply = new DHTUDPPacketReplyStore(this, store_request, this.local_contact, originating_contact);
                                reply.setDiversificationTypes(new byte[store_request.getKeys().length]);
                                this.requestReceiveReplyProcessor(originating_contact, reply);
                                packet_handler_stub.send(reply, request2.getAddress());
                            }
                        } else {
                            DHTUDPPacketReplyStore reply = new DHTUDPPacketReplyStore(this, store_request, this.local_contact, originating_contact);
                            reply.setDiversificationTypes(res.getDiversificationTypes());
                            this.requestReceiveReplyProcessor(originating_contact, reply);
                            packet_handler_stub.send(reply, request2.getAddress());
                        }
                    }
                } else if (request2 instanceof DHTUDPPacketRequestQueryStorage) {
                    DHTUDPPacketRequestQueryStorage query_request = (DHTUDPPacketRequestQueryStorage)request2;
                    DHTTransportQueryStoreReply res = this.request_handler.queryStoreRequest(originating_contact, query_request.getHeaderLength(), query_request.getKeys());
                    DHTUDPPacketReplyQueryStorage reply = new DHTUDPPacketReplyQueryStorage(this, query_request, this.local_contact, originating_contact);
                    reply.setRandomID(originating_contact.getRandomID());
                    reply.setResponse(res.getHeaderSize(), res.getEntries());
                    this.requestReceiveReplyProcessor(originating_contact, reply);
                    packet_handler_stub.send(reply, request2.getAddress());
                } else if (request2 instanceof DHTUDPPacketRequestFindNode) {
                    DHTUDPPacketRequestFindNode find_request = (DHTUDPPacketRequestFindNode)request2;
                    boolean acceptable = this.bootstrap_node ? bad_originator || Arrays.equals(find_request.getID(), originating_contact.getID()) : true;
                    if (acceptable) {
                        if (find_request.getProtocolVersion() >= 22) {
                            this.updateContactStatus(originating_contact, find_request.getNodeStatus(), true);
                            this.request_handler.setTransportEstimatedDHTSize(find_request.getEstimatedDHTSize());
                        }
                        DHTTransportContact[] res = this.request_handler.findNodeRequest(originating_contact, find_request.getID());
                        DHTUDPPacketReplyFindNode reply = new DHTUDPPacketReplyFindNode(this, find_request, this.local_contact, originating_contact);
                        reply.setRandomID(originating_contact.getRandomID());
                        reply.setNodeStatus(this.getNodeStatus());
                        reply.setEstimatedDHTSize(this.request_handler.getTransportEstimatedDHTSize());
                        reply.setContacts(res);
                        this.requestReceiveReplyProcessor(originating_contact, reply);
                        packet_handler_stub.send(reply, request2.getAddress());
                    }
                } else if (request2 instanceof DHTUDPPacketRequestFindValue) {
                    if (!this.bootstrap_node) {
                        DHTUDPPacketRequestFindValue find_request = (DHTUDPPacketRequestFindValue)request2;
                        DHTTransportFindValueReply res = this.request_handler.findValueRequest(originating_contact, find_request.getID(), find_request.getMaximumValues(), find_request.getFlags());
                        if (res.blocked()) {
                            if (originating_contact.getProtocolVersion() >= 14) {
                                DHTUDPPacketReplyError reply = new DHTUDPPacketReplyError(this, request2, this.local_contact, originating_contact);
                                reply.setErrorType(2);
                                reply.setKeyBlockDetails(res.getBlockedKey(), res.getBlockedSignature());
                                this.requestReceiveReplyProcessor(originating_contact, reply);
                                packet_handler_stub.send(reply, request2.getAddress());
                            } else {
                                DHTUDPPacketReplyFindValue reply = new DHTUDPPacketReplyFindValue(this, find_request, this.local_contact, originating_contact);
                                reply.setValues(new DHTTransportValue[0], (byte)1, false);
                                this.requestReceiveReplyProcessor(originating_contact, reply);
                                packet_handler_stub.send(reply, request2.getAddress());
                            }
                        } else {
                            DHTUDPPacketReplyFindValue reply = new DHTUDPPacketReplyFindValue(this, find_request, this.local_contact, originating_contact);
                            if (res.hit()) {
                                DHTTransportValue[] res_values = res.getValues();
                                int max_size = 1370;
                                ArrayList<DHTTransportValue> values = new ArrayList<DHTTransportValue>();
                                int values_size = 0;
                                int pos = 0;
                                while (pos < res_values.length) {
                                    DHTTransportValue v = res_values[pos];
                                    int v_len = v.getValue().length + 26;
                                    if (values_size > 0 && values_size + v_len > max_size) {
                                        DHTTransportValue[] x = new DHTTransportValue[values.size()];
                                        values.toArray(x);
                                        reply.setValues(x, res.getDiversificationType(), true);
                                        packet_handler_stub.send(reply, request2.getAddress());
                                        values_size = 0;
                                        values = new ArrayList();
                                        continue;
                                    }
                                    values.add(v);
                                    values_size += v_len;
                                    ++pos;
                                }
                                DHTTransportValue[] x = new DHTTransportValue[values.size()];
                                values.toArray(x);
                                reply.setValues(x, res.getDiversificationType(), false);
                                this.requestReceiveReplyProcessor(originating_contact, reply);
                                packet_handler_stub.send(reply, request2.getAddress());
                            } else {
                                reply.setContacts(res.getContacts());
                                this.requestReceiveReplyProcessor(originating_contact, reply);
                                packet_handler_stub.send(reply, request2.getAddress());
                            }
                        }
                    }
                } else if (request2 instanceof DHTUDPPacketData) {
                    if (!this.bootstrap_node) {
                        this.dataRequest(originating_contact, (DHTUDPPacketData)request2);
                    }
                } else {
                    Debug.out("Unexpected packet:" + request2.toString());
                }
            }
        }
        catch (DHTUDPPacketHandlerException transport_address) {
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    @Override
    public DHTTransportAlternativeNetwork getAlternativeNetwork(int network_type) {
        return this.alt_net_states.get(network_type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerAlternativeNetwork(DHTTransportAlternativeNetwork network) {
        Object object = this.alt_net_providers_lock;
        synchronized (object) {
            HashMap<Integer, DHTTransportAlternativeNetwork> new_providers = new HashMap<Integer, DHTTransportAlternativeNetwork>(this.alt_net_providers);
            new_providers.put(network.getNetworkType(), network);
            this.alt_net_providers = new_providers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterAlternativeNetwork(DHTTransportAlternativeNetwork network) {
        Object object = this.alt_net_providers_lock;
        synchronized (object) {
            HashMap<Integer, DHTTransportAlternativeNetwork> new_providers = new HashMap<Integer, DHTTransportAlternativeNetwork>(this.alt_net_providers);
            Iterator it = new_providers.entrySet().iterator();
            while (it.hasNext()) {
                if (it.next().getValue() != network) continue;
                it.remove();
            }
            this.alt_net_providers = new_providers;
        }
    }

    private void checkAltContacts() {
        int total_required = 0;
        for (DHTTransportAlternativeNetworkImpl net : this.alt_net_states.values()) {
            total_required += net.getRequiredContactCount();
        }
        if (total_required > 0) {
            ArrayList<DHTTransportContact> targets = new ArrayList<DHTTransportContact>(128);
            try {
                this.this_mon.enter();
                for (DHTTransportContact contact : this.routable_contact_history.values()) {
                    if (contact.getProtocolVersion() < 52) continue;
                    targets.add(contact);
                }
            }
            finally {
                this.this_mon.exit();
            }
            if (targets.size() > 0) {
                ((DHTTransportContact)targets.get(RandomUtils.nextInt(targets.size()))).sendPing(new DHTTransportReplyHandlerAdapter(){

                    @Override
                    public void pingReply(DHTTransportContact _contact) {
                    }

                    @Override
                    public void failed(DHTTransportContact _contact, Throwable _error) {
                    }
                });
            }
        }
    }

    private void sendAltContacts(DHTUDPPacketRequestPing request2, DHTUDPPacketReplyPing reply) {
        if (request2.getProtocolVersion() >= 52) {
            int[] alt_nets = request2.getAltNetworks();
            int[] counts = request2.getAltNetworkCounts();
            if (alt_nets.length > 0) {
                ArrayList<DHTTransportAlternativeContact> alt_contacts = new ArrayList<DHTTransportAlternativeContact>();
                Map<Integer, DHTTransportAlternativeNetwork> providers = this.alt_net_providers;
                int i = 0;
                while (i < alt_nets.length) {
                    int net;
                    DHTTransportAlternativeNetworkImpl local;
                    int count = counts[i];
                    if (count != 0 && (local = this.alt_net_states.get(net = alt_nets[i])) != null) {
                        DHTTransportAlternativeNetwork provider2;
                        int wanted = local.getRequiredContactCount();
                        if (wanted > 0 && (provider2 = providers.get(net)) != null) {
                            local.addContactsForSend(provider2.getContacts(wanted));
                        }
                        if (net == 3) {
                            count = Math.min(2, count);
                        }
                        alt_contacts.addAll(local.getContacts(count, true));
                    }
                    ++i;
                }
                if (alt_contacts.size() > 0) {
                    reply.setAltContacts(alt_contacts);
                }
            }
        }
    }

    private void requestAltContacts(DHTUDPPacketRequestPing request2) {
        if (request2.getProtocolVersion() >= 52) {
            ArrayList<int[]> wanted = null;
            for (DHTTransportAlternativeNetworkImpl net : this.alt_net_states.values()) {
                int req = net.getRequiredContactCount();
                if (req <= 0) continue;
                int net_type = net.getNetworkType();
                if (net_type == 3) {
                    req = Math.min(2, req);
                }
                if (wanted == null) {
                    wanted = new ArrayList<int[]>(this.alt_net_states.size());
                }
                wanted.add(new int[]{net_type, req});
            }
            if (wanted != null) {
                int[] networks = new int[wanted.size()];
                int[] counts = new int[networks.length];
                int i = 0;
                while (i < networks.length) {
                    int[] entry = (int[])wanted.get(i);
                    networks[i] = entry[0];
                    counts[i] = entry[1];
                    ++i;
                }
                request2.setAltContactRequest(networks, counts);
            }
        }
    }

    private void receiveAltContacts(DHTUDPPacketReplyPing reply) {
        if (reply.getProtocolVersion() >= 52) {
            DHTTransportAlternativeContact[] dHTTransportAlternativeContactArray = reply.getAltContacts();
            int n = dHTTransportAlternativeContactArray.length;
            int n2 = 0;
            while (n2 < n) {
                DHTTransportAlternativeContact contact = dHTTransportAlternativeContactArray[n2];
                DHTTransportAlternativeNetworkImpl net = this.alt_net_states.get(contact.getNetworkType());
                if (net != null) {
                    net.addContactFromReply(contact);
                }
                ++n2;
            }
        }
    }

    protected void requestReceiveRequestProcessor(DHTTransportUDPContactImpl contact, DHTUDPPacketRequest request2) {
    }

    protected void requestReceiveReplyProcessor(DHTTransportUDPContactImpl contact, DHTUDPPacketReply reply) {
        int action = reply.getAction();
        if (action == 1025 || action == 1029 || action == 1031) {
            reply.setNetworkPositions(this.local_contact.getNetworkPositions());
        }
    }

    protected void requestSendRequestProcessor(DHTTransportUDPContactImpl contact, DHTUDPPacketRequest request2) {
    }

    protected void requestSendReplyProcessor(DHTTransportUDPContactImpl remote_contact, DHTTransportReplyHandler handler, DHTUDPPacketReply reply, long elapsed_time) throws DHTUDPPacketHandlerException {
        long proc_time;
        DHTNetworkPosition[] remote_nps = reply.getNetworkPositions();
        if (remote_nps != null && (proc_time = reply.getProcessingTime()) > 0L) {
            long rtt = elapsed_time - proc_time;
            if (rtt < 0L) {
                rtt = 0L;
            }
            remote_contact.setNetworkPositions(remote_nps);
            DHTNetworkPositionManager.update(this.local_contact.getNetworkPositions(), remote_contact.getID(), remote_nps, rtt);
        }
        remote_contact.setGenericFlags(reply.getGenericFlags());
        if (reply.getAction() == 1032) {
            DHTUDPPacketReplyError error = (DHTUDPPacketReplyError)reply;
            switch (error.getErrorType()) {
                case 1: {
                    try {
                        this.externalAddressChange(remote_contact, error.getOriginatingAddress(), false);
                    }
                    catch (DHTTransportException e) {
                        Debug.printStackTrace(e);
                    }
                    throw new DHTUDPPacketHandlerException("address changed notification");
                }
                case 2: {
                    handler.keyBlockRequest(remote_contact, error.getKeyBlockRequest(), error.getKeyBlockSignature());
                    this.contactAlive(remote_contact);
                    throw new DHTUDPPacketHandlerException("key blocked");
                }
            }
            throw new DHTUDPPacketHandlerException("unknown error type " + error.getErrorType());
        }
        this.contactAlive(remote_contact);
    }

    protected long getConnectionID() {
        return Long.MIN_VALUE | this.random.nextLong();
    }

    @Override
    public boolean supportsStorage() {
        return !this.bootstrap_node;
    }

    @Override
    public void addListener(DHTTransportListener l) {
        this.listeners.add(l);
        if (this.external_address != null) {
            l.currentAddress(this.external_address);
        }
    }

    @Override
    public void removeListener(DHTTransportListener l) {
        this.listeners.remove(l);
    }
}

