/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.networkmanager.Transport;
import com.aelitis.azureus.core.networkmanager.impl.ProtocolDecoder;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelper;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelperFilter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

public class IncomingConnectionManager {
    private static final LogIDs LOGID = LogIDs.NWMAN;
    private static final IncomingConnectionManager singleton = new IncomingConnectionManager();
    private volatile Map match_buffers_cow = new HashMap();
    private final AEMonitor match_buffers_mon = new AEMonitor("IncomingConnectionManager:match");
    private int max_match_buffer_size = 0;
    private int max_min_match_buffer_size = 0;
    private final ArrayList connections = new ArrayList();
    private final AEMonitor connections_mon = new AEMonitor("IncomingConnectionManager:conns");

    public static IncomingConnectionManager getSingleton() {
        return singleton;
    }

    protected IncomingConnectionManager() {
        SimpleTimer.addPeriodicEvent("IncomingConnectionManager:timeouts", 5000L, new TimerEventPerformer(){

            @Override
            public void perform(TimerEvent ev) {
                IncomingConnectionManager.this.doTimeoutChecks();
            }
        });
    }

    public boolean isEmpty() {
        return this.match_buffers_cow.isEmpty();
    }

    public Object[] checkForMatch(TransportHelper transport, int incoming_port, ByteBuffer to_check, boolean min_match) {
        int orig_position = to_check.position();
        int orig_limit = to_check.limit();
        to_check.position(0);
        MatchListener listener = null;
        Object routing_data = null;
        Iterator i = this.match_buffers_cow.entrySet().iterator();
        while (i.hasNext() && !transport.isClosed()) {
            Map.Entry entry = i.next();
            NetworkManager.ByteMatcher bm = (NetworkManager.ByteMatcher)entry.getKey();
            MatchListener this_listener = (MatchListener)entry.getValue();
            int specific_port = bm.getSpecificPort();
            if (specific_port != -1 && specific_port != incoming_port) continue;
            if (min_match) {
                if (orig_position < bm.minSize() || (routing_data = bm.minMatches(transport, to_check, incoming_port)) == null) continue;
                listener = this_listener;
                break;
            }
            if (orig_position < bm.matchThisSizeOrBigger() || (routing_data = bm.matches(transport, to_check, incoming_port)) == null) continue;
            listener = this_listener;
            break;
        }
        to_check.position(orig_position);
        to_check.limit(orig_limit);
        if (listener == null) {
            return null;
        }
        return new Object[]{listener, routing_data};
    }

    public void registerMatchBytes(NetworkManager.ByteMatcher matcher, MatchListener listener) {
        try {
            this.match_buffers_mon.enter();
            if (matcher.maxSize() > this.max_match_buffer_size) {
                this.max_match_buffer_size = matcher.maxSize();
            }
            if (matcher.minSize() > this.max_min_match_buffer_size) {
                this.max_min_match_buffer_size = matcher.minSize();
            }
            HashMap<NetworkManager.ByteMatcher, MatchListener> new_match_buffers = new HashMap<NetworkManager.ByteMatcher, MatchListener>(this.match_buffers_cow);
            new_match_buffers.put(matcher, listener);
            this.match_buffers_cow = new_match_buffers;
            this.addSharedSecrets(matcher.getSharedSecrets());
        }
        finally {
            this.match_buffers_mon.exit();
        }
    }

    public void deregisterMatchBytes(NetworkManager.ByteMatcher to_remove) {
        try {
            this.match_buffers_mon.enter();
            HashMap new_match_buffers = new HashMap(this.match_buffers_cow);
            new_match_buffers.remove(to_remove);
            if (to_remove.maxSize() == this.max_match_buffer_size) {
                this.max_match_buffer_size = 0;
                for (NetworkManager.ByteMatcher bm : new_match_buffers.keySet()) {
                    if (bm.maxSize() <= this.max_match_buffer_size) continue;
                    this.max_match_buffer_size = bm.maxSize();
                }
            }
            this.match_buffers_cow = new_match_buffers;
            this.removeSharedSecrets(to_remove.getSharedSecrets());
        }
        finally {
            this.match_buffers_mon.exit();
        }
    }

    public void addSharedSecrets(byte[][] secrets) {
        if (secrets != null) {
            ProtocolDecoder.addSecrets(secrets);
        }
    }

    public void removeSharedSecrets(byte[][] secrets) {
        if (secrets != null) {
            ProtocolDecoder.removeSecrets(secrets);
        }
    }

    public int getMaxMatchBufferSize() {
        return this.max_match_buffer_size;
    }

    public int getMaxMinMatchBufferSize() {
        return this.max_min_match_buffer_size;
    }

    public void addConnection(int local_port, TransportHelperFilter filter2, Transport new_transport) {
        TransportHelper transport_helper = filter2.getHelper();
        if (this.isEmpty()) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "Incoming connection from [" + transport_helper.getAddress() + "] dropped because zero routing handlers registered"));
            }
            transport_helper.close("No routing handler");
            return;
        }
        IncomingConnection ic = new IncomingConnection(filter2, this.getMaxMatchBufferSize());
        SelectorListener sel_listener = new SelectorListener(local_port, new_transport);
        try {
            this.connections_mon.enter();
            this.connections.add(ic);
            transport_helper.registerForReadSelects(sel_listener, ic);
        }
        finally {
            this.connections_mon.exit();
        }
        sel_listener.selectSuccess(transport_helper, ic);
    }

    protected void removeConnection(IncomingConnection connection, boolean close_as_well, String reason) {
        try {
            this.connections_mon.enter();
            connection.filter.getHelper().cancelReadSelects();
            this.connections.remove(connection);
        }
        finally {
            this.connections_mon.exit();
        }
        if (close_as_well) {
            connection.filter.getHelper().close("Tidy close" + (reason == null || reason.length() == 0 ? "" : ": " + reason));
        }
    }

    protected void doTimeoutChecks() {
        try {
            IncomingConnection ic;
            this.connections_mon.enter();
            ArrayList<IncomingConnection> to_close = null;
            long now = SystemTime.getCurrentTime();
            int i = 0;
            while (i < this.connections.size()) {
                ic = (IncomingConnection)this.connections.get(i);
                TransportHelper transport_helper = ic.filter.getHelper();
                if (ic.last_read_time > 0L) {
                    if (now < ic.last_read_time) {
                        ic.last_read_time = now;
                    } else if (now - ic.last_read_time > (long)transport_helper.getReadTimeout()) {
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, "Incoming connection [" + transport_helper.getAddress() + "] forcibly timed out due to socket read inactivity [" + ic.buffer.position() + " bytes read: " + new String(ic.buffer.array()) + "]"));
                        }
                        if (to_close == null) {
                            to_close = new ArrayList<IncomingConnection>();
                        }
                        to_close.add(ic);
                    }
                } else if (now < ic.initial_connect_time) {
                    ic.initial_connect_time = now;
                } else if (now - ic.initial_connect_time > (long)transport_helper.getConnectTimeout()) {
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "Incoming connection [" + transport_helper.getAddress() + "] forcibly timed out after " + "60sec due to socket inactivity"));
                    }
                    if (to_close == null) {
                        to_close = new ArrayList();
                    }
                    to_close.add(ic);
                }
                ++i;
            }
            if (to_close != null) {
                i = 0;
                while (i < to_close.size()) {
                    ic = (IncomingConnection)to_close.get(i);
                    this.removeConnection(ic, true, "incoming connection routing timeout");
                    ++i;
                }
            }
        }
        finally {
            this.connections_mon.exit();
        }
    }

    protected static class IncomingConnection {
        protected final TransportHelperFilter filter;
        protected final ByteBuffer buffer;
        protected long initial_connect_time;
        protected long last_read_time = -1L;

        protected IncomingConnection(TransportHelperFilter filter2, int buff_size) {
            this.filter = filter2;
            this.buffer = ByteBuffer.allocate(buff_size);
            this.initial_connect_time = SystemTime.getCurrentTime();
        }
    }

    public static interface MatchListener {
        public boolean autoCryptoFallback();

        public void connectionMatched(Transport var1, Object var2);
    }

    protected class SelectorListener
    implements TransportHelper.selectListener {
        private final int local_port;
        private final Transport transport;

        protected SelectorListener(int _local_port, Transport _transport) {
            this.local_port = _local_port;
            this.transport = _transport;
        }

        @Override
        public boolean selectSuccess(TransportHelper transport_helper, Object attachment) {
            IncomingConnection ic;
            block12: {
                ic = (IncomingConnection)attachment;
                try {
                    long bytes_read = ic.filter.read(new ByteBuffer[]{ic.buffer}, 0, 1);
                    if (bytes_read < 0L) {
                        throw new IOException("end of stream on socket read");
                    }
                    if (bytes_read != 0L) break block12;
                    return false;
                }
                catch (Throwable t) {
                    try {
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, 1, "Incoming connection [" + transport_helper.getAddress() + "] socket read exception: " + t.getMessage()));
                        }
                    }
                    catch (Throwable x) {
                        Debug.out("Caught exception on incoming exception log:");
                        x.printStackTrace();
                        System.out.println("CAUSED BY:");
                        t.printStackTrace();
                    }
                    IncomingConnectionManager.this.removeConnection(ic, true, t == null ? null : Debug.getNestedExceptionMessage(t));
                    return false;
                }
            }
            ic.last_read_time = SystemTime.getCurrentTime();
            Object[] match_data = IncomingConnectionManager.this.checkForMatch(transport_helper, this.local_port, ic.buffer, false);
            if (match_data == null) {
                if (transport_helper.isClosed() || ic.buffer.position() >= IncomingConnectionManager.this.getMaxMatchBufferSize()) {
                    ic.buffer.flip();
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, 1, "Incoming stream from [" + transport_helper.getAddress() + "] does not match " + "any known byte pattern: " + ByteFormatter.nicePrint(ic.buffer.array(), 128)));
                    }
                    IncomingConnectionManager.this.removeConnection(ic, true, "routing failed: unknown hash");
                }
            } else {
                ic.buffer.flip();
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "Incoming stream from [" + transport_helper.getAddress() + "] recognized as " + "known byte pattern: " + ByteFormatter.nicePrint(ic.buffer.array(), 64)));
                }
                IncomingConnectionManager.this.removeConnection(ic, false, null);
                this.transport.setAlreadyRead(ic.buffer);
                this.transport.connectedInbound();
                MatchListener listener = (MatchListener)match_data[0];
                listener.connectionMatched(this.transport, match_data[1]);
            }
            return true;
        }

        @Override
        public void selectFailure(TransportHelper transport_helper, Object attachment, Throwable msg) {
            IncomingConnection ic = (IncomingConnection)attachment;
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, 1, "Incoming connection [" + transport_helper.getAddress() + "] socket select op failure: " + msg.getMessage()));
            }
            IncomingConnectionManager.this.removeConnection(ic, true, msg == null ? null : Debug.getNestedExceptionMessage(msg));
        }
    }
}

