/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.uploadslots;

import com.aelitis.azureus.core.peermanager.uploadslots.DownloadingRanker;
import com.aelitis.azureus.core.peermanager.uploadslots.SeedingRanker;
import com.aelitis.azureus.core.peermanager.uploadslots.UploadHelper;
import com.aelitis.azureus.core.peermanager.uploadslots.UploadSession;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.RandomUtils;

public class UploadSessionPicker {
    private final LinkedList next_optimistics = new LinkedList();
    private final AEMonitor next_optimistics_mon = new AEMonitor("UploadSessionPicker");
    private final LinkedList helpers = new LinkedList();
    private final DownloadingRanker down_ranker = new DownloadingRanker();
    private final SeedingRanker seed_ranker = new SeedingRanker();

    protected UploadSessionPicker() {
    }

    protected void registerHelper(UploadHelper helper) {
        try {
            this.next_optimistics_mon.enter();
            this.helpers.add(helper);
            int priority = helper.getPriority();
            int i = 0;
            while (i < priority) {
                this.insertHelper(helper);
                ++i;
            }
        }
        finally {
            this.next_optimistics_mon.exit();
        }
    }

    protected void deregisterHelper(UploadHelper helper) {
        try {
            this.next_optimistics_mon.enter();
            this.helpers.remove(helper);
            boolean rem = this.next_optimistics.removeAll(Collections.singleton(helper));
            if (!rem) {
                Debug.out("!rem");
            }
        }
        finally {
            this.next_optimistics_mon.exit();
        }
    }

    protected void updateHelper(UploadHelper helper) {
        try {
            this.next_optimistics_mon.enter();
            int priority = helper.getPriority();
            int count = 0;
            Iterator it = this.next_optimistics.iterator();
            while (it.hasNext()) {
                UploadHelper h = (UploadHelper)it.next();
                if (h != helper || ++count <= priority) continue;
                it.remove();
            }
            if (count < priority) {
                int i = count;
                while (i < priority) {
                    this.insertHelper(helper);
                    ++i;
                }
            }
        }
        finally {
            this.next_optimistics_mon.exit();
        }
    }

    private void insertHelper(UploadHelper helper) {
        int pos = RandomUtils.nextInt(this.next_optimistics.size() + 1);
        this.next_optimistics.add(pos, helper);
    }

    protected int getHelperCount() {
        try {
            this.next_optimistics_mon.enter();
            int n = this.next_optimistics.size();
            return n;
        }
        finally {
            this.next_optimistics_mon.exit();
        }
    }

    protected UploadSession pickNextOptimisticSession() {
        try {
            this.next_optimistics_mon.enter();
            HashSet<UploadHelper> failed_helpers = null;
            int loops_allowed = this.next_optimistics.size();
            while (loops_allowed > 0) {
                UploadHelper helper = (UploadHelper)this.next_optimistics.removeFirst();
                this.next_optimistics.addLast(helper);
                if (failed_helpers == null || !failed_helpers.contains(helper)) {
                    PEPeer peer = helper.isSeeding() ? this.seed_ranker.getNextOptimisticPeer(helper.getAllPeers()) : this.down_ranker.getNextOptimisticPeer(helper.getAllPeers());
                    if (peer == null) {
                        if (failed_helpers == null) {
                            failed_helpers = new HashSet<UploadHelper>();
                        }
                        failed_helpers.add(helper);
                    } else {
                        UploadSession uploadSession = new UploadSession(peer, helper.isSeeding() ? 1 : 0);
                        return uploadSession;
                    }
                }
                --loops_allowed;
            }
            return null;
        }
        finally {
            this.next_optimistics_mon.exit();
        }
    }

    private ArrayList<PEPeer> globalGetAllDownloadPeers() {
        try {
            this.next_optimistics_mon.enter();
            ArrayList<PEPeer> all = new ArrayList<PEPeer>();
            for (UploadHelper helper : this.helpers) {
                if (helper.isSeeding()) continue;
                all.addAll(helper.getAllPeers());
            }
            ArrayList<PEPeer> arrayList = all;
            return arrayList;
        }
        finally {
            this.next_optimistics_mon.exit();
        }
    }

    protected LinkedList<UploadSession> pickBestDownloadSessions(int max_sessions) {
        ArrayList<PEPeer> all_peers = this.globalGetAllDownloadPeers();
        if (all_peers.isEmpty()) {
            return new LinkedList<UploadSession>();
        }
        ArrayList<PEPeer> best = this.down_ranker.rankPeers(max_sessions, all_peers);
        if (best.size() != max_sessions) {
            Debug.outNoStack("best.size()[" + best.size() + "] != max_sessions[" + max_sessions + "]");
        }
        if (best.isEmpty()) {
            return new LinkedList<UploadSession>();
        }
        LinkedList<UploadSession> best_sessions = new LinkedList<UploadSession>();
        for (PEPeer peer : best) {
            UploadSession session = new UploadSession(peer, 0);
            best_sessions.add(session);
        }
        return best_sessions;
    }
}

