/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.proxy.impl;

import com.aelitis.azureus.core.networkmanager.VirtualChannelSelector;
import com.aelitis.azureus.core.proxy.AEProxy;
import com.aelitis.azureus.core.proxy.AEProxyException;
import com.aelitis.azureus.core.proxy.AEProxyHandler;
import com.aelitis.azureus.core.proxy.impl.AEProxyConnectionImpl;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketTimeoutException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

public class AEProxyImpl
implements AEProxy,
VirtualChannelSelector.VirtualSelectorListener {
    private static final LogIDs LOGID = LogIDs.NET;
    private static final int DEBUG_PERIOD = 60000;
    private long last_debug;
    private int port;
    private final long connect_timeout;
    private final long read_timeout;
    private final AEProxyHandler proxy_handler;
    private ServerSocketChannel ssc;
    final VirtualChannelSelector read_selector;
    final VirtualChannelSelector connect_selector;
    final VirtualChannelSelector write_selector;
    private final List<AEProxyConnectionImpl> processors = new ArrayList<AEProxyConnectionImpl>();
    private final HashMap write_select_regs = new HashMap();
    private boolean allow_external_access;
    private final AEMonitor this_mon = new AEMonitor("AEProxyImpl");
    private volatile boolean destroyed;

    public AEProxyImpl(int _port, long _connect_timeout, long _read_timeout, AEProxyHandler _proxy_handler) throws AEProxyException {
        this.port = _port;
        this.connect_timeout = _connect_timeout;
        this.read_timeout = _read_timeout;
        this.proxy_handler = _proxy_handler;
        String name = "Proxy:" + this.port;
        this.read_selector = new VirtualChannelSelector(name, 1, false);
        this.connect_selector = new VirtualChannelSelector(name, 8, true);
        this.write_selector = new VirtualChannelSelector(name, 4, true);
        try {
            this.ssc = ServerSocketChannel.open();
            ServerSocket ss = this.ssc.socket();
            ss.setReuseAddress(true);
            ss.bind(new InetSocketAddress(InetAddress.getByName("127.0.0.1"), this.port), 128);
            if (this.port == 0) {
                this.port = ss.getLocalPort();
            }
            new AEThread2("AEProxy:connect.loop"){

                @Override
                public void run() {
                    AEProxyImpl.this.selectLoop(AEProxyImpl.this.connect_selector);
                }
            }.start();
            new AEThread2("AEProxy:read.loop"){

                @Override
                public void run() {
                    AEProxyImpl.this.selectLoop(AEProxyImpl.this.read_selector);
                }
            }.start();
            new AEThread2("AEProxy:write.loop"){

                @Override
                public void run() {
                    AEProxyImpl.this.selectLoop(AEProxyImpl.this.write_selector);
                }
            }.start();
            new AEThread2("AEProxy:accept.loop"){

                @Override
                public void run() {
                    AEProxyImpl.this.acceptLoop(AEProxyImpl.this.ssc);
                }
            }.start();
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "AEProxy: listener established on port " + this.port));
            }
        }
        catch (Throwable e) {
            Logger.logTextResource(new LogAlert(false, 3, "Tracker.alert.listenfail"), new String[]{"" + this.port});
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "AEProxy: listener failed on port " + this.port, e));
            }
            throw new AEProxyException("AEProxy: accept fails: " + e.toString());
        }
    }

    @Override
    public void setAllowExternalConnections(boolean permit) {
        this.allow_external_access = permit;
    }

    protected void acceptLoop(ServerSocketChannel ssc) {
        long successfull_accepts = 0L;
        long failed_accepts = 0L;
        while (!this.destroyed) {
            try {
                SocketChannel socket_channel = ssc.accept();
                ++successfull_accepts;
                if (!this.allow_external_access && !socket_channel.socket().getInetAddress().isLoopbackAddress()) {
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, 1, "AEProxy: incoming connection from '" + socket_channel.socket().getInetAddress() + "' - closed as not local"));
                    }
                    socket_channel.close();
                    continue;
                }
                try {
                    socket_channel.configureBlocking(false);
                    socket_channel.socket().setTcpNoDelay(true);
                }
                catch (Throwable e) {
                    socket_channel.close();
                    throw e;
                }
                AEProxyConnectionImpl processor2 = new AEProxyConnectionImpl(this, socket_channel, this.proxy_handler);
                if (processor2.isClosed()) continue;
                boolean added = false;
                try {
                    this.this_mon.enter();
                    if (!this.destroyed) {
                        added = true;
                        this.processors.add(processor2);
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, "AEProxy: active processors = " + this.processors.size()));
                        }
                    }
                }
                finally {
                    this.this_mon.exit();
                }
                if (!added) {
                    processor2.close();
                    continue;
                }
                this.read_selector.register(socket_channel, this, (Object)processor2);
            }
            catch (Throwable e) {
                if (this.destroyed) continue;
                ++failed_accepts;
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "AEProxy: listener failed on port " + this.port, e));
                }
                if (failed_accepts <= 100L || successfull_accepts != 0L) continue;
                Logger.logTextResource(new LogAlert(false, 3, "Network.alert.acceptfail"), new String[]{"" + this.port, "TCP"});
                break;
            }
        }
    }

    protected void close(AEProxyConnectionImpl processor2) {
        try {
            this.this_mon.enter();
            this.processors.remove(processor2);
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected void selectLoop(VirtualChannelSelector selector) {
        long last_time = 0L;
        while (!this.destroyed) {
            try {
                selector.select(100L);
                if (selector != this.read_selector) continue;
                long now = SystemTime.getCurrentTime();
                if (now < last_time) {
                    last_time = now;
                    continue;
                }
                if (now - last_time < 5000L) continue;
                last_time = now;
                this.checkTimeouts();
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    protected void checkTimeouts() {
        long now = SystemTime.getCurrentTime();
        if (now - this.last_debug > 60000L) {
            this.last_debug = now;
            try {
                this.this_mon.enter();
                for (AEProxyConnectionImpl processor2 : this.processors) {
                    if (!Logger.isEnabled()) continue;
                    Logger.log(new LogEvent(LOGID, "AEProxy: active processor: " + processor2.getStateString()));
                }
            }
            finally {
                this.this_mon.exit();
            }
        }
        if (this.connect_timeout <= 0L && this.read_timeout <= 0L) {
            return;
        }
        ArrayList<AEProxyConnectionImpl> closes = new ArrayList<AEProxyConnectionImpl>();
        try {
            this.this_mon.enter();
            for (AEProxyConnectionImpl processor3 : this.processors) {
                long diff = now - processor3.getTimeStamp();
                if (this.connect_timeout > 0L && diff >= this.connect_timeout && !processor3.isConnected()) {
                    closes.add(processor3);
                    continue;
                }
                if (this.read_timeout <= 0L || diff < this.read_timeout || !processor3.isConnected()) continue;
                closes.add(processor3);
            }
        }
        finally {
            this.this_mon.exit();
        }
        int i = 0;
        while (i < closes.size()) {
            ((AEProxyConnectionImpl)closes.get(i)).failed(new SocketTimeoutException("timeout"));
            ++i;
        }
    }

    protected void requestWriteSelect(AEProxyConnectionImpl processor2, SocketChannel sc) {
        if (this.write_select_regs.containsKey(sc)) {
            this.write_selector.resumeSelects(sc);
        } else {
            this.write_select_regs.put(sc, null);
            this.write_selector.register(sc, this, (Object)processor2);
        }
    }

    protected void cancelWriteSelect(SocketChannel sc) {
        this.write_select_regs.remove(sc);
        this.write_selector.cancel(sc);
    }

    protected void requestReadSelect(AEProxyConnectionImpl processor2, SocketChannel sc) {
        this.read_selector.register(sc, this, (Object)processor2);
    }

    protected void cancelReadSelect(SocketChannel sc) {
        this.read_selector.cancel(sc);
    }

    protected void requestConnectSelect(AEProxyConnectionImpl processor2, SocketChannel sc) {
        this.connect_selector.register(sc, this, (Object)processor2);
    }

    protected void cancelConnectSelect(SocketChannel sc) {
        this.connect_selector.cancel(sc);
    }

    @Override
    public boolean selectSuccess(VirtualChannelSelector selector, SocketChannel sc, Object attachment) {
        AEProxyConnectionImpl processor2 = (AEProxyConnectionImpl)attachment;
        if (selector == this.read_selector) {
            return processor2.read(sc);
        }
        if (selector == this.write_selector) {
            return processor2.write(sc);
        }
        return processor2.connect(sc);
    }

    @Override
    public void selectFailure(VirtualChannelSelector selector, SocketChannel sc, Object attachment, Throwable msg) {
        AEProxyConnectionImpl processor2 = (AEProxyConnectionImpl)attachment;
        processor2.failed(msg);
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void destroy() {
        ArrayList<AEProxyConnectionImpl> to_close;
        try {
            this.this_mon.enter();
            this.destroyed = true;
            to_close = new ArrayList<AEProxyConnectionImpl>(this.processors);
        }
        finally {
            this.this_mon.exit();
        }
        for (AEProxyConnectionImpl con : to_close) {
            try {
                con.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.ssc != null) {
            try {
                this.ssc.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.connect_selector.destroy();
        this.read_selector.destroy();
        this.write_selector.destroy();
    }
}

