/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.tag.impl;

import com.aelitis.azureus.core.tag.Tag;
import com.aelitis.azureus.core.tag.TagException;
import com.aelitis.azureus.core.tag.TagFeatureFileLocation;
import com.aelitis.azureus.core.tag.TagFeatureLimits;
import com.aelitis.azureus.core.tag.TagFeatureProperties;
import com.aelitis.azureus.core.tag.TagFeatureRSSFeed;
import com.aelitis.azureus.core.tag.TagFeatureRateLimit;
import com.aelitis.azureus.core.tag.TagListener;
import com.aelitis.azureus.core.tag.Taggable;
import com.aelitis.azureus.core.tag.impl.TagManagerImpl;
import com.aelitis.azureus.core.tag.impl.TagTypeBase;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.ListenerManager;
import org.gudy.azureus2.core3.util.ListenerManagerDispatcher;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;

public abstract class TagBase
implements Tag,
SimpleTimer.TimerTickReceiver {
    protected static final String AT_RATELIMIT_UP = "rl.up";
    protected static final String AT_RATELIMIT_DOWN = "rl.down";
    protected static final String AT_VISIBLE = "vis";
    protected static final String AT_PUBLIC = "pub";
    protected static final String AT_GROUP = "gr";
    protected static final String AT_CAN_BE_PUBLIC = "canpub";
    protected static final String AT_ORIGINAL_NAME = "oname";
    protected static final String AT_IMAGE_ID = "img.id";
    protected static final String AT_COLOR_ID = "col.rgb";
    protected static final String AT_RSS_ENABLE = "rss.enable";
    protected static final String AT_RATELIMIT_UP_PRI = "rl.uppri";
    protected static final String AT_XCODE_TARGET = "xcode.to";
    protected static final String AT_FL_MOVE_COMP = "fl.comp";
    protected static final String AT_FL_COPY_COMP = "fl.copy";
    protected static final String AT_FL_INIT_LOC = "fl.init";
    protected static final String AT_RATELIMIT_MIN_SR = "rl.minsr";
    protected static final String AT_RATELIMIT_MAX_SR = "rl.maxsr";
    protected static final String AT_RATELIMIT_MAX_SR_ACTION = "rl.maxsr.a";
    protected static final String AT_RATELIMIT_MAX_AGGREGATE_SR = "rl.maxaggsr";
    protected static final String AT_RATELIMIT_MAX_AGGREGATE_SR_ACTION = "rl.maxaggsr.a";
    protected static final String AT_RATELIMIT_MAX_AGGREGATE_SR_PRIORITY = "rl.maxaggsr.p";
    protected static final String AT_PROPERTY_PREFIX = "pp.";
    protected static final String AT_EOA_PREFIX = "eoa.";
    protected static final String AT_BYTES_UP = "b.up";
    protected static final String AT_BYTES_DOWN = "b.down";
    protected static final String AT_DESCRIPTION = "desc";
    protected static final String AT_MAX_TAGGABLES = "max.t";
    protected static final String AT_REMOVAL_STRATEGY = "max.t.r";
    protected static final String AT_EOS_SCRIPT = "eos.scr";
    protected static final String AT_NOTIFICATION_POST = "noti.post";
    private static final String[] EMPTY_STRING_LIST = new String[0];
    final TagTypeBase tag_type;
    private final int tag_id;
    private String tag_name;
    private static final int TL_ADD = 1;
    private static final int TL_REMOVE = 2;
    private static final int TL_SYNC = 3;
    private final ListenerManager<TagListener> t_listeners = ListenerManager.createManager("TagListeners", new ListenerManagerDispatcher<TagListener>(){

        @Override
        public void dispatch(TagListener listener, int type, Object value) {
            if (type == 1) {
                listener.taggableAdded(TagBase.this, (Taggable)value);
            } else if (type == 2) {
                listener.taggableRemoved(TagBase.this, (Taggable)value);
            } else if (type == 3) {
                listener.taggableSync(TagBase.this);
            }
        }
    });
    private final Map<org.gudy.azureus2.plugins.tag.TagListener, TagListener> listener_map = new HashMap<org.gudy.azureus2.plugins.tag.TagListener, TagListener>();
    private Boolean is_visible;
    private Boolean is_public;
    private String group;
    private int[] colour;
    private String description;
    private TagFeatureRateLimit tag_rl;
    private TagFeatureRSSFeed tag_rss;
    private TagFeatureFileLocation tag_fl;
    private TagFeatureLimits tag_limits;
    private HashMap<String, Object> transient_properties;
    private static final Map<Long, long[][]> session_cache = new HashMap<Long, long[][]>();
    private long[] total_up_at_start;
    private long[] total_down_at_start;
    private long[] session_up;
    private long[] session_down;
    private long[] session_up_reset;
    private long[] session_down_reset;
    private static final int HISTORY_MAX_SECS = 1800;
    private volatile boolean history_retention_required;
    private long[] history;
    private int history_pos;
    private boolean history_wrapped;
    private boolean timer_registered;

    protected TagBase(TagTypeBase _tag_type, int _tag_id, String _tag_name) {
        this.tag_type = _tag_type;
        this.tag_id = _tag_id;
        this.tag_name = _tag_name;
        if (this.getManager().isEnabled()) {
            this.is_visible = this.readBooleanAttribute(AT_VISIBLE, null);
            this.is_public = this.readBooleanAttribute(AT_PUBLIC, null);
            this.group = this.readStringAttribute(AT_GROUP, null);
            this.description = this.readStringAttribute(AT_DESCRIPTION, null);
            if (this instanceof TagFeatureRateLimit) {
                this.tag_rl = (TagFeatureRateLimit)((Object)this);
            }
            if (this instanceof TagFeatureRSSFeed) {
                this.tag_rss = (TagFeatureRSSFeed)((Object)this);
                if (this.tag_rss.isTagRSSFeedEnabled()) {
                    this.getManager().checkRSSFeeds(this, true);
                }
            }
            if (this instanceof TagFeatureFileLocation) {
                this.tag_fl = (TagFeatureFileLocation)((Object)this);
            }
            if (this instanceof TagFeatureLimits) {
                this.tag_limits = (TagFeatureLimits)((Object)this);
            }
        }
    }

    protected void initialized() {
        this.loadPersistentStuff();
        this.loadTransientStuff();
    }

    public Tag getTag() {
        return this;
    }

    protected void addTag() {
        if (this.getManager().isEnabled()) {
            this.tag_type.addTag(this);
        }
    }

    protected TagManagerImpl getManager() {
        return this.tag_type.getTagManager();
    }

    @Override
    public TagTypeBase getTagType() {
        return this.tag_type;
    }

    @Override
    public int getTagID() {
        return this.tag_id;
    }

    @Override
    public long getTagUID() {
        return (long)this.getTagType().getTagType() << 32 | (long)this.tag_id;
    }

    @Override
    public String getTagName() {
        return this.getTagName(true);
    }

    protected String getTagNameRaw() {
        return this.tag_name;
    }

    @Override
    public String getTagName(boolean localize) {
        if (localize) {
            if (this.tag_name.startsWith("tag.")) {
                return MessageText.getString(this.tag_name);
            }
            return this.tag_name;
        }
        if (this.tag_name.startsWith("tag.")) {
            return this.tag_name;
        }
        String original_name = this.readStringAttribute(AT_ORIGINAL_NAME, null);
        if (original_name != null && original_name.startsWith("tag.")) {
            return original_name;
        }
        return "!" + this.tag_name + "!";
    }

    @Override
    public void setTagName(String name) throws TagException {
        String original_name;
        if (this.getTagType().isTagTypeAuto()) {
            throw new TagException("Not supported");
        }
        if (this.tag_name.startsWith("tag.") && (original_name = this.readStringAttribute(AT_ORIGINAL_NAME, null)) == null) {
            this.writeStringAttribute(AT_ORIGINAL_NAME, this.tag_name);
        }
        this.tag_name = name;
        this.tag_type.fireChanged(this);
    }

    @Override
    public boolean isPublic() {
        boolean[] autos;
        boolean pub;
        boolean bl = pub = this.is_public == null ? this.getPublicDefault() : this.is_public.booleanValue();
        if (pub && ((autos = this.isTagAuto())[0] || autos[1])) {
            pub = false;
        }
        return pub;
    }

    @Override
    public void setPublic(boolean v) {
        if (this.is_public == null || v != this.is_public) {
            if (v && !this.canBePublic()) {
                Debug.out("Invalid attempt to set public");
                return;
            }
            this.is_public = v;
            this.writeBooleanAttribute(AT_PUBLIC, v);
            this.tag_type.fireChanged(this);
        }
    }

    protected boolean getPublicDefault() {
        if (!this.getCanBePublicDefault()) {
            return false;
        }
        return this.tag_type.getTagManager().getTagPublicDefault();
    }

    @Override
    public void setCanBePublic(boolean can_be_public) {
        this.writeBooleanAttribute(AT_CAN_BE_PUBLIC, can_be_public);
        if (!can_be_public && this.isPublic()) {
            this.setPublic(false);
        }
    }

    @Override
    public boolean canBePublic() {
        return this.readBooleanAttribute(AT_CAN_BE_PUBLIC, this.getCanBePublicDefault());
    }

    protected boolean getCanBePublicDefault() {
        return true;
    }

    @Override
    public boolean[] isTagAuto() {
        return new boolean[2];
    }

    @Override
    public boolean isVisible() {
        return this.is_visible == null ? this.getVisibleDefault() : this.is_visible.booleanValue();
    }

    @Override
    public void setVisible(boolean v) {
        if (this.is_visible == null || v != this.is_visible) {
            this.is_visible = v;
            this.writeBooleanAttribute(AT_VISIBLE, v);
            this.tag_type.fireChanged(this);
        }
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public void setGroup(String new_group) {
        if (this.group == null && new_group == null) {
            return;
        }
        if (this.group == null || new_group == null || !this.group.equals(new_group)) {
            this.group = new_group;
            this.writeStringAttribute(AT_GROUP, new_group);
            this.tag_type.fireChanged(this);
        }
    }

    protected boolean getVisibleDefault() {
        return true;
    }

    @Override
    public String getImageID() {
        return this.readStringAttribute(AT_IMAGE_ID, null);
    }

    @Override
    public void setImageID(String id) {
        this.writeStringAttribute(AT_IMAGE_ID, id);
    }

    private int[] decodeRGB(String str) {
        if (str == null) {
            return null;
        }
        String[] bits = str.split(",");
        if (bits.length != 3) {
            return null;
        }
        int[] rgb = new int[3];
        int i = 0;
        while (i < bits.length) {
            try {
                rgb[i] = Integer.parseInt(bits[i]);
            }
            catch (Throwable e) {
                return null;
            }
            ++i;
        }
        return rgb;
    }

    private String encodeRGB(int[] rgb) {
        if (rgb == null || rgb.length != 3) {
            return null;
        }
        return String.valueOf(rgb[0]) + "," + rgb[1] + "," + rgb[2];
    }

    public boolean isColorDefault() {
        return this.decodeRGB(this.readStringAttribute(AT_COLOR_ID, null)) == null;
    }

    @Override
    public int[] getColor() {
        int[] result = this.colour;
        if (result == null) {
            result = this.decodeRGB(this.readStringAttribute(AT_COLOR_ID, null));
            if (result == null) {
                result = this.tag_type.getColorDefault();
            }
            this.colour = result;
        }
        return result;
    }

    @Override
    public void setColor(int[] rgb) {
        this.writeStringAttribute(AT_COLOR_ID, this.encodeRGB(rgb));
        this.colour = null;
        this.tag_type.fireChanged(this);
    }

    public boolean isTagRSSFeedEnabled() {
        if (this.tag_rss != null) {
            return this.readBooleanAttribute(AT_RSS_ENABLE, false);
        }
        return false;
    }

    public void setTagRSSFeedEnabled(boolean enable) {
        if (this.tag_rss != null && this.isTagRSSFeedEnabled() != enable) {
            this.writeBooleanAttribute(AT_RSS_ENABLE, enable);
            this.tag_type.fireChanged(this);
            this.tag_type.getTagManager().checkRSSFeeds(this, enable);
        }
    }

    public boolean supportsTagInitialSaveFolder() {
        return false;
    }

    public File getTagInitialSaveFolder() {
        if (this.tag_fl != null) {
            String str = this.readStringAttribute(AT_FL_INIT_LOC, null);
            if (str == null) {
                return null;
            }
            return new File(str);
        }
        return null;
    }

    public void setTagInitialSaveFolder(File folder) {
        if (this.tag_fl != null) {
            File existing = this.getTagInitialSaveFolder();
            if (existing == null && folder == null) {
                return;
            }
            if (existing == null || folder == null || !existing.equals(folder)) {
                this.writeStringAttribute(AT_FL_INIT_LOC, folder == null ? null : folder.getAbsolutePath());
                this.tag_type.fireChanged(this);
            }
        }
    }

    public boolean supportsTagMoveOnComplete() {
        return false;
    }

    public File getTagMoveOnCompleteFolder() {
        if (this.tag_fl != null) {
            String str = this.readStringAttribute(AT_FL_MOVE_COMP, null);
            if (str == null) {
                return null;
            }
            return new File(str);
        }
        return null;
    }

    public void setTagMoveOnCompleteFolder(File folder) {
        if (this.tag_fl != null) {
            File existing = this.getTagMoveOnCompleteFolder();
            if (existing == null && folder == null) {
                return;
            }
            if (existing == null || folder == null || !existing.equals(folder)) {
                this.writeStringAttribute(AT_FL_MOVE_COMP, folder == null ? null : folder.getAbsolutePath());
                this.tag_type.fireChanged(this);
            }
        }
    }

    public boolean supportsTagCopyOnComplete() {
        return false;
    }

    public File getTagCopyOnCompleteFolder() {
        if (this.tag_fl != null) {
            String str = this.readStringAttribute(AT_FL_COPY_COMP, null);
            if (str == null) {
                return null;
            }
            return new File(str);
        }
        return null;
    }

    public void setTagCopyOnCompleteFolder(File folder) {
        if (this.tag_fl != null) {
            File existing = this.getTagCopyOnCompleteFolder();
            if (existing == null && folder == null) {
                return;
            }
            if (existing == null || folder == null || !existing.equals(folder)) {
                this.writeStringAttribute(AT_FL_COPY_COMP, folder == null ? null : folder.getAbsolutePath());
                this.tag_type.fireChanged(this);
            }
        }
    }

    public int getTagMinShareRatio() {
        return -1;
    }

    public void setTagMinShareRatio(int sr) {
        Debug.out("not supported");
    }

    public int getTagMaxShareRatio() {
        return -1;
    }

    public void setTagMaxShareRatio(int sr) {
        Debug.out("not supported");
    }

    public int getTagMaxShareRatioAction() {
        return -1;
    }

    public void setTagMaxShareRatioAction(int action) {
        Debug.out("not supported");
    }

    public int getTagAggregateShareRatio() {
        return -1;
    }

    public int getTagMaxAggregateShareRatio() {
        return -1;
    }

    public void setTagMaxAggregateShareRatio(int sr) {
        Debug.out("not supported");
    }

    public int getTagMaxAggregateShareRatioAction() {
        return -1;
    }

    public void setTagMaxAggregateShareRatioAction(int action) {
        Debug.out("not supported");
    }

    public boolean getTagMaxAggregateShareRatioHasPriority() {
        return true;
    }

    public void setTagMaxAggregateShareRatioHasPriority(boolean priority) {
        Debug.out("not supported");
    }

    public int getMaximumTaggables() {
        if (this.tag_limits != null) {
            return this.readLongAttribute(AT_MAX_TAGGABLES, 0L).intValue();
        }
        return -1;
    }

    public void setMaximumTaggables(int max) {
        if (this.tag_limits != null && this.getMaximumTaggables() != max) {
            this.writeLongAttribute(AT_MAX_TAGGABLES, max);
            this.tag_type.fireChanged(this);
            this.checkMaximumTaggables();
        }
    }

    protected void checkMaximumTaggables() {
    }

    public int getRemovalStrategy() {
        if (this.tag_limits != null) {
            return this.readLongAttribute(AT_REMOVAL_STRATEGY, 0L).intValue();
        }
        return -1;
    }

    public void setRemovalStrategy(int id) {
        if (this.tag_limits != null && this.getRemovalStrategy() != id) {
            this.writeLongAttribute(AT_REMOVAL_STRATEGY, id);
            this.tag_type.fireChanged(this);
        }
    }

    public TagFeatureProperties.TagProperty[] getSupportedProperties() {
        return new TagFeatureProperties.TagProperty[0];
    }

    public TagFeatureProperties.TagProperty getProperty(String name) {
        TagFeatureProperties.TagProperty[] props;
        TagFeatureProperties.TagProperty[] tagPropertyArray = props = this.getSupportedProperties();
        int n = props.length;
        int n2 = 0;
        while (n2 < n) {
            TagFeatureProperties.TagProperty prop = tagPropertyArray[n2];
            if (prop.getName(false) == name) {
                return prop;
            }
            ++n2;
        }
        return null;
    }

    protected TagFeatureProperties.TagProperty createTagProperty(String name, int type) {
        return new TagPropertyImpl(name, type);
    }

    public int getSupportedActions() {
        return 0;
    }

    public boolean supportsAction(int action) {
        return (this.getSupportedActions() & action) != 0;
    }

    public boolean isActionEnabled(int action) {
        if (!this.supportsAction(action)) {
            return false;
        }
        return this.readBooleanAttribute(AT_PROPERTY_PREFIX + action, false);
    }

    public void setActionEnabled(int action, boolean enabled) {
        if (!this.supportsAction(action)) {
            if (enabled) {
                Debug.out("not supported");
            }
            return;
        }
        this.writeBooleanAttribute(AT_PROPERTY_PREFIX + action, enabled);
    }

    public String getActionScript() {
        String script = this.readStringAttribute(AT_EOS_SCRIPT, "");
        if (script == null) {
            script = "";
        }
        return script;
    }

    public void setActionScript(String script) {
        if (script == null) {
            script = "";
        }
        script = script.trim();
        this.writeStringAttribute(AT_EOS_SCRIPT, script);
        this.setActionEnabled(32, script.length() > 0);
    }

    public int getPostingNotifications() {
        return this.readLongAttribute(AT_NOTIFICATION_POST, 0L).intValue();
    }

    public void setPostingNotifications(int flags) {
        this.writeLongAttribute(AT_NOTIFICATION_POST, flags);
    }

    @Override
    public void addTaggable(Taggable t) {
        this.t_listeners.dispatch(1, t);
        this.tag_type.taggableAdded(this, t);
        this.tag_type.fireChanged(this);
        if (this.tag_limits != null) {
            this.checkMaximumTaggables();
        }
    }

    @Override
    public void removeTaggable(Taggable t) {
        this.t_listeners.dispatch(2, t);
        this.tag_type.taggableRemoved(this, t);
        this.tag_type.fireChanged(this);
    }

    protected void sync() {
        this.t_listeners.dispatch(3, null);
        this.tag_type.taggableSync(this);
        this.savePersistentStuff();
    }

    protected void closing() {
        this.savePersistentStuff();
    }

    @Override
    public void removeTag() {
        boolean was_rss = this.isTagRSSFeedEnabled();
        this.tag_type.removeTag(this);
        if (was_rss) {
            this.tag_type.getTagManager().checkRSSFeeds(this, false);
        }
        this.saveTransientStuff();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String str) {
        String existing = this.getDescription();
        if (existing == str) {
            return;
        }
        if (str != null && existing != null && str.equals(existing)) {
            return;
        }
        this.description = str;
        this.writeStringAttribute(AT_DESCRIPTION, str);
        this.tag_type.fireChanged(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTransientProperty(String property, Object value) {
        TagBase tagBase = this;
        synchronized (tagBase) {
            if (this.transient_properties == null) {
                if (value == null) {
                    return;
                }
                this.transient_properties = new HashMap();
            }
            if (value == null) {
                this.transient_properties.remove(property);
            } else {
                this.transient_properties.put(property, value);
            }
            this.tag_type.fireChanged(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getTransientProperty(String property) {
        TagBase tagBase = this;
        synchronized (tagBase) {
            block4: {
                if (this.transient_properties != null) break block4;
                return null;
            }
            return this.transient_properties.get(property);
        }
    }

    @Override
    public void addTagListener(TagListener listener, boolean fire_for_existing) {
        if (!this.t_listeners.hasListener(listener)) {
            this.t_listeners.addListener(listener);
        }
        if (fire_for_existing) {
            for (Taggable t : this.getTagged()) {
                listener.taggableAdded(this, t);
            }
        }
    }

    protected void destroy() {
        Set<Taggable> taggables = this.getTagged();
        for (Taggable t : taggables) {
            this.t_listeners.dispatch(2, t);
            this.tag_type.taggableRemoved(this, t);
        }
    }

    @Override
    public void removeTagListener(TagListener listener) {
        this.t_listeners.removeListener(listener);
    }

    @Override
    public List<org.gudy.azureus2.plugins.tag.Taggable> getTaggables() {
        Set<Taggable> taggables = this.getTagged();
        ArrayList<org.gudy.azureus2.plugins.tag.Taggable> result = new ArrayList<org.gudy.azureus2.plugins.tag.Taggable>(taggables.size());
        for (Taggable t : taggables) {
            if (!(t instanceof DownloadManager)) continue;
            result.add(PluginCoreUtils.wrap((DownloadManager)t));
        }
        return result;
    }

    @Override
    public void requestAttention() {
        this.tag_type.requestAttention(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(final org.gudy.azureus2.plugins.tag.TagListener listener) {
        Map<org.gudy.azureus2.plugins.tag.TagListener, TagListener> map = this.listener_map;
        synchronized (map) {
            TagListener l = this.listener_map.get(listener);
            if (l != null) {
                Debug.out("listener already added");
                return;
            }
            l = new TagListener(){

                @Override
                public void taggableSync(Tag tag) {
                    listener.taggableSync(tag);
                }

                @Override
                public void taggableRemoved(Tag tag, Taggable tagged) {
                    listener.taggableRemoved(tag, tagged);
                }

                @Override
                public void taggableAdded(Tag tag, Taggable tagged) {
                    listener.taggableAdded(tag, tagged);
                }
            };
            this.listener_map.put(listener, l);
            this.addTagListener(l, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(org.gudy.azureus2.plugins.tag.TagListener listener) {
        Map<org.gudy.azureus2.plugins.tag.TagListener, TagListener> map = this.listener_map;
        synchronized (map) {
            TagListener l = this.listener_map.remove(listener);
            if (l == null) {
                Debug.out("listener not found");
                return;
            }
            this.removeTagListener(l);
        }
    }

    protected Boolean readBooleanAttribute(String attr, Boolean def) {
        return this.tag_type.readBooleanAttribute(this, attr, def);
    }

    protected boolean writeBooleanAttribute(String attr, Boolean value) {
        return this.tag_type.writeBooleanAttribute(this, attr, value);
    }

    protected Long readLongAttribute(String attr, Long def) {
        return this.tag_type.readLongAttribute(this, attr, def);
    }

    protected boolean writeLongAttribute(String attr, long value) {
        return this.tag_type.writeLongAttribute(this, attr, value);
    }

    protected String readStringAttribute(String attr, String def) {
        return this.tag_type.readStringAttribute(this, attr, def);
    }

    protected void writeStringAttribute(String attr, String value) {
        this.tag_type.writeStringAttribute(this, attr, value);
    }

    protected String[] readStringListAttribute(String attr, String[] def) {
        return this.tag_type.readStringListAttribute(this, attr, def);
    }

    protected boolean writeStringListAttribute(String attr, String[] value) {
        return this.tag_type.writeStringListAttribute(this, attr, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTransientStuff() {
        if (this.tag_rl != null && this.tag_rl.supportsTagRates()) {
            Map<Long, long[][]> map = session_cache;
            synchronized (map) {
                long[][] entry = session_cache.get(this.getTagUID());
                if (entry != null) {
                    this.total_up_at_start = entry[0];
                    this.total_down_at_start = entry[1];
                    this.session_up = entry[2];
                    this.session_down = entry[3];
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveTransientStuff() {
        if (this.tag_rl != null && this.tag_rl.supportsTagRates()) {
            long[] session_up = this.getTagSessionUploadTotalRaw();
            long[] session_down = this.getTagSessionDownloadTotalRaw();
            Map<Long, long[][]> map = session_cache;
            synchronized (map) {
                session_cache.put(this.getTagUID(), new long[][]{this.total_up_at_start, this.total_down_at_start, session_up, session_down});
            }
        }
    }

    private void loadPersistentStuff() {
        if (this.tag_rl != null && this.tag_rl.supportsTagRates()) {
            String[] downs;
            String[] ups = this.readStringListAttribute(AT_BYTES_UP, null);
            if (ups != null) {
                this.total_up_at_start = new long[ups.length];
                int i = 0;
                while (i < ups.length) {
                    try {
                        this.total_up_at_start[i] = Long.parseLong(ups[i]);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                    ++i;
                }
            }
            if ((downs = this.readStringListAttribute(AT_BYTES_DOWN, null)) != null) {
                this.total_down_at_start = new long[downs.length];
                int i = 0;
                while (i < downs.length) {
                    try {
                        this.total_down_at_start[i] = Long.parseLong(downs[i]);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                    ++i;
                }
            }
        }
    }

    private void savePersistentStuff() {
        if (this.tag_rl != null && this.tag_rl.supportsTagRates()) {
            long[] session_down;
            long[] session_up = this.getTagSessionUploadTotalRaw();
            if (session_up != null) {
                String[] ups = new String[session_up.length];
                int i = 0;
                while (i < ups.length) {
                    long l = session_up[i];
                    if (this.total_up_at_start != null && this.total_up_at_start.length > i) {
                        l += this.total_up_at_start[i];
                    }
                    ups[i] = String.valueOf(l);
                    ++i;
                }
                this.writeStringListAttribute(AT_BYTES_UP, ups);
            }
            if ((session_down = this.getTagSessionDownloadTotalRaw()) != null) {
                String[] downs = new String[session_down.length];
                int i = 0;
                while (i < downs.length) {
                    long l = session_down[i];
                    if (this.total_down_at_start != null && this.total_down_at_start.length > i) {
                        l += this.total_down_at_start[i];
                    }
                    downs[i] = String.valueOf(l);
                    ++i;
                }
                this.writeStringListAttribute(AT_BYTES_DOWN, downs);
            }
        }
    }

    public long[] getTagUploadTotal() {
        long[] result = this.getTagSessionUploadTotalRaw();
        if (result != null && this.total_up_at_start != null && this.total_up_at_start.length == result.length) {
            int i = 0;
            while (i < result.length) {
                int n = i;
                result[n] = result[n] + this.total_up_at_start[i];
                ++i;
            }
        }
        return result;
    }

    public long[] getTagSessionUploadTotal() {
        long[] result = this.getTagSessionUploadTotalRaw();
        if (result != null && this.session_up_reset != null && result.length == this.session_up_reset.length) {
            int i = 0;
            while (i < result.length) {
                int n = i;
                result[n] = result[n] - this.session_up_reset[i];
                ++i;
            }
        }
        return result;
    }

    public void resetTagSessionUploadTotal() {
        this.session_up_reset = this.getTagSessionUploadTotalRaw();
    }

    private long[] getTagSessionUploadTotalRaw() {
        if (this.tag_rl == null || !this.tag_rl.supportsTagRates()) {
            return null;
        }
        long[] result = this.getTagSessionUploadTotalCurrent();
        if (result != null && this.session_up != null) {
            if (result.length == this.session_up.length) {
                int i = 0;
                while (i < result.length) {
                    int n = i;
                    result[n] = result[n] + this.session_up[i];
                    ++i;
                }
            } else {
                Debug.out("derp");
            }
        }
        return result;
    }

    protected long[] getTagSessionUploadTotalCurrent() {
        return null;
    }

    public long[] getTagDownloadTotal() {
        long[] result = this.getTagSessionDownloadTotalRaw();
        if (result != null && this.total_down_at_start != null && this.total_down_at_start.length == result.length) {
            int i = 0;
            while (i < result.length) {
                int n = i;
                result[n] = result[n] + this.total_down_at_start[i];
                ++i;
            }
        }
        return result;
    }

    public long[] getTagSessionDownloadTotal() {
        long[] result = this.getTagSessionDownloadTotalRaw();
        if (result != null && this.session_down_reset != null && result.length == this.session_down_reset.length) {
            int i = 0;
            while (i < result.length) {
                int n = i;
                result[n] = result[n] - this.session_down_reset[i];
                ++i;
            }
        }
        return result;
    }

    public void resetTagSessionDownloadTotal() {
        this.session_down_reset = this.getTagSessionDownloadTotalRaw();
    }

    private long[] getTagSessionDownloadTotalRaw() {
        if (this.tag_rl == null || !this.tag_rl.supportsTagRates()) {
            return null;
        }
        long[] result = this.getTagSessionDownloadTotalCurrent();
        if (result != null && this.session_down != null) {
            if (result.length == this.session_down.length) {
                int i = 0;
                while (i < result.length) {
                    int n = i;
                    result[n] = result[n] + this.session_down[i];
                    ++i;
                }
            } else {
                Debug.out("derp");
            }
        }
        return result;
    }

    protected long[] getTagSessionDownloadTotalCurrent() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRecentHistoryRetention(boolean required) {
        if (this.tag_rl == null || !this.tag_rl.supportsTagRates()) {
            return;
        }
        TagBase tagBase = this;
        synchronized (tagBase) {
            if (required) {
                if (!this.history_retention_required) {
                    this.history = new long[1800];
                    this.history_pos = 0;
                    this.history_retention_required = true;
                    if (!this.timer_registered) {
                        SimpleTimer.addTickReceiver(this);
                        this.timer_registered = true;
                    }
                }
            } else {
                this.history = null;
                this.history_retention_required = false;
                if (this.timer_registered) {
                    SimpleTimer.removeTickReceiver(this);
                    this.timer_registered = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[][] getRecentHistory() {
        TagBase tagBase = this;
        synchronized (tagBase) {
            if (this.history == null) {
                return new int[2][0];
            }
            int entries = this.history_wrapped ? 1800 : this.history_pos;
            int start = this.history_wrapped ? this.history_pos : 0;
            int[][] result = new int[2][entries];
            int pos = start;
            int i = 0;
            while (i < entries) {
                if (pos == 1800) {
                    pos = 0;
                }
                long entry = this.history[pos++];
                int send_rate = (int)(entry >> 32 & 0xFFFFFFFFL);
                int recv_rate = (int)(entry & 0xFFFFFFFFL);
                result[0][i] = send_rate;
                result[1][i] = recv_rate;
                ++i;
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tick(long mono_now, int count) {
        if (!this.history_retention_required) {
            return;
        }
        long send_rate = this.tag_rl.getTagCurrentUploadRate();
        long receive_rate = this.tag_rl.getTagCurrentDownloadRate();
        long entry = send_rate << 32 & 0xFFFFFFFF00000000L | receive_rate & 0xFFFFFFFFL;
        TagBase tagBase = this;
        synchronized (tagBase) {
            if (this.history != null) {
                this.history[this.history_pos++] = entry;
                if (this.history_pos == 1800) {
                    this.history_pos = 0;
                    this.history_wrapped = true;
                }
            }
        }
    }

    public void generate(IndentWriter writer) {
        writer.println(this.tag_name);
        try {
            writer.indent();
            this.tag_type.generateConfig(writer, this);
        }
        finally {
            writer.exdent();
        }
    }

    private class TagPropertyImpl
    implements TagFeatureProperties.TagProperty {
        private final String name;
        private final int type;
        private final CopyOnWriteList<TagFeatureProperties.TagPropertyListener> listeners = new CopyOnWriteList();

        private TagPropertyImpl(String _name, int _type) {
            this.name = _name;
            this.type = _type;
        }

        @Override
        public Tag getTag() {
            return TagBase.this;
        }

        @Override
        public int getType() {
            return this.type;
        }

        @Override
        public String getName(boolean localize) {
            if (localize) {
                return MessageText.getString("tag.property." + this.name);
            }
            return this.name;
        }

        @Override
        public void setStringList(String[] value) {
            if (TagBase.this.writeStringListAttribute(TagBase.AT_PROPERTY_PREFIX + this.name, value)) {
                for (TagFeatureProperties.TagPropertyListener l : this.listeners) {
                    try {
                        l.propertyChanged(this);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
                TagBase.this.tag_type.fireChanged(TagBase.this);
            }
        }

        @Override
        public String[] getStringList() {
            return TagBase.this.readStringListAttribute(TagBase.AT_PROPERTY_PREFIX + this.name, EMPTY_STRING_LIST);
        }

        @Override
        public void setBoolean(Boolean value) {
            if (TagBase.this.writeBooleanAttribute(TagBase.AT_PROPERTY_PREFIX + this.name, value)) {
                for (TagFeatureProperties.TagPropertyListener l : this.listeners) {
                    try {
                        l.propertyChanged(this);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
                TagBase.this.tag_type.fireChanged(TagBase.this);
            }
        }

        @Override
        public Boolean getBoolean() {
            return TagBase.this.readBooleanAttribute(TagBase.AT_PROPERTY_PREFIX + this.name, null);
        }

        @Override
        public void setLong(Long value) {
            if (TagBase.this.writeLongAttribute(TagBase.AT_PROPERTY_PREFIX + this.name, value)) {
                for (TagFeatureProperties.TagPropertyListener l : this.listeners) {
                    try {
                        l.propertyChanged(this);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
                TagBase.this.tag_type.fireChanged(TagBase.this);
            }
        }

        @Override
        public Long getLong() {
            return TagBase.this.readLongAttribute(TagBase.AT_PROPERTY_PREFIX + this.name, null);
        }

        @Override
        public String getString() {
            String value = null;
            switch (this.getType()) {
                case 1: {
                    String[] vals = this.getStringList();
                    if (vals == null || vals.length <= 0) break;
                    value = "";
                    String name = this.getName(false);
                    if (name.equals("tracker_templates")) {
                        String str_merge = MessageText.getString("label.merge");
                        String str_replace = MessageText.getString("label.replace");
                        String str_remove = MessageText.getString("Button.remove");
                        String[] stringArray = vals;
                        int n = vals.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String val = stringArray[n2];
                            String[] bits = val.split(":");
                            String type = bits[0];
                            String str = bits[1];
                            str = type.equals("m") ? String.valueOf(str) + ": " + str_merge : (type.equals("r") ? String.valueOf(str) + ": " + str_replace : String.valueOf(str) + ": " + str_remove);
                            value = String.valueOf(value) + (value.length() == 0 ? "" : ",") + str;
                            ++n2;
                        }
                    } else {
                        if (name.equals("constraint")) {
                            boolean auto_remove;
                            value = String.valueOf(value) + vals[0];
                            if (vals.length <= 1) break;
                            String options = vals[1];
                            boolean auto_add = !options.contains("am=2;");
                            boolean bl = auto_remove = !options.contains("am=1;");
                            if (auto_add && auto_remove || !auto_add && !auto_remove) break;
                            value = String.valueOf(value) + "," + MessageText.getString("label.scope");
                            value = String.valueOf(value) + "=";
                            if (auto_add) {
                                value = String.valueOf(value) + MessageText.getString("label.addition.only");
                                break;
                            }
                            value = String.valueOf(value) + MessageText.getString("label.removal.only");
                            break;
                        }
                        String[] stringArray = vals;
                        int n = vals.length;
                        int n3 = 0;
                        while (n3 < n) {
                            String val = stringArray[n3];
                            value = String.valueOf(value) + (value.length() == 0 ? "" : ",") + val;
                            ++n3;
                        }
                    }
                    break;
                }
                case 2: {
                    Boolean val = this.getBoolean();
                    if (val == null) break;
                    value = String.valueOf(val);
                    break;
                }
                case 3: {
                    Long val = this.getLong();
                    if (val == null) break;
                    value = String.valueOf(val);
                    break;
                }
                default: {
                    value = "Unknown type";
                }
            }
            if (value == null) {
                return "";
            }
            return String.valueOf(this.getName(true)) + "=" + value;
        }

        @Override
        public void addListener(TagFeatureProperties.TagPropertyListener listener) {
            this.listeners.add(listener);
        }

        @Override
        public void removeListener(TagFeatureProperties.TagPropertyListener listener) {
            this.listeners.remove(listener);
        }

        @Override
        public void syncListeners() {
            for (TagFeatureProperties.TagPropertyListener l : this.listeners) {
                try {
                    l.propertySync(this);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        }
    }
}

