/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.tag.impl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.tag.Tag;
import com.aelitis.azureus.core.tag.TagFeatureProperties;
import com.aelitis.azureus.core.tag.TagListener;
import com.aelitis.azureus.core.tag.TagType;
import com.aelitis.azureus.core.tag.TagTypeAdapter;
import com.aelitis.azureus.core.tag.Taggable;
import com.aelitis.azureus.core.tag.TaggableLifecycleAdapter;
import com.aelitis.azureus.core.tag.impl.TagManagerImpl;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.core3.util.TrackersUtil;

public class TagPropertyTrackerTemplateHandler
implements TagFeatureProperties.TagPropertyListener,
TagListener {
    final TagManagerImpl tag_manager;

    protected TagPropertyTrackerTemplateHandler(AzureusCore _core, TagManagerImpl _tm) {
        this.tag_manager = _tm;
        this.tag_manager.addTaggableLifecycleListener(2L, new TaggableLifecycleAdapter(){

            @Override
            public void initialised(List<Taggable> current_taggables) {
                TagType tt = TagPropertyTrackerTemplateHandler.this.tag_manager.getTagType(3);
                tt.addTagTypeListener(new TagTypeAdapter(){

                    @Override
                    public void tagAdded(Tag tag) {
                        TagFeatureProperties tfp = (TagFeatureProperties)((Object)tag);
                        TagFeatureProperties.TagProperty prop = tfp.getProperty("tracker_templates");
                        if (prop != null) {
                            prop.addListener(TagPropertyTrackerTemplateHandler.this);
                            tag.addTagListener(TagPropertyTrackerTemplateHandler.this, false);
                        }
                    }
                }, true);
            }
        });
    }

    private String[] getPropertyBits(TagFeatureProperties.TagProperty prop) {
        String[] bits = prop.getStringList();
        if (bits == null || bits.length == 0) {
            return null;
        }
        return bits;
    }

    private void handleStuff(String[] bits, Set<Taggable> taggables) {
        Map<String, List<List<String>>> templates = TrackersUtil.getInstance().getMultiTrackers();
        String[] stringArray = bits;
        int n = bits.length;
        int n2 = 0;
        while (n2 < n) {
            String bit = stringArray[n2];
            String[] temp = bit.split(":");
            String t_name = temp[1];
            List<List<String>> template_trackers = templates.get(t_name);
            if (template_trackers == null) {
                Debug.out("Tracker template '" + t_name + "' not found");
            } else {
                String type = temp[0];
                for (Taggable t : taggables) {
                    DownloadManager dm = (DownloadManager)t;
                    TOTorrent torrent = dm.getTorrent();
                    if (torrent == null) continue;
                    List<List<String>> trackers = TorrentUtils.announceGroupsToList(torrent);
                    trackers = type.equals("m") ? TorrentUtils.mergeAnnounceURLs(trackers, template_trackers) : (type.equals("r") ? template_trackers : TorrentUtils.removeAnnounceURLs(trackers, template_trackers, true));
                    TorrentUtils.listToAnnounceGroups(trackers, torrent);
                }
            }
            ++n2;
        }
    }

    @Override
    public void propertyChanged(TagFeatureProperties.TagProperty property) {
        String[] bits = this.getPropertyBits(property);
        if (bits == null) {
            return;
        }
        this.handleStuff(bits, property.getTag().getTagged());
    }

    @Override
    public void propertySync(TagFeatureProperties.TagProperty property) {
        this.propertyChanged(property);
    }

    @Override
    public void taggableAdded(Tag tag, Taggable tagged) {
        TagFeatureProperties tfp = (TagFeatureProperties)((Object)tag);
        TagFeatureProperties.TagProperty prop = tfp.getProperty("tracker_templates");
        if (prop != null) {
            String[] bits = this.getPropertyBits(prop);
            if (bits == null) {
                return;
            }
            HashSet<Taggable> taggables = new HashSet<Taggable>();
            taggables.add(tagged);
            this.handleStuff(bits, taggables);
        }
    }

    @Override
    public void taggableSync(Tag tag) {
    }

    @Override
    public void taggableRemoved(Tag tag, Taggable tagged) {
    }
}

