/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.tag.impl;

import com.aelitis.azureus.core.tag.Tag;
import com.aelitis.azureus.core.tag.TagException;
import com.aelitis.azureus.core.tag.TagFeatureNotifications;
import com.aelitis.azureus.core.tag.TagManagerFactory;
import com.aelitis.azureus.core.tag.TagType;
import com.aelitis.azureus.core.tag.Taggable;
import com.aelitis.azureus.core.tag.TaggableResolver;
import com.aelitis.azureus.core.tag.impl.TagBase;
import com.aelitis.azureus.core.tag.impl.TagTypeBase;
import com.aelitis.azureus.core.tag.impl.TagTypeWithState;
import com.aelitis.azureus.core.util.AZ3Functions;
import com.aelitis.azureus.core.util.CopyOnWriteSet;
import com.aelitis.azureus.util.MapUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

public abstract class TagWithState
extends TagBase {
    private final CopyOnWriteSet<Taggable> objects = new CopyOnWriteSet(true);
    private TagFeatureNotifications tag_notifications;
    private boolean removed;

    public TagWithState(TagTypeBase tt, int tag_id, String name) {
        super(tt, tag_id, name);
        if (tt.hasTagTypeFeature(256L)) {
            this.tag_notifications = (TagFeatureNotifications)((Object)this);
        }
    }

    protected TagWithState(TagTypeBase tt, int tag_id, Map map) {
        super(tt, tag_id, MapUtils.getMapString(map, "n", ""));
        List list;
        if (tt.hasTagTypeFeature(256L)) {
            this.tag_notifications = (TagFeatureNotifications)((Object)this);
        }
        if (map != null && (list = (List)map.get("o")) != null) {
            for (byte[] b : list) {
                try {
                    String id = new String(b, "UTF-8");
                    Taggable taggable = tt.resolveTaggable(id);
                    if (taggable == null) continue;
                    this.objects.add(taggable);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        }
    }

    protected void exportDetails(Map map, boolean do_contents) {
        MapUtils.setMapString(map, "n", this.getTagNameRaw());
        if (do_contents) {
            Iterator<Taggable> it = this.objects.iterator();
            ArrayList<byte[]> l = new ArrayList<byte[]>(this.objects.size());
            while (it.hasNext()) {
                try {
                    Taggable taggable = it.next();
                    String id = taggable.getTaggableID();
                    if (id == null) continue;
                    l.add(id.getBytes("UTF-8"));
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
            map.put("o", l);
        }
    }

    @Override
    public void setTagName(String name) throws TagException {
        super.setTagName(name);
        this.getManager().tagChanged(this);
    }

    @Override
    public void addTaggable(Taggable t) {
        if (this.removed) {
            Debug.out("Tag has been removed");
            return;
        }
        boolean added = this.objects.add(t);
        super.addTaggable(t);
        if (added) {
            this.getManager().tagContentsChanged(this);
            if (this.tag_notifications != null) {
                this.checkNotifications(t, true);
            }
        }
    }

    @Override
    public void removeTaggable(Taggable t) {
        boolean removed = this.objects.remove(t);
        super.removeTaggable(t);
        if (removed) {
            this.getManager().tagContentsChanged(this);
            if (this.tag_notifications != null) {
                this.checkNotifications(t, false);
            }
        }
    }

    protected void checkNotifications(Taggable taggable, boolean is_add) {
        int flags = this.getPostingNotifications();
        if (flags != 0) {
            AZ3Functions.provider provider2;
            boolean rem;
            boolean add = (flags & 1) != 0;
            boolean bl = rem = (flags & 2) != 0;
            if ((add == is_add || rem == !is_add) && (provider2 = AZ3Functions.getProvider()) != null) {
                TaggableResolver resolver = taggable.getTaggableResolver();
                String name = resolver != null ? resolver.getDisplayName(taggable) : taggable.toString();
                name = MessageText.getString(is_add ? "tag.notification.added" : "tag.notification.removed", new String[]{name, this.getTagName(true)});
                HashMap<String, String> cb_data = new HashMap<String, String>();
                cb_data.put("allowReAdd", "true");
                cb_data.put("taguid", String.valueOf(this.getTagUID()));
                cb_data.put("id", String.valueOf(taggable.getTaggableID()));
                String icon_id = "image.sidebar.tag-green";
                int[] color = this.getColor();
                if (color != null && color.length == 3) {
                    long rgb = color[0] << 16 | color[1] << 8 | color[2];
                    String hex = Long.toHexString(rgb);
                    while (hex.length() < 6) {
                        hex = "0" + hex;
                    }
                    icon_id = String.valueOf(icon_id) + "#" + hex;
                }
                provider2.addLocalActivity(String.valueOf(this.getTagUID()) + ":" + taggable.getTaggableID() + ":" + is_add, icon_id, name, new String[]{MessageText.getString("label.view")}, ActivityCallback.class, cb_data);
            }
        }
    }

    @Override
    public void removeTag() {
        super.removeTag();
        this.removed = true;
    }

    protected boolean isRemoved() {
        return this.removed;
    }

    @Override
    public int getTaggedCount() {
        return this.objects.size();
    }

    @Override
    public boolean hasTaggable(Taggable t) {
        return this.objects.contains(t);
    }

    @Override
    public Set<Taggable> getTagged() {
        return this.objects.getSet();
    }

    public static class ActivityCallback
    implements AZ3Functions.provider.LocalActivityCallback {
        @Override
        public void actionSelected(String action, Map<String, String> data) {
            String taguid = data.get("taguid");
            final String id = data.get("id");
            if (taguid != null && id != null) {
                try {
                    TaggableResolver resolver;
                    TagType tt;
                    Tag tag = TagManagerFactory.getTagManager().lookupTagByUID(Long.parseLong(taguid));
                    if (tag != null && (tt = tag.getTagType()) instanceof TagTypeWithState && (resolver = ((TagTypeWithState)tt).getResolver()) != null) {
                        if (!tag.isVisible()) {
                            tag.setVisible(true);
                        }
                        tag.requestAttention();
                        SimpleTimer.addEvent("async", SystemTime.getOffsetTime(500L), new TimerEventPerformer(){

                            @Override
                            public void perform(TimerEvent event2) {
                                resolver.requestAttention(id);
                            }
                        });
                    }
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        }
    }
}

