/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class MultiPartDecoder {
    public FormField[] decode(String boundary, InputStream is) throws IOException {
        int buffer_pos_start;
        int len;
        byte[] header_end_bytes = "\r\n\r\n".getBytes("ISO-8859-1");
        byte[] boundary_bytes = ("\r\n--" + boundary).getBytes("ISO-8859-1");
        int boundary_len = boundary_bytes.length;
        byte[] buffer = new byte[65536];
        int buffer_pos = 0;
        boolean in_header = true;
        byte[] current_target = header_end_bytes;
        int current_target_length = 4;
        FormField current_field = null;
        ArrayList<FormField> fields = new ArrayList<FormField>();
        do {
            int rem;
            buffer_pos_start = buffer_pos;
            len = is.read(buffer, buffer_pos, buffer.length - buffer_pos);
            if (len < 0) {
                len = 0;
            }
            buffer_pos += len;
            boolean found_target = false;
            int i = 0;
            while (i <= buffer_pos - current_target_length) {
                if (buffer[i] == current_target[0]) {
                    found_target = true;
                    int j = 1;
                    while (j < current_target_length) {
                        if (buffer[i + j] != current_target[j]) {
                            found_target = false;
                            break;
                        }
                        ++j;
                    }
                    if (found_target) {
                        if (in_header) {
                            int p1;
                            String header;
                            int cdl_pos;
                            if (current_field != null) {
                                current_field.complete();
                            }
                            if ((cdl_pos = (header = new String(buffer, 0, i + 4)).toLowerCase().indexOf("content-disposition")) == -1) {
                                throw new IOException("invalid header '" + header + "'");
                            }
                            int cd_nl = header.indexOf("\r\n", cdl_pos);
                            String cd_line = header.substring(cdl_pos, cd_nl);
                            int cd_pos = 0;
                            HashMap<String, String> attributes = new HashMap<String, String>();
                            do {
                                String bit;
                                if ((p1 = cd_line.indexOf(";", cd_pos)) == -1) {
                                    bit = cd_line.substring(cd_pos);
                                } else {
                                    bit = cd_line.substring(cd_pos, p1);
                                    cd_pos = p1 + 1;
                                }
                                int ep = bit.indexOf("=");
                                if (ep == -1) continue;
                                String lhs = bit.substring(0, ep).trim();
                                String rhs = bit.substring(ep + 1).trim();
                                if (rhs.startsWith("\"")) {
                                    rhs = rhs.substring(1);
                                }
                                if (rhs.endsWith("\"")) {
                                    rhs = rhs.substring(0, rhs.length() - 1);
                                }
                                attributes.put(lhs.toLowerCase(), rhs);
                            } while (p1 != -1);
                            String field_name = (String)attributes.get("name");
                            if (field_name == null) {
                                throw new IOException(String.valueOf(cd_line) + " missing 'name' attribute");
                            }
                            current_field = new FormField(field_name, attributes);
                            fields.add(current_field);
                        } else {
                            current_field.write(buffer, 0, i);
                        }
                        int rem2 = buffer_pos - (i + current_target_length);
                        if (rem2 > 0) {
                            System.arraycopy(buffer, i + current_target_length, buffer, 0, rem2);
                        }
                        buffer_pos = rem2;
                        if (in_header) {
                            in_header = false;
                            current_target = boundary_bytes;
                            current_target_length = boundary_len;
                            break;
                        }
                        in_header = true;
                        current_target = header_end_bytes;
                        current_target_length = 4;
                        break;
                    }
                }
                ++i;
            }
            if (found_target || in_header || (rem = buffer_pos - current_target_length) <= 0) continue;
            current_field.write(buffer, 0, rem);
            System.arraycopy(buffer, rem, buffer, 0, current_target_length);
            buffer_pos = current_target_length;
        } while (len != 0 || buffer_pos != buffer_pos_start);
        if (buffer_pos < 2 || buffer[0] != 45 || buffer[1] != 45) {
            throw new IOException("Incorrect termination of form upload data");
        }
        if (current_field != null) {
            current_field.complete();
        }
        FormField[] res = new FormField[fields.size()];
        fields.toArray(res);
        return res;
    }

    public static class FormField {
        protected final String name;
        protected final Map attributes;
        protected long total_len;
        final ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        File file;
        FileOutputStream fos;
        InputStream returned_stream;

        protected FormField(String _name, Map _attributes) {
            this.name = _name;
            this.attributes = _attributes;
        }

        public String getName() {
            return this.name;
        }

        public String getAttribute(String attr_name) {
            return (String)this.attributes.get(attr_name.toLowerCase());
        }

        public InputStream getInputStream() throws IOException {
            this.returned_stream = this.file == null ? new ByteArrayInputStream(this.baos.toByteArray()) : new FileInputStream(this.file);
            return this.returned_stream;
        }

        public String getString() throws IOException {
            String str = new LineNumberReader(new InputStreamReader(this.getInputStream())).readLine();
            if (str == null) {
                str = "";
            }
            return str;
        }

        public void destroy() {
            if (this.returned_stream != null) {
                try {
                    this.returned_stream.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (this.file != null) {
                this.file.delete();
            }
        }

        protected void write(byte[] buffer, int start, int len) throws IOException {
            this.total_len += (long)len;
            if (this.fos != null) {
                this.fos.write(buffer, start, len);
            } else if (this.total_len > 1024L) {
                this.file = File.createTempFile("AZU", null);
                this.file.deleteOnExit();
                this.fos = new FileOutputStream(this.file);
                this.fos.write(this.baos.toByteArray());
                this.fos.write(buffer, start, len);
            } else {
                this.baos.write(buffer, start, len);
            }
        }

        protected void complete() throws IOException {
            if (this.fos != null) {
                this.fos.close();
            }
        }
    }
}

