/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.util.loopcontrol.impl;

import com.aelitis.azureus.core.util.loopcontrol.LoopControler;

public class PIDLoopControler
implements LoopControler {
    final double pGain;
    final double iGain;
    final double dGain;
    double iState;
    static final double iMin = -5000.0;
    static final double iMax = 5000.0;
    double dState;

    public PIDLoopControler(double pGain, double iGain, double dGain) {
        this.pGain = pGain;
        this.iGain = iGain;
        this.dGain = dGain;
    }

    @Override
    public double updateControler(double error, double position) {
        double pTerm = this.pGain * error;
        this.iState += error;
        if (this.iState > 5000.0) {
            this.iState = 5000.0;
        }
        if (this.iState < -5000.0) {
            this.iState = -5000.0;
        }
        double iTerm = this.iGain * this.iState;
        double d = this.dState - position;
        double dTerm = this.dGain * d;
        this.dState = position;
        double result = pTerm + iTerm - dTerm;
        System.out.println("PID p,i,d (" + this.pGain + "," + this.iGain + "," + this.dGain + ") : is,ds (" + this.iState + "," + d + ") p,i,d (" + pTerm + "," + iTerm + "," + dTerm + ") => " + result);
        return result;
    }

    @Override
    public void reset() {
        this.dState = 0.0;
        this.iState = 0.0;
    }
}

