/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.xmwebui;

import com.aelitis.azureus.core.metasearch.Engine;
import com.aelitis.azureus.core.metasearch.Result;
import com.aelitis.azureus.core.metasearch.ResultListener;
import com.aelitis.azureus.plugins.xmwebui.XMWebUIPlugin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.SystemTime;

class SearchInstance
implements ResultListener {
    private final XMWebUIPlugin xmWebUIPlugin;
    private String sid;
    private long start_time = SystemTime.getMonotonousTime();
    private long last_got_results_on = -1L;
    private boolean all_searches_complete = false;
    private Map<String, List> engine_results = new HashMap<String, List>();

    SearchInstance(XMWebUIPlugin xmWebUIPlugin, Engine[] engines) {
        this.xmWebUIPlugin = xmWebUIPlugin;
        byte[] bytes = new byte[16];
        RandomUtils.nextSecureBytes(bytes);
        this.sid = Base32.encode(bytes);
        Engine[] engineArray = engines;
        int n = engines.length;
        int n2 = 0;
        while (n2 < n) {
            Engine e = engineArray[n2];
            this.engine_results.put(e.getUID(), new ArrayList());
            ++n2;
        }
    }

    String getSID() {
        return this.sid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setEngines(Engine[] engines) {
        HashSet<String> active_engines = new HashSet<String>();
        Engine[] engineArray = engines;
        int n = engines.length;
        int n2 = 0;
        while (n2 < n) {
            Engine e = engineArray[n2];
            active_engines.add(e.getUID());
            ++n2;
        }
        SearchInstance searchInstance = this;
        synchronized (searchInstance) {
            Iterator<String> it = this.engine_results.keySet().iterator();
            while (it.hasNext()) {
                if (active_engines.contains(it.next())) continue;
                it.remove();
            }
        }
    }

    long getLastResultsAgo() {
        return this.last_got_results_on > 0L ? SystemTime.getMonotonousTime() - this.last_got_results_on : -1L;
    }

    boolean isComplete() {
        return this.all_searches_complete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean getResults(Map result) {
        this.last_got_results_on = SystemTime.getMonotonousTime();
        result.put("sid", this.sid);
        ArrayList engines = new ArrayList();
        result.put("engines", engines);
        SearchInstance searchInstance = this;
        synchronized (searchInstance) {
            boolean all_complete = true;
            for (Map.Entry<String, List> entry : this.engine_results.entrySet()) {
                HashMap<String, Object> m = new HashMap<String, Object>();
                engines.add(m);
                m.put("id", entry.getKey());
                List results = entry.getValue();
                Iterator it = results.iterator();
                boolean engine_complete = false;
                while (it.hasNext()) {
                    Object obj = it.next();
                    if (obj instanceof Boolean) {
                        engine_complete = true;
                        break;
                    }
                    if (obj instanceof Throwable) {
                        m.put("error", Debug.getNestedExceptionMessage((Throwable)obj));
                        continue;
                    }
                    it.remove();
                    Result[] sr = (Result[])obj;
                    ArrayList<Map> l_sr = (ArrayList<Map>)m.get("results");
                    if (l_sr == null) {
                        l_sr = new ArrayList<Map>();
                        m.put("results", l_sr);
                    }
                    Result[] resultArray = sr;
                    int n = sr.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Result r = resultArray[n2];
                        l_sr.add(r.toJSONMap());
                        ++n2;
                    }
                }
                if (!engine_complete && this.all_searches_complete) {
                    engine_complete = true;
                    if (!m.containsKey("error")) {
                        m.put("error", "Timeout");
                    }
                }
                m.put("complete", engine_complete);
                if (engine_complete) continue;
                all_complete = false;
            }
            this.all_searches_complete = all_complete;
            result.put("complete", all_complete);
            return all_complete;
        }
    }

    long getAge() {
        return SystemTime.getMonotonousTime() - this.start_time;
    }

    @Override
    public void contentReceived(Engine engine, String content2) {
    }

    @Override
    public void matchFound(Engine engine, String[] fields) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resultsReceived(Engine engine, Result[] results) {
        if (this.xmWebUIPlugin.trace_param.getValue()) {
            this.xmWebUIPlugin.log("results: " + engine.getName() + " - " + results.length);
        }
        SearchInstance searchInstance = this;
        synchronized (searchInstance) {
            List list = this.engine_results.get(engine.getUID());
            if (!(list == null || list.size() > 0 && list.get(list.size() - 1) instanceof Boolean)) {
                list.add(results);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resultsComplete(Engine engine) {
        if (this.xmWebUIPlugin.trace_param.getValue()) {
            this.xmWebUIPlugin.log("comp: " + engine.getName());
        }
        SearchInstance searchInstance = this;
        synchronized (searchInstance) {
            List list = this.engine_results.get(engine.getUID());
            if (!(list == null || list.size() > 0 && list.get(list.size() - 1) instanceof Boolean)) {
                list.add(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineFailed(Engine engine, Throwable cause) {
        if (this.xmWebUIPlugin.trace_param.getValue()) {
            this.xmWebUIPlugin.log("fail: " + engine.getName());
        }
        SearchInstance searchInstance = this;
        synchronized (searchInstance) {
            List list = this.engine_results.get(engine.getUID());
            if (!(list == null || list.size() > 0 && list.get(list.size() - 1) instanceof Boolean)) {
                list.add(cause);
                list.add(true);
            }
        }
    }

    @Override
    public void engineRequiresLogin(Engine engine, Throwable cause) {
        this.engineFailed(engine, cause);
    }

    String getString() {
        return this.sid;
    }

    public void failWithTimeout() {
        this.all_searches_complete = true;
    }
}

