/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.net.natpmp.upnp.impl;

import com.aelitis.net.natpmp.NatPMPDevice;
import com.aelitis.net.natpmp.upnp.NatPMPUPnP;
import com.aelitis.net.natpmp.upnp.impl.NatPMPUPnPRootDeviceImpl;
import com.aelitis.net.upnp.UPnP;
import com.aelitis.net.upnp.UPnPListener;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

public class NatPMPUPnPImpl
implements NatPMPUPnP {
    private UPnP upnp;
    private NatPMPDevice nat_device;
    private NatPMPUPnPRootDeviceImpl root_device;
    private List listeners = new ArrayList();
    private boolean enabled = true;
    private boolean started;

    public NatPMPUPnPImpl(UPnP _upnp, NatPMPDevice _nat_device) {
        this.upnp = _upnp;
        this.nat_device = _nat_device;
    }

    protected void start() {
        SimpleTimer.addPeriodicEvent("NATPMP:search", 60000L, new TimerEventPerformer(){

            @Override
            public void perform(TimerEvent event2) {
                NatPMPUPnPImpl.this.search();
            }
        });
        this.search();
    }

    @Override
    public void setEnabled(boolean _enabled) {
        this.enabled = _enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    protected void search() {
        block7: {
            if (!this.enabled) {
                return;
            }
            if (this.root_device != null) {
                return;
            }
            try {
                boolean found = this.nat_device.connect();
                if (!found) break block7;
                this.root_device = new NatPMPUPnPRootDeviceImpl(this.upnp, this.nat_device);
                int i = 0;
                while (i < this.listeners.size()) {
                    try {
                        ((UPnPListener)this.listeners.get(i)).rootDeviceFound(this.root_device);
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                    ++i;
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    @Override
    public synchronized void addListener(UPnPListener listener) {
        this.listeners.add(listener);
        if (this.root_device == null) {
            if (this.listeners.size() == 1 && !this.started) {
                this.started = true;
                this.start();
            }
        } else {
            listener.rootDeviceFound(this.root_device);
        }
    }

    @Override
    public synchronized void removeListener(UPnPListener listener) {
        this.listeners.remove(listener);
    }
}

