/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.plugins.rcmplugin;

import com.aelitis.azureus.core.content.RelatedContent;
import com.aelitis.azureus.core.content.RelatedContentManager;
import com.aelitis.net.magneturi.MagnetURIHandler;
import com.aelitis.plugins.rcmplugin.RCMPlugin;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.ByteArrayHashMap;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.utils.search.SearchException;
import org.gudy.azureus2.plugins.utils.search.SearchInstance;
import org.gudy.azureus2.plugins.utils.search.SearchObserver;
import org.gudy.azureus2.plugins.utils.search.SearchProvider;
import org.gudy.azureus2.plugins.utils.search.SearchResult;

public class RCM_SearchProvider
implements SearchProvider {
    private RCMPlugin plugin;
    private Map<Integer, Object> properties = new HashMap<Integer, Object>();

    protected RCM_SearchProvider(RCMPlugin _plugin) {
        this.plugin = _plugin;
        this.properties.put(1, MessageText.getString("rcm.search.provider"));
        try {
            URL url = MagnetURIHandler.getSingleton().registerResource(new MagnetURIHandler.ResourceProvider(){

                @Override
                public String getUID() {
                    return String.valueOf(RelatedContentManager.class.getName()) + ".1";
                }

                @Override
                public String getFileType() {
                    return "png";
                }

                @Override
                public byte[] getData() {
                    InputStream is = this.getClass().getClassLoader().getResourceAsStream("com/aelitis/plugins/rcmplugin/resources/rcm.png");
                    if (is == null) {
                        return null;
                    }
                    try {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        try {
                            int len;
                            byte[] buffer = new byte[8192];
                            while ((len = is.read(buffer)) > 0) {
                                baos.write(buffer, 0, len);
                            }
                        }
                        finally {
                            is.close();
                        }
                        return baos.toByteArray();
                    }
                    catch (Throwable e) {
                        return null;
                    }
                }
            });
            this.properties.put(2, url.toExternalForm());
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    @Override
    public SearchInstance search(Map<String, Object> search_parameters, SearchObserver observer) throws SearchException {
        try {
            RelatedContentManager manager = RelatedContentManager.getSingleton();
            return manager.searchRCM(search_parameters, new SearchObserverFilter(manager, search_parameters, observer));
        }
        catch (Throwable e) {
            throw new SearchException("Search failed", e);
        }
    }

    @Override
    public Object getProperty(int property) {
        return this.properties.get(property);
    }

    @Override
    public void setProperty(int property, Object value) {
        this.properties.put(property, value);
    }

    private class SearchObserverFilter
    implements SearchObserver {
        private RelatedContentManager manager;
        private ByteArrayHashMap<RelatedContent> hash_map;
        final boolean is_popularity;
        private SearchObserver observer;
        private int min_rank;

        private SearchObserverFilter(RelatedContentManager _manager, Map<String, Object> _search_parameters, SearchObserver _observer) {
            this.min_rank = RCM_SearchProvider.this.plugin.getMinuumSearchRank();
            this.manager = _manager;
            this.observer = _observer;
            String expression = (String)_search_parameters.get("s");
            this.is_popularity = expression.equals("(.)");
            if (this.min_rank > 0) {
                RelatedContent[] rc;
                this.hash_map = new ByteArrayHashMap();
                RelatedContent[] relatedContentArray = rc = this.manager.getRelatedContent();
                int n = rc.length;
                int n2 = 0;
                while (n2 < n) {
                    RelatedContent r = relatedContentArray[n2];
                    byte[] hash = r.getHash();
                    if (hash != null) {
                        this.hash_map.put(hash, r);
                    }
                    ++n2;
                }
            }
        }

        @Override
        public void resultReceived(SearchInstance search, SearchResult result) {
            Long version;
            if (this.is_popularity && (version = (Long)result.getProperty(22)) != null && version < 1L) {
                return;
            }
            if (this.hash_map == null) {
                long cnet = (Long)result.getProperty(50000);
                if (!RCM_SearchProvider.this.plugin.isVisible(cnet)) {
                    byte[] tracker_keys = (byte[])result.getProperty(50001);
                    if (!RCM_SearchProvider.this.plugin.isVisible(tracker_keys)) {
                        byte[] ws_keys = (byte[])result.getProperty(50002);
                        if (!RCM_SearchProvider.this.plugin.isVisible(ws_keys)) {
                            return;
                        }
                    }
                }
                this.observer.resultReceived(search, result);
            } else {
                RelatedContent rc;
                byte[] hash = (byte[])result.getProperty(21);
                if (hash != null && (rc = this.hash_map.get(hash)).getRank() >= this.min_rank) {
                    this.observer.resultReceived(search, result);
                }
            }
        }

        @Override
        public void complete() {
            this.observer.complete();
        }

        @Override
        public void cancelled() {
            this.observer.cancelled();
        }

        @Override
        public Object getProperty(int property) {
            return this.observer.getProperty(property);
        }
    }
}

