/*
 * Decompiled with CFR 0.152.
 */
package lbms.plugins.mldht.kad;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Comparator;
import lbms.plugins.mldht.kad.utils.ThreadLocalUtils;

public class Key
implements Comparable<Key>,
Serializable {
    public static final Key MIN_KEY = new Key();
    public static final Key MAX_KEY = new Key();
    private static final long serialVersionUID = -1180893806923345652L;
    public static final int SHA1_HASH_LENGTH = 20;
    public static final int KEY_BITS = 160;
    protected byte[] hash = new byte[20];

    static {
        Arrays.fill(Key.MAX_KEY.hash, (byte)-1);
    }

    protected Key() {
    }

    public Key(Key k) {
        System.arraycopy(k.hash, 0, this.hash, 0, 20);
    }

    public Key(String hex) {
        if (hex.length() != 40) {
            throw new IllegalArgumentException("Hex String must have 40 bytes");
        }
        int i = 0;
        while (i < hex.length()) {
            this.hash[i / 2] = (byte)((Character.digit(hex.charAt(i), 16) << 4) + Character.digit(hex.charAt(i + 1), 16));
            i += 2;
        }
    }

    public Key(byte[] hash) {
        if (hash.length != 20) {
            throw new IllegalArgumentException("Invalid Hash must be 20bytes, was: " + hash.length);
        }
        System.arraycopy(hash, 0, this.hash, 0, 20);
    }

    @Override
    public int compareTo(Key o) {
        int i = 0;
        int n = this.hash.length;
        while (i < n) {
            int byte1 = this.hash[i] & 0xFF;
            int byte2 = o.hash[i] & 0xFF;
            if (byte1 != byte2) {
                if (byte1 < byte2) {
                    return -1;
                }
                return 1;
            }
            ++i;
        }
        return 0;
    }

    public int threeWayDistance(Key k1, Key k2) {
        int i = 0;
        int n = this.hash.length;
        while (i < n) {
            if (k1.hash[i] != k2.hash[i]) {
                int byte1 = (k1.hash[i] ^ this.hash[i]) & 0xFF;
                int byte2 = (k2.hash[i] ^ this.hash[i]) & 0xFF;
                if (byte1 < byte2) {
                    return -1;
                }
                return 1;
            }
            ++i;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Key) {
            Key otherKey = (Key)o;
            int i = 0;
            int n = this.hash.length;
            while (i < n) {
                if (this.hash[i] != otherKey.hash[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public byte[] getHash() {
        return (byte[])this.hash.clone();
    }

    public Key getDerivedKey(int idx) {
        Key k = new Key(this);
        byte[] data = k.hash;
        int i = 0;
        while (i < 32) {
            if ((1 << i & idx) != 0) {
                int n = i / 8;
                data[n] = (byte)(data[n] ^ 128 >> i % 8);
            }
            ++i;
        }
        return k;
    }

    public int hashCode() {
        return (this.hash[0] ^ this.hash[1] ^ this.hash[2] ^ this.hash[3] ^ this.hash[4]) << 24 | (this.hash[5] ^ this.hash[6] ^ this.hash[7] ^ this.hash[8] ^ this.hash[9]) << 16 | (this.hash[10] ^ this.hash[11] ^ this.hash[12] ^ this.hash[13] ^ this.hash[14]) << 8 | this.hash[15] ^ this.hash[16] ^ this.hash[17] ^ this.hash[18] ^ this.hash[19];
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean nicePrint) {
        StringBuilder b = new StringBuilder(nicePrint ? 44 : 40);
        int i = 0;
        while (i < this.hash.length) {
            int nibble;
            if (nicePrint && i % 4 == 0 && i > 0) {
                b.append(' ');
            }
            b.append((char)((nibble = (this.hash[i] & 0xF0) >> 4) < 10 ? 48 + nibble : 65 + nibble - 10));
            nibble = this.hash[i] & 0xF;
            b.append((char)(nibble < 10 ? 48 + nibble : 65 + nibble - 10));
            ++i;
        }
        return b.toString();
    }

    public int findApproxKeyDistance(Key id) {
        Key d = Key.distance(id, this);
        int bit_on = 255;
        byte[] data_hash = d.getHash();
        int i = 0;
        while (i < 20) {
            int b = data_hash[i] & 0xFF;
            if (b != 0) {
                int j = 0;
                while (j < 8) {
                    if ((b & 128 >> j) != 0) {
                        bit_on = i * 8 + j;
                        return 159 - bit_on;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return 0;
    }

    public Key distance(Key x) {
        return Key.distance(this, x);
    }

    public double naturalDistance(Key otherKey) {
        return Math.log(new BigInteger(1, this.hash).subtract(new BigInteger(1, otherKey.hash)).mod(new BigInteger(1, Key.MAX_KEY.hash).add(new BigInteger("1"))).doubleValue()) / Math.log(2.0);
    }

    public static Key distance(Key a, Key b) {
        Key x = new Key();
        int i = 0;
        while (i < a.hash.length) {
            x.hash[i] = (byte)(a.hash[i] ^ b.hash[i]);
            ++i;
        }
        return x;
    }

    public static Key createRandomKey() {
        Key x = new Key();
        ThreadLocalUtils.getThreadLocalRandom().nextBytes(x.hash);
        return x;
    }

    public static void main(String[] args) {
        Key k1 = new Key(MIN_KEY);
        k1.hash[19] = -128;
        Key k2 = new Key(MIN_KEY);
        System.out.println(Math.log(k1.naturalDistance(k2)) / Math.log(2.0));
    }

    public static final class DistanceOrder
    implements Comparator<Key> {
        final Key target;

        public DistanceOrder(Key target) {
            this.target = target;
        }

        @Override
        public int compare(Key o1, Key o2) {
            return this.target.threeWayDistance(o1, o2);
        }
    }
}

