/*
 * Decompiled with CFR 0.152.
 */
package lbms.plugins.mldht.kad.tasks;

import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import lbms.plugins.mldht.kad.DHT;
import lbms.plugins.mldht.kad.KBucketEntry;
import lbms.plugins.mldht.kad.Key;
import lbms.plugins.mldht.kad.Node;
import lbms.plugins.mldht.kad.RPCCallBase;
import lbms.plugins.mldht.kad.RPCServerBase;
import lbms.plugins.mldht.kad.messages.FindNodeRequest;
import lbms.plugins.mldht.kad.messages.FindNodeResponse;
import lbms.plugins.mldht.kad.messages.MessageBase;
import lbms.plugins.mldht.kad.tasks.Task;
import lbms.plugins.mldht.kad.utils.PackUtil;

public class KeyspaceCrawler
extends Task {
    Set<InetSocketAddress> responded = new HashSet<InetSocketAddress>();

    KeyspaceCrawler(RPCServerBase rpc, Node node) {
        super(Key.createRandomKey(), rpc, node);
        this.setInfo("Exhaustive Keyspace Crawl");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    synchronized void update() {
        block10: {
            var1_1 = this.todo;
            synchronized (var1_1) {
                while (true) lbl-1000:
                // 3 sources

                {
                    if (this.todo.size() <= 0 || !this.canDoRequest()) {
                        break block10;
                    }
                    e = (KBucketEntry)this.todo.first();
                    this.todo.remove(e);
                    if (this.visited.contains(e)) continue;
                    fnr = new FindNodeRequest(Key.createRandomKey());
                    fnr.setWant4(this.rpc.getDHT().getType() == DHT.DHTtype.IPV4_DHT || DHT.getDHT(DHT.DHTtype.IPV4_DHT).getNode().getNumEntriesInRoutingTable() < 30);
                    fnr.setWant6(this.rpc.getDHT().getType() == DHT.DHTtype.IPV6_DHT || DHT.getDHT(DHT.DHTtype.IPV6_DHT).getNode().getNumEntriesInRoutingTable() < 30);
                    fnr.setDestination(e.getAddress());
                    this.rpcCall(fnr, e.getID());
                    if (this.canDoRequest()) {
                        fnr = new FindNodeRequest(e.getID());
                        fnr.setWant4(this.rpc.getDHT().getType() == DHT.DHTtype.IPV4_DHT || DHT.getDHT(DHT.DHTtype.IPV4_DHT).getNode().getNumEntriesInRoutingTable() < 30);
                        fnr.setWant6(this.rpc.getDHT().getType() == DHT.DHTtype.IPV6_DHT || DHT.getDHT(DHT.DHTtype.IPV6_DHT).getNode().getNumEntriesInRoutingTable() < 30);
                        fnr.setDestination(e.getAddress());
                        this.rpcCall(fnr, e.getID());
                    }
                    var4_4 = this.visited;
                    synchronized (var4_4) {
                        this.visited.add(e);
                        continue;
                    }
                    break;
                }
                {
                    ** while (true)
                }
            }
        }
        if (this.todo.size() == 0 && this.getNumOutstandingRequests() == 0 && !this.isFinished()) {
            this.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void callFinished(RPCCallBase c, MessageBase rsp) {
        if (this.isFinished()) {
            return;
        }
        if (rsp.getMethod() == MessageBase.Method.FIND_NODE && rsp.getType() == MessageBase.Type.RSP_MSG) {
            FindNodeResponse fnr = (FindNodeResponse)rsp;
            this.responded.add(fnr.getOrigin());
            DHT.DHTtype[] dHTtypeArray = DHT.DHTtype.values();
            int n = dHTtypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                DHT.DHTtype type = dHTtypeArray[n2];
                byte[] nodes = fnr.getNodes(type);
                if (nodes != null) {
                    int nval = nodes.length / type.NODES_ENTRY_LENGTH;
                    if (type == this.rpc.getDHT().getType()) {
                        SortedSet sortedSet = this.todo;
                        synchronized (sortedSet) {
                            int i = 0;
                            while (i < nval) {
                                KBucketEntry e = PackUtil.UnpackBucketEntry(nodes, i * type.NODES_ENTRY_LENGTH, type);
                                if (!(this.node.allLocalIDs().contains(e.getID()) || this.todo.contains(e) || this.visited.contains(e))) {
                                    this.todo.add(e);
                                }
                                ++i;
                            }
                        }
                    } else {
                        int i = 0;
                        while (i < nval) {
                            KBucketEntry e = PackUtil.UnpackBucketEntry(nodes, i * type.NODES_ENTRY_LENGTH, type);
                            DHT.getDHT(type).addDHTNode(e.getAddress().getAddress().getHostAddress(), e.getAddress().getPort());
                            ++i;
                        }
                    }
                }
                ++n2;
            }
        }
    }

    @Override
    boolean canDoRequest() {
        return this.getNumOutstandingRequestsExcludingStalled() < 50;
    }

    @Override
    public void kill() {
    }

    @Override
    void callTimeout(RPCCallBase c) {
    }

    @Override
    public void start() {
        int added = 0;
        for (Node.RoutingTableEntry bucket : this.node.getBuckets()) {
            for (KBucketEntry e : bucket.getBucket().getEntries()) {
                if (e.isBad()) continue;
                this.todo.add(e);
                ++added;
            }
        }
        super.start();
    }

    @Override
    protected void done() {
        super.done();
        System.out.println("crawled " + this.visited.size() + " nodes, seen " + this.responded.size());
    }
}

