/*
 * Decompiled with CFR 0.152.
 */
package lbms.plugins.mldht.kad.tasks;

import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import lbms.plugins.mldht.kad.DHT;
import lbms.plugins.mldht.kad.KBucketEntry;
import lbms.plugins.mldht.kad.KClosestNodesSearch;
import lbms.plugins.mldht.kad.Key;
import lbms.plugins.mldht.kad.Node;
import lbms.plugins.mldht.kad.RPCCallBase;
import lbms.plugins.mldht.kad.RPCServerBase;
import lbms.plugins.mldht.kad.messages.FindNodeRequest;
import lbms.plugins.mldht.kad.messages.FindNodeResponse;
import lbms.plugins.mldht.kad.messages.MessageBase;
import lbms.plugins.mldht.kad.tasks.Task;
import lbms.plugins.mldht.kad.utils.AddressUtils;
import lbms.plugins.mldht.kad.utils.PackUtil;

public class NodeLookup
extends Task {
    private int validReponsesSinceLastClosestSetModification;
    SortedSet<Key> closestSet;
    private Map<MessageBase, Key> lookupMap;
    private boolean forBootstrap = false;

    public NodeLookup(Key node_id, RPCServerBase rpc, Node node, boolean isBootstrap) {
        super(node_id, rpc, node);
        this.forBootstrap = isBootstrap;
        this.closestSet = new TreeSet<Key>(new Key.DistanceOrder(this.targetKey));
        this.lookupMap = new HashMap<MessageBase, Key>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void update() {
        SortedSet sortedSet = this.todo;
        synchronized (sortedSet) {
            while (this.todo.size() > 0 && this.canDoRequest() && this.validReponsesSinceLastClosestSetModification < 10) {
                KBucketEntry e = (KBucketEntry)this.todo.first();
                this.todo.remove(e);
                if (this.visited.contains(e)) continue;
                FindNodeRequest fnr = new FindNodeRequest(this.targetKey);
                fnr.setWant4(this.rpc.getDHT().getType() == DHT.DHTtype.IPV4_DHT || DHT.getDHT(DHT.DHTtype.IPV4_DHT).getNode() != null && DHT.getDHT(DHT.DHTtype.IPV4_DHT).getNode().getNumEntriesInRoutingTable() < 30);
                fnr.setWant6(this.rpc.getDHT().getType() == DHT.DHTtype.IPV6_DHT || DHT.getDHT(DHT.DHTtype.IPV6_DHT).getNode() != null && DHT.getDHT(DHT.DHTtype.IPV6_DHT).getNode().getNumEntriesInRoutingTable() < 30);
                fnr.setDestination(e.getAddress());
                Map<MessageBase, Key> map = this.lookupMap;
                synchronized (map) {
                    this.lookupMap.put(fnr, e.getID());
                }
                this.rpcCall(fnr, e.getID());
                this.visited.add(e);
            }
        }
        if (this.todo.size() == 0 && this.getNumOutstandingRequests() == 0 && !this.isFinished()) {
            this.done();
        } else if (this.getNumOutstandingRequests() == 0 && this.validReponsesSinceLastClosestSetModification >= 10) {
            this.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void callFinished(RPCCallBase c, MessageBase rsp) {
        if (this.isFinished()) {
            return;
        }
        if (rsp.getMethod() == MessageBase.Method.FIND_NODE && rsp.getType() == MessageBase.Type.RSP_MSG) {
            MessageBase b = c.getRequest();
            Map<MessageBase, Key> map = this.lookupMap;
            synchronized (map) {
                if (this.lookupMap.containsKey(b)) {
                    SortedSet<Key> sortedSet = this.closestSet;
                    synchronized (sortedSet) {
                        Key toAdd = this.lookupMap.remove(b);
                        this.closestSet.add(toAdd);
                        if (this.closestSet.size() > 8) {
                            Key last = this.closestSet.last();
                            this.closestSet.remove(last);
                            this.validReponsesSinceLastClosestSetModification = toAdd == last ? ++this.validReponsesSinceLastClosestSetModification : 0;
                        }
                    }
                }
            }
            FindNodeResponse fnr = (FindNodeResponse)rsp;
            DHT.DHTtype[] dHTtypeArray = DHT.DHTtype.values();
            int n = dHTtypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                DHT.DHTtype type = dHTtypeArray[n2];
                byte[] nodes = fnr.getNodes(type);
                if (nodes != null) {
                    int nval = nodes.length / type.NODES_ENTRY_LENGTH;
                    if (type == this.rpc.getDHT().getType()) {
                        SortedSet sortedSet = this.todo;
                        synchronized (sortedSet) {
                            int i = 0;
                            while (i < nval) {
                                KBucketEntry e = PackUtil.UnpackBucketEntry(nodes, i * type.NODES_ENTRY_LENGTH, type);
                                if (!(AddressUtils.isBogon(e.getAddress()) || this.node.allLocalIDs().contains(e.getID()) || this.todo.contains(e) || this.visited.contains(e))) {
                                    this.todo.add(e);
                                }
                                ++i;
                            }
                        }
                    } else {
                        int i = 0;
                        while (i < nval) {
                            KBucketEntry e = PackUtil.UnpackBucketEntry(nodes, i * type.NODES_ENTRY_LENGTH, type);
                            DHT.getDHT(type).addDHTNode(e.getAddress().getAddress().getHostAddress(), e.getAddress().getPort());
                            ++i;
                        }
                    }
                }
                ++n2;
            }
        }
    }

    @Override
    void callTimeout(RPCCallBase c) {
    }

    @Override
    public void start() {
        boolean added = false;
        Key knsTargetKey = this.forBootstrap ? this.targetKey.getDerivedKey(-1) : this.targetKey;
        KClosestNodesSearch kns = new KClosestNodesSearch(knsTargetKey, 24, this.rpc.getDHT());
        kns.fill();
        this.todo.addAll(kns.getEntries());
        super.start();
    }

    @Override
    protected void done() {
        super.done();
        this.rpc.getDHT().getEstimator().update(new TreeSet<Key>(this.closestSet));
    }
}

