/*
 * Decompiled with CFR 0.152.
 */
package lbms.plugins.mldht.kad.utils;

import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.LinkedList;
import lbms.plugins.mldht.kad.PeerAddressDBItem;

public class AddressUtils {
    public static boolean isBogon(PeerAddressDBItem item) {
        return AddressUtils.isBogon(item.getInetAddress(), item.getPort());
    }

    public static boolean isBogon(InetSocketAddress addr) {
        return AddressUtils.isBogon(addr.getAddress(), addr.getPort());
    }

    public static boolean isBogon(InetAddress addr, int port) {
        return port <= 0 || port > 65535 || !AddressUtils.isGlobalUnicast(addr);
    }

    public static boolean isGlobalUnicast(InetAddress addr) {
        return !addr.isAnyLocalAddress() && !addr.isLinkLocalAddress() && !addr.isLoopbackAddress() && !addr.isMulticastAddress() && !addr.isSiteLocalAddress();
    }

    public static LinkedList<InetAddress> getAvailableAddrs(boolean multiHoming, Class<? extends InetAddress> type) {
        LinkedList<InetAddress> addrs = new LinkedList<InetAddress>();
        try {
            InetAddress[] allBindAddresses = NetworkAdmin.getSingleton().getAllBindAddresses(true);
            if (allBindAddresses.length == 1 && allBindAddresses[0].isAnyLocalAddress()) {
                if (allBindAddresses[0] instanceof Inet6Address && type == Inet4Address.class) {
                    allBindAddresses = new InetAddress[]{InetAddress.getByAddress(new byte[4])};
                } else if (allBindAddresses[0] instanceof Inet4Address && type == Inet6Address.class) {
                    allBindAddresses = new InetAddress[]{InetAddress.getByAddress(new byte[16])};
                }
            }
            InetAddress[] inetAddressArray = allBindAddresses;
            int n = allBindAddresses.length;
            int n2 = 0;
            while (n2 < n) {
                block16: {
                    InetAddress inetAddress = inetAddressArray[n2];
                    try {
                        InetAddress addr;
                        if (type == Inet6Address.class && inetAddress instanceof Inet6Address) {
                            addr = (Inet6Address)inetAddress;
                            if (((Inet6Address)addr).isIPv4CompatibleAddress() || !AddressUtils.isGlobalUnicast(addr)) break block16;
                            byte[] raw = ((Inet6Address)addr).getAddress();
                            if (raw[0] == 32 && raw[1] == 1 && raw[2] == 0 && raw[3] == 0) {
                                addrs.addLast(addr);
                            } else {
                                addrs.addFirst(addr);
                            }
                        }
                        if (type == Inet4Address.class && inetAddress instanceof Inet4Address) {
                            addr = (Inet4Address)inetAddress;
                            if (!(multiHoming && !AddressUtils.isGlobalUnicast(addr) || ((Inet4Address)addr).isLinkLocalAddress() || ((Inet4Address)addr).isLoopbackAddress())) {
                                addrs.add(addr);
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!multiHoming) {
            addrs.retainAll(Collections.singleton(addrs.peekFirst()));
        }
        return addrs;
    }
}

