/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.internat;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.util.Arrays;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoder;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;

public class LocaleUtilDecoderReal
implements LocaleUtilDecoder {
    protected final CharsetDecoder decoder;
    protected final int index;
    private AEMonitor this_mon = new AEMonitor("LUDR");

    protected LocaleUtilDecoderReal(int _index, CharsetDecoder _decoder) {
        this.index = _index;
        this.decoder = _decoder;
    }

    @Override
    public String getName() {
        return this.decoder.charset().name();
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public String tryDecode(byte[] array, boolean lax) {
        try {
            CoderResult cr;
            ByteBuffer bb = ByteBuffer.wrap(array);
            CharBuffer cb = CharBuffer.allocate(array.length);
            this.this_mon.enter();
            try {
                cr = this.decoder.decode(bb, cb, true);
            }
            finally {
                this.this_mon.exit();
            }
            if (!cr.isError()) {
                cb.flip();
                String str = cb.toString();
                if (lax) {
                    return str;
                }
                byte[] b2 = str.getBytes(this.getName());
                if (Arrays.equals(array, b2)) {
                    return str;
                }
            }
        }
        finally {
            return null;
        }
    }

    @Override
    public String decodeString(byte[] bytes) throws UnsupportedEncodingException {
        if (bytes == null) {
            return null;
        }
        try {
            CoderResult cr;
            ByteBuffer bb = ByteBuffer.wrap(bytes);
            CharBuffer cb = CharBuffer.allocate(bytes.length);
            this.this_mon.enter();
            try {
                cr = this.decoder.decode(bb, cb, true);
            }
            finally {
                this.this_mon.exit();
            }
            if (!cr.isError()) {
                cb.flip();
                String str = cb.toString();
                byte[] b2 = str.getBytes(this.decoder.charset().name());
                if (Arrays.equals(bytes, b2)) {
                    return str;
                }
            }
        }
        catch (Throwable bb) {
            // empty catch block
        }
        try {
            return new String(bytes, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            Debug.printStackTrace(e);
            return new String(bytes);
        }
    }
}

