/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.peer.impl.control;

import com.aelitis.azureus.core.networkmanager.LimitedRateGroup;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPConnectionManager;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPNetworkManager;
import com.aelitis.azureus.core.networkmanager.impl.udp.UDPNetworkManager;
import com.aelitis.azureus.core.peermanager.PeerManagerRegistration;
import com.aelitis.azureus.core.peermanager.control.PeerControlInstance;
import com.aelitis.azureus.core.peermanager.control.PeerControlScheduler;
import com.aelitis.azureus.core.peermanager.control.PeerControlSchedulerFactory;
import com.aelitis.azureus.core.peermanager.nat.PeerNATInitiator;
import com.aelitis.azureus.core.peermanager.nat.PeerNATTraverser;
import com.aelitis.azureus.core.peermanager.peerdb.PeerDatabase;
import com.aelitis.azureus.core.peermanager.peerdb.PeerDatabaseFactory;
import com.aelitis.azureus.core.peermanager.peerdb.PeerExchangerItem;
import com.aelitis.azureus.core.peermanager.peerdb.PeerItem;
import com.aelitis.azureus.core.peermanager.peerdb.PeerItemFactory;
import com.aelitis.azureus.core.peermanager.piecepicker.PiecePicker;
import com.aelitis.azureus.core.peermanager.piecepicker.PiecePickerFactory;
import com.aelitis.azureus.core.peermanager.unchoker.Unchoker;
import com.aelitis.azureus.core.peermanager.unchoker.UnchokerFactory;
import com.aelitis.azureus.core.peermanager.unchoker.UnchokerUtil;
import com.aelitis.azureus.core.peermanager.uploadslots.UploadHelper;
import com.aelitis.azureus.core.peermanager.uploadslots.UploadSlotManager;
import com.aelitis.azureus.core.tracker.TrackerPeerSource;
import com.aelitis.azureus.core.tracker.TrackerPeerSourceAdapter;
import com.aelitis.azureus.core.util.FeatureAvailability;
import com.aelitis.azureus.core.util.bloom.BloomFilter;
import com.aelitis.azureus.core.util.bloom.BloomFilterFactory;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerCheckRequest;
import org.gudy.azureus2.core3.disk.DiskManagerCheckRequestListener;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequest;
import org.gudy.azureus2.core3.disk.DiskManagerWriteRequest;
import org.gudy.azureus2.core3.disk.DiskManagerWriteRequestListener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.ipfilter.BannedIp;
import org.gudy.azureus2.core3.ipfilter.IPFilterListener;
import org.gudy.azureus2.core3.ipfilter.IpFilter;
import org.gudy.azureus2.core3.ipfilter.IpFilterManager;
import org.gudy.azureus2.core3.ipfilter.IpFilterManagerFactory;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.LogRelation;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPeerManagerAdapter;
import org.gudy.azureus2.core3.peer.PEPeerManagerListener;
import org.gudy.azureus2.core3.peer.PEPeerManagerStats;
import org.gudy.azureus2.core3.peer.PEPeerStats;
import org.gudy.azureus2.core3.peer.PEPiece;
import org.gudy.azureus2.core3.peer.impl.PEPeerControl;
import org.gudy.azureus2.core3.peer.impl.PEPeerManagerStatsImpl;
import org.gudy.azureus2.core3.peer.impl.PEPeerStatsImpl;
import org.gudy.azureus2.core3.peer.impl.PEPeerTransport;
import org.gudy.azureus2.core3.peer.impl.PEPeerTransportFactory;
import org.gudy.azureus2.core3.peer.impl.PEPieceImpl;
import org.gudy.azureus2.core3.peer.impl.PEPieceWriteImpl;
import org.gudy.azureus2.core3.peer.impl.control.SuperSeedPeer;
import org.gudy.azureus2.core3.peer.impl.control.SuperSeedPiece;
import org.gudy.azureus2.core3.peer.util.PeerIdentityDataID;
import org.gudy.azureus2.core3.peer.util.PeerIdentityManager;
import org.gudy.azureus2.core3.peer.util.PeerUtils;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerResponse;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerResponsePeer;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.AddressUtils;
import org.gudy.azureus2.core3.util.Average;
import org.gudy.azureus2.core3.util.BrokenMd5Hasher;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimeFormatter;
import org.gudy.azureus2.plugins.network.Connection;
import org.gudy.azureus2.plugins.network.OutgoingMessageQueue;
import org.gudy.azureus2.plugins.peers.Peer;
import org.gudy.azureus2.plugins.peers.PeerDescriptor;

public class PEPeerControlImpl
extends LogRelation
implements PEPeerControl,
DiskManagerWriteRequestListener,
PeerControlInstance,
PeerNATInitiator,
DiskManagerCheckRequestListener,
IPFilterListener {
    private static final LogIDs LOGID = LogIDs.PEER;
    private static final boolean TEST_PERIODIC_SEEDING_SCAN_FAIL_HANDLING = false;
    private static final int WARNINGS_LIMIT = 2;
    private static final int CHECK_REASON_DOWNLOADED = 1;
    private static final int CHECK_REASON_COMPLETE = 2;
    private static final int CHECK_REASON_SCAN = 3;
    private static final int CHECK_REASON_SEEDING_CHECK = 4;
    private static final int CHECK_REASON_BAD_PIECE_CHECK = 5;
    private static final int SEED_CHECK_WAIT_MARKER = 65526;
    private static boolean disconnect_seeds_when_seeding;
    private static boolean enable_seeding_piece_rechecks;
    private static int stalled_piece_timeout;
    private static boolean fast_unchoke_new_peers;
    private static float ban_peer_discard_ratio;
    private static int ban_peer_discard_min_kb;
    private static boolean udp_fallback_for_failed_connection;
    private static boolean udp_fallback_for_dropped_connection;
    private static boolean udp_probe_enabled;
    private static boolean hide_a_piece;
    private static boolean prefer_udp_default;
    private static final IpFilter ip_filter;
    private volatile boolean is_running = false;
    private volatile boolean is_destroyed = false;
    private volatile ArrayList<PEPeerTransport> peer_transports_cow = new ArrayList();
    private final AEMonitor peer_transports_mon = new AEMonitor("PEPeerControl:PT");
    protected final PEPeerManagerAdapter adapter;
    private final DiskManager disk_mgr;
    private final DiskManagerPiece[] dm_pieces;
    private final boolean is_private_torrent;
    private PEPeerManager.StatsReceiver stats_receiver;
    private final PiecePicker piecePicker;
    private long lastNeededUndonePieceChange;
    private boolean seeding_mode;
    private boolean restart_initiated;
    private final int _nbPieces;
    private final PEPieceImpl[] pePieces;
    private int nbPiecesActive;
    private int nbPeersSnubbed;
    private PeerIdentityDataID _hash;
    private final byte[] _myPeerId;
    private PEPeerManagerStatsImpl _stats;
    private int stats_tick_count;
    private int _seeds;
    private int _peers;
    private int _remotesTCPNoLan;
    private int _remotesUDPNoLan;
    private int _remotesUTPNoLan;
    private int _tcpPendingConnections;
    private int _tcpConnectingConnections;
    private long last_remote_time;
    private long _timeStarted;
    private long _timeStarted_mono;
    private long _timeStartedSeeding = -1L;
    private long _timeStartedSeeding_mono = -1L;
    private long _timeFinished;
    private Average _averageReceptionSpeed;
    private long mainloop_loop_count;
    private static final int MAINLOOP_ONE_SECOND_INTERVAL;
    private static final int MAINLOOP_FIVE_SECOND_INTERVAL;
    private static final int MAINLOOP_TEN_SECOND_INTERVAL;
    private static final int MAINLOOP_TWENTY_SECOND_INTERVAL;
    private static final int MAINLOOP_THIRTY_SECOND_INTERVAL;
    private static final int MAINLOOP_SIXTY_SECOND_INTERVAL;
    private static final int MAINLOOP_TEN_MINUTE_INTERVAL;
    private volatile ArrayList<PEPeerManagerListener> peer_manager_listeners_cow = new ArrayList();
    private final List<Object[]> piece_check_result_list = new ArrayList<Object[]>();
    private final AEMonitor piece_check_result_list_mon = new AEMonitor("PEPeerControl:PCRL");
    private boolean superSeedMode;
    private int superSeedModeCurrentPiece;
    private int superSeedModeNumberOfAnnounces;
    private SuperSeedPiece[] superSeedPieces;
    private int hidden_piece;
    private final AEMonitor this_mon = new AEMonitor("PEPeerControl");
    private long ip_filter_last_update_time;
    private Map<Object, Object> user_data;
    private Unchoker unchoker;
    private List<Object[]> external_rate_limiters_cow;
    private int bytes_queued_for_upload;
    private int connections_with_queued_data;
    private int connections_with_queued_data_blocked;
    private int connections_unchoked;
    private List<PEPeerTransport> sweepList = Collections.emptyList();
    private int nextPEXSweepIndex = 0;
    private final UploadHelper upload_helper = new UploadHelper(){

        @Override
        public int getPriority() {
            return 4;
        }

        @Override
        public ArrayList<PEPeer> getAllPeers() {
            return PEPeerControlImpl.this.peer_transports_cow;
        }

        @Override
        public boolean isSeeding() {
            return PEPeerControlImpl.this.seeding_mode;
        }
    };
    private final PeerDatabase peer_database = PeerDatabaseFactory.createPeerDatabase();
    private int bad_piece_reported = -1;
    private int next_rescan_piece = -1;
    private long rescan_piece_time = -1L;
    private long last_eta;
    private long last_eta_smoothed;
    private long last_eta_calculation;
    private static final int MAX_UDP_CONNECTIONS = 16;
    private static final int PENDING_NAT_TRAVERSAL_MAX = 32;
    private static final int MAX_UDP_TRAVERSAL_COUNT = 3;
    private static final String PEER_NAT_TRAVERSE_DONE_KEY;
    private final Map<String, PEPeerTransport> pending_nat_traversals = new LinkedHashMap<String, PEPeerTransport>(32, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, PEPeerTransport> eldest) {
            return this.size() > 32;
        }
    };
    private int udp_traversal_count;
    private static final int UDP_RECONNECT_MAX = 16;
    private final Map<String, PEPeerTransport> udp_reconnects = new LinkedHashMap<String, PEPeerTransport>(16, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, PEPeerTransport> eldest) {
            return this.size() > 16;
        }
    };
    private static final int UDP_RECONNECT_MIN_MILLIS = 10000;
    private long last_udp_reconnect;
    private boolean prefer_udp;
    private static final int PREFER_UDP_BLOOM_SIZE = 10000;
    private volatile BloomFilter prefer_udp_bloom;
    private final LimitedRateGroup upload_limited_rate_group = new LimitedRateGroup(){

        @Override
        public String getName() {
            return "per_dl_up: " + PEPeerControlImpl.this.getDisplayName();
        }

        @Override
        public int getRateLimitBytesPerSecond() {
            return PEPeerControlImpl.this.adapter.getUploadRateLimitBytesPerSecond();
        }

        @Override
        public boolean isDisabled() {
            return PEPeerControlImpl.this.adapter.getUploadRateLimitBytesPerSecond() == -1;
        }

        @Override
        public void updateBytesUsed(int used) {
        }
    };
    private final LimitedRateGroup download_limited_rate_group = new LimitedRateGroup(){

        @Override
        public String getName() {
            return "per_dl_down: " + PEPeerControlImpl.this.getDisplayName();
        }

        @Override
        public int getRateLimitBytesPerSecond() {
            return PEPeerControlImpl.this.adapter.getDownloadRateLimitBytesPerSecond();
        }

        @Override
        public boolean isDisabled() {
            return PEPeerControlImpl.this.adapter.getDownloadRateLimitBytesPerSecond() == -1;
        }

        @Override
        public void updateBytesUsed(int used) {
        }
    };
    private final int partition_id;
    private final boolean is_metadata_download;
    private int metadata_infodict_size;
    private DiskManager.GettingThere finish_in_progress;
    private long last_seed_disconnect_time;
    private final BloomFilter naughty_fast_extension_bloom = BloomFilterFactory.createRotating(BloomFilterFactory.createAddRemove4Bit(2000), 2);
    private static final int FE_EVENT_LIMIT = 5;
    private int optimisticDisconnectCount = 0;

    static {
        COConfigurationManager.addAndFireParameterListeners(new String[]{"Disconnect Seed", "Seeding Piece Check Recheck Enable", "peercontrol.stalled.piece.write.timeout", "Peer.Fast.Initial.Unchoke.Enabled", "Ip Filter Ban Discard Ratio", "Ip Filter Ban Discard Min KB", "peercontrol.udp.fallback.connect.fail", "peercontrol.udp.fallback.connect.drop", "peercontrol.udp.probe.enable", "peercontrol.hide.piece", "peercontrol.hide.piece.ds", "peercontrol.prefer.udp"}, new ParameterListener(){

            @Override
            public void parameterChanged(String name) {
                disconnect_seeds_when_seeding = COConfigurationManager.getBooleanParameter("Disconnect Seed");
                enable_seeding_piece_rechecks = COConfigurationManager.getBooleanParameter("Seeding Piece Check Recheck Enable");
                stalled_piece_timeout = COConfigurationManager.getIntParameter("peercontrol.stalled.piece.write.timeout", 60000);
                fast_unchoke_new_peers = COConfigurationManager.getBooleanParameter("Peer.Fast.Initial.Unchoke.Enabled");
                ban_peer_discard_ratio = COConfigurationManager.getFloatParameter("Ip Filter Ban Discard Ratio");
                ban_peer_discard_min_kb = COConfigurationManager.getIntParameter("Ip Filter Ban Discard Min KB");
                udp_fallback_for_failed_connection = COConfigurationManager.getBooleanParameter("peercontrol.udp.fallback.connect.fail");
                udp_fallback_for_dropped_connection = COConfigurationManager.getBooleanParameter("peercontrol.udp.fallback.connect.drop");
                udp_probe_enabled = COConfigurationManager.getBooleanParameter("peercontrol.udp.probe.enable");
                hide_a_piece = COConfigurationManager.getBooleanParameter("peercontrol.hide.piece");
                boolean hide_a_piece_ds = COConfigurationManager.getBooleanParameter("peercontrol.hide.piece.ds");
                if (hide_a_piece && !hide_a_piece_ds) {
                    disconnect_seeds_when_seeding = false;
                }
                prefer_udp_default = COConfigurationManager.getBooleanParameter("peercontrol.prefer.udp");
            }
        });
        ip_filter = IpFilterManagerFactory.getSingleton().getIPFilter();
        MAINLOOP_ONE_SECOND_INTERVAL = 1000 / PeerControlScheduler.SCHEDULE_PERIOD_MILLIS;
        MAINLOOP_FIVE_SECOND_INTERVAL = MAINLOOP_ONE_SECOND_INTERVAL * 5;
        MAINLOOP_TEN_SECOND_INTERVAL = MAINLOOP_ONE_SECOND_INTERVAL * 10;
        MAINLOOP_TWENTY_SECOND_INTERVAL = MAINLOOP_ONE_SECOND_INTERVAL * 20;
        MAINLOOP_THIRTY_SECOND_INTERVAL = MAINLOOP_ONE_SECOND_INTERVAL * 30;
        MAINLOOP_SIXTY_SECOND_INTERVAL = MAINLOOP_ONE_SECOND_INTERVAL * 60;
        MAINLOOP_TEN_MINUTE_INTERVAL = MAINLOOP_SIXTY_SECOND_INTERVAL * 10;
        PEER_NAT_TRAVERSE_DONE_KEY = String.valueOf(PEPeerControlImpl.class.getName()) + "::nat_trav_done";
    }

    public PEPeerControlImpl(byte[] _peer_id, PEPeerManagerAdapter _adapter, DiskManager _diskManager, int _partition_id) {
        this._myPeerId = _peer_id;
        this.adapter = _adapter;
        this.disk_mgr = _diskManager;
        this.partition_id = _partition_id;
        boolean is_private = false;
        try {
            is_private = this.disk_mgr.getTorrent().getPrivate();
        }
        catch (Throwable e) {
            Debug.out(e);
        }
        this.is_private_torrent = is_private;
        this.is_metadata_download = this.adapter.isMetadataDownload();
        if (!this.is_metadata_download) {
            this.metadata_infodict_size = this.adapter.getTorrentInfoDictSize();
        }
        this._nbPieces = this.disk_mgr.getNbPieces();
        this.dm_pieces = this.disk_mgr.getPieces();
        this.pePieces = new PEPieceImpl[this._nbPieces];
        this.hidden_piece = hide_a_piece ? (int)(Math.abs(this.adapter.getRandomSeed()) % (long)this._nbPieces) : -1;
        this.piecePicker = PiecePickerFactory.create(this);
        ip_filter.addListener(this);
    }

    @Override
    public void start() {
        try {
            this._hash = PeerIdentityManager.createDataID(this.disk_mgr.getTorrent().getHash());
        }
        catch (TOTorrentException e) {
            Debug.printStackTrace(e);
            this._hash = PeerIdentityManager.createDataID(new byte[20]);
        }
        int i = 0;
        while (i < this._nbPieces) {
            DiskManagerPiece dmPiece = this.dm_pieces[i];
            if (!dmPiece.isDone() && dmPiece.getNbWritten() > 0) {
                this.addPiece(new PEPieceImpl(this, dmPiece, 0), i, true, null);
            }
            ++i;
        }
        this.peer_transports_cow = new ArrayList();
        this.mainloop_loop_count = 0L;
        this._averageReceptionSpeed = Average.getInstance(1000, 30);
        this._stats = new PEPeerManagerStatsImpl(this);
        this.superSeedMode = COConfigurationManager.getBooleanParameter("Use Super Seeding") && this.getRemaining() == 0L;
        this.superSeedModeCurrentPiece = 0;
        if (this.superSeedMode) {
            this.initialiseSuperSeedMode();
        }
        this.checkFinished(true);
        UploadSlotManager.getSingleton().registerHelper(this.upload_helper);
        this.lastNeededUndonePieceChange = Long.MIN_VALUE;
        this._timeStarted = SystemTime.getCurrentTime();
        this._timeStarted_mono = SystemTime.getMonotonousTime();
        this.is_running = true;
        PeerManagerRegistration reg = this.adapter.getPeerManagerRegistration();
        if (reg != null) {
            reg.activate(this);
        }
        PeerNATTraverser.getSingleton().register(this);
        PeerControlSchedulerFactory.getSingleton(this.partition_id).register(this);
    }

    @Override
    public void stopAll() {
        this.is_running = false;
        UploadSlotManager.getSingleton().deregisterHelper(this.upload_helper);
        PeerControlSchedulerFactory.getSingleton(this.partition_id).unregister(this);
        PeerNATTraverser.getSingleton().unregister(this);
        PeerManagerRegistration reg = this.adapter.getPeerManagerRegistration();
        if (reg != null) {
            reg.deactivate();
        }
        this.closeAndRemoveAllPeers("download stopped", false);
        int i = 0;
        while (i < this._nbPieces) {
            if (this.pePieces[i] != null) {
                this.removePiece(this.pePieces[i], i);
            }
            ++i;
        }
        ip_filter.removeListener(this);
        this.piecePicker.destroy();
        ArrayList<PEPeerManagerListener> peer_manager_listeners = this.peer_manager_listeners_cow;
        int i2 = 0;
        while (i2 < peer_manager_listeners.size()) {
            peer_manager_listeners.get(i2).destroyed();
            ++i2;
        }
        this.sweepList = Collections.emptyList();
        this.pending_nat_traversals.clear();
        this.udp_reconnects.clear();
        this.is_destroyed = true;
    }

    @Override
    public int getPartitionID() {
        return this.partition_id;
    }

    @Override
    public boolean isDestroyed() {
        return this.is_destroyed;
    }

    @Override
    public DiskManager getDiskManager() {
        return this.disk_mgr;
    }

    @Override
    public PiecePicker getPiecePicker() {
        return this.piecePicker;
    }

    @Override
    public PEPeerManagerAdapter getAdapter() {
        return this.adapter;
    }

    @Override
    public String getDisplayName() {
        return this.adapter.getDisplayName();
    }

    @Override
    public String getName() {
        return this.getDisplayName();
    }

    @Override
    public void schedule() {
        if (this.finish_in_progress != null) {
            if (this.finish_in_progress.hasGotThere()) {
                this.finish_in_progress = null;
            } else {
                return;
            }
        }
        try {
            this.updateStats();
            this.updateTrackerAnnounceInterval();
            this.doConnectionChecks();
            this.processPieceChecks();
            if (this.finish_in_progress != null) {
                return;
            }
            if (!this.seeding_mode) {
                this.checkCompletedPieces();
            }
            this.checkBadPieces();
            this.checkInterested();
            this.piecePicker.updateAvailability();
            this.checkCompletionState();
            if (this.finish_in_progress != null) {
                return;
            }
            this.checkSeeds();
            if (!this.seeding_mode) {
                this.checkRequests();
                this.piecePicker.allocateRequests();
                this.checkRescan();
                this.checkSpeedAndReserved();
                this.check99PercentBug();
            }
            this.updatePeersInSuperSeedMode();
            this.doUnchokes();
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        ++this.mainloop_loop_count;
    }

    private void analyseTrackerResponse(TRTrackerAnnouncerResponse tracker_response) {
        Map extensions;
        TRTrackerAnnouncerResponsePeer[] peers = tracker_response.getPeers();
        if (peers != null) {
            this.addPeersFromTracker(tracker_response.getPeers());
        }
        if ((extensions = tracker_response.getExtensions()) != null) {
            this.addExtendedPeersFromTracker(extensions);
        }
    }

    @Override
    public void processTrackerResponse(TRTrackerAnnouncerResponse response) {
        if (this.is_running) {
            this.analyseTrackerResponse(response);
        }
    }

    private void addExtendedPeersFromTracker(Map extensions) {
        Map protocols = (Map)extensions.get("protocols");
        if (protocols != null) {
            System.out.println("PEPeerControl: tracker response contained protocol extensions");
            for (String protocol_name : protocols.keySet()) {
                Map protocol = (Map)protocols.get(protocol_name);
                List transports = PEPeerTransportFactory.createExtendedTransports(this, protocol_name, protocol);
                int i = 0;
                while (i < transports.size()) {
                    PEPeer transport = (PEPeer)transports.get(i);
                    this.addPeer(transport);
                    ++i;
                }
            }
        }
    }

    @Override
    public List<PEPeer> getPeers() {
        return this.peer_transports_cow;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public List<PEPeer> getPeers(String address) {
        result = new ArrayList<PEPeer>();
        it = this.peer_transports_cow.iterator();
        if (!address.contains(":")) ** GOTO lbl-1000
        try {
            address_bytes = InetAddress.getByName(address).getAddress();
            while (it.hasNext()) {
                peer = it.next();
                peer_address = peer.getIp();
                if (!peer_address.contains(":")) continue;
                peer_bytes = (byte[])peer.getUserData("ipv6.bytes");
                if (peer_bytes == null) {
                    peer_bytes = InetAddress.getByName(peer_address).getAddress();
                    peer.setUserData("ipv6.bytes", peer_bytes);
                }
                if (!Arrays.equals(address_bytes, peer_bytes)) continue;
                result.add(peer);
            }
            return result;
        }
        catch (Throwable address_bytes) lbl-1000:
        // 4 sources

        {
            ** while (it.hasNext())
        }
lbl-1000:
        // 1 sources

        {
            peer = it.next();
            if (!peer.getIp().equals(address)) continue;
            result.add(peer);
            continue;
        }
lbl26:
        // 1 sources

        return result;
    }

    @Override
    public int getPendingPeerCount() {
        return this.peer_database.getDiscoveredPeerCount();
    }

    @Override
    public PeerDescriptor[] getPendingPeers() {
        return this.peer_database.getDiscoveredPeers();
    }

    @Override
    public PeerDescriptor[] getPendingPeers(String address) {
        return this.peer_database.getDiscoveredPeers(address);
    }

    @Override
    public void addPeer(PEPeer _transport) {
        if (!(_transport instanceof PEPeerTransport)) {
            throw new RuntimeException("invalid class");
        }
        PEPeerTransport transport = (PEPeerTransport)_transport;
        if (!ip_filter.isInRange(transport.getIp(), this.getDisplayName(), this.getTorrentHash())) {
            ArrayList<PEPeerTransport> peer_transports = this.peer_transports_cow;
            if (!peer_transports.contains(transport)) {
                this.addToPeerTransports(transport);
                transport.start();
            } else {
                Debug.out("addPeer():: peer_transports.contains(transport): SHOULD NEVER HAPPEN !");
                transport.closeConnection("already connected");
            }
        } else {
            transport.closeConnection("IP address blocked by filters");
        }
    }

    protected byte[] getTorrentHash() {
        try {
            return this.disk_mgr.getTorrent().getHash();
        }
        catch (Throwable e) {
            return null;
        }
    }

    @Override
    public void removePeer(PEPeer _transport) {
        this.removePeer(_transport, "remove peer");
    }

    @Override
    public void removePeer(PEPeer _transport, String reason) {
        if (!(_transport instanceof PEPeerTransport)) {
            throw new RuntimeException("invalid class");
        }
        PEPeerTransport transport = (PEPeerTransport)_transport;
        this.closeAndRemovePeer(transport, reason, true);
    }

    private void closeAndRemovePeer(PEPeerTransport peer, String reason, boolean log_if_not_found) {
        boolean removed = false;
        try {
            this.peer_transports_mon.enter();
            if (this.peer_transports_cow.contains(peer)) {
                ArrayList<PEPeerTransport> new_peer_transports = new ArrayList<PEPeerTransport>(this.peer_transports_cow);
                new_peer_transports.remove(peer);
                this.peer_transports_cow = new_peer_transports;
                removed = true;
            }
        }
        finally {
            this.peer_transports_mon.exit();
        }
        if (removed) {
            peer.closeConnection(reason);
            this.peerRemoved(peer);
        }
    }

    private void closeAndRemoveAllPeers(String reason, boolean reconnect) {
        PEPeerTransport peer;
        ArrayList<PEPeerTransport> peer_transports;
        try {
            this.peer_transports_mon.enter();
            peer_transports = this.peer_transports_cow;
            this.peer_transports_cow = new ArrayList(0);
        }
        finally {
            this.peer_transports_mon.exit();
        }
        int i = 0;
        while (i < peer_transports.size()) {
            peer = (PEPeerTransport)peer_transports.get(i);
            try {
                peer.closeConnection(reason);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            try {
                this.peerRemoved(peer);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
        if (reconnect) {
            i = 0;
            while (i < peer_transports.size()) {
                peer = (PEPeerTransport)peer_transports.get(i);
                PEPeerTransport pEPeerTransport = peer.reconnect(false, false);
                ++i;
            }
        }
    }

    @Override
    public void addPeer(String ip_address, int tcp_port, int udp_port, boolean use_crypto, Map user_data) {
        byte type = use_crypto ? (byte)1 : 0;
        PeerItem peer_item = PeerItemFactory.createPeerItem(ip_address, tcp_port, PeerItem.convertSourceID("Plugin"), type, udp_port, (byte)1, 0);
        byte crypto_level = 1;
        if (!this.isAlreadyConnected(peer_item)) {
            boolean udp_ok;
            boolean tcp_ok = TCPNetworkManager.TCP_OUTGOING_ENABLED && tcp_port > 0;
            boolean bl = udp_ok = UDPNetworkManager.UDP_OUTGOING_ENABLED && udp_port > 0;
            String fail_reason = tcp_ok && (!this.prefer_udp && !prefer_udp_default || !udp_ok) ? this.makeNewOutgoingConnection("Plugin", ip_address, tcp_port, udp_port, true, use_crypto, crypto_level, user_data) : (udp_ok ? this.makeNewOutgoingConnection("Plugin", ip_address, tcp_port, udp_port, false, use_crypto, crypto_level, user_data) : "No usable protocol");
            if (fail_reason != null) {
                Debug.out("Injected peer " + ip_address + ":" + tcp_port + " was not added - " + fail_reason);
            }
        }
    }

    @Override
    public void peerDiscovered(String peer_source, String ip_address, int tcp_port, int udp_port, boolean use_crypto) {
        if (this.peer_database != null) {
            ArrayList<PEPeerTransport> peer_transports = this.peer_transports_cow;
            int x = 0;
            while (x < peer_transports.size()) {
                PEPeer transport = peer_transports.get(x);
                if (ip_address.equals(transport.getIp())) {
                    boolean same_allowed;
                    boolean bl = same_allowed = COConfigurationManager.getBooleanParameter("Allow Same IP Peers") || transport.getIp().equals("127.0.0.1");
                    if (!same_allowed || tcp_port == transport.getPort()) {
                        return;
                    }
                }
                ++x;
            }
            byte type = use_crypto ? (byte)1 : 0;
            PeerItem item = PeerItemFactory.createPeerItem(ip_address, tcp_port, PeerItem.convertSourceID(peer_source), type, udp_port, (byte)1, 0);
            this.peerDiscovered(null, item);
            this.peer_database.addDiscoveredPeer(item);
        }
    }

    private void addPeersFromTracker(TRTrackerAnnouncerResponsePeer[] peers) {
        int i = 0;
        while (i < peers.length) {
            TRTrackerAnnouncerResponsePeer peer = peers[i];
            ArrayList<PEPeerTransport> peer_transports = this.peer_transports_cow;
            boolean already_connected = false;
            int x = 0;
            while (x < peer_transports.size()) {
                PEPeerTransport transport = (PEPeerTransport)peer_transports.get(x);
                if (peer.getAddress().equals(transport.getIp())) {
                    boolean same_allowed;
                    boolean bl = same_allowed = COConfigurationManager.getBooleanParameter("Allow Same IP Peers") || transport.getIp().equals("127.0.0.1");
                    if (!same_allowed || peer.getPort() == transport.getPort()) {
                        already_connected = true;
                        break;
                    }
                }
                ++x;
            }
            if (!already_connected) {
                int http_port;
                if (this.peer_database != null) {
                    byte type = peer.getProtocol() == 2 ? (byte)1 : 0;
                    byte crypto_level = peer.getAZVersion() < 3 ? (byte)1 : 2;
                    PeerItem item = PeerItemFactory.createPeerItem(peer.getAddress(), peer.getPort(), PeerItem.convertSourceID(peer.getSource()), type, peer.getUDPPort(), crypto_level, peer.getUploadSpeed());
                    this.peerDiscovered(null, item);
                    this.peer_database.addDiscoveredPeer(item);
                }
                if ((http_port = peer.getHTTPPort()) != 0 && !this.seeding_mode) {
                    this.adapter.addHTTPSeed(peer.getAddress(), http_port);
                }
            }
            ++i;
        }
    }

    private String makeNewOutgoingConnection(String peer_source, String address, int tcp_port, int udp_port, boolean use_tcp, boolean require_crypto, byte crypto_level, Map user_data) {
        boolean same_allowed;
        boolean max_reached;
        Boolean pc;
        if (ip_filter.isInRange(address, this.getDisplayName(), this.getTorrentHash())) {
            return "IPFilter block";
        }
        String net_cat = AENetworkClassifier.categoriseAddress(address);
        if (!this.adapter.isNetworkEnabled(net_cat)) {
            return "Network '" + net_cat + "' is not enabled";
        }
        if (!this.adapter.isPeerSourceEnabled(peer_source)) {
            return "Peer source '" + peer_source + "' is not enabled";
        }
        boolean is_priority_connection = false;
        if (user_data != null && (pc = (Boolean)user_data.get(Peer.PR_PRIORITY_CONNECTION)) != null && pc.booleanValue()) {
            is_priority_connection = true;
        }
        boolean bl = max_reached = this.getMaxNewConnectionsAllowed(net_cat) == 0;
        if (max_reached && (peer_source != "Plugin" || !this.doOptimisticDisconnect(AddressUtils.isLANLocalAddress(address) != 2, is_priority_connection, net_cat))) {
            return "Too many connections";
        }
        boolean bl2 = same_allowed = COConfigurationManager.getBooleanParameter("Allow Same IP Peers") || address.equals("127.0.0.1");
        if (!same_allowed && PeerIdentityManager.containsIPAddress(this._hash, address)) {
            return "Already connected to IP";
        }
        if (PeerUtils.ignorePeerPort(tcp_port)) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(this.disk_mgr.getTorrent(), LOGID, "Skipping connect with " + address + ":" + tcp_port + " as peer port is in ignore list."));
            }
            return "TCP port '" + tcp_port + "' is in ignore list";
        }
        PEPeerTransport real = PEPeerTransportFactory.createTransport(this, peer_source, address, tcp_port, udp_port, use_tcp, require_crypto, crypto_level, user_data);
        this.addToPeerTransports(real);
        return null;
    }

    private void checkCompletedPieces() {
        if (this.mainloop_loop_count % (long)MAINLOOP_ONE_SECOND_INTERVAL != 0L) {
            return;
        }
        int i = 0;
        while (i < this._nbPieces) {
            DiskManagerPiece dmPiece = this.dm_pieces[i];
            if (dmPiece.isNeedsCheck()) {
                dmPiece.setChecking();
                DiskManagerCheckRequest req = this.disk_mgr.createCheckRequest(i, new Integer(1));
                req.setAdHoc(false);
                this.disk_mgr.enqueueCheckRequest(req, this);
            }
            ++i;
        }
    }

    private boolean checkEmptyPiece(int pieceNumber) {
        if (this.piecePicker.isInEndGameMode()) {
            return false;
        }
        PEPieceImpl pePiece = this.pePieces[pieceNumber];
        DiskManagerPiece dmPiece = this.dm_pieces[pieceNumber];
        if (pePiece == null || pePiece.isRequested()) {
            return false;
        }
        if (dmPiece.getNbWritten() > 0 || pePiece.getNbUnrequested() < pePiece.getNbBlocks() || pePiece.getReservedBy() != null) {
            return false;
        }
        pePiece.reset();
        this.removePiece(pePiece, pieceNumber);
        return true;
    }

    private void checkSpeedAndReserved() {
        if (this.mainloop_loop_count % (long)MAINLOOP_FIVE_SECOND_INTERVAL != 0L) {
            return;
        }
        int nbPieces = this._nbPieces;
        PEPieceImpl[] pieces = this.pePieces;
        int i = 0;
        while (i < nbPieces) {
            this.checkEmptyPiece(i);
            PEPieceImpl pePiece = pieces[i];
            if (pePiece != null) {
                long timeSinceActivity = pePiece.getTimeSinceLastActivity() / 1000L;
                int pieceSpeed = pePiece.getSpeed();
                if (pieceSpeed > 0 && (double)(timeSinceActivity * (long)pieceSpeed) * 0.25 > 16.0) {
                    if (pePiece.getNbUnrequested() > 2) {
                        pePiece.setSpeed(pieceSpeed - 1);
                    } else {
                        pePiece.setSpeed(0);
                    }
                }
                if (timeSinceActivity > 120L) {
                    pePiece.setSpeed(0);
                    String reservingPeer = pePiece.getReservedBy();
                    if (reservingPeer != null) {
                        PEPeerTransport pt = this.getTransportFromAddress(reservingPeer);
                        if (this.needsMD5CheckOnCompletion(i)) {
                            this.badPeerDetected(reservingPeer, i);
                        } else if (pt != null) {
                            this.closeAndRemovePeer(pt, "Reserved piece data timeout; 120 seconds", true);
                        }
                        pePiece.setReservedBy(null);
                    }
                    if (!this.piecePicker.isInEndGameMode()) {
                        pePiece.checkRequests();
                    }
                    this.checkEmptyPiece(i);
                }
            }
            ++i;
        }
    }

    private void check99PercentBug() {
        if (this.mainloop_loop_count % (long)MAINLOOP_SIXTY_SECOND_INTERVAL == 0L) {
            int hp_avail;
            long now = SystemTime.getCurrentTime();
            int i = 0;
            while (i < this.pePieces.length) {
                DiskManagerPiece dm_piece;
                PEPieceImpl pe_piece = this.pePieces[i];
                if (!(pe_piece == null || (dm_piece = this.dm_pieces[i]).isDone() || !pe_piece.isDownloaded() || now - pe_piece.getLastDownloadTime(now) <= (long)stalled_piece_timeout || this.disk_mgr.hasOutstandingWriteRequestForPiece(i) || this.disk_mgr.hasOutstandingReadRequestForPiece(i) || this.disk_mgr.hasOutstandingCheckRequestForPiece(i))) {
                    Debug.out("Fully downloaded piece stalled pending write, resetting p_piece " + i);
                    pe_piece.reset();
                }
                ++i;
            }
            if (this.hidden_piece >= 0 && (hp_avail = this.piecePicker.getAvailability(this.hidden_piece)) < (this.dm_pieces[this.hidden_piece].isDone() ? 2 : 1)) {
                int[] avails = this.piecePicker.getAvailability();
                int num = 0;
                int i2 = 0;
                while (i2 < avails.length) {
                    if (avails[i2] > 0 && !this.dm_pieces[i2].isDone() && this.pePieces[i2] == null) {
                        ++num;
                    }
                    ++i2;
                }
                if (num > 0) {
                    num = RandomUtils.nextInt(num);
                    int backup = -1;
                    int i3 = 0;
                    while (i3 < avails.length) {
                        if (avails[i3] > 0 && !this.dm_pieces[i3].isDone() && this.pePieces[i3] == null) {
                            if (backup == -1) {
                                backup = i3;
                            }
                            if (num == 0) {
                                this.hidden_piece = i3;
                                backup = -1;
                                break;
                            }
                            --num;
                        }
                        ++i3;
                    }
                    if (backup != -1) {
                        this.hidden_piece = backup;
                    }
                }
            }
        }
    }

    private void checkInterested() {
        if (this.mainloop_loop_count % (long)MAINLOOP_ONE_SECOND_INTERVAL != 0L) {
            return;
        }
        if (this.lastNeededUndonePieceChange >= this.piecePicker.getNeededUndonePieceChange()) {
            return;
        }
        this.lastNeededUndonePieceChange = this.piecePicker.getNeededUndonePieceChange();
        ArrayList<PEPeerTransport> peer_transports = this.peer_transports_cow;
        int cntPeersSnubbed = 0;
        int i = 0;
        while (i < peer_transports.size()) {
            PEPeerTransport peer = (PEPeerTransport)peer_transports.get(i);
            peer.checkInterested();
            if (peer.isSnubbed()) {
                ++cntPeersSnubbed;
            }
            ++i;
        }
        this.setNbPeersSnubbed(cntPeersSnubbed);
    }

    private void processPieceChecks() {
        if (this.piece_check_result_list.size() > 0) {
            ArrayList<Object[]> pieces;
            try {
                this.piece_check_result_list_mon.enter();
                pieces = new ArrayList<Object[]>(this.piece_check_result_list);
                this.piece_check_result_list.clear();
            }
            finally {
                this.piece_check_result_list_mon.exit();
            }
            for (Object[] data : pieces) {
                this.processPieceCheckResult((DiskManagerCheckRequest)data[0], (Integer)data[1]);
            }
        }
    }

    private void checkBadPieces() {
        if (this.mainloop_loop_count % (long)MAINLOOP_SIXTY_SECOND_INTERVAL == 0L && this.bad_piece_reported != -1) {
            DiskManagerCheckRequest req = this.disk_mgr.createCheckRequest(this.bad_piece_reported, new Integer(5));
            req.setLowPriority(true);
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(this.disk_mgr.getTorrent(), LOGID, "Rescanning reported-bad piece " + this.bad_piece_reported));
            }
            this.bad_piece_reported = -1;
            try {
                this.disk_mgr.enqueueCheckRequest(req, this);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void checkRescan() {
        if (this.rescan_piece_time == 0L) {
            return;
        }
        if (this.next_rescan_piece == -1) {
            if (this.mainloop_loop_count % (long)PEPeerControlImpl.MAINLOOP_FIVE_SECOND_INTERVAL == 0L && this.adapter.isPeriodicRescanEnabled()) {
                this.next_rescan_piece = 0;
            }
        } else if (this.mainloop_loop_count % (long)PEPeerControlImpl.MAINLOOP_TEN_MINUTE_INTERVAL == 0L && !this.adapter.isPeriodicRescanEnabled()) {
            this.next_rescan_piece = -1;
        }
        if (this.next_rescan_piece == -1) {
            return;
        }
        now = SystemTime.getCurrentTime();
        if (this.rescan_piece_time > now) {
            this.rescan_piece_time = now;
        }
        if (now - this.rescan_piece_time >= (millis_per_piece = (piece_size = (long)this.disk_mgr.getPieceLength()) / 250L)) ** GOTO lbl32
        return;
lbl-1000:
        // 1 sources

        {
            this_piece = this.next_rescan_piece++;
            if (this.next_rescan_piece == this._nbPieces) {
                this.next_rescan_piece = -1;
            }
            if (this.pePieces[this_piece] != null || this.dm_pieces[this_piece].isDone() || !this.dm_pieces[this_piece].isNeeded()) continue;
            req = this.disk_mgr.createCheckRequest(this_piece, new Integer(3));
            req.setLowPriority(true);
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(this.disk_mgr.getTorrent(), PEPeerControlImpl.LOGID, "Rescanning piece " + this_piece));
            }
            this.rescan_piece_time = 0L;
            try {
                this.disk_mgr.enqueueCheckRequest(req, this);
            }
            catch (Throwable e) {
                this.rescan_piece_time = now;
                Debug.printStackTrace(e);
            }
            break;
lbl32:
            // 2 sources

            ** while (this.next_rescan_piece != -1)
        }
lbl33:
        // 3 sources

    }

    @Override
    public void badPieceReported(PEPeerTransport originator, int piece_number) {
        Debug.outNoStack(String.valueOf(this.getDisplayName()) + ": bad piece #" + piece_number + " reported by " + originator.getIp());
        if (piece_number < 0 || piece_number >= this._nbPieces) {
            return;
        }
        this.bad_piece_reported = piece_number;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isFastExtensionPermitted(PEPeerTransport originator) {
        try {
            byte[] key = originator.getIp().getBytes("ISO-8859-1");
            BloomFilter bloomFilter = this.naughty_fast_extension_bloom;
            synchronized (bloomFilter) {
                int events = this.naughty_fast_extension_bloom.add(key);
                if (events < 5) {
                    return true;
                }
                Logger.log(new LogEvent(this.disk_mgr.getTorrent(), LOGID, "Fast extension disabled for " + originator.getIp() + " due to repeat connections"));
                return false;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reportBadFastExtensionUse(PEPeerTransport originator) {
        try {
            byte[] key = originator.getIp().getBytes("ISO-8859-1");
            BloomFilter bloomFilter = this.naughty_fast_extension_bloom;
            synchronized (bloomFilter) {
                if (this.naughty_fast_extension_bloom.add(key) == 5) {
                    Logger.log(new LogEvent(this.disk_mgr.getTorrent(), LOGID, "Fast extension disabled for " + originator.getIp() + " due to repeat requests for the same pieces"));
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void setStatsReceiver(PEPeerManager.StatsReceiver receiver) {
        this.stats_receiver = receiver;
    }

    @Override
    public void statsRequest(PEPeerTransport originator, Map request2) {
        HashMap reply = new HashMap();
        this.adapter.statsRequest(originator, request2, reply);
        if (reply.size() > 0) {
            originator.sendStatsReply(reply);
        }
    }

    @Override
    public void statsReply(PEPeerTransport originator, Map reply) {
        PEPeerManager.StatsReceiver receiver = this.stats_receiver;
        if (receiver != null) {
            receiver.receiveStats(originator, reply);
        }
    }

    private void checkFinished(boolean start_of_day) {
        boolean all_pieces_done;
        boolean bl = all_pieces_done = this.disk_mgr.getRemainingExcludingDND() == 0L;
        if (all_pieces_done) {
            this.seeding_mode = true;
            this.prefer_udp_bloom = null;
            this.piecePicker.clearEndGameChunks();
            if (!start_of_day) {
                this.adapter.setStateFinishing();
            }
            this._timeFinished = SystemTime.getCurrentTime();
            ArrayList<PEPeerTransport> peer_transports = this.peer_transports_cow;
            int i = 0;
            while (i < peer_transports.size()) {
                PEPeerTransport pc = (PEPeerTransport)peer_transports.get(i);
                pc.setSnubbed(false);
                ++i;
            }
            this.setNbPeersSnubbed(0);
            boolean checkPieces = COConfigurationManager.getBooleanParameter("Check Pieces on Completion");
            if (checkPieces && !start_of_day) {
                DiskManagerCheckRequest req = this.disk_mgr.createCheckRequest(-1, new Integer(2));
                this.disk_mgr.enqueueCompleteRecheckRequest(req, this);
            }
            this._timeStartedSeeding = SystemTime.getCurrentTime();
            this._timeStartedSeeding_mono = SystemTime.getMonotonousTime();
            try {
                this.disk_mgr.saveResumeData(false);
            }
            catch (Throwable e) {
                Debug.out("Failed to save resume data", e);
            }
            this.adapter.setStateSeeding(start_of_day);
            final AESemaphore waiting_it = new AESemaphore("PEC:DE");
            new AEThread2("PEC:DE"){

                @Override
                public void run() {
                    try {
                        PEPeerControlImpl.this.disk_mgr.downloadEnded(new DiskManager.OperationStatus(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void gonnaTakeAWhile(DiskManager.GettingThere gt) {
                                boolean async_set = false;
                                PEPeerControlImpl pEPeerControlImpl = PEPeerControlImpl.this;
                                synchronized (pEPeerControlImpl) {
                                    if (PEPeerControlImpl.this.finish_in_progress == null) {
                                        PEPeerControlImpl.this.finish_in_progress = gt;
                                        async_set = true;
                                    }
                                }
                                if (async_set) {
                                    waiting_it.release();
                                }
                            }
                        });
                    }
                    finally {
                        waiting_it.release();
                    }
                }
            }.start();
            waiting_it.reserve();
        } else {
            this.seeding_mode = false;
        }
    }

    protected void checkCompletionState() {
        boolean dm_done;
        if (this.mainloop_loop_count % (long)MAINLOOP_ONE_SECOND_INTERVAL != 0L) {
            return;
        }
        boolean bl = dm_done = this.disk_mgr.getRemainingExcludingDND() == 0L;
        if (this.seeding_mode) {
            if (!dm_done) {
                this.seeding_mode = false;
                this._timeStartedSeeding = -1L;
                this._timeStartedSeeding_mono = -1L;
                this._timeFinished = 0L;
                Logger.log(new LogEvent(this.disk_mgr.getTorrent(), LOGID, "Turning off seeding mode for PEPeerManager"));
            }
        } else if (dm_done) {
            this.checkFinished(false);
            if (this.seeding_mode) {
                Logger.log(new LogEvent(this.disk_mgr.getTorrent(), LOGID, "Turning on seeding mode for PEPeerManager"));
            }
        }
    }

    private void checkRequests() {
        if (this.mainloop_loop_count % (long)MAINLOOP_ONE_SECOND_INTERVAL != 0L) {
            return;
        }
        long now = SystemTime.getCurrentTime();
        ArrayList<PEPeerTransport> peer_transports = this.peer_transports_cow;
        int i = peer_transports.size() - 1;
        while (i >= 0) {
            List expired;
            PEPeerTransport pc = (PEPeerTransport)peer_transports.get(i);
            if (pc.getPeerState() == 30 && (expired = pc.getExpiredRequests()) != null && expired.size() > 0) {
                boolean isSeed = pc.isSeed();
                long timeSinceGoodData = pc.getTimeSinceGoodDataReceived();
                if (timeSinceGoodData < 0L || timeSinceGoodData > 60000L) {
                    pc.setSnubbed(true);
                }
                DiskManagerReadRequest request2 = (DiskManagerReadRequest)expired.get(0);
                long timeSinceData = pc.getTimeSinceLastDataMessageReceived();
                boolean noData = timeSinceData < 0L || timeSinceData > (long)(1000 * (isSeed ? 120 : 60));
                long timeSinceOldestRequest = now - request2.getTimeCreated(now);
                int j = timeSinceOldestRequest > 120000L && noData ? 0 : 1;
                while (j < expired.size()) {
                    request2 = (DiskManagerReadRequest)expired.get(j);
                    pc.sendCancel(request2);
                    int pieceNumber = request2.getPieceNumber();
                    PEPieceImpl pe_piece = this.pePieces[pieceNumber];
                    if (pe_piece != null) {
                        pe_piece.clearRequested(request2.getOffset() / 16384);
                    }
                    if (!this.piecePicker.isInEndGameMode()) {
                        this.checkEmptyPiece(pieceNumber);
                    }
                    ++j;
                }
            }
            --i;
        }
    }

    private void updateTrackerAnnounceInterval() {
        int num_wanted;
        if (this.mainloop_loop_count % (long)MAINLOOP_FIVE_SECOND_INTERVAL != 0L) {
            return;
        }
        int WANT_LIMIT = 100;
        int[] _num_wanted = this.getMaxNewConnectionsAllowed();
        if (_num_wanted[0] < 0) {
            num_wanted = 100;
        } else {
            num_wanted = _num_wanted[0] + _num_wanted[1];
            if (num_wanted > 100) {
                num_wanted = 100;
            }
        }
        boolean has_remote = this.adapter.isNATHealthy();
        if (has_remote) {
            num_wanted = (int)((double)num_wanted / 1.5);
        }
        int current_connection_count = PeerIdentityManager.getIdentityCount(this._hash);
        TRTrackerScraperResponse tsr = this.adapter.getTrackerScrapeResponse();
        if (tsr != null && tsr.isValid()) {
            int swarm_size;
            int num_seeds = tsr.getSeeds();
            int num_peers = tsr.getPeers();
            if (this.seeding_mode) {
                float ratio = (float)num_peers / (float)(num_seeds + num_peers);
                swarm_size = (int)((float)num_peers * ratio);
            } else {
                swarm_size = num_peers + num_seeds;
            }
            if (swarm_size < num_wanted) {
                num_wanted = swarm_size;
            }
        }
        if (num_wanted < 1) {
            this.adapter.setTrackerRefreshDelayOverrides(100);
            return;
        }
        if (current_connection_count == 0) {
            current_connection_count = 1;
        }
        int current_percent = current_connection_count * 100 / (current_connection_count + num_wanted);
        this.adapter.setTrackerRefreshDelayOverrides(current_percent);
    }

    @Override
    public boolean hasDownloadablePiece() {
        return this.piecePicker.hasDownloadablePiece();
    }

    @Override
    public int getBytesQueuedForUpload() {
        return this.bytes_queued_for_upload;
    }

    @Override
    public int getNbPeersWithUploadQueued() {
        return this.connections_with_queued_data;
    }

    @Override
    public int getNbPeersWithUploadBlocked() {
        return this.connections_with_queued_data_blocked;
    }

    @Override
    public int getNbPeersUnchoked() {
        return this.connections_unchoked;
    }

    @Override
    public int[] getAvailability() {
        return this.piecePicker.getAvailability();
    }

    @Override
    public float getMinAvailability() {
        return this.piecePicker.getMinAvailability();
    }

    @Override
    public float getMinAvailability(int file_index) {
        return this.piecePicker.getMinAvailability(file_index);
    }

    @Override
    public long getBytesUnavailable() {
        return this.piecePicker.getBytesUnavailable();
    }

    @Override
    public float getAvgAvail() {
        return this.piecePicker.getAvgAvail();
    }

    @Override
    public long getAvailWentBadTime() {
        long went_bad = this.piecePicker.getAvailWentBadTime();
        if ((double)this.piecePicker.getMinAvailability() < 1.0 && this.last_seed_disconnect_time > went_bad - 5000L) {
            went_bad = this.last_seed_disconnect_time;
        }
        return went_bad;
    }

    @Override
    public void addPeerTransport(PEPeerTransport transport) {
        if (!ip_filter.isInRange(transport.getIp(), this.getDisplayName(), this.getTorrentHash())) {
            ArrayList<PEPeerTransport> peer_transports = this.peer_transports_cow;
            if (!peer_transports.contains(transport)) {
                this.addToPeerTransports(transport);
            } else {
                Debug.out("addPeerTransport():: peer_transports.contains(transport): SHOULD NEVER HAPPEN !");
                transport.closeConnection("already connected");
            }
        } else {
            transport.closeConnection("IP address blocked by filters");
        }
    }

    private void doUnchokes() {
        if (this.mainloop_loop_count % (long)MAINLOOP_ONE_SECOND_INTERVAL != 0L) {
            return;
        }
        int max_to_unchoke = this.adapter.getMaxUploads();
        ArrayList<PEPeer> peer_transports = this.peer_transports_cow;
        if (this.seeding_mode) {
            if (this.unchoker == null || !this.unchoker.isSeedingUnchoker()) {
                this.unchoker = UnchokerFactory.getSingleton().getUnchoker(true);
            }
        } else if (this.unchoker == null || this.unchoker.isSeedingUnchoker()) {
            this.unchoker = UnchokerFactory.getSingleton().getUnchoker(false);
        }
        if (this.mainloop_loop_count % (long)MAINLOOP_TEN_SECOND_INTERVAL == 0L) {
            boolean do_high_latency_peers;
            boolean refresh = this.mainloop_loop_count % (long)MAINLOOP_THIRTY_SECOND_INTERVAL == 0L;
            boolean bl = do_high_latency_peers = this.mainloop_loop_count % (long)MAINLOOP_TWENTY_SECOND_INTERVAL == 0L;
            if (do_high_latency_peers) {
                boolean ok = false;
                String[] stringArray = AENetworkClassifier.AT_NON_PUBLIC;
                int n = AENetworkClassifier.AT_NON_PUBLIC.length;
                int n2 = 0;
                while (n2 < n) {
                    String net = stringArray[n2];
                    if (this.adapter.isNetworkEnabled(net)) {
                        ok = true;
                        break;
                    }
                    ++n2;
                }
                if (!ok) {
                    do_high_latency_peers = false;
                }
            }
            this.unchoker.calculateUnchokes(max_to_unchoke, peer_transports, refresh, this.adapter.hasPriorityConnection(), do_high_latency_peers);
            ArrayList<PEPeer> chokes = this.unchoker.getChokes();
            ArrayList<PEPeer> unchokes = this.unchoker.getUnchokes();
            this.addFastUnchokes(unchokes);
            UnchokerUtil.performChokes(chokes, unchokes);
        } else if (this.mainloop_loop_count % (long)MAINLOOP_ONE_SECOND_INTERVAL == 0L) {
            ArrayList<PEPeer> unchokes = this.unchoker.getImmediateUnchokes(max_to_unchoke, peer_transports);
            this.addFastUnchokes(unchokes);
            UnchokerUtil.performChokes(null, unchokes);
        }
    }

    private void addFastUnchokes(ArrayList peers_to_unchoke) {
        for (PEPeerTransport peer : this.peer_transports_cow) {
            if (peer.getConnectionState() != 4 || !UnchokerUtil.isUnchokable(peer, true) || peers_to_unchoke.contains(peer)) continue;
            if (peer.isLANLocal()) {
                peers_to_unchoke.add(peer);
                continue;
            }
            if (!fast_unchoke_new_peers || peer.getData("fast_unchoke_done") != null) continue;
            peer.setData("fast_unchoke_done", "");
            peers_to_unchoke.add(peer);
        }
    }

    private void sendHave(int pieceNumber) {
        ArrayList<PEPeerTransport> peer_transports = this.peer_transports_cow;
        int i = 0;
        while (i < peer_transports.size()) {
            PEPeerTransport pc = (PEPeerTransport)peer_transports.get(i);
            pc.sendHave(pieceNumber);
            ++i;
        }
    }

    private void checkSeeds() {
        if (this.mainloop_loop_count % (long)MAINLOOP_ONE_SECOND_INTERVAL != 0L) {
            return;
        }
        if (!disconnect_seeds_when_seeding) {
            return;
        }
        ArrayList<PEPeerTransport> to_close = null;
        ArrayList<PEPeerTransport> peer_transports = this.peer_transports_cow;
        int i = 0;
        while (i < peer_transports.size()) {
            PEPeerTransport pc = (PEPeerTransport)peer_transports.get(i);
            if (pc != null && pc.getPeerState() == 30 && (this.isSeeding() && pc.isSeed() || pc.isRelativeSeed())) {
                if (to_close == null) {
                    to_close = new ArrayList<PEPeerTransport>();
                }
                to_close.add(pc);
            }
            ++i;
        }
        if (to_close != null) {
            i = 0;
            while (i < to_close.size()) {
                this.closeAndRemovePeer((PEPeerTransport)to_close.get(i), "disconnect other seed when seeding", false);
                ++i;
            }
        }
    }

    private void updateStats() {
        if (this.mainloop_loop_count % (long)MAINLOOP_ONE_SECOND_INTERVAL != 0L) {
            return;
        }
        ++this.stats_tick_count;
        ArrayList<PEPeerTransport> peer_transports = this.peer_transports_cow;
        int new_pending_tcp_connections = 0;
        int new_connecting_tcp_connections = 0;
        int new_seeds = 0;
        int new_peers = 0;
        int new_tcp_incoming = 0;
        int new_udp_incoming = 0;
        int new_utp_incoming = 0;
        int bytes_queued = 0;
        int con_queued = 0;
        int con_blocked = 0;
        int con_unchoked = 0;
        for (PEPeerTransport pc : peer_transports) {
            if (pc.getPeerState() == 30) {
                Connection connection;
                if (!pc.isChokedByMe()) {
                    ++con_unchoked;
                }
                if ((connection = pc.getPluginConnection()) != null) {
                    OutgoingMessageQueue mq = connection.getOutgoingMessageQueue();
                    int q = mq.getDataQueuedBytes() + mq.getProtocolQueuedBytes();
                    bytes_queued += q;
                    if (q > 0) {
                        ++con_queued;
                        if (mq.isBlocked()) {
                            ++con_blocked;
                        }
                    }
                }
                if (pc.isSeed()) {
                    ++new_seeds;
                } else {
                    ++new_peers;
                }
                if (!pc.isIncoming() || pc.isLANLocal()) continue;
                if (pc.isTCP()) {
                    ++new_tcp_incoming;
                    continue;
                }
                String protocol = pc.getProtocol();
                if (protocol.equals("UDP")) {
                    ++new_udp_incoming;
                    continue;
                }
                ++new_utp_incoming;
                continue;
            }
            if (!pc.isTCP()) continue;
            int c_state = pc.getConnectionState();
            if (c_state == 0) {
                ++new_pending_tcp_connections;
                continue;
            }
            if (c_state != 1) continue;
            ++new_connecting_tcp_connections;
        }
        this._seeds = new_seeds;
        this._peers = new_peers;
        this._remotesTCPNoLan = new_tcp_incoming;
        this._remotesUDPNoLan = new_udp_incoming;
        this._remotesUTPNoLan = new_utp_incoming;
        this._tcpPendingConnections = new_pending_tcp_connections;
        this._tcpConnectingConnections = new_connecting_tcp_connections;
        this.bytes_queued_for_upload = bytes_queued;
        this.connections_with_queued_data = con_queued;
        this.connections_with_queued_data_blocked = con_blocked;
        this.connections_unchoked = con_unchoked;
        this._stats.update(this.stats_tick_count);
    }

    @Override
    public void requestCanceled(DiskManagerReadRequest request2) {
        int pieceNumber = request2.getPieceNumber();
        PEPieceImpl pe_piece = this.pePieces[pieceNumber];
        if (pe_piece != null) {
            pe_piece.clearRequested(request2.getOffset() / 16384);
        }
    }

    public PEPeerControl getControl() {
        return this;
    }

    @Override
    public byte[][] getSecrets(int crypto_level) {
        return this.adapter.getSecrets(crypto_level);
    }

    @Override
    public byte[] getHash() {
        return this._hash.getDataID();
    }

    @Override
    public PeerIdentityDataID getPeerIdentityDataID() {
        return this._hash;
    }

    @Override
    public byte[] getPeerId() {
        return this._myPeerId;
    }

    @Override
    public long getRemaining() {
        return this.disk_mgr.getRemaining();
    }

    @Override
    public void discarded(PEPeer peer, int length) {
        if (length > 0) {
            this._stats.discarded(peer, length);
            if (ban_peer_discard_ratio > 0.0f && !this.piecePicker.isInEndGameMode() && !this.piecePicker.hasEndGameModeBeenAbandoned()) {
                long discarded;
                long received = peer.getStats().getTotalDataBytesReceived();
                long non_discarded = received - (discarded = peer.getStats().getTotalBytesDiscarded());
                if (non_discarded < 0L) {
                    non_discarded = 0L;
                }
                if (discarded >= (long)ban_peer_discard_min_kb * 1024L && (non_discarded == 0L || (float)discarded / (float)non_discarded >= ban_peer_discard_ratio)) {
                    this.badPeerDetected(peer.getIp(), -1);
                }
            }
        }
    }

    @Override
    public void dataBytesReceived(PEPeer peer, int length) {
        if (length > 0) {
            this._stats.dataBytesReceived(peer, length);
            this._averageReceptionSpeed.addValue(length);
        }
    }

    @Override
    public void protocolBytesReceived(PEPeer peer, int length) {
        if (length > 0) {
            this._stats.protocolBytesReceived(peer, length);
        }
    }

    @Override
    public void dataBytesSent(PEPeer peer, int length) {
        if (length > 0) {
            this._stats.dataBytesSent(peer, length);
        }
    }

    @Override
    public void protocolBytesSent(PEPeer peer, int length) {
        if (length > 0) {
            this._stats.protocolBytesSent(peer, length);
        }
    }

    @Override
    public void writeCompleted(DiskManagerWriteRequest request2) {
        int pieceNumber = request2.getPieceNumber();
        DiskManagerPiece dm_piece = this.dm_pieces[pieceNumber];
        if (!dm_piece.isDone()) {
            PEPieceImpl pePiece = this.pePieces[pieceNumber];
            if (pePiece != null) {
                Object user_data = request2.getUserData();
                String key = user_data instanceof String ? (String)user_data : (user_data instanceof PEPeer ? ((PEPeer)user_data).getIp() : "<none>");
                pePiece.setWritten(key, request2.getOffset() / 16384);
            } else {
                dm_piece.setWritten(request2.getOffset() / 16384);
            }
        }
    }

    @Override
    public void writeFailed(DiskManagerWriteRequest request2, Throwable cause) {
    }

    @Override
    public void writeBlock(int pieceNumber, int offset, DirectByteBuffer data, Object sender, boolean cancel) {
        DiskManagerPiece dmPiece = this.dm_pieces[pieceNumber];
        int blockNumber = offset / 16384;
        if (dmPiece.isWritten(blockNumber)) {
            data.returnToPool();
            return;
        }
        PEPieceImpl pe_piece = this.pePieces[pieceNumber];
        if (pe_piece != null) {
            pe_piece.setDownloaded(offset);
        }
        DiskManagerWriteRequest request2 = this.disk_mgr.createWriteRequest(pieceNumber, offset, data, sender);
        this.disk_mgr.enqueueWriteRequest(request2, this);
        if (this.piecePicker.isInEndGameMode()) {
            this.piecePicker.removeFromEndGameModeChunks(pieceNumber, offset);
        }
        if (cancel || this.piecePicker.isInEndGameMode()) {
            ArrayList<PEPeerTransport> peer_transports = this.peer_transports_cow;
            int i = 0;
            while (i < peer_transports.size()) {
                PEPeerTransport connection = (PEPeerTransport)peer_transports.get(i);
                DiskManagerReadRequest dmr = this.disk_mgr.createReadRequest(pieceNumber, offset, dmPiece.getBlockSize(blockNumber));
                connection.sendCancel(dmr);
                ++i;
            }
        }
    }

    @Override
    public boolean isWritten(int piece_number, int offset) {
        return this.dm_pieces[piece_number].isWritten(offset / 16384);
    }

    @Override
    public boolean validateReadRequest(PEPeerTransport originator, int pieceNumber, int offset, int length) {
        if (this.disk_mgr.checkBlockConsistencyForRead(String.valueOf(originator.getClient()) + ": " + originator.getIp(), true, pieceNumber, offset, length)) {
            DiskManagerPiece dm_piece;
            int read_count;
            if (enable_seeding_piece_rechecks && this.isSeeding() && (read_count = (dm_piece = this.dm_pieces[pieceNumber]).getReadCount() & 0xFFFF) < 65525) {
                dm_piece.setReadCount((short)(++read_count));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean validateHintRequest(PEPeerTransport originator, int pieceNumber, int offset, int length) {
        return this.disk_mgr.checkBlockConsistencyForHint(String.valueOf(originator.getClient()) + ": " + originator.getIp(), pieceNumber, offset, length);
    }

    @Override
    public boolean validatePieceReply(PEPeerTransport originator, int pieceNumber, int offset, DirectByteBuffer data) {
        return this.disk_mgr.checkBlockConsistencyForWrite(String.valueOf(originator.getClient()) + ": " + originator.getIp(), pieceNumber, offset, data);
    }

    @Override
    public int getAvailability(int pieceNumber) {
        return this.piecePicker.getAvailability(pieceNumber);
    }

    @Override
    public void havePiece(int pieceNumber, int pieceLength, PEPeer pcOrigin) {
        int availability;
        this.piecePicker.addHavePiece(pcOrigin, pieceNumber);
        this._stats.haveNewPiece(pieceLength);
        if (this.superSeedMode) {
            this.superSeedPieces[pieceNumber].peerHasPiece(pcOrigin);
            if (pieceNumber == pcOrigin.getUniqueAnnounce()) {
                pcOrigin.setUniqueAnnounce(-1);
                --this.superSeedModeNumberOfAnnounces;
            }
        }
        if ((availability = this.piecePicker.getAvailability(pieceNumber) - 1) < 4) {
            if (this.dm_pieces[pieceNumber].isDone()) {
                --availability;
            }
            if (availability <= 0) {
                return;
            }
            ArrayList<PEPeerTransport> peer_transports = this.peer_transports_cow;
            int i = peer_transports.size() - 1;
            while (i >= 0) {
                PEPeerTransport pc = (PEPeerTransport)peer_transports.get(i);
                if (pc != pcOrigin && pc.getPeerState() == 30 && pc.isPieceAvailable(pieceNumber)) {
                    ((PEPeerStatsImpl)pc.getStats()).statisticalSentPiece(pieceLength / availability);
                }
                --i;
            }
        }
    }

    @Override
    public int getPieceLength(int pieceNumber) {
        return this.disk_mgr.getPieceLength(pieceNumber);
    }

    @Override
    public int getNbPeers() {
        return this._peers;
    }

    @Override
    public int getNbSeeds() {
        return this._seeds;
    }

    @Override
    public int getNbRemoteTCPConnections() {
        return this._remotesTCPNoLan;
    }

    @Override
    public int getNbRemoteUDPConnections() {
        return this._remotesUDPNoLan;
    }

    @Override
    public int getNbRemoteUTPConnections() {
        return this._remotesUTPNoLan;
    }

    @Override
    public long getLastRemoteConnectionTime() {
        return this.last_remote_time;
    }

    @Override
    public PEPeerManagerStats getStats() {
        return this._stats;
    }

    @Override
    public int getNbPeersStalledPendingLoad() {
        int res = 0;
        for (PEPeerTransport transport : this.peer_transports_cow) {
            if (!transport.isStalledPendingLoad()) continue;
            ++res;
        }
        return res;
    }

    @Override
    public long getETA(boolean smoothed) {
        long now = SystemTime.getCurrentTime();
        if (now < this.last_eta_calculation || now - this.last_eta_calculation > 900L) {
            long smooth_result;
            long jagged_result;
            long dataRemaining = this.disk_mgr.getRemainingExcludingDND();
            if (dataRemaining > 0L) {
                int writtenNotChecked = 0;
                int i = 0;
                while (i < this._nbPieces) {
                    if (this.dm_pieces[i].isInteresting()) {
                        writtenNotChecked += this.dm_pieces[i].getNbWritten() * 16384;
                    }
                    ++i;
                }
                if ((dataRemaining -= (long)writtenNotChecked) < 0L) {
                    dataRemaining = 0L;
                }
            }
            if (dataRemaining == 0L) {
                long timeElapsed = (this._timeFinished - this._timeStarted) / 1000L;
                jagged_result = timeElapsed > 1L ? timeElapsed * -1L : 0L;
                smooth_result = jagged_result;
            } else {
                long lETA;
                long averageSpeed = this._averageReceptionSpeed.getAverage();
                long l = lETA = averageSpeed == 0L ? 1827387392L : dataRemaining / averageSpeed;
                if (lETA == 0L) {
                    lETA = 1L;
                }
                jagged_result = lETA;
                averageSpeed = this._stats.getSmoothedDataReceiveRate();
                long l2 = lETA = averageSpeed == 0L ? 1827387392L : dataRemaining / averageSpeed;
                if (lETA == 0L) {
                    lETA = 1L;
                }
                smooth_result = lETA;
            }
            this.last_eta = jagged_result;
            this.last_eta_smoothed = smooth_result;
            this.last_eta_calculation = now;
        }
        return smoothed ? this.last_eta_smoothed : this.last_eta;
    }

    @Override
    public boolean isRTA() {
        return this.piecePicker.getRTAProviders().size() > 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addToPeerTransports(PEPeerTransport peer) {
        List<Object[]> limiters;
        boolean added = false;
        try {
            this.peer_transports_mon.enter();
            if (peer.getPeerState() == 50) {
                return;
            }
            if (this.peer_transports_cow.contains(peer)) {
                Debug.out("Transport added twice");
                return;
            }
            if (this.is_running) {
                ArrayList<PEPeerTransport> new_peer_transports = new ArrayList<PEPeerTransport>(this.peer_transports_cow.size() + 1);
                new_peer_transports.addAll(this.peer_transports_cow);
                new_peer_transports.add(peer);
                this.peer_transports_cow = new_peer_transports;
                added = true;
            }
            limiters = this.external_rate_limiters_cow;
        }
        finally {
            this.peer_transports_mon.exit();
        }
        if (added) {
            long connect_time;
            boolean incoming = peer.isIncoming();
            this._stats.haveNewConnection(incoming);
            if (incoming && (connect_time = SystemTime.getCurrentTime()) > this.last_remote_time) {
                this.last_remote_time = connect_time;
            }
            if (limiters != null) {
                int i = 0;
                while (i < limiters.size()) {
                    Object[] entry = limiters.get(i);
                    peer.addRateLimiter((LimitedRateGroup)entry[0], (Boolean)entry[1]);
                    ++i;
                }
            }
            this.peerAdded(peer);
            return;
        } else {
            peer.closeConnection("PeerTransport added when manager not running");
        }
    }

    @Override
    public void addRateLimiter(LimitedRateGroup group, boolean upload) {
        ArrayList<PEPeerTransport> transports;
        try {
            this.peer_transports_mon.enter();
            ArrayList<Object[]> new_limiters = new ArrayList<Object[]>(this.external_rate_limiters_cow == null ? 1 : this.external_rate_limiters_cow.size() + 1);
            if (this.external_rate_limiters_cow != null) {
                new_limiters.addAll(this.external_rate_limiters_cow);
            }
            new_limiters.add(new Object[]{group, upload});
            this.external_rate_limiters_cow = new_limiters;
            transports = this.peer_transports_cow;
        }
        finally {
            this.peer_transports_mon.exit();
        }
        int i = 0;
        while (i < transports.size()) {
            ((PEPeerTransport)transports.get(i)).addRateLimiter(group, upload);
            ++i;
        }
    }

    @Override
    public void removeRateLimiter(LimitedRateGroup group, boolean upload) {
        ArrayList<PEPeerTransport> transports;
        try {
            this.peer_transports_mon.enter();
            if (this.external_rate_limiters_cow != null) {
                ArrayList<Object[]> new_limiters = new ArrayList<Object[]>(this.external_rate_limiters_cow.size() - 1);
                int i = 0;
                while (i < this.external_rate_limiters_cow.size()) {
                    Object[] entry = this.external_rate_limiters_cow.get(i);
                    if (entry[0] != group) {
                        new_limiters.add(entry);
                    }
                    ++i;
                }
                this.external_rate_limiters_cow = new_limiters.size() == 0 ? null : new_limiters;
            }
            transports = this.peer_transports_cow;
        }
        finally {
            this.peer_transports_mon.exit();
        }
        int i = 0;
        while (i < transports.size()) {
            ((PEPeerTransport)transports.get(i)).removeRateLimiter(group, upload);
            ++i;
        }
    }

    @Override
    public int getUploadRateLimitBytesPerSecond() {
        return this.adapter.getUploadRateLimitBytesPerSecond();
    }

    @Override
    public int getDownloadRateLimitBytesPerSecond() {
        return this.adapter.getDownloadRateLimitBytesPerSecond();
    }

    @Override
    public void peerConnectionClosed(PEPeerTransport peer, boolean connect_failed, boolean network_failed) {
        boolean connection_found = false;
        boolean tcpReconnect = false;
        boolean ipv6reconnect = false;
        try {
            boolean canTryIpv6;
            this.peer_transports_mon.enter();
            int udpPort = peer.getUDPListenPort();
            boolean canTryUDP = UDPNetworkManager.UDP_OUTGOING_ENABLED && peer.getUDPListenPort() > 0;
            boolean bl = canTryIpv6 = NetworkAdmin.getSingleton().hasIPV6Potential(true) && peer.getAlternativeIPv6() != null;
            if (this.is_running) {
                PeerItem peer_item = peer.getPeerItemIdentity();
                PeerItem self_item = this.peer_database.getSelfPeer();
                if (self_item == null || !self_item.equals(peer_item)) {
                    boolean wasIPv6;
                    String ip = peer.getIp();
                    if (peer.getNetwork() == "Public") {
                        try {
                            wasIPv6 = AddressUtils.getByName(ip) instanceof Inet6Address;
                        }
                        catch (UnknownHostException e) {
                            wasIPv6 = false;
                            canTryIpv6 = false;
                        }
                    } else {
                        wasIPv6 = false;
                        canTryIpv6 = false;
                    }
                    String key = String.valueOf(ip) + ":" + udpPort;
                    if (peer.isTCP()) {
                        String net = AENetworkClassifier.categoriseAddress(ip);
                        if (connect_failed) {
                            if (canTryUDP && udp_fallback_for_failed_connection) {
                                this.pending_nat_traversals.put(key, peer);
                            } else if (canTryIpv6 && !wasIPv6) {
                                tcpReconnect = true;
                                ipv6reconnect = true;
                            }
                        } else if (canTryUDP && udp_fallback_for_dropped_connection && network_failed && this.seeding_mode && peer.isInterested() && !peer.isSeed() && !peer.isRelativeSeed() && peer.getStats().getEstimatedSecondsToCompletion() > 60L && FeatureAvailability.isUDPPeerReconnectEnabled()) {
                            if (Logger.isEnabled()) {
                                Logger.log(new LogEvent((Object)peer, LOGID, 1, "Unexpected stream closure detected, attempting recovery"));
                            }
                            this.udp_reconnects.put(key, peer);
                        } else if (network_failed && peer.isSafeForReconnect() && (!this.seeding_mode || !peer.isSeed() && !peer.isRelativeSeed() && peer.getStats().getEstimatedSecondsToCompletion() >= 60L) && this.getMaxConnections(net) > 0 && (this.getMaxNewConnectionsAllowed(net) < 0 || this.getMaxNewConnectionsAllowed(net) > this.getMaxConnections(net) / 3) && FeatureAvailability.isGeneralPeerReconnectEnabled()) {
                            tcpReconnect = true;
                        }
                    } else if (connect_failed && udp_fallback_for_failed_connection && peer.getData(PEER_NAT_TRAVERSE_DONE_KEY) == null) {
                        this.pending_nat_traversals.put(key, peer);
                    }
                }
            }
            if (this.peer_transports_cow.contains(peer)) {
                ArrayList<PEPeerTransport> new_peer_transports = new ArrayList<PEPeerTransport>(this.peer_transports_cow);
                new_peer_transports.remove(peer);
                this.peer_transports_cow = new_peer_transports;
                connection_found = true;
            }
        }
        finally {
            this.peer_transports_mon.exit();
        }
        if (connection_found) {
            if (peer.getPeerState() != 50) {
                System.out.println("peer.getPeerState() != PEPeer.DISCONNECTED: " + peer.getPeerState());
            }
            this.peerRemoved(peer);
        }
        if (tcpReconnect) {
            peer.reconnect(false, ipv6reconnect);
        }
    }

    @Override
    public void peerAdded(PEPeer pc) {
        this.adapter.addPeer(pc);
        ArrayList<PEPeerManagerListener> peer_manager_listeners = this.peer_manager_listeners_cow;
        int i = 0;
        while (i < peer_manager_listeners.size()) {
            peer_manager_listeners.get(i).peerAdded(this, pc);
            ++i;
        }
    }

    @Override
    public void peerRemoved(PEPeer pc) {
        int[] reserved_pieces;
        int piece;
        int udp;
        if (this.is_running && !this.seeding_mode && (this.prefer_udp || prefer_udp_default) && (udp = pc.getUDPListenPort()) != 0 && udp == pc.getTCPListenPort()) {
            BloomFilter filter2 = this.prefer_udp_bloom;
            if (filter2 == null) {
                filter2 = this.prefer_udp_bloom = BloomFilterFactory.createAddOnly(10000);
            }
            if (filter2.getEntryCount() < 1000) {
                filter2.add(pc.getIp().getBytes());
            }
        }
        if ((piece = pc.getUniqueAnnounce()) != -1 && this.superSeedMode) {
            --this.superSeedModeNumberOfAnnounces;
            this.superSeedPieces[piece].peerLeft();
        }
        if ((reserved_pieces = pc.getReservedPieceNumbers()) != null) {
            int[] nArray = reserved_pieces;
            int n = reserved_pieces.length;
            int n2 = 0;
            while (n2 < n) {
                String reserved_by;
                int reserved_piece = nArray[n2];
                PEPieceImpl pe_piece = this.pePieces[reserved_piece];
                if (pe_piece != null && (reserved_by = pe_piece.getReservedBy()) != null && reserved_by.equals(pc.getIp())) {
                    pe_piece.setReservedBy(null);
                }
                ++n2;
            }
        }
        if (pc.isSeed()) {
            this.last_seed_disconnect_time = SystemTime.getCurrentTime();
        }
        this.adapter.removePeer(pc);
        ArrayList<PEPeerManagerListener> peer_manager_listeners = this.peer_manager_listeners_cow;
        int i = 0;
        while (i < peer_manager_listeners.size()) {
            peer_manager_listeners.get(i).peerRemoved(this, pc);
            ++i;
        }
    }

    @Override
    public void addPiece(PEPiece piece, int pieceNumber, PEPeer for_peer) {
        this.addPiece(piece, pieceNumber, false, for_peer);
    }

    protected void addPiece(PEPiece piece, int pieceNumber, boolean force_add, PEPeer for_peer) {
        if (piece == null || this.pePieces[pieceNumber] != null) {
            Debug.out("piece state inconsistent");
        }
        this.pePieces[pieceNumber] = (PEPieceImpl)piece;
        ++this.nbPiecesActive;
        if (this.is_running || force_add) {
            this.adapter.addPiece(piece);
        }
        ArrayList<PEPeerManagerListener> peer_manager_listeners = this.peer_manager_listeners_cow;
        int i = 0;
        while (i < peer_manager_listeners.size()) {
            try {
                peer_manager_listeners.get(i).pieceAdded(this, piece, for_peer);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
    }

    public void removePiece(PEPiece pePiece, int pieceNumber) {
        if (pePiece != null) {
            this.adapter.removePiece(pePiece);
        } else {
            pePiece = this.pePieces[pieceNumber];
        }
        if (this.pePieces[pieceNumber] != null) {
            this.pePieces[pieceNumber] = null;
            --this.nbPiecesActive;
        }
        if (pePiece == null) {
            return;
        }
        ArrayList<PEPeerManagerListener> peer_manager_listeners = this.peer_manager_listeners_cow;
        int i = 0;
        while (i < peer_manager_listeners.size()) {
            try {
                peer_manager_listeners.get(i).pieceRemoved(this, pePiece);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
    }

    @Override
    public int getNbActivePieces() {
        return this.nbPiecesActive;
    }

    @Override
    public String getElapsedTime() {
        return TimeFormatter.format((SystemTime.getCurrentTime() - this._timeStarted) / 1000L);
    }

    @Override
    public long getTimeStarted(boolean mono) {
        return mono ? this._timeStarted_mono : this._timeStarted;
    }

    @Override
    public long getTimeStartedSeeding(boolean mono) {
        return mono ? this._timeStartedSeeding_mono : this._timeStartedSeeding;
    }

    private byte[] computeMd5Hash(DirectByteBuffer buffer) {
        BrokenMd5Hasher md5 = new BrokenMd5Hasher();
        md5.reset();
        int position = buffer.position((byte)8);
        md5.update(buffer.getBuffer((byte)8));
        buffer.position((byte)8, position);
        ByteBuffer md5Result = ByteBuffer.allocate(16);
        md5Result.position(0);
        md5.finalDigest(md5Result);
        byte[] result = new byte[16];
        md5Result.position(0);
        int i = 0;
        while (i < result.length) {
            result[i] = md5Result.get();
            ++i;
        }
        return result;
    }

    private void MD5CheckPiece(PEPiece piece, boolean correct) {
        String[] writers = piece.getWriters();
        int offset = 0;
        int i = 0;
        while (i < writers.length) {
            DirectByteBuffer buffer;
            int length = piece.getBlockSize(i);
            String peer = writers[i];
            if (peer != null && (buffer = this.disk_mgr.readBlock(piece.getPieceNumber(), offset, length)) != null) {
                byte[] hash = this.computeMd5Hash(buffer);
                buffer.returnToPool();
                buffer = null;
                piece.addWrite(i, peer, hash, correct);
            }
            offset += length;
            ++i;
        }
    }

    @Override
    public void checkCompleted(DiskManagerCheckRequest request2, boolean passed) {
        try {
            this.piece_check_result_list_mon.enter();
            this.piece_check_result_list.add(new Object[]{request2, new Integer(passed ? 1 : 0)});
        }
        finally {
            this.piece_check_result_list_mon.exit();
        }
    }

    @Override
    public void checkCancelled(DiskManagerCheckRequest request2) {
        try {
            this.piece_check_result_list_mon.enter();
            this.piece_check_result_list.add(new Object[]{request2, new Integer(2)});
        }
        finally {
            this.piece_check_result_list_mon.exit();
        }
    }

    @Override
    public void checkFailed(DiskManagerCheckRequest request2, Throwable cause) {
        try {
            this.piece_check_result_list_mon.enter();
            this.piece_check_result_list.add(new Object[]{request2, new Integer(0)});
        }
        finally {
            this.piece_check_result_list_mon.exit();
        }
    }

    @Override
    public boolean needsMD5CheckOnCompletion(int pieceNumber) {
        PEPieceImpl piece = this.pePieces[pieceNumber];
        if (piece == null) {
            return false;
        }
        return piece.getPieceWrites().size() > 0;
    }

    /*
     * Unable to fully structure code
     */
    private void processPieceCheckResult(DiskManagerCheckRequest request, int outcome) {
        block45: {
            check_type = (Integer)request.getUserData();
            try {
                block46: {
                    pieceNumber = request.getPieceNumber();
                    if (check_type == 2) {
                        if (outcome == 0) {
                            Debug.out(String.valueOf(this.getDisplayName()) + ": Piece #" + pieceNumber + " failed final re-check. Re-downloading...");
                            if (!this.restart_initiated) {
                                this.restart_initiated = true;
                                this.adapter.restartDownload(true);
                            }
                        }
lbl10:
                        // 8 sources

                        return;
                    }
                    if (check_type != 4 && check_type != 5) break block46;
                    if (outcome != 0) ** GOTO lbl10
                    if (check_type == 4) {
                        Debug.out(String.valueOf(this.getDisplayName()) + "Piece #" + pieceNumber + " failed recheck while seeding. Re-downloading...");
                    } else {
                        Debug.out(String.valueOf(this.getDisplayName()) + "Piece #" + pieceNumber + " failed recheck after being reported as bad. Re-downloading...");
                    }
                    Logger.log(new LogAlert((Object)this, true, 3, "Download '" + this.getDisplayName() + "': piece " + pieceNumber + " has been corrupted, re-downloading"));
                    if (this.restart_initiated) ** GOTO lbl10
                    this.restart_initiated = true;
                    this.adapter.restartDownload(true);
                    ** continue;
                }
                pePiece = this.pePieces[pieceNumber];
                if (outcome == 1 || this.is_metadata_download) {
                    try {
                        if (pePiece != null) {
                            if (this.needsMD5CheckOnCompletion(pieceNumber)) {
                                this.MD5CheckPiece(pePiece, true);
                            }
                            if ((list = pePiece.getPieceWrites()).size() > 0) {
                                i = 0;
                                while (i < pePiece.getNbBlocks()) {
                                    listPerBlock = pePiece.getPieceWrites(i);
                                    correctHash = null;
                                    for (PEPieceWriteImpl write : listPerBlock) {
                                        if (!write.isCorrect()) continue;
                                        correctHash = write.getHash();
                                    }
                                    if (correctHash != null) {
                                        for (PEPieceWriteImpl write : listPerBlock) {
                                            if (Arrays.equals(write.getHash(), correctHash)) continue;
                                            this.badPeerDetected(write.getSender(), pieceNumber);
                                        }
                                    }
                                    ++i;
                                }
                            }
                        }
                        break block45;
                    }
                    finally {
                        this.removePiece(pePiece, pieceNumber);
                        this.sendHave(pieceNumber);
                    }
                }
                if (outcome == 0) {
                    it = this.peer_manager_listeners_cow.iterator();
                    while (it.hasNext()) {
                        try {
                            it.next().pieceCorrupted(this, pieceNumber);
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                    if (pePiece != null) {
                        try {
                            this.MD5CheckPiece(pePiece, false);
                            writers = pePiece.getWriters();
                            uniqueWriters = new ArrayList<String>();
                            writesPerWriter = new int[writers.length];
                            i = 0;
                            while (i < writers.length) {
                                writer = writers[i];
                                if (writer != null) {
                                    writerId = uniqueWriters.indexOf(writer);
                                    if (writerId == -1) {
                                        uniqueWriters.add(writer);
                                        writerId = uniqueWriters.size() - 1;
                                    }
                                    v0 = writerId;
                                    writesPerWriter[v0] = writesPerWriter[v0] + 1;
                                }
                                ++i;
                            }
                            nbWriters = uniqueWriters.size();
                            if (nbWriters == 1) {
                                bad_ip = (String)uniqueWriters.get(0);
                                bad_peer = this.getTransportFromAddress(bad_ip);
                                if (bad_peer != null) {
                                    bad_peer.sendBadPiece(pieceNumber);
                                }
                                this.badPeerDetected(bad_ip, pieceNumber);
                                pePiece.reset();
                            } else if (nbWriters > 1) {
                                maxWrites = 0;
                                bestWriter = null;
                                bestWriter_transport = null;
                                i = 0;
                                while (i < uniqueWriters.size()) {
                                    writes = writesPerWriter[i];
                                    if (writes > maxWrites && (pt = this.getTransportFromAddress(writer = (String)uniqueWriters.get(i))) != null && pt.getReservedPieceNumbers() == null && !PEPeerControlImpl.ip_filter.isInRange(writer, this.getDisplayName(), this.getTorrentHash())) {
                                        bestWriter = writer;
                                        maxWrites = writes;
                                        bestWriter_transport = pt;
                                    }
                                    ++i;
                                }
                                if (bestWriter != null) {
                                    pePiece.setReservedBy(bestWriter);
                                    bestWriter_transport.addReservedPieceNumber(pePiece.getPieceNumber());
                                    pePiece.setRequestable();
                                    i = 0;
                                    while (i < pePiece.getNbBlocks()) {
                                        if (writers[i] == null || !writers[i].equals(bestWriter)) {
                                            pePiece.reDownloadBlock(i);
                                        }
                                        ++i;
                                    }
                                } else {
                                    pePiece.reset();
                                }
                            } else {
                                pePiece.reset();
                            }
                            this.piecePicker.addEndGameChunks(pePiece);
                            this._stats.hashFailed(pePiece.getLength());
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                            pePiece.reset();
                        }
                    } else {
                        this.dm_pieces[pieceNumber].reset();
                    }
                }
            }
            finally {
                if (check_type == 3) {
                    this.rescan_piece_time = SystemTime.getCurrentTime();
                }
                if (!this.seeding_mode) {
                    this.checkFinished(false);
                }
            }
        }
    }

    private void badPeerDetected(String ip, int piece_number) {
        int ps;
        boolean hash_fail = piece_number >= 0;
        PEPeerTransport peer = this.getTransportFromAddress(ip);
        if (hash_fail && peer != null) {
            Iterator<PEPeerManagerListener> it = this.peer_manager_listeners_cow.iterator();
            while (it.hasNext()) {
                try {
                    it.next().peerSentBadData(this, peer, piece_number);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
        IpFilterManager filter_manager = IpFilterManagerFactory.getSingleton();
        int nbWarnings = filter_manager.getBadIps().addWarningForIp(ip);
        boolean disconnect_peer = false;
        if (nbWarnings > 2) {
            if (COConfigurationManager.getBooleanParameter("Ip Filter Enable Banning")) {
                if (ip_filter.ban(ip, this.getDisplayName(), false)) {
                    this.checkForBannedConnections();
                }
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent((Object)peer, LOGID, 3, String.valueOf(ip) + " : has been banned and won't be able " + "to connect until you restart azureus"));
                }
                disconnect_peer = true;
            }
        } else if (!hash_fail) {
            disconnect_peer = true;
        }
        if (disconnect_peer && peer != null && (ps = peer.getPeerState()) != 40 && ps != 50) {
            this.closeAndRemovePeer(peer, "has sent too many " + (hash_fail ? "bad pieces" : "discarded blocks") + ", " + 2 + " max.", true);
        }
    }

    @Override
    public PEPiece[] getPieces() {
        return this.pePieces;
    }

    @Override
    public PEPiece getPiece(int pieceNumber) {
        return this.pePieces[pieceNumber];
    }

    @Override
    public PEPeerStats createPeerStats(PEPeer owner) {
        return new PEPeerStatsImpl(owner);
    }

    @Override
    public DiskManagerReadRequest createDiskManagerRequest(int pieceNumber, int offset, int length) {
        return this.disk_mgr.createReadRequest(pieceNumber, offset, length);
    }

    @Override
    public boolean requestExists(String peer_ip, int piece_number, int offset, int length) {
        ArrayList<PEPeerTransport> peer_transports = this.peer_transports_cow;
        DiskManagerReadRequest request2 = null;
        int i = 0;
        while (i < peer_transports.size()) {
            PEPeerTransport conn = (PEPeerTransport)peer_transports.get(i);
            if (conn.getIp().equals(peer_ip)) {
                if (request2 == null) {
                    request2 = this.createDiskManagerRequest(piece_number, offset, length);
                }
                if (conn.getRequestIndex(request2) != -1) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean seedPieceRecheck() {
        DiskManagerPiece dm_piece;
        if (!enable_seeding_piece_rechecks && !this.isSeeding()) {
            return false;
        }
        int max_reads = 0;
        int max_reads_index = 0;
        int i = 0;
        while (i < this.dm_pieces.length) {
            DiskManagerPiece dm_piece2 = this.dm_pieces[i];
            if (dm_piece2.isDone()) {
                int num = dm_piece2.getReadCount() & 0xFFFF;
                if (num > 65526) {
                    if (--num == 65526) {
                        num = 0;
                    }
                    dm_piece2.setReadCount((short)num);
                } else if (num > max_reads) {
                    max_reads = num;
                    max_reads_index = i;
                }
            }
            ++i;
        }
        if (max_reads > 0 && max_reads >= (dm_piece = this.dm_pieces[max_reads_index]).getNbBlocks() * 3) {
            DiskManagerCheckRequest req = this.disk_mgr.createCheckRequest(max_reads_index, new Integer(4));
            req.setAdHoc(true);
            req.setLowPriority(true);
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(this.disk_mgr.getTorrent(), LOGID, "Rechecking piece " + max_reads_index + " while seeding as most active"));
            }
            this.disk_mgr.enqueueCheckRequest(req, this);
            dm_piece.setReadCount((short)-1);
            int i2 = 0;
            while (i2 < this.dm_pieces.length) {
                int num;
                if (i2 != max_reads_index && (num = this.dm_pieces[i2].getReadCount() & 0xFFFF) < 65526) {
                    this.dm_pieces[i2].setReadCount((short)0);
                }
                ++i2;
            }
            return true;
        }
        return false;
    }

    @Override
    public void addListener(PEPeerManagerListener l) {
        try {
            this.this_mon.enter();
            ArrayList<PEPeerManagerListener> peer_manager_listeners = new ArrayList<PEPeerManagerListener>(this.peer_manager_listeners_cow.size() + 1);
            peer_manager_listeners.addAll(this.peer_manager_listeners_cow);
            peer_manager_listeners.add(l);
            this.peer_manager_listeners_cow = peer_manager_listeners;
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void removeListener(PEPeerManagerListener l) {
        try {
            this.this_mon.enter();
            ArrayList<PEPeerManagerListener> peer_manager_listeners = new ArrayList<PEPeerManagerListener>(this.peer_manager_listeners_cow);
            peer_manager_listeners.remove(l);
            this.peer_manager_listeners_cow = peer_manager_listeners;
        }
        finally {
            this.this_mon.exit();
        }
    }

    private void checkForBannedConnections() {
        if (ip_filter.isEnabled()) {
            ArrayList<PEPeerTransport> to_close = null;
            ArrayList<PEPeerTransport> peer_transports = this.peer_transports_cow;
            String name = this.getDisplayName();
            byte[] hash = this.getTorrentHash();
            int i = 0;
            while (i < peer_transports.size()) {
                PEPeerTransport conn = (PEPeerTransport)peer_transports.get(i);
                if (ip_filter.isInRange(conn.getIp(), name, hash)) {
                    if (to_close == null) {
                        to_close = new ArrayList<PEPeerTransport>();
                    }
                    to_close.add(conn);
                }
                ++i;
            }
            if (to_close != null) {
                i = 0;
                while (i < to_close.size()) {
                    this.closeAndRemovePeer((PEPeerTransport)to_close.get(i), "IPFilter banned IP address", true);
                    ++i;
                }
            }
        }
    }

    @Override
    public boolean isSeeding() {
        return this.seeding_mode;
    }

    @Override
    public boolean isMetadataDownload() {
        return this.is_metadata_download;
    }

    @Override
    public int getTorrentInfoDictSize() {
        return this.metadata_infodict_size;
    }

    @Override
    public void setTorrentInfoDictSize(int size) {
        this.metadata_infodict_size = size;
    }

    @Override
    public boolean isInEndGameMode() {
        return this.piecePicker.isInEndGameMode();
    }

    @Override
    public boolean isSuperSeedMode() {
        return this.superSeedMode;
    }

    @Override
    public boolean canToggleSuperSeedMode() {
        if (this.superSeedMode) {
            return true;
        }
        return this.superSeedPieces == null && this.getRemaining() == 0L;
    }

    @Override
    public void setSuperSeedMode(boolean _superSeedMode) {
        if (_superSeedMode == this.superSeedMode) {
            return;
        }
        boolean kick_peers = false;
        if (_superSeedMode) {
            if (this.superSeedPieces == null && this.getRemaining() == 0L) {
                this.superSeedMode = true;
                this.initialiseSuperSeedMode();
                kick_peers = true;
            }
        } else {
            this.superSeedMode = false;
            kick_peers = true;
        }
        if (kick_peers) {
            ArrayList<PEPeerTransport> peer_transports = this.peer_transports_cow;
            int i = 0;
            while (i < peer_transports.size()) {
                PEPeerTransport conn = (PEPeerTransport)peer_transports.get(i);
                this.closeAndRemovePeer(conn, "Turning on super-seeding", false);
                ++i;
            }
        }
    }

    private void initialiseSuperSeedMode() {
        this.superSeedPieces = new SuperSeedPiece[this._nbPieces];
        int i = 0;
        while (i < this._nbPieces) {
            this.superSeedPieces[i] = new SuperSeedPiece(this, i);
            ++i;
        }
    }

    private void updatePeersInSuperSeedMode() {
        if (!this.superSeedMode) {
            return;
        }
        int i = 0;
        while (i < this.superSeedPieces.length) {
            this.superSeedPieces[i].updateTime();
            ++i;
        }
        int nbUnchoke = this.adapter.getMaxUploads();
        if (this.superSeedModeNumberOfAnnounces >= 2 * nbUnchoke) {
            return;
        }
        PEPeer selectedPeer = null;
        ArrayList<SuperSeedPeer> sortedPeers = null;
        ArrayList<PEPeerTransport> peer_transports = this.peer_transports_cow;
        sortedPeers = new ArrayList<SuperSeedPeer>(peer_transports.size());
        Iterator iter1 = peer_transports.iterator();
        while (iter1.hasNext()) {
            sortedPeers.add(new SuperSeedPeer((PEPeerTransport)iter1.next()));
        }
        Collections.sort(sortedPeers);
        Iterator iter2 = sortedPeers.iterator();
        while (iter2.hasNext()) {
            PEPeerTransport peer = ((SuperSeedPeer)iter2.next()).peer;
            if (peer.getUniqueAnnounce() != -1 || peer.getPeerState() != 30) continue;
            selectedPeer = peer;
            break;
        }
        if (selectedPeer == null || selectedPeer.getPeerState() >= 40) {
            return;
        }
        if (selectedPeer.getUploadHint() == 0) {
            selectedPeer.setUploadHint(31536000);
        }
        boolean found = false;
        SuperSeedPiece piece = null;
        boolean loopdone = false;
        while (!found) {
            piece = this.superSeedPieces[this.superSeedModeCurrentPiece];
            if (piece.getLevel() > 0) {
                piece = null;
                ++this.superSeedModeCurrentPiece;
                if (this.superSeedModeCurrentPiece < this._nbPieces) continue;
                this.superSeedModeCurrentPiece = 0;
                if (loopdone) {
                    this.superSeedMode = false;
                    this.closeAndRemoveAllPeers("quiting SuperSeed mode", true);
                    return;
                }
                loopdone = true;
                continue;
            }
            found = true;
        }
        if (piece == null) {
            return;
        }
        if (selectedPeer.isPieceAvailable(piece.getPieceNumber())) {
            return;
        }
        selectedPeer.setUniqueAnnounce(piece.getPieceNumber());
        ++this.superSeedModeNumberOfAnnounces;
        piece.pieceRevealedToPeer();
        selectedPeer.sendHave(piece.getPieceNumber());
    }

    @Override
    public void updateSuperSeedPiece(PEPeer peer, int pieceNumber) {
        if (!this.superSeedMode) {
            return;
        }
        this.superSeedPieces[pieceNumber].peerHasPiece(null);
        if (peer.getUniqueAnnounce() == pieceNumber) {
            peer.setUniqueAnnounce(-1);
            --this.superSeedModeNumberOfAnnounces;
        }
    }

    @Override
    public boolean isPrivateTorrent() {
        return this.is_private_torrent;
    }

    @Override
    public int getExtendedMessagingMode() {
        return this.adapter.getExtendedMessagingMode();
    }

    @Override
    public boolean isPeerExchangeEnabled() {
        return this.adapter.isPeerExchangeEnabled();
    }

    @Override
    public LimitedRateGroup getUploadLimitedRateGroup() {
        return this.upload_limited_rate_group;
    }

    @Override
    public LimitedRateGroup getDownloadLimitedRateGroup() {
        return this.download_limited_rate_group;
    }

    @Override
    public Object getData(String key) {
        try {
            this.this_mon.enter();
            if (this.user_data == null) {
                return null;
            }
            Object object = this.user_data.get(key);
            return object;
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void setData(String key, Object value) {
        try {
            this.this_mon.enter();
            if (this.user_data == null) {
                this.user_data = new HashMap<Object, Object>();
            }
            if (value == null) {
                if (this.user_data.containsKey(key)) {
                    this.user_data.remove(key);
                }
            } else {
                this.user_data.put(key, value);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public int getConnectTimeout(int ct_def) {
        int max;
        int lower_limit;
        if (ct_def <= 0) {
            return ct_def;
        }
        if (this.seeding_mode) {
            return ct_def;
        }
        int max_sim_con = TCPConnectionManager.MAX_SIMULTANIOUS_CONNECT_ATTEMPTS;
        if (max_sim_con >= 50) {
            return ct_def;
        }
        int connected = this._seeds + this._peers;
        int connecting = this._tcpConnectingConnections;
        int queued = this._tcpPendingConnections;
        int not_yet_connected = this.peer_database.getDiscoveredPeerCount();
        int potential = connecting + queued + not_yet_connected;
        if (potential <= (lower_limit = (max = this.getMaxConnections("")) / 4) || max == lower_limit) {
            return ct_def;
        }
        int MIN_CT = 7500;
        if (potential >= max) {
            return 7500;
        }
        int pos = potential - lower_limit;
        int scale = max - lower_limit;
        int res = 7500 + (ct_def - 7500) * (scale - pos) / scale;
        return res;
    }

    private void doConnectionChecks() {
        ArrayList<PEPeerTransport> peer_transports;
        int goal;
        long last_update;
        ArrayList<PEPeerTransport> peer_transports2;
        if (this.mainloop_loop_count % (long)MAINLOOP_ONE_SECOND_INTERVAL == 0L) {
            int[] allowed_info;
            int allowed_base;
            peer_transports2 = this.peer_transports_cow;
            int num_waiting_establishments = 0;
            int udp_connections = 0;
            int i = 0;
            while (i < peer_transports2.size()) {
                PEPeerTransport transport = (PEPeerTransport)peer_transports2.get(i);
                int state = transport.getConnectionState();
                if (state == 0 || state == 1) {
                    ++num_waiting_establishments;
                }
                if (!transport.isTCP()) {
                    ++udp_connections;
                }
                ++i;
            }
            int[] allowed_seeds_info = this.getMaxSeedConnections();
            int base_allowed_seeds = allowed_seeds_info[0];
            if (base_allowed_seeds > 0) {
                int extra_seeds = allowed_seeds_info[1];
                int to_disconnect = this._seeds - base_allowed_seeds;
                if (to_disconnect > 0) {
                    HashSet<PEPeerTransport> to_retain = new HashSet<PEPeerTransport>();
                    if (extra_seeds > 0) {
                        for (PEPeerTransport transport : peer_transports2) {
                            if (!transport.isSeed() || transport.getNetwork() == "Public") continue;
                            to_retain.add(transport);
                            if (to_retain.size() == extra_seeds) break;
                        }
                        to_disconnect -= to_retain.size();
                    }
                    int i2 = peer_transports2.size() - 1;
                    while (i2 >= 0 && to_disconnect > 0) {
                        PEPeerTransport transport = (PEPeerTransport)peer_transports2.get(i2);
                        if (transport.isSeed() && !to_retain.contains(transport)) {
                            this.closeAndRemovePeer(transport, "Too many seeds", false);
                            --to_disconnect;
                        }
                        --i2;
                    }
                }
            }
            if ((allowed_base = (allowed_info = this.getMaxNewConnectionsAllowed())[0]) < 0 || allowed_base > 1000) {
                allowed_info[0] = allowed_base = 1000;
            }
            if (this.adapter.isNATHealthy()) {
                int free = this.getMaxConnections()[0] / 20;
                allowed_info[0] = allowed_base -= free;
            }
            int i3 = 0;
            while (i3 < allowed_info.length) {
                int allowed = allowed_info[i3];
                if (allowed > 0) {
                    int wanted = TCPConnectionManager.MAX_SIMULTANIOUS_CONNECT_ATTEMPTS - num_waiting_establishments;
                    if (wanted > allowed) {
                        num_waiting_establishments += wanted - allowed;
                    }
                    int remaining = allowed;
                    int tcp_remaining = TCPNetworkManager.getSingleton().getConnectDisconnectManager().getMaxOutboundPermitted();
                    int udp_remaining = UDPNetworkManager.getSingleton().getConnectionManager().getMaxOutboundPermitted();
                    while (num_waiting_establishments < TCPConnectionManager.MAX_SIMULTANIOUS_CONNECT_ATTEMPTS && (tcp_remaining > 0 || udp_remaining > 0)) {
                        boolean udp_ok;
                        boolean prefer_udp_overall;
                        PeerItem item;
                        if (!this.is_running || (item = this.peer_database.getNextOptimisticConnectPeer(i3 == 1)) == null || !this.is_running) break;
                        PeerItem self = this.peer_database.getSelfPeer();
                        if (self != null && self.equals(item) || this.isAlreadyConnected(item)) continue;
                        String source = PeerItem.convertSourceString(item.getSource());
                        boolean use_crypto = item.getHandshakeType() == 1;
                        int tcp_port = item.getTCPPort();
                        int udp_port = item.getUDPPort();
                        if (udp_port == 0 && udp_probe_enabled) {
                            udp_port = tcp_port;
                        }
                        boolean bl = prefer_udp_overall = this.prefer_udp || prefer_udp_default;
                        if (prefer_udp_overall && udp_port == 0) {
                            byte[] address = item.getIP().getBytes();
                            BloomFilter bloom = this.prefer_udp_bloom;
                            if (bloom != null && bloom.contains(address)) {
                                udp_port = tcp_port;
                            }
                        }
                        boolean tcp_ok = TCPNetworkManager.TCP_OUTGOING_ENABLED && tcp_port > 0 && tcp_remaining > 0;
                        boolean bl2 = udp_ok = UDPNetworkManager.UDP_OUTGOING_ENABLED && udp_port > 0 && udp_remaining > 0;
                        if (!(!tcp_ok || prefer_udp_overall && udp_ok)) {
                            if (this.makeNewOutgoingConnection(source, item.getAddressString(), tcp_port, udp_port, true, use_crypto, item.getCryptoLevel(), null) != null) continue;
                            --tcp_remaining;
                            ++num_waiting_establishments;
                            --remaining;
                            continue;
                        }
                        if (!udp_ok || this.makeNewOutgoingConnection(source, item.getAddressString(), tcp_port, udp_port, false, use_crypto, item.getCryptoLevel(), null) != null) continue;
                        --udp_remaining;
                        ++num_waiting_establishments;
                        --remaining;
                    }
                    if (i3 == 0 && UDPNetworkManager.UDP_OUTGOING_ENABLED && remaining > 0 && udp_remaining > 0 && udp_connections < 16) {
                        this.doUDPConnectionChecks(remaining);
                    }
                }
                ++i3;
            }
        }
        if (this.mainloop_loop_count % (long)MAINLOOP_FIVE_SECOND_INTERVAL == 0L) {
            peer_transports2 = this.peer_transports_cow;
            int i = 0;
            while (i < peer_transports2.size()) {
                PEPeerTransport transport = (PEPeerTransport)peer_transports2.get(i);
                if (!transport.doTimeoutChecks()) {
                    transport.doKeepAliveCheck();
                    transport.doPerformanceTuningCheck();
                }
                ++i;
            }
        }
        if (this.mainloop_loop_count % (long)MAINLOOP_TEN_SECOND_INTERVAL == 0L && (last_update = ip_filter.getLastUpdateTime()) != this.ip_filter_last_update_time) {
            this.ip_filter_last_update_time = last_update;
            this.checkForBannedConnections();
        }
        if (this.mainloop_loop_count % (long)MAINLOOP_THIRTY_SECOND_INTERVAL == 0L) {
            this.optimisticDisconnectCount = 0;
            int[] allowed = this.getMaxNewConnectionsAllowed();
            if (allowed[0] + allowed[1] == 0) {
                this.doOptimisticDisconnect(false, false, "");
            }
        }
        float percentage = ((float)(this.mainloop_loop_count % (long)MAINLOOP_SIXTY_SECOND_INTERVAL) + 1.0f) / (1.0f * (float)MAINLOOP_SIXTY_SECOND_INTERVAL);
        if (this.mainloop_loop_count % (long)MAINLOOP_SIXTY_SECOND_INTERVAL == 0L) {
            goal = 0;
            this.sweepList = this.peer_transports_cow;
        } else {
            goal = (int)Math.floor(percentage * (float)this.sweepList.size());
        }
        int i = this.nextPEXSweepIndex;
        while (i < goal && i < this.sweepList.size()) {
            PEPeerTransport peer = this.sweepList.get(i);
            peer.updatePeerExchange();
            ++i;
        }
        this.nextPEXSweepIndex = goal;
        if (this.mainloop_loop_count % (long)MAINLOOP_SIXTY_SECOND_INTERVAL == 0L && (peer_transports = this.peer_transports_cow).size() > 1) {
            HashMap<String, ArrayList<PEPeerTransport>> peer_map = new HashMap<String, ArrayList<PEPeerTransport>>();
            for (PEPeerTransport peer : peer_transports) {
                if (peer.isIncoming() || peer.getPeerState() != 10 || peer.getConnectionState() != 1 || peer.getLastMessageSentTime() == 0L) continue;
                String key = String.valueOf(peer.getIp()) + ":" + peer.getPort();
                ArrayList<PEPeerTransport> list = (ArrayList<PEPeerTransport>)peer_map.get(key);
                if (list == null) {
                    list = new ArrayList<PEPeerTransport>(1);
                    peer_map.put(key, list);
                }
                list.add(peer);
            }
            for (List list : peer_map.values()) {
                if (list.size() < 2) continue;
                long newest_time = Long.MIN_VALUE;
                PEPeerTransport newest_peer = null;
                for (PEPeerTransport peer : list) {
                    long last_sent = peer.getLastMessageSentTime();
                    if (last_sent <= newest_time) continue;
                    newest_time = last_sent;
                    newest_peer = peer;
                }
                for (PEPeerTransport peer : list) {
                    if (peer == newest_peer || peer.getPeerState() != 10 || peer.getConnectionState() != 1) continue;
                    this.closeAndRemovePeer(peer, "Removing old duplicate connection", false);
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    private void doUDPConnectionChecks(int number) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 16[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean doOptimisticDisconnect(boolean pending_lan_local_peer, boolean force, String network) {
        int maxOptimistics;
        long medianConnectionTime;
        int non_pub_extra;
        if (network != "I2P") {
            int[] max_con = this.getMaxConnections();
            non_pub_extra = max_con[1];
        } else {
            non_pub_extra = 0;
        }
        ArrayList<PEPeerTransport> peer_transports = this.peer_transports_cow;
        PEPeerTransport max_transport = null;
        PEPeerTransport max_seed_transport = null;
        PEPeerTransport max_non_lan_transport = null;
        PEPeerTransport max_pub_transport = null;
        PEPeerTransport max_pub_seed_transport = null;
        PEPeerTransport max_pub_non_lan_transport = null;
        long max_time = 0L;
        long max_seed_time = 0L;
        long max_non_lan_time = 0L;
        long max_pub_time = 0L;
        long max_pub_seed_time = 0L;
        long max_pub_non_lan_time = 0L;
        int non_pub_found = 0;
        ArrayList<Long> activeConnectionTimes = new ArrayList<Long>(peer_transports.size());
        int lan_peer_count = 0;
        int i = 0;
        while (i < peer_transports.size()) {
            PEPeerTransport peer = (PEPeerTransport)peer_transports.get(i);
            if (peer.getConnectionState() == 4) {
                boolean count_pubs;
                long timeSinceConnection = peer.getTimeSinceConnectionEstablished();
                long timeSinceSentData = peer.getTimeSinceLastDataMessageSent();
                activeConnectionTimes.add(timeSinceConnection);
                long peerTestTime = 0L;
                if (this.seeding_mode) {
                    if (timeSinceSentData != -1L) {
                        peerTestTime = timeSinceSentData;
                    }
                } else {
                    long timeSinceGoodData = peer.getTimeSinceGoodDataReceived();
                    peerTestTime = timeSinceGoodData == -1L ? (peerTestTime += timeSinceConnection) : (peerTestTime += timeSinceGoodData);
                    if (!peer.isInteresting()) {
                        peerTestTime = !peer.isInterested() ? (peerTestTime += timeSinceConnection + timeSinceSentData) : (peerTestTime += timeSinceConnection - timeSinceSentData);
                        peerTestTime *= 2L;
                    }
                    peerTestTime += peer.getSnubbedTime();
                }
                if (!peer.isIncoming()) {
                    peerTestTime *= 2L;
                }
                boolean bl = count_pubs = non_pub_extra > 0 && peer.getNetwork() == "Public";
                if (peer.isLANLocal()) {
                    ++lan_peer_count;
                } else {
                    if (peerTestTime > max_non_lan_time) {
                        max_non_lan_time = peerTestTime;
                        max_non_lan_transport = peer;
                    }
                    if (count_pubs && peerTestTime > max_pub_non_lan_time) {
                        max_pub_non_lan_time = peerTestTime;
                        max_pub_non_lan_transport = peer;
                    }
                }
                if (!this.seeding_mode) {
                    PEPeerStats pestats;
                    peerTestTime += peer.getSnubbedTime();
                    if (peer.getSnubbedTime() > 120L) {
                        peerTestTime = (long)((double)peerTestTime * 1.5);
                    }
                    if ((pestats = peer.getStats()).getTotalDataBytesReceived() + pestats.getTotalDataBytesSent() > 524288L) {
                        boolean goodPeer = true;
                        if (peer.isSnubbed() && pestats.getTotalDataBytesReceived() < pestats.getTotalDataBytesSent()) {
                            peerTestTime = (long)((double)peerTestTime * 1.5);
                            goodPeer = false;
                        }
                        if (pestats.getTotalDataBytesSent() > pestats.getTotalDataBytesReceived() * 10L) {
                            peerTestTime *= 2L;
                            goodPeer = false;
                        }
                        if (pestats.getTotalDataBytesReceived() > 0L && pestats.getTotalBytesDiscarded() > 0L) {
                            peerTestTime = (long)((double)peerTestTime * (1.0 + (double)pestats.getTotalBytesDiscarded() / (double)pestats.getTotalDataBytesReceived()));
                        }
                        if (goodPeer) {
                            peerTestTime = (long)((double)peerTestTime * 0.7);
                        }
                    }
                }
                if (peerTestTime > max_time) {
                    max_time = peerTestTime;
                    max_transport = peer;
                }
                if (count_pubs) {
                    if (peerTestTime > max_pub_time) {
                        max_pub_time = peerTestTime;
                        max_pub_transport = peer;
                    }
                } else {
                    ++non_pub_found;
                }
                if (peer.isSeed() || peer.isRelativeSeed()) {
                    if (peerTestTime > max_seed_time) {
                        max_seed_time = peerTestTime;
                        max_seed_transport = peer;
                    }
                    if (count_pubs && peerTestTime > max_pub_seed_time) {
                        max_pub_seed_time = peerTestTime;
                        max_pub_seed_transport = peer;
                    }
                }
            }
            ++i;
        }
        if (non_pub_extra > 0 && non_pub_found <= non_pub_extra) {
            if (max_transport != null && max_transport.getNetwork() != "Public") {
                max_time = max_pub_time;
                max_transport = max_pub_transport;
            }
            if (max_seed_transport != null && max_seed_transport.getNetwork() != "Public") {
                max_seed_time = max_pub_seed_time;
                max_seed_transport = max_pub_seed_transport;
            }
            if (max_non_lan_transport != null && max_non_lan_transport.getNetwork() != "Public") {
                max_non_lan_time = max_pub_non_lan_time;
                max_non_lan_transport = max_pub_non_lan_transport;
            }
        }
        if (activeConnectionTimes.size() > 0) {
            Collections.sort(activeConnectionTimes);
            medianConnectionTime = (Long)activeConnectionTimes.get(activeConnectionTimes.size() / 2);
        } else {
            medianConnectionTime = 0L;
        }
        int max_con = this.getMaxConnections(network);
        int n = maxOptimistics = max_con == 0 ? 8 : Math.max(max_con / 30, 2);
        if (!pending_lan_local_peer && !force && this.optimisticDisconnectCount >= maxOptimistics && medianConnectionTime < 300000L) {
            return false;
        }
        if (max_transport != null) {
            int LAN_PEER_MAX = 4;
            if (max_transport.isLANLocal() && lan_peer_count < 4 && max_non_lan_transport != null) {
                max_transport = max_non_lan_transport;
                max_time = max_non_lan_time;
            }
            if (this.getMaxSeedConnections(network) > 0 && max_seed_transport != null && max_time > 300000L) {
                this.closeAndRemovePeer(max_seed_transport, "timed out by doOptimisticDisconnect()", true);
                ++this.optimisticDisconnectCount;
                return true;
            }
            if (max_transport != null && max_time > 300000L) {
                this.closeAndRemovePeer(max_transport, "timed out by doOptimisticDisconnect()", true);
                ++this.optimisticDisconnectCount;
                return true;
            }
            if (pending_lan_local_peer && lan_peer_count < 4) {
                this.closeAndRemovePeer(max_transport, "making space for LAN peer in doOptimisticDisconnect()", true);
                ++this.optimisticDisconnectCount;
                return true;
            }
            if (force) {
                this.closeAndRemovePeer(max_transport, "force removal of worst peer in doOptimisticDisconnect()", true);
                return true;
            }
        } else if (force && peer_transports.size() > 0) {
            PEPeerTransport pt = (PEPeerTransport)peer_transports.get(new Random().nextInt(peer_transports.size()));
            this.closeAndRemovePeer(pt, "force removal of random peer in doOptimisticDisconnect()", true);
            return true;
        }
        return false;
    }

    @Override
    public PeerExchangerItem createPeerExchangeConnection(final PEPeerTransport base_peer) {
        if (base_peer.getTCPListenPort() > 0) {
            PeerItem peer = PeerItemFactory.createPeerItem(base_peer.getIp(), base_peer.getTCPListenPort(), (byte)2, base_peer.getPeerItemIdentity().getHandshakeType(), base_peer.getUDPListenPort(), (byte)1, 0);
            return this.peer_database.registerPeerConnection(peer, new PeerExchangerItem.Helper(){

                @Override
                public boolean isSeed() {
                    return base_peer.isSeed();
                }
            });
        }
        return null;
    }

    private boolean isAlreadyConnected(PeerItem peer_id) {
        ArrayList<PEPeerTransport> peer_transports = this.peer_transports_cow;
        int i = 0;
        while (i < peer_transports.size()) {
            PEPeerTransport peer = (PEPeerTransport)peer_transports.get(i);
            if (peer.getPeerItemIdentity().equals(peer_id)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void peerVerifiedAsSelf(PEPeerTransport self) {
        if (self.getTCPListenPort() > 0) {
            PeerItem peer = PeerItemFactory.createPeerItem(self.getIp(), self.getTCPListenPort(), PeerItem.convertSourceID(self.getPeerSource()), self.getPeerItemIdentity().getHandshakeType(), self.getUDPListenPort(), (byte)2, 0);
            this.peer_database.setSelfPeer(peer);
        }
    }

    @Override
    public void IPFilterEnabledChanged(boolean is_enabled) {
        if (is_enabled) {
            this.checkForBannedConnections();
        }
    }

    @Override
    public boolean canIPBeBanned(String ip) {
        return true;
    }

    @Override
    public boolean canIPBeBlocked(String ip, byte[] torrent_hash) {
        return true;
    }

    @Override
    public void IPBlockedListChanged(IpFilter filter2) {
        Iterator<PEPeerTransport> it = this.peer_transports_cow.iterator();
        String name = this.getDisplayName();
        byte[] hash = this.getTorrentHash();
        while (it.hasNext()) {
            try {
                PEPeerTransport peer = it.next();
                if (!filter2.isInRange(peer.getIp(), name, hash)) continue;
                peer.closeConnection("IP address blocked by filters");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void IPBanned(BannedIp ip) {
        int i = 0;
        while (i < this._nbPieces) {
            if (this.pePieces[i] != null) {
                this.pePieces[i].reDownloadBlocks(ip.getIp());
            }
            ++i;
        }
    }

    @Override
    public long getHiddenBytes() {
        if (this.hidden_piece < 0) {
            return 0L;
        }
        return this.dm_pieces[this.hidden_piece].getLength();
    }

    @Override
    public int getHiddenPiece() {
        return this.hidden_piece;
    }

    @Override
    public int getUploadPriority() {
        return this.adapter.getUploadPriority();
    }

    @Override
    public int getAverageCompletionInThousandNotation() {
        ArrayList<PEPeerTransport> peer_transports = this.peer_transports_cow;
        if (peer_transports != null) {
            long total = this.disk_mgr.getTotalLength();
            int my_completion = total == 0L ? 1000 : (int)(1000L * (total - this.disk_mgr.getRemainingExcludingDND()) / total);
            int sum = my_completion == 1000 ? 0 : my_completion;
            int num = my_completion == 1000 ? 0 : 1;
            int i = 0;
            while (i < peer_transports.size()) {
                PEPeer peer = peer_transports.get(i);
                if (peer.getPeerState() == 30 && !peer.isSeed()) {
                    ++num;
                    sum += peer.getPercentDoneInThousandNotation();
                }
                ++i;
            }
            return num > 0 ? sum / num : 0;
        }
        return -1;
    }

    @Override
    public int[] getMaxConnections() {
        return this.adapter.getMaxConnections();
    }

    private int getMaxConnections(String net) {
        int[] data = this.getMaxConnections();
        int result = data[0];
        if (result > 0 && net != "Public") {
            result += data[1];
        }
        return result;
    }

    public int[] getMaxSeedConnections() {
        return this.adapter.getMaxSeedConnections();
    }

    private int getMaxSeedConnections(String net) {
        int[] data = this.getMaxSeedConnections();
        int result = data[0];
        if (result > 0 && net != "Public") {
            result += data[1];
        }
        return result;
    }

    @Override
    public int getMaxNewConnectionsAllowed(String network) {
        int[] max_con = this.getMaxConnections();
        int dl_max = max_con[0];
        if (network != "Public") {
            dl_max += max_con[1];
        }
        int allowed_peers = PeerUtils.numNewConnectionsAllowed(this.getPeerIdentityDataID(), dl_max);
        return allowed_peers;
    }

    private int[] getMaxNewConnectionsAllowed() {
        int[] max_con = this.getMaxConnections();
        int dl_max = max_con[0];
        int extra = max_con[1];
        int allowed_peers = PeerUtils.numNewConnectionsAllowed(this.getPeerIdentityDataID(), dl_max + extra);
        if (allowed_peers >= 0 && (allowed_peers -= extra) < 0) {
            if ((extra += allowed_peers) < 0) {
                extra = 0;
            }
            allowed_peers = 0;
        }
        return new int[]{allowed_peers, extra};
    }

    @Override
    public int getSchedulePriority() {
        return this.isSeeding() ? Integer.MAX_VALUE : this.adapter.getPosition();
    }

    @Override
    public boolean hasPotentialConnections() {
        return this.pending_nat_traversals.size() + this.peer_database.getDiscoveredPeerCount() > 0;
    }

    @Override
    public String getRelationText() {
        return this.adapter.getLogRelation().getRelationText();
    }

    @Override
    public Object[] getQueryableInterfaces() {
        return this.adapter.getLogRelation().getQueryableInterfaces();
    }

    @Override
    public PEPeerTransport getTransportFromIdentity(byte[] peer_id) {
        ArrayList<PEPeerTransport> peer_transports = this.peer_transports_cow;
        int i = 0;
        while (i < peer_transports.size()) {
            PEPeerTransport conn = (PEPeerTransport)peer_transports.get(i);
            if (Arrays.equals(peer_id, conn.getId())) {
                return conn;
            }
            ++i;
        }
        return null;
    }

    @Override
    public PEPeerTransport getTransportFromAddress(String peer) {
        ArrayList<PEPeerTransport> peer_transports = this.peer_transports_cow;
        int i = 0;
        while (i < peer_transports.size()) {
            PEPeerTransport pt = (PEPeerTransport)peer_transports.get(i);
            if (peer.equals(pt.getIp())) {
                return pt;
            }
            ++i;
        }
        return null;
    }

    @Override
    public void incNbPeersSnubbed() {
        ++this.nbPeersSnubbed;
    }

    @Override
    public void decNbPeersSnubbed() {
        --this.nbPeersSnubbed;
    }

    @Override
    public void setNbPeersSnubbed(int n) {
        this.nbPeersSnubbed = n;
    }

    @Override
    public int getNbPeersSnubbed() {
        return this.nbPeersSnubbed;
    }

    @Override
    public boolean getPreferUDP() {
        return this.prefer_udp;
    }

    @Override
    public void setPreferUDP(boolean prefer) {
        this.prefer_udp = prefer;
    }

    @Override
    public boolean isPeerSourceEnabled(String peer_source) {
        return this.adapter.isPeerSourceEnabled(peer_source);
    }

    @Override
    public boolean isNetworkEnabled(String net) {
        return this.adapter.isNetworkEnabled(net);
    }

    @Override
    public void peerDiscovered(PEPeerTransport finder, PeerItem pi) {
        ArrayList<PEPeerManagerListener> peer_manager_listeners = this.peer_manager_listeners_cow;
        int i = 0;
        while (i < peer_manager_listeners.size()) {
            try {
                peer_manager_listeners.get(i).peerDiscovered(this, pi, finder);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
    }

    @Override
    public TrackerPeerSource getTrackerPeerSource() {
        return new TrackerPeerSourceAdapter(){

            @Override
            public int getType() {
                return 5;
            }

            @Override
            public int getStatus() {
                return PEPeerControlImpl.this.isPeerExchangeEnabled() ? 5 : 1;
            }

            @Override
            public String getName() {
                return MessageText.getString("tps.pex.details", new String[]{String.valueOf(PEPeerControlImpl.this.peer_transports_cow.size()), String.valueOf(PEPeerControlImpl.this.peer_database.getExchangedPeerCount()), String.valueOf(PEPeerControlImpl.this.peer_database.getDiscoveredPeerCount())});
            }

            @Override
            public int getPeers() {
                return PEPeerControlImpl.this.isPeerExchangeEnabled() ? PEPeerControlImpl.this.peer_database.getExchangedPeersUsed() : -1;
            }
        };
    }

    @Override
    public void generateEvidence(IndentWriter writer) {
        writer.println("PeerManager: seeding=" + this.seeding_mode);
        writer.println("    udp_fb=" + this.pending_nat_traversals.size() + ",udp_tc=" + this.udp_traversal_count + ",pd=[" + this.peer_database.getString() + "]");
        String pending_udp = "";
        try {
            this.peer_transports_mon.enter();
            for (PEPeerTransport peer : this.pending_nat_traversals.values()) {
                pending_udp = String.valueOf(pending_udp) + (pending_udp.length() == 0 ? "" : ",") + peer.getPeerItemIdentity().getAddressString() + ":" + peer.getPeerItemIdentity().getUDPPort();
            }
        }
        finally {
            this.peer_transports_mon.exit();
        }
        if (pending_udp.length() > 0) {
            writer.println("    pending_udp=" + pending_udp);
        }
        List traversals = PeerNATTraverser.getSingleton().getTraversals(this);
        String active_udp = "";
        for (InetSocketAddress ad : traversals) {
            active_udp = String.valueOf(active_udp) + (active_udp.length() == 0 ? "" : ",") + AddressUtils.getHostAddress(ad) + ":" + ad.getPort();
        }
        if (active_udp.length() > 0) {
            writer.println("    active_udp=" + active_udp);
        }
        if (!this.seeding_mode) {
            int i;
            int num;
            String str;
            writer.println("  Active Pieces");
            int num_active = 0;
            try {
                writer.indent();
                str = "";
                num = 0;
                i = 0;
                while (i < this.pePieces.length) {
                    PEPieceImpl piece = this.pePieces[i];
                    if (piece != null) {
                        ++num_active;
                        str = String.valueOf(str) + (str.length() == 0 ? "" : ",") + "#" + i + " " + this.dm_pieces[i].getString() + ": " + piece.getString();
                        if (++num == 20) {
                            writer.println(str);
                            str = "";
                            num = 0;
                        }
                    }
                    ++i;
                }
                if (num > 0) {
                    writer.println(str);
                }
            }
            finally {
                writer.exdent();
            }
            if (num_active == 0) {
                writer.println("  Inactive Pieces (excluding done/skipped)");
                try {
                    writer.indent();
                    str = "";
                    num = 0;
                    i = 0;
                    while (i < this.dm_pieces.length) {
                        DiskManagerPiece dm_piece = this.dm_pieces[i];
                        if (dm_piece.isInteresting()) {
                            str = String.valueOf(str) + (str.length() == 0 ? "" : ",") + "#" + i + " " + this.dm_pieces[i].getString();
                            if (++num == 20) {
                                writer.println(str);
                                str = "";
                                num = 0;
                            }
                        }
                        ++i;
                    }
                    if (num > 0) {
                        writer.println(str);
                    }
                }
                finally {
                    writer.exdent();
                }
            }
            this.piecePicker.generateEvidence(writer);
        }
        try {
            this.peer_transports_mon.enter();
            writer.println("Peers: total = " + this.peer_transports_cow.size());
            writer.indent();
            try {
                writer.indent();
                for (PEPeerTransport peer : this.peer_transports_cow) {
                    peer.generateEvidence(writer);
                }
            }
            finally {
                writer.exdent();
            }
        }
        finally {
            this.peer_transports_mon.exit();
            writer.exdent();
        }
        this.disk_mgr.generateEvidence(writer);
    }
}

