/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.client.impl;

import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncer;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerException;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerFactory;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerFactoryListener;
import org.gudy.azureus2.core3.tracker.client.impl.TRTrackerAnnouncerImpl;
import org.gudy.azureus2.core3.tracker.client.impl.TRTrackerAnnouncerMuxer;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;

public class TRTrackerAnnouncerFactoryImpl {
    protected static final List<TRTrackerAnnouncerFactoryListener> listeners = new ArrayList<TRTrackerAnnouncerFactoryListener>();
    protected static final List<TRTrackerAnnouncerImpl> clients = new ArrayList<TRTrackerAnnouncerImpl>();
    protected static final AEMonitor class_mon = new AEMonitor("TRTrackerClientFactory");

    public static TRTrackerAnnouncer create(TOTorrent torrent, TRTrackerAnnouncerFactory.DataProvider provider2, boolean manual) throws TRTrackerAnnouncerException {
        TRTrackerAnnouncerMuxer client = new TRTrackerAnnouncerMuxer(torrent, provider2, manual);
        if (!manual) {
            ArrayList<TRTrackerAnnouncerFactoryListener> listeners_copy;
            try {
                class_mon.enter();
                clients.add(client);
                listeners_copy = new ArrayList<TRTrackerAnnouncerFactoryListener>(listeners);
            }
            finally {
                class_mon.exit();
            }
            int i = 0;
            while (i < listeners_copy.size()) {
                try {
                    ((TRTrackerAnnouncerFactoryListener)listeners_copy.get(i)).clientCreated(client);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
                ++i;
            }
        }
        return client;
    }

    public static void addListener(TRTrackerAnnouncerFactoryListener l) {
        ArrayList<TRTrackerAnnouncerImpl> clients_copy;
        try {
            class_mon.enter();
            listeners.add(l);
            clients_copy = new ArrayList<TRTrackerAnnouncerImpl>(clients);
        }
        finally {
            class_mon.exit();
        }
        int i = 0;
        while (i < clients_copy.size()) {
            try {
                l.clientCreated((TRTrackerAnnouncer)clients_copy.get(i));
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
    }

    public static void removeListener(TRTrackerAnnouncerFactoryListener l) {
        try {
            class_mon.enter();
            listeners.remove(l);
        }
        finally {
            class_mon.exit();
        }
    }

    public static void destroy(TRTrackerAnnouncer client) {
        if (!client.isManual()) {
            ArrayList<TRTrackerAnnouncerFactoryListener> listeners_copy;
            try {
                class_mon.enter();
                clients.remove(client);
                listeners_copy = new ArrayList<TRTrackerAnnouncerFactoryListener>(listeners);
            }
            finally {
                class_mon.exit();
            }
            int i = 0;
            while (i < listeners_copy.size()) {
                try {
                    ((TRTrackerAnnouncerFactoryListener)listeners_copy.get(i)).clientDestroyed(client);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
                ++i;
            }
        }
    }
}

