/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.client.impl.dht;

import com.aelitis.azureus.core.tracker.TrackerPeerSource;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeSet;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLSet;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncer;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerDataProvider;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerException;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerListener;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerResponse;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerResponsePeer;
import org.gudy.azureus2.core3.tracker.client.impl.TRTrackerAnnouncerHelper;
import org.gudy.azureus2.core3.tracker.client.impl.TRTrackerAnnouncerImpl;
import org.gudy.azureus2.core3.tracker.client.impl.TRTrackerAnnouncerResponseImpl;
import org.gudy.azureus2.core3.tracker.client.impl.TRTrackerAnnouncerResponsePeerImpl;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.clientid.ClientIDException;
import org.gudy.azureus2.plugins.download.DownloadAnnounceResult;
import org.gudy.azureus2.plugins.download.DownloadAnnounceResultPeer;
import org.gudy.azureus2.pluginsimpl.local.clientid.ClientIDManagerImpl;

public class TRTrackerDHTAnnouncerImpl
implements TRTrackerAnnouncerHelper {
    public static final LogIDs LOGID = LogIDs.TRACKER;
    private final TOTorrent torrent;
    private HashWrapper torrent_hash;
    private final TRTrackerAnnouncerImpl.Helper helper;
    private byte[] data_peer_id;
    private String tracker_status_str;
    private long last_update_time;
    private int state = 1;
    private TRTrackerAnnouncerResponseImpl last_response;
    private final boolean manual;

    public TRTrackerDHTAnnouncerImpl(TOTorrent _torrent, String[] _networks, boolean _manual, TRTrackerAnnouncerImpl.Helper _helper) throws TRTrackerAnnouncerException {
        this.torrent = _torrent;
        this.manual = _manual;
        this.helper = _helper;
        try {
            this.torrent_hash = this.torrent.getHashWrapper();
        }
        catch (TOTorrentException e) {
            Debug.printStackTrace(e);
        }
        try {
            this.data_peer_id = ClientIDManagerImpl.getSingleton().generatePeerID(this.torrent_hash.getBytes(), false);
        }
        catch (ClientIDException e) {
            throw new TRTrackerAnnouncerException("TRTrackerAnnouncer: Peer ID generation fails", e);
        }
        this.last_response = new TRTrackerAnnouncerResponseImpl(this.torrent.getAnnounceURL(), this.torrent_hash, 0, 0L, "Initialising");
        this.tracker_status_str = String.valueOf(MessageText.getString("PeerManager.status.checking")) + "...";
    }

    @Override
    public void setAnnounceDataProvider(TRTrackerAnnouncerDataProvider provider2) {
    }

    @Override
    public boolean isManual() {
        return this.manual;
    }

    @Override
    public TOTorrent getTorrent() {
        return this.torrent;
    }

    @Override
    public URL getTrackerURL() {
        return TorrentUtils.getDecentralisedURL(this.torrent);
    }

    @Override
    public void setTrackerURL(URL url) {
        Debug.out("Not implemented");
    }

    @Override
    public TOTorrentAnnounceURLSet[] getAnnounceSets() {
        return new TOTorrentAnnounceURLSet[]{this.torrent.getAnnounceURLGroup().createAnnounceURLSet(new URL[]{TorrentUtils.getDecentralisedURL(this.torrent)})};
    }

    @Override
    public void resetTrackerUrl(boolean shuffle) {
    }

    @Override
    public void setIPOverride(String override) {
    }

    @Override
    public void clearIPOverride() {
    }

    public int getPort() {
        return 0;
    }

    @Override
    public byte[] getPeerId() {
        return this.data_peer_id;
    }

    @Override
    public void setRefreshDelayOverrides(int percentage) {
    }

    @Override
    public int getTimeUntilNextUpdate() {
        long elapsed = (SystemTime.getCurrentTime() - this.last_update_time) / 1000L;
        return (int)(this.last_response.getTimeToWait() - elapsed);
    }

    @Override
    public int getLastUpdateTime() {
        return (int)(this.last_update_time / 1000L);
    }

    @Override
    public void update(boolean force) {
        this.state = 2;
    }

    @Override
    public void complete(boolean already_reported) {
        this.state = 3;
    }

    @Override
    public void stop(boolean for_queue) {
        this.state = 4;
    }

    @Override
    public void destroy() {
    }

    @Override
    public int getStatus() {
        return this.state;
    }

    @Override
    public String getStatusString() {
        return this.tracker_status_str;
    }

    @Override
    public TRTrackerAnnouncer getBestAnnouncer() {
        return this;
    }

    @Override
    public TRTrackerAnnouncerResponse getLastResponse() {
        return this.last_response;
    }

    @Override
    public boolean isUpdating() {
        return false;
    }

    @Override
    public long getInterval() {
        return -1L;
    }

    @Override
    public long getMinInterval() {
        return -1L;
    }

    @Override
    public void refreshListeners() {
    }

    @Override
    public void setAnnounceResult(DownloadAnnounceResult result) {
        TRTrackerAnnouncerResponsePeer[] cached_peers;
        TRTrackerAnnouncerResponseImpl response;
        this.last_update_time = SystemTime.getCurrentTime();
        if (result.getResponseType() == 2) {
            this.tracker_status_str = MessageText.getString("PeerManager.status.error");
            String reason = result.getError();
            if (reason != null) {
                this.tracker_status_str = String.valueOf(this.tracker_status_str) + " (" + reason + ")";
            }
            response = new TRTrackerAnnouncerResponseImpl(result.getURL(), this.torrent_hash, 0, result.getTimeToWait(), reason);
        } else {
            DownloadAnnounceResultPeer[] ext_peers = result.getPeers();
            ArrayList<TRTrackerAnnouncerResponsePeerImpl> peers_list = new ArrayList<TRTrackerAnnouncerResponsePeerImpl>(ext_peers.length);
            int i = 0;
            while (i < ext_peers.length) {
                DownloadAnnounceResultPeer ext_peer = ext_peers[i];
                if (ext_peer != null) {
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(this.torrent, LOGID, "EXTERNAL PEER DHT: ip=" + ext_peer.getAddress() + ",port=" + ext_peer.getPort() + ",prot=" + ext_peer.getProtocol()));
                    }
                    int http_port = 0;
                    byte az_version = 1;
                    peers_list.add(new TRTrackerAnnouncerResponsePeerImpl(ext_peer.getSource(), ext_peer.getPeerID(), ext_peer.getAddress(), ext_peer.getPort(), ext_peer.getUDPPort(), http_port, ext_peer.getProtocol(), az_version, 0));
                }
                ++i;
            }
            TRTrackerAnnouncerResponsePeer[] peers = peers_list.toArray(new TRTrackerAnnouncerResponsePeerImpl[peers_list.size()]);
            this.helper.addToTrackerCache((TRTrackerAnnouncerResponsePeerImpl[])peers);
            this.tracker_status_str = MessageText.getString("PeerManager.status.ok");
            response = new TRTrackerAnnouncerResponseImpl(result.getURL(), this.torrent_hash, 2, result.getTimeToWait(), peers);
        }
        this.last_response = response;
        TRTrackerAnnouncerResponsePeer[] peers = response.getPeers();
        if ((peers == null || peers.length < 5) && (cached_peers = this.helper.getPeersFromCache(100)).length > 0) {
            TreeSet<TRTrackerAnnouncerResponsePeer> new_peers = new TreeSet<TRTrackerAnnouncerResponsePeer>(new Comparator<TRTrackerAnnouncerResponsePeer>(){

                @Override
                public int compare(TRTrackerAnnouncerResponsePeer o1, TRTrackerAnnouncerResponsePeer o2) {
                    return o1.compareTo(o2);
                }
            });
            if (peers != null) {
                new_peers.addAll(Arrays.asList(peers));
            }
            new_peers.addAll(Arrays.asList(cached_peers));
            response.setPeers(new_peers.toArray(new TRTrackerAnnouncerResponsePeer[new_peers.size()]));
        }
        this.helper.informResponse(this, response);
    }

    @Override
    public void addListener(TRTrackerAnnouncerListener l) {
        this.helper.addListener(l);
    }

    @Override
    public void removeListener(TRTrackerAnnouncerListener l) {
        this.helper.removeListener(l);
    }

    @Override
    public void setTrackerResponseCache(Map map) {
        this.helper.setTrackerResponseCache(map);
    }

    @Override
    public void removeFromTrackerResponseCache(String ip, int tcpPort) {
        this.helper.removeFromTrackerResponseCache(ip, tcpPort);
    }

    @Override
    public Map getTrackerResponseCache() {
        return this.helper.getTrackerResponseCache();
    }

    @Override
    public TrackerPeerSource getTrackerPeerSource(TOTorrentAnnounceURLSet set) {
        Debug.out("not implemented");
        return null;
    }

    @Override
    public TrackerPeerSource getCacheTrackerPeerSource() {
        Debug.out("not implemented");
        return null;
    }

    @Override
    public void generateEvidence(IndentWriter writer) {
        writer.println("DHT announce: " + (this.last_response == null ? "null" : this.last_response.getString()));
    }
}

