/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.server.impl.udp;

import com.aelitis.net.udp.uc.PRUDPPacket;
import com.aelitis.net.udp.uc.PRUDPPacketRequest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.tracker.protocol.PRHelpers;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyAnnounce;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyAnnounce2;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyConnect;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyError;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyScrape;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyScrape2;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketRequestAnnounce;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketRequestAnnounce2;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketRequestScrape;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketTracker;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPTrackerCodecs;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerPeerImpl;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerProcessor;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerTorrentImpl;
import org.gudy.azureus2.core3.tracker.server.impl.udp.TRTrackerServerUDP;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.SHA1Hasher;
import org.gudy.azureus2.core3.util.SystemTime;

public class TRTrackerServerProcessorUDP
extends TRTrackerServerProcessor {
    private static final LogIDs LOGID = LogIDs.TRACKER;
    public static final long CONNECTION_ID_LIFETIME = 180000L;
    private final TRTrackerServerUDP server;
    private final DatagramSocket socket;
    private final DatagramPacket request_dg;
    private static final Map<Long, connectionData> connection_id_map = new LinkedHashMap<Long, connectionData>();
    private static final Map<String, List<connectionData>> connection_ip_map = new HashMap<String, List<connectionData>>();
    private static long last_timeout_check;
    private static final SecureRandom random;
    private static final AEMonitor random_mon;

    static {
        random = RandomUtils.SECURE_RANDOM;
        random_mon = new AEMonitor("TRTrackerServerUDP:rand");
        PRUDPTrackerCodecs.registerCodecs();
    }

    protected TRTrackerServerProcessorUDP(TRTrackerServerUDP _server, DatagramSocket _socket, DatagramPacket _packet) {
        this.server = _server;
        this.socket = _socket;
        this.request_dg = _packet;
    }

    @Override
    public void runSupport() {
        byte[] input_buffer = new byte[this.request_dg.getLength()];
        System.arraycopy(this.request_dg.getData(), 0, input_buffer, 0, input_buffer.length);
        int packet_data_length = input_buffer.length;
        String auth_user = null;
        byte[] auth_user_bytes = null;
        byte[] auth_hash = null;
        if (this.server.isTrackerPasswordEnabled()) {
            if (input_buffer.length < 17) {
                Logger.log(new LogEvent(LOGID, 1, "TRTrackerServerProcessorUDP: packet received but authorisation missing"));
                return;
            }
            auth_user_bytes = new byte[8];
            auth_hash = new byte[8];
            System.arraycopy(input_buffer, packet_data_length -= 16, auth_user_bytes, 0, 8);
            int user_len = 0;
            while (user_len < 8 && auth_user_bytes[user_len] != 0) {
                ++user_len;
            }
            auth_user = new String(auth_user_bytes, 0, user_len);
            System.arraycopy(input_buffer, packet_data_length + 8, auth_hash, 0, 8);
        }
        DataInputStream is = new DataInputStream(new ByteArrayInputStream(input_buffer, 0, packet_data_length));
        try {
            try {
                int request_type;
                TRTrackerServerTorrentImpl torrent;
                PRUDPPacket reply;
                block35: {
                    String client_ip_address = this.request_dg.getAddress().getHostAddress();
                    PRUDPPacketRequest request2 = PRUDPPacketRequest.deserialiseRequest(null, is);
                    Logger.log(new LogEvent(LOGID, "TRTrackerServerProcessorUDP: packet received: " + request2.getString()));
                    reply = null;
                    torrent = null;
                    if (auth_user_bytes != null) {
                        byte[] sha1_pw = null;
                        if (this.server.hasExternalAuthorisation()) {
                            try {
                                URL resource = new URL("udp://" + this.server.getHost() + ":" + this.server.getPort() + "/");
                                sha1_pw = this.server.performExternalAuthorisation(resource, auth_user);
                            }
                            catch (MalformedURLException e) {
                                Debug.printStackTrace(e);
                            }
                            if (sha1_pw == null) {
                                Logger.log(new LogEvent(LOGID, 3, "TRTrackerServerProcessorUDP: auth fails for user '" + auth_user + "'"));
                                reply = new PRUDPPacketReplyError(request2.getTransactionId(), "Access Denied");
                            }
                        } else {
                            sha1_pw = this.server.getPassword();
                        }
                        if (reply == null) {
                            SHA1Hasher hasher = new SHA1Hasher();
                            hasher.update(input_buffer, 0, packet_data_length);
                            hasher.update(auth_user_bytes);
                            hasher.update(sha1_pw);
                            byte[] digest = hasher.getDigest();
                            int i = 0;
                            while (i < auth_hash.length) {
                                if (auth_hash[i] != digest[i]) {
                                    Logger.log(new LogEvent(LOGID, 3, "TRTrackerServerProcessorUDP: auth fails for user '" + auth_user + "'"));
                                    reply = new PRUDPPacketReplyError(request2.getTransactionId(), "Access Denied");
                                    break;
                                }
                                ++i;
                            }
                        }
                    }
                    request_type = -1;
                    if (reply == null) {
                        if (this.server.isEnabled()) {
                            try {
                                Object[] x;
                                int type = request2.getAction();
                                if (type == 0) {
                                    reply = this.handleConnect(client_ip_address, request2);
                                    break block35;
                                }
                                if (type == 1) {
                                    x = this.handleAnnounceAndScrape(client_ip_address, request2, 1);
                                    if (x == null) {
                                        throw new Exception("Connection ID mismatch");
                                    }
                                    reply = (PRUDPPacket)x[0];
                                    torrent = (TRTrackerServerTorrentImpl)x[1];
                                    request_type = 1;
                                    break block35;
                                }
                                if (type == 2) {
                                    x = this.handleAnnounceAndScrape(client_ip_address, request2, 2);
                                    if (x == null) {
                                        throw new Exception("Connection ID mismatch");
                                    }
                                    reply = (PRUDPPacket)x[0];
                                    torrent = (TRTrackerServerTorrentImpl)x[1];
                                    request_type = 2;
                                    break block35;
                                }
                                reply = new PRUDPPacketReplyError(request2.getTransactionId(), "unsupported action");
                            }
                            catch (Throwable e) {
                                String error = e.getMessage();
                                if (error == null) {
                                    error = e.toString();
                                }
                                reply = new PRUDPPacketReplyError(request2.getTransactionId(), error);
                            }
                        } else {
                            System.out.println("UDP Tracker: replying 'disabled' to " + client_ip_address);
                            reply = new PRUDPPacketReplyError(request2.getTransactionId(), "UDP Tracker disabled");
                        }
                    }
                }
                if (reply != null) {
                    InetAddress address = this.request_dg.getAddress();
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    DataOutputStream os = new DataOutputStream(baos);
                    reply.serialise(os);
                    byte[] output_buffer = baos.toByteArray();
                    DatagramPacket reply_packet = new DatagramPacket(output_buffer, output_buffer.length, address, this.request_dg.getPort());
                    this.socket.send(reply_packet);
                    this.server.updateStats(request_type, torrent, input_buffer.length, output_buffer.length);
                }
            }
            catch (Throwable e) {
                Logger.log(new LogEvent(LOGID, "TRTrackerServerProcessorUDP: processing fails", e));
                try {
                    is.close();
                }
                catch (Throwable throwable) {}
            }
        }
        finally {
            try {
                is.close();
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    public void interruptTask() {
    }

    protected long allocateConnectionId(String client_address) {
        try {
            List<connectionData> cds;
            random_mon.enter();
            long id = random.nextLong();
            Long new_key = new Long(id);
            connectionData new_data = new connectionData(client_address, id);
            if (new_data.getTime() - last_timeout_check > 500L) {
                last_timeout_check = new_data.getTime();
                Iterator<Long> it = connection_id_map.keySet().iterator();
                while (it.hasNext()) {
                    Long key = it.next();
                    connectionData data = connection_id_map.get(key);
                    if (new_data.getTime() - data.getTime() <= 180000L) break;
                    it.remove();
                    List<connectionData> cds2 = connection_ip_map.get(client_address);
                    if (cds2 == null) continue;
                    Iterator<connectionData> it2 = cds2.iterator();
                    while (it2.hasNext()) {
                        if (it2.next().getID() != key) continue;
                        it2.remove();
                        break;
                    }
                    if (cds2.size() != 0) continue;
                    connection_ip_map.remove(client_address);
                }
            }
            if ((cds = connection_ip_map.get(client_address)) == null) {
                cds = new ArrayList<connectionData>();
                connection_ip_map.put(client_address, cds);
            }
            cds.add(new_data);
            if (cds.size() > 512) {
                connectionData dead = cds.remove(0);
                connection_id_map.remove(dead.getID());
            }
            connection_id_map.put(new_key, new_data);
            long l = id;
            return l;
        }
        finally {
            random_mon.exit();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean checkConnectionId(String client_address, long id) {
        try {
            boolean ok;
            random_mon.enter();
            Long key = new Long(id);
            connectionData data = connection_id_map.get(key);
            if (data == null) {
                return false;
            }
            if (SystemTime.getMonotonousTime() - data.getTime() > 180000L) {
                return false;
            }
            boolean bl = ok = data.getAddress().equals(client_address);
            return bl;
        }
        finally {
            random_mon.exit();
        }
    }

    protected PRUDPPacket handleConnect(String client_ip_address, PRUDPPacketRequest request2) {
        long conn_id = this.allocateConnectionId(client_ip_address);
        PRUDPPacketReplyConnect reply = new PRUDPPacketReplyConnect(request2.getTransactionId(), conn_id);
        return reply;
    }

    protected Object[] handleAnnounceAndScrape(String client_ip_address, PRUDPPacketRequest request2, int request_type) throws Exception {
        if (!this.checkConnectionId(client_ip_address, request2.getConnectionId())) {
            return null;
        }
        ArrayList<byte[]> hashbytes = new ArrayList<byte[]>();
        HashWrapper peer_id = null;
        int port = 0;
        String event2 = null;
        long uploaded = 0L;
        long downloaded = 0L;
        long left = 0L;
        int num_want = -1;
        String key = null;
        if (request_type == 1) {
            int i_ip;
            int i_event;
            PRUDPPacketRequest announce;
            if (PRUDPPacketTracker.VERSION == 1) {
                announce = (PRUDPPacketRequestAnnounce)request2;
                hashbytes.add(((PRUDPPacketRequestAnnounce)announce).getHash());
                peer_id = new HashWrapper(((PRUDPPacketRequestAnnounce)announce).getPeerId());
                port = ((PRUDPPacketRequestAnnounce)announce).getPort();
                i_event = ((PRUDPPacketRequestAnnounce)announce).getEvent();
                switch (i_event) {
                    case 2: {
                        event2 = "started";
                        break;
                    }
                    case 3: {
                        event2 = "stopped";
                        break;
                    }
                    case 1: {
                        event2 = "completed";
                    }
                }
                uploaded = ((PRUDPPacketRequestAnnounce)announce).getUploaded();
                downloaded = ((PRUDPPacketRequestAnnounce)announce).getDownloaded();
                left = ((PRUDPPacketRequestAnnounce)announce).getLeft();
                num_want = ((PRUDPPacketRequestAnnounce)announce).getNumWant();
                i_ip = ((PRUDPPacketRequestAnnounce)announce).getIPAddress();
                if (i_ip != 0) {
                    client_ip_address = PRHelpers.intToAddress(i_ip);
                }
            } else {
                announce = (PRUDPPacketRequestAnnounce2)request2;
                hashbytes.add(((PRUDPPacketRequestAnnounce2)announce).getHash());
                peer_id = new HashWrapper(((PRUDPPacketRequestAnnounce2)announce).getPeerId());
                port = ((PRUDPPacketRequestAnnounce2)announce).getPort();
                i_event = ((PRUDPPacketRequestAnnounce2)announce).getEvent();
                switch (i_event) {
                    case 2: {
                        event2 = "started";
                        break;
                    }
                    case 3: {
                        event2 = "stopped";
                        break;
                    }
                    case 1: {
                        event2 = "completed";
                    }
                }
                uploaded = ((PRUDPPacketRequestAnnounce2)announce).getUploaded();
                downloaded = ((PRUDPPacketRequestAnnounce2)announce).getDownloaded();
                left = ((PRUDPPacketRequestAnnounce2)announce).getLeft();
                num_want = ((PRUDPPacketRequestAnnounce2)announce).getNumWant();
                i_ip = ((PRUDPPacketRequestAnnounce2)announce).getIPAddress();
                if (i_ip != 0) {
                    client_ip_address = PRHelpers.intToAddress(i_ip);
                }
                key = "" + ((PRUDPPacketRequestAnnounce2)announce).getKey();
            }
        } else {
            PRUDPPacketRequestScrape scrape = (PRUDPPacketRequestScrape)request2;
            hashbytes.addAll(scrape.getHashes());
        }
        Map[] root_out = new Map[1];
        TRTrackerServerPeerImpl[] peer_out = new TRTrackerServerPeerImpl[1];
        TRTrackerServerTorrentImpl torrent = this.processTrackerRequest(this.server, "", root_out, peer_out, request_type, (byte[][])hashbytes.toArray((T[])new byte[0][0]), null, null, peer_id, false, (byte)0, key, event2, false, port, 0, 0, client_ip_address, client_ip_address, downloaded, uploaded, left, num_want, (byte)0, (byte)1, 0, null);
        Map root = root_out[0];
        if (request_type == 1) {
            if (PRUDPPacketTracker.VERSION == 1) {
                PRUDPPacketReplyAnnounce reply = new PRUDPPacketReplyAnnounce(request2.getTransactionId());
                reply.setInterval(((Long)root.get("interval")).intValue());
                List peers = (List)root.get("peers");
                int[] addresses = new int[peers.size()];
                short[] ports = new short[addresses.length];
                int i = 0;
                while (i < addresses.length) {
                    Map peer = (Map)peers.get(i);
                    addresses[i] = PRHelpers.addressToInt(new String((byte[])peer.get("ip")));
                    ports[i] = ((Long)peer.get("port")).shortValue();
                    ++i;
                }
                reply.setPeers(addresses, ports);
                return new Object[]{reply, torrent};
            }
            PRUDPPacketReplyAnnounce2 reply = new PRUDPPacketReplyAnnounce2(request2.getTransactionId());
            reply.setInterval(((Long)root.get("interval")).intValue());
            boolean local_scrape = client_ip_address.equals("127.0.0.1");
            Map scrape_details = torrent.exportScrapeToMap("", client_ip_address, !local_scrape);
            int seeders = ((Long)scrape_details.get("complete")).intValue();
            int leechers = ((Long)scrape_details.get("incomplete")).intValue();
            reply.setLeechersSeeders(leechers, seeders);
            List peers = (List)root.get("peers");
            int[] addresses = new int[peers.size()];
            short[] ports = new short[addresses.length];
            int i = 0;
            while (i < addresses.length) {
                Map peer = (Map)peers.get(i);
                addresses[i] = PRHelpers.addressToInt(new String((byte[])peer.get("ip")));
                ports[i] = ((Long)peer.get("port")).shortValue();
                ++i;
            }
            reply.setPeers(addresses, ports);
            return new Object[]{reply, torrent};
        }
        if (PRUDPPacketTracker.VERSION == 1) {
            PRUDPPacketReplyScrape reply = new PRUDPPacketReplyScrape(request2.getTransactionId());
            Map files = (Map)root.get("files");
            byte[][] hashes = new byte[files.size()][];
            int[] s_complete = new int[hashes.length];
            int[] s_downloaded = new int[hashes.length];
            int[] s_incomplete = new int[hashes.length];
            Iterator it = files.keySet().iterator();
            int pos = 0;
            while (it.hasNext()) {
                String hash_str = (String)it.next();
                hashes[pos] = hash_str.getBytes("ISO-8859-1");
                Map details = (Map)files.get(hash_str);
                s_complete[pos] = ((Long)details.get("complete")).intValue();
                s_incomplete[pos] = ((Long)details.get("incomplete")).intValue();
                s_downloaded[pos] = ((Long)details.get("downloaded")).intValue();
                ++pos;
            }
            reply.setDetails(hashes, s_complete, s_downloaded, s_incomplete);
            return new Object[]{reply, torrent};
        }
        PRUDPPacketReplyScrape2 reply = new PRUDPPacketReplyScrape2(request2.getTransactionId());
        Map files = (Map)root.get("files");
        int[] s_complete = new int[files.size()];
        int[] s_downloaded = new int[s_complete.length];
        int[] s_incomplete = new int[s_complete.length];
        Iterator it = files.keySet().iterator();
        int pos = 0;
        while (it.hasNext()) {
            String hash_str = (String)it.next();
            Map details = (Map)files.get(hash_str);
            s_complete[pos] = ((Long)details.get("complete")).intValue();
            s_incomplete[pos] = ((Long)details.get("incomplete")).intValue();
            s_downloaded[pos] = ((Long)details.get("downloaded")).intValue();
            ++pos;
        }
        reply.setDetails(s_complete, s_downloaded, s_incomplete);
        return new Object[]{reply, torrent};
    }

    protected static class connectionData {
        private final String address;
        private final long id;
        private final long time;

        private connectionData(String _address, long _id) {
            this.address = _address;
            this.id = _id;
            this.time = SystemTime.getMonotonousTime();
        }

        private String getAddress() {
            return this.address;
        }

        private long getID() {
            return this.id;
        }

        private long getTime() {
            return this.time;
        }
    }
}

