/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.WeakHashMap;
import org.gudy.azureus2.core3.util.AEDiagnosticsLogger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.StringInterner;

public abstract class AEMonSem {
    protected static final boolean DEBUG = false;
    protected static final boolean DEBUG_CHECK_DUPLICATES = false;
    protected static final long DEBUG_TIMER = 30000L;
    private static final ThreadLocal tls = new ThreadLocal(){

        public Object initialValue() {
            return new Stack();
        }
    };
    private static long monitor_id_next;
    private static long semaphore_id_next;
    private static final Map debug_traces;
    static final List debug_recursions;
    private static final List debug_reciprocals;
    private static final Map debug_name_mapping;
    private static final Map debug_monitors;
    private static final Map debug_semaphores;
    protected long entry_count;
    protected long last_entry_count;
    protected String last_trace_key;
    protected final String name;
    protected final boolean is_monitor;
    protected int waiting = 0;

    static {
        debug_traces = new HashMap();
        debug_recursions = new ArrayList();
        debug_reciprocals = new ArrayList();
        debug_name_mapping = new WeakHashMap();
        debug_monitors = new WeakHashMap();
        debug_semaphores = new WeakHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void check(AEDiagnosticsLogger diag_logger) {
        ArrayList<AEMonSem> active = new ArrayList<AEMonSem>();
        ArrayList<AEMonitor> waiting_monitors = new ArrayList<AEMonitor>();
        ArrayList<AEMonitor> busy_monitors = new ArrayList<AEMonitor>();
        ArrayList<AEMonSem> waiting_semaphores = new ArrayList<AEMonSem>();
        Class<AEMonSem> clazz = AEMonSem.class;
        synchronized (AEMonSem.class) {
            Thread last_waiter;
            diag_logger.log("AEMonSem: mid = " + monitor_id_next + ", sid = " + semaphore_id_next + ", monitors = " + debug_monitors.size() + ", semaphores = " + debug_semaphores.size() + ", names = " + debug_name_mapping.size() + ", traces = " + debug_traces.size());
            Iterator it = debug_monitors.keySet().iterator();
            long new_mon_entries = 0L;
            while (it.hasNext()) {
                AEMonitor monitor = (AEMonitor)it.next();
                long diff = monitor.entry_count - monitor.last_entry_count;
                if (diff != 0L) {
                    active.add(monitor);
                    new_mon_entries += diff;
                }
                if (monitor.waiting > 0) {
                    waiting_monitors.add(monitor);
                    continue;
                }
                if (monitor.owner == null) continue;
                busy_monitors.add(monitor);
            }
            it = debug_semaphores.keySet().iterator();
            long new_sem_entries = 0L;
            while (it.hasNext()) {
                AEMonSem semaphore = (AEMonSem)it.next();
                long diff = semaphore.entry_count - semaphore.last_entry_count;
                if (diff != 0L) {
                    active.add(semaphore);
                    new_sem_entries += diff;
                }
                if (semaphore.waiting <= 0) continue;
                waiting_semaphores.add(semaphore);
            }
            diag_logger.log("    activity: monitors = " + new_mon_entries + " - " + new_mon_entries / 30L + "/sec, semaphores = " + new_sem_entries + " - " + new_sem_entries / 30L + "/sec ");
            // ** MonitorExit[var5_5] (shouldn't be in output)
            AEMonSem[] x = new AEMonSem[active.size()];
            active.toArray(x);
            Arrays.sort(x, new Comparator(){

                public int compare(Object o1, Object o2) {
                    AEMonSem a1 = (AEMonSem)o1;
                    AEMonSem a2 = (AEMonSem)o2;
                    return a1.name.compareTo(a2.name);
                }
            });
            AEMonSem current = null;
            long current_total = 0L;
            Object[][] total_x = new Object[x.length][];
            int total_pos = 0;
            int i = 0;
            while (i < x.length) {
                AEMonSem ms = x[i];
                long diff = ms.entry_count - ms.last_entry_count;
                if (current == null) {
                    current = ms;
                } else if (current.name.equals(ms.name)) {
                    current_total += diff;
                } else {
                    total_x[total_pos++] = new Object[]{current.name, new Long(current_total)};
                    current = ms;
                    current_total = diff;
                }
                ++i;
            }
            if (current != null) {
                total_x[total_pos++] = new Object[]{current.name, new Long(current_total)};
            }
            Arrays.sort(total_x, new Comparator(){

                public int compare(Object o1, Object o2) {
                    Object[] a1 = (Object[])o1;
                    Object[] a2 = (Object[])o2;
                    if (a1 == null && a2 == null) {
                        return 0;
                    }
                    if (a1 == null) {
                        return 1;
                    }
                    if (a2 == null) {
                        return -1;
                    }
                    long a1_count = (Long)a1[1];
                    long a2_count = (Long)a2[1];
                    return (int)(a2_count - a1_count);
                }
            });
            String top_act_str = "    top activity: ";
            int i2 = 0;
            while (i2 < Math.min(10, total_x.length)) {
                if (total_x[i2] != null) {
                    top_act_str = String.valueOf(top_act_str) + (i2 == 0 ? "" : ", ") + total_x[i2][0] + " = " + total_x[i2][1];
                }
                ++i2;
            }
            diag_logger.log(top_act_str);
            if (waiting_monitors.size() > 0) {
                diag_logger.log("    waiting monitors");
                i2 = 0;
                while (i2 < waiting_monitors.size()) {
                    AEMonSem ms = (AEMonSem)waiting_monitors.get(i2);
                    last_waiter = ((AEMonitor)ms).last_waiter;
                    diag_logger.log("        [" + (last_waiter == null ? "<waiter lost>" : last_waiter.getName()) + "] " + ms.name + " - " + ms.last_trace_key);
                    ++i2;
                }
            }
            if (busy_monitors.size() > 0) {
                diag_logger.log("    busy monitors");
                i2 = 0;
                while (i2 < busy_monitors.size()) {
                    AEMonSem ms = (AEMonSem)busy_monitors.get(i2);
                    Thread owner = ((AEMonitor)ms).owner;
                    diag_logger.log("        [" + (owner == null ? "<owner lost>" : owner.getName()) + "] " + ms.name + " - " + ms.last_trace_key);
                    ++i2;
                }
            }
            if (waiting_semaphores.size() > 0) {
                diag_logger.log("    waiting semaphores");
                i2 = 0;
                while (i2 < waiting_semaphores.size()) {
                    AEMonSem ms = (AEMonSem)waiting_semaphores.get(i2);
                    last_waiter = ((AESemaphore)ms).latest_waiter;
                    diag_logger.log("        [" + (last_waiter == null ? "<waiter lost>" : last_waiter.getName()) + "] " + ms.name + " - " + ms.last_trace_key);
                    ++i2;
                }
            }
            i2 = 0;
            while (i2 < x.length) {
                AEMonSem ms = x[i2];
                ms.last_entry_count = ms.entry_count;
                ++i2;
            }
            return;
        }
    }

    protected AEMonSem(String _name, boolean _monitor) {
        this.is_monitor = _monitor;
        this.name = this.is_monitor ? _name : StringInterner.intern("(S)" + _name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void debugEntry() {
        block28: {
            try {
                Stack stack = (Stack)tls.get();
                if (stack.size() > 64) {
                    StringBuilder sb = new StringBuilder(1024);
                    int i = 0;
                    while (i < stack.size()) {
                        AEMonSem mon = (AEMonSem)stack.get(i);
                        sb.append("$").append(mon.name);
                        ++i;
                    }
                    Debug.out("**** Whoaaaaaa, AEMonSem debug stack is getting too large!!!! **** " + sb);
                }
                if (!stack.isEmpty()) {
                    String recursion_trace = "";
                    StringBuilder sb = new StringBuilder();
                    boolean check_recursion = this.is_monitor && !debug_recursions.contains(this.name);
                    String prev_name = null;
                    int i = 0;
                    while (i < stack.size()) {
                        AEMonSem mon = (AEMonSem)stack.get(i);
                        if (check_recursion && mon.name.equals(this.name) && mon != this) {
                            recursion_trace = String.valueOf(recursion_trace) + (recursion_trace.length() == 0 ? "" : "\r\n") + "Recursive locks on different instances: " + this.name;
                            debug_recursions.add(this.name);
                        }
                        if (prev_name == null || !mon.name.equals(prev_name)) {
                            sb.append("$");
                            sb.append(mon.name);
                        }
                        prev_name = mon.name;
                        ++i;
                    }
                    sb.append("$");
                    sb.append(this.name);
                    sb.append("$");
                    String trace_key = sb.toString();
                    if (recursion_trace.length() > 0) {
                        Debug.outNoStack(String.valueOf(recursion_trace) + "\r\n    " + trace_key);
                    }
                    this.last_trace_key = trace_key;
                    if (!this.is_monitor) {
                        boolean match = false;
                        int i2 = 0;
                        while (i2 < stack.size()) {
                            AEMonSem ms = (AEMonSem)stack.get(i2);
                            if (ms.name.equals(this.name)) {
                                match = true;
                                break;
                            }
                            ++i2;
                        }
                        if (!match) {
                            stack.push(this);
                        }
                    } else {
                        stack.push(this);
                    }
                    Map map = debug_traces;
                    synchronized (map) {
                        if (debug_traces.get(trace_key) == null) {
                            Thread thread = Thread.currentThread();
                            String thread_name = String.valueOf(thread.getName()) + "[" + thread.hashCode() + "]";
                            String stack_trace = Debug.getStackTrace(true, false);
                            for (String old_key : debug_traces.keySet()) {
                                String[] data = (String[])debug_traces.get(old_key);
                                String old_thread_name = data[0];
                                String old_trace = data[1];
                                if (thread_name.equals(old_thread_name)) continue;
                                int earliest_common = stack.size();
                                int common_count = 0;
                                int i3 = 0;
                                while (i3 < stack.size()) {
                                    String n1 = ((AEMonSem)stack.get((int)i3)).name;
                                    int p1 = old_key.indexOf("$" + n1 + "$");
                                    if (p1 != -1) {
                                        ++common_count;
                                        earliest_common = Math.min(earliest_common, i3 + 1);
                                    }
                                    ++i3;
                                }
                                if (common_count < 2) continue;
                                i3 = 0;
                                while (i3 < earliest_common) {
                                    AEMonSem ms1 = (AEMonSem)stack.get(i3);
                                    if (ms1.is_monitor) {
                                        String n1 = ms1.name;
                                        int j = i3 + 1;
                                        while (j < stack.size()) {
                                            String n2;
                                            AEMonSem ms2 = (AEMonSem)stack.get(j);
                                            if (ms2.is_monitor && !n1.equals(n2 = ms2.name)) {
                                                String reciprocal_log;
                                                int p1 = old_key.indexOf("$" + n1 + "$");
                                                int p2 = old_key.indexOf("$" + n2 + "$");
                                                if (p1 != -1 && p2 != -1 && p1 > p2 && !debug_reciprocals.contains(reciprocal_log = String.valueOf(trace_key) + " / " + old_key)) {
                                                    debug_reciprocals.add(reciprocal_log);
                                                    Debug.outNoStack("AEMonSem: Reciprocal usage:\r\n    " + trace_key + "\r\n" + "        [" + thread_name + "] " + stack_trace + "\r\n" + "    " + old_key + "\r\n" + "        [" + old_thread_name + "] " + old_trace);
                                                }
                                            }
                                            ++j;
                                        }
                                    }
                                    ++i3;
                                }
                            }
                            debug_traces.put(trace_key, new String[]{thread_name, stack_trace});
                        }
                        break block28;
                    }
                }
                this.last_trace_key = "$" + this.name + "$";
                stack.push(this);
            }
            catch (Throwable e) {
                try {
                    Debug.printStackTrace(e);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    protected void debugExit() {
        try {
            Stack stack = (Stack)tls.get();
            if (this.is_monitor) {
                while (stack.peek() != this) {
                    stack.pop();
                }
                stack.pop();
            } else if (!stack.isEmpty() && stack.peek() == this) {
                stack.pop();
            }
        }
        catch (Throwable e) {
            try {
                Debug.printStackTrace(e);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public String getName() {
        return this.name;
    }

    protected static class monSemData {
        protected final String class_name;
        protected final int line_number;

        protected monSemData(String _class_name, int _line_number) {
            this.class_name = _class_name;
            this.line_number = _line_number;
        }
    }
}

