/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import org.gudy.azureus2.core3.util.AEMonSem;
import org.gudy.azureus2.core3.util.Debug;

public class AESemaphore
extends AEMonSem {
    private int dont_wait = 0;
    private int total_reserve = 0;
    private int total_release = 0;
    private boolean released_forever = false;
    protected Thread latest_waiter;

    public AESemaphore(String _name) {
        this(_name, 0);
    }

    public AESemaphore(String _name, int count) {
        super(_name, false);
        this.dont_wait = count;
        this.total_release = count;
    }

    public void reserve() {
        if (!this.reserve(0L)) {
            Debug.out("AESemaphore: reserve completed without acquire [" + this.getString() + "]");
        }
    }

    public boolean reserve(long millis) {
        return this.reserveSupport(millis, 1) == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reserveIfAvailable() {
        AESemaphore aESemaphore = this;
        synchronized (aESemaphore) {
            block4: {
                if (!this.released_forever && this.dont_wait <= 0) break block4;
                this.reserve();
                return true;
            }
            return false;
        }
    }

    public int reserveSet(int max_to_reserve, long millis) {
        return this.reserveSupport(millis, max_to_reserve);
    }

    public int reserveSet(int max_to_reserve) {
        return this.reserveSupport(0L, max_to_reserve);
    }

    /*
     * Exception decompiling
     */
    protected int reserveSupport(long millis, int max_to_reserve) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[DOLOOP]], but top level block is 13[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        AESemaphore aESemaphore = this;
        synchronized (aESemaphore) {
            ++this.total_release;
            if (this.waiting != 0) {
                --this.waiting;
                this.notify();
            } else {
                ++this.dont_wait;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseAllWaiters() {
        AESemaphore aESemaphore = this;
        synchronized (aESemaphore) {
            int x = this.waiting;
            int i = 0;
            while (i < x) {
                this.release();
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseForever() {
        AESemaphore aESemaphore = this;
        synchronized (aESemaphore) {
            this.releaseAllWaiters();
            this.released_forever = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReleasedForever() {
        AESemaphore aESemaphore = this;
        synchronized (aESemaphore) {
            return this.released_forever;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getValue() {
        AESemaphore aESemaphore = this;
        synchronized (aESemaphore) {
            return this.dont_wait - this.waiting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString() {
        AESemaphore aESemaphore = this;
        synchronized (aESemaphore) {
            return "value=" + this.dont_wait + ",waiting=" + this.waiting + ",res=" + this.total_reserve + ",rel=" + this.total_release;
        }
    }
}

