/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.util.LinkedList;
import org.gudy.azureus2.core3.util.AESemaphore2;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.DebugLight;
import org.gudy.azureus2.core3.util.SystemTime;

public abstract class AEThread2 {
    public static final boolean TRACE_TIMES = false;
    private static final int MIN_RETAINED = Math.max(Runtime.getRuntime().availableProcessors(), 2);
    private static final int MAX_RETAINED = Math.max(MIN_RETAINED * 4, 16);
    private static final int THREAD_TIMEOUT_CHECK_PERIOD = 10000;
    private static final int THREAD_TIMEOUT = 60000;
    private static final LinkedList daemon_threads = new LinkedList();
    private static long last_timeout_check;
    private static long total_starts;
    private static long total_creates;
    private threadWrapper wrapper;
    private String name;
    private final boolean daemon;
    private int priority = 5;
    private volatile JoinLock lock = new JoinLock();

    public AEThread2(String _name) {
        this(_name, true);
    }

    public AEThread2(String _name, boolean _daemon) {
        this.name = _name;
        this.daemon = _daemon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        JoinLock newLock;
        JoinLock currentLock = this.lock;
        Object object = currentLock;
        synchronized (object) {
            newLock = currentLock.released ? (this.lock = new JoinLock()) : currentLock;
        }
        if (this.daemon) {
            object = daemon_threads;
            synchronized (object) {
                ++total_starts;
                if (daemon_threads.isEmpty()) {
                    ++total_creates;
                    this.wrapper = new threadWrapper(this.name, true);
                } else {
                    this.wrapper = (threadWrapper)daemon_threads.removeLast();
                    this.wrapper.setName(this.name);
                }
            }
        } else {
            this.wrapper = new threadWrapper(this.name, false);
        }
        if (this.priority != this.wrapper.getPriority()) {
            this.wrapper.setPriority(this.priority);
        }
        this.wrapper.currentLock = newLock;
        this.wrapper.start(this, this.name);
    }

    public void setPriority(int _priority) {
        this.priority = _priority;
        if (this.wrapper != null) {
            this.wrapper.setPriority(this.priority);
        }
    }

    public void setName(String s) {
        this.name = s;
        if (this.wrapper != null) {
            this.wrapper.setName(this.name);
        }
    }

    public String getName() {
        return this.name;
    }

    public void interrupt() {
        if (this.wrapper == null) {
            throw new IllegalStateException("Interrupted before started!");
        }
        this.wrapper.interrupt();
    }

    public boolean isAlive() {
        return this.wrapper == null ? false : this.wrapper.isAlive();
    }

    public boolean isCurrentThread() {
        return this.wrapper == Thread.currentThread();
    }

    public String toString() {
        if (this.wrapper == null) {
            return String.valueOf(this.name) + " [daemon=" + this.daemon + ",priority=" + this.priority + "]";
        }
        return this.wrapper.toString();
    }

    public abstract void run();

    public static boolean isOurThread(Thread thread) {
        return AEThread.isOurThread(thread);
    }

    public static void setOurThread() {
        AEThread.setOurThread();
    }

    public static void setOurThread(Thread thread) {
        AEThread.setOurThread(thread);
    }

    public static void setDebug(Object debug) {
        Thread current = Thread.currentThread();
        if (current instanceof threadWrapper) {
            ((threadWrapper)current).setDebug(debug);
        }
    }

    public static Object[] getDebug(Thread t) {
        if (t instanceof threadWrapper) {
            return ((threadWrapper)t).getDebug();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void join() {
        JoinLock currentLock;
        JoinLock joinLock = currentLock = this.lock;
        synchronized (joinLock) {
            while (true) {
                if (currentLock.released) {
                    return;
                }
                try {
                    currentLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private static final class JoinLock {
        volatile boolean released = false;

        private JoinLock() {
        }
    }

    protected static class threadWrapper
    extends Thread {
        private AESemaphore2 sem;
        private AEThread2 target;
        private JoinLock currentLock;
        private long last_active_time;
        private Object[] debug;

        protected threadWrapper(String name, boolean daemon) {
            super(name);
            this.setDaemon(daemon);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            do {
                Object object = this.currentLock;
                synchronized (object) {
                    block15: {
                        try {
                            try {
                                this.target.run();
                            }
                            catch (Throwable e) {
                                DebugLight.printStackTrace(e);
                                this.target = null;
                                this.debug = null;
                                this.currentLock.released = true;
                                this.currentLock.notifyAll();
                                break block15;
                            }
                        }
                        catch (Throwable throwable) {
                            this.target = null;
                            this.debug = null;
                            this.currentLock.released = true;
                            this.currentLock.notifyAll();
                            throw throwable;
                        }
                        this.target = null;
                        this.debug = null;
                        this.currentLock.released = true;
                        this.currentLock.notifyAll();
                    }
                }
                if (this.isInterrupted() || !Thread.currentThread().isDaemon()) break;
                object = daemon_threads;
                synchronized (object) {
                    this.last_active_time = SystemTime.getCurrentTime();
                    if (this.last_active_time < last_timeout_check || this.last_active_time - last_timeout_check > 10000L) {
                        last_timeout_check = this.last_active_time;
                        while (daemon_threads.size() > 0 && daemon_threads.size() > MIN_RETAINED) {
                            threadWrapper thread = (threadWrapper)daemon_threads.getFirst();
                            long thread_time = thread.last_active_time;
                            if (this.last_active_time >= thread_time && this.last_active_time - thread_time <= 60000L) break;
                            daemon_threads.removeFirst();
                            thread.retire();
                        }
                    }
                    if (daemon_threads.size() >= MAX_RETAINED) {
                        return;
                    }
                    daemon_threads.addLast(this);
                    this.setName("AEThread2:parked[" + daemon_threads.size() + "]");
                }
                this.sem.reserve();
            } while (this.target != null);
        }

        protected void start(AEThread2 _target, String _name) {
            this.target = _target;
            this.setName(_name);
            if (this.sem == null) {
                this.sem = new AESemaphore2("AEThread2");
                super.start();
            } else {
                this.sem.release();
            }
        }

        protected void retire() {
            this.sem.release();
        }

        protected void setDebug(Object d) {
            this.debug = new Object[]{d, SystemTime.getMonotonousTime()};
        }

        protected Object[] getDebug() {
            return this.debug;
        }
    }
}

