/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.util.ArrayList;
import java.util.List;

public class ByteArrayHashMap<T> {
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    protected Entry<T>[] table;
    protected int size;
    private int threshold;
    final float loadFactor;

    public ByteArrayHashMap(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + initialCapacity);
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal load factor: " + loadFactor);
        }
        int capacity = 1;
        while (capacity < initialCapacity) {
            capacity <<= 1;
        }
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)capacity * loadFactor);
        this.table = new Entry[capacity];
    }

    public ByteArrayHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public ByteArrayHashMap() {
        this.loadFactor = 0.75f;
        this.threshold = 12;
        this.table = new Entry[16];
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public T get(byte[] key, int offset, int len) {
        byte[] k = new byte[len];
        System.arraycopy(key, offset, k, 0, len);
        return this.get(k);
    }

    public T get(byte[] key) {
        int hash = ByteArrayHashMap.hash(key);
        int i = ByteArrayHashMap.indexFor(hash, this.table.length);
        Entry<Object> e = this.table[i];
        while (e != null) {
            if (e.hash == hash && ByteArrayHashMap.eq(key, e.key)) {
                return (T)e.value;
            }
            e = e.next;
        }
        return null;
    }

    public boolean containsKey(byte[] key) {
        int hash = ByteArrayHashMap.hash(key);
        int i = ByteArrayHashMap.indexFor(hash, this.table.length);
        Entry<Object> e = this.table[i];
        while (e != null) {
            if (e.hash == hash && ByteArrayHashMap.eq(key, e.key)) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public T put(byte[] key, T value) {
        int hash = ByteArrayHashMap.hash(key);
        int i = ByteArrayHashMap.indexFor(hash, this.table.length);
        Entry<Object> e = this.table[i];
        while (e != null) {
            if (e.hash == hash && ByteArrayHashMap.eq(key, e.key)) {
                Object oldValue = e.value;
                e.value = value;
                return (T)oldValue;
            }
            e = e.next;
        }
        this.addEntry(hash, key, value, i);
        return null;
    }

    public T remove(byte[] key) {
        Entry<T> e = this.removeEntryForKey(key);
        return e == null ? null : (T)e.value;
    }

    public void clear() {
        Entry<T>[] tab = this.table;
        int i = 0;
        while (i < tab.length) {
            tab[i] = null;
            ++i;
        }
        this.size = 0;
    }

    public List<byte[]> keys() {
        ArrayList<byte[]> res = new ArrayList<byte[]>();
        int j = 0;
        while (j < this.table.length) {
            Entry<Object> e = this.table[j];
            while (e != null) {
                res.add(e.key);
                e = e.next;
            }
            ++j;
        }
        return res;
    }

    public List<T> values() {
        ArrayList res = new ArrayList();
        int j = 0;
        while (j < this.table.length) {
            Entry<Object> e = this.table[j];
            while (e != null) {
                res.add(e.value);
                e = e.next;
            }
            ++j;
        }
        return res;
    }

    public ByteArrayHashMap<T> duplicate() {
        ByteArrayHashMap res = new ByteArrayHashMap(this.size, this.loadFactor);
        int j = 0;
        while (j < this.table.length) {
            Entry<Object> e = this.table[j];
            while (e != null) {
                res.put(e.key, e.value);
                e = e.next;
            }
            ++j;
        }
        return res;
    }

    void resize(int newCapacity) {
        Entry<T>[] oldTable = this.table;
        int oldCapacity = oldTable.length;
        if (oldCapacity == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        Entry[] newTable = new Entry[newCapacity];
        this.transfer(newTable);
        this.table = newTable;
        this.threshold = (int)((float)newCapacity * this.loadFactor);
    }

    void transfer(Entry<T>[] newTable) {
        Entry<T>[] src = this.table;
        int newCapacity = newTable.length;
        int j = 0;
        while (j < src.length) {
            Entry<Object> e = src[j];
            if (e != null) {
                Entry next;
                src[j] = null;
                do {
                    next = e.next;
                    int i = ByteArrayHashMap.indexFor(e.hash, newCapacity);
                    e.next = newTable[i];
                    newTable[i] = e;
                } while ((e = next) != null);
            }
            ++j;
        }
    }

    Entry<T> removeEntryForKey(byte[] key) {
        Entry<T> prev;
        int hash = ByteArrayHashMap.hash(key);
        int i = ByteArrayHashMap.indexFor(hash, this.table.length);
        Entry<Object> e = prev = this.table[i];
        while (e != null) {
            Entry next = e.next;
            if (e.hash == hash && ByteArrayHashMap.eq(key, e.key)) {
                --this.size;
                if (prev == e) {
                    this.table[i] = next;
                } else {
                    prev.next = next;
                }
                return e;
            }
            prev = e;
            e = next;
        }
        return e;
    }

    void addEntry(int hash, byte[] key, T value, int bucketIndex) {
        this.table[bucketIndex] = new Entry<T>(hash, key, value, this.table[bucketIndex]);
        if (this.size++ >= this.threshold) {
            this.resize(2 * this.table.length);
        }
    }

    void createEntry(int hash, byte[] key, T value, int bucketIndex) {
        this.table[bucketIndex] = new Entry<T>(hash, key, value, this.table[bucketIndex]);
        ++this.size;
    }

    private static final int hash(byte[] x) {
        int hash = 0;
        int len = x.length;
        int i = 0;
        while (i < len) {
            hash = 31 * hash + x[i];
            ++i;
        }
        return hash;
    }

    private static final boolean eq(byte[] x, byte[] y) {
        if (x == y) {
            return true;
        }
        int len = x.length;
        if (len != y.length) {
            return false;
        }
        int i = 0;
        while (i < len) {
            if (x[i] != y[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static final int indexFor(int h, int length) {
        return h & length - 1;
    }

    protected static class Entry<S> {
        public final byte[] key;
        public S value;
        public final int hash;
        public Entry<S> next;

        Entry(int h, byte[] k, S v, Entry<S> n) {
            this.value = v;
            this.next = n;
            this.key = k;
            this.hash = h;
        }

        public byte[] getKey() {
            return this.key;
        }

        public S getValue() {
            return this.value;
        }
    }
}

