/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.charset.Charset;
import java.security.AccessControlException;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.regex.Pattern;

public class Constants {
    public static final String EMPTY_STRING = "";
    public static final String SF_WEB_SITE = "http://plugins.vuze.com/";
    public static final String AELITIS_TORRENTS = "http://cf1.vuze.com/torrent/torrents/";
    public static final String AELITIS_FILES = "http://cf1.vuze.com/torrent/files/";
    public static final String AZUREUS_WIKI = "http://wiki.vuze.com/w/";
    public static final String VERSION_SERVER_V4 = "version.vuze.com";
    public static final String VERSION_SERVER_V6 = "version6.vuze.com";
    public static final String DHT_SEED_ADDRESS_V4 = "dht.vuze.com";
    public static final String DHT_SEED_ADDRESS_V6 = "dht6.vuze.com";
    public static final String DHT_SEED_ADDRESS_V6_TUNNEL = "dht6tunnel.vuze.com";
    public static final String NAT_TEST_SERVER = "nettest.vuze.com";
    public static final String NAT_TEST_SERVER_HTTP = "http://nettest.vuze.com/";
    public static final String SPEED_TEST_SERVER = "speedtest.vuze.com";
    public static final String PAIRING_URL = "https://pair.vuze.com/pairing";
    public static final String[] AZUREUS_DOMAINS;
    public static final String DEFAULT_ENCODING = "UTF8";
    public static final String BYTE_ENCODING = "ISO-8859-1";
    public static final Charset BYTE_CHARSET;
    public static final Charset DEFAULT_CHARSET;
    public static final int DEFAULT_INSTANCE_PORT = 6880;
    public static final int INSTANCE_PORT;
    public static final Locale LOCALE_ENGLISH;
    public static final String INFINITY_STRING = "\u221e";
    public static final int CRAPPY_INFINITY_AS_INT = 31536000;
    public static final long CRAPPY_INFINITE_AS_LONG = 1827387392L;
    public static boolean DOWNLOAD_SOURCES_PRETEND_COMPLETE;
    public static final String APP_NAME;
    public static final String APP_PLUS_NAME;
    public static final String AZUREUS_NAME = "Azureus";
    public static final String AZUREUS_PROTOCOL_NAME_PRE_4813 = "Azureus";
    public static final String AZUREUS_PROTOCOL_NAME = "Vuze";
    public static final String AZUREUS_VERSION = "5.7.4.1_CVS";
    public static final String BUILD_VERSION = "@build.version@";
    public static final String AZUREUS_SUBVER = "";
    public static final byte[] VERSION_ID;
    private static final boolean FORCE_NON_CVS;
    public static final boolean IS_CVS_VERSION;
    public static final String OSName;
    public static final boolean isOSX;
    public static final boolean isLinux;
    public static final boolean isSolaris;
    public static final boolean isFreeBSD;
    public static final boolean isWindowsXP;
    public static final boolean isWindows95;
    public static final boolean isWindows98;
    public static final boolean isWindows2000;
    public static final boolean isWindowsME;
    public static final boolean isWindows9598ME;
    public static boolean isSafeMode;
    public static final boolean isWindows;
    public static final boolean isUnix;
    public static final boolean isWindowsVista;
    public static final boolean isWindowsVistaSP2OrHigher;
    public static final boolean isWindowsVistaOrHigher;
    public static final boolean isWindows7OrHigher;
    public static final boolean isWindows8OrHigher;
    public static final Pattern PAT_SPLIT_COMMAWORDS;
    public static final Pattern PAT_SPLIT_COMMA;
    public static final Pattern PAT_SPLIT_DOT;
    public static final Pattern PAT_SPLIT_SPACE;
    public static final Pattern PAT_SPLIT_SLASH_N;
    public static final boolean is64Bit;
    public static final boolean isJava64Bit;
    public static final boolean isOSX_10_5_OrHigher;
    public static final boolean isOSX_10_6_OrHigher;
    public static final boolean isOSX_10_7_OrHigher;
    public static final boolean isOSX_10_8_OrHigher;
    public static final boolean isAndroid;
    public static final String JAVA_VERSION;
    public static final int API_LEVEL;
    public static final boolean isJava7OrHigher;
    public static final boolean isJava8OrHigher;
    public static final boolean isJava9OrHigher;
    public static final boolean isJava10OrHigher;
    public static final String FILE_WILDCARD;

    static {
        boolean _10plus;
        boolean _9plus;
        boolean _8plus;
        boolean _7plus;
        boolean _isJava64Bit;
        boolean _is64Bit;
        block45: {
            int ip;
            AZUREUS_DOMAINS = new String[]{"azureusplatform.com", "azureus.com", "aelitis.com", "vuze.com"};
            String ip_str = System.getProperty("azureus.instance.port", String.valueOf(6880));
            try {
                ip = Integer.parseInt(ip_str);
            }
            catch (Throwable e) {
                ip = 6880;
            }
            INSTANCE_PORT = ip;
            Charset bc = null;
            Charset dc = null;
            try {
                bc = Charset.forName(BYTE_ENCODING);
                dc = Charset.forName(DEFAULT_ENCODING);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            BYTE_CHARSET = bc;
            DEFAULT_CHARSET = dc;
            LOCALE_ENGLISH = new Locale("en", "");
            try {
                String timezone = System.getProperty("azureus.timezone", null);
                if (timezone != null) {
                    TimeZone.setDefault(TimeZone.getTimeZone(timezone));
                }
            }
            catch (Throwable e) {
                if (e instanceof AccessControlException) break block45;
                e.printStackTrace();
            }
        }
        DOWNLOAD_SOURCES_PRETEND_COMPLETE = false;
        APP_NAME = System.getProperty("azureus.product.name", AZUREUS_PROTOCOL_NAME);
        APP_PLUS_NAME = String.valueOf(APP_NAME) + " Plus";
        VERSION_ID = "-AZ5741-".getBytes();
        FORCE_NON_CVS = System.getProperty("az.force.noncvs", "0").equals("1");
        IS_CVS_VERSION = Constants.isCVSVersion(AZUREUS_VERSION) && !FORCE_NON_CVS;
        OSName = System.getProperty("os.name");
        isOSX = OSName.toLowerCase().startsWith("mac os");
        isLinux = OSName.equalsIgnoreCase("Linux");
        isSolaris = OSName.equalsIgnoreCase("SunOS");
        isFreeBSD = OSName.equalsIgnoreCase("FreeBSD");
        isWindowsXP = OSName.equalsIgnoreCase("Windows XP");
        isWindows95 = OSName.equalsIgnoreCase("Windows 95");
        isWindows98 = OSName.equalsIgnoreCase("Windows 98");
        isWindows2000 = OSName.equalsIgnoreCase("Windows 2000");
        isWindowsME = OSName.equalsIgnoreCase("Windows ME");
        isWindows9598ME = isWindows95 || isWindows98 || isWindowsME;
        isSafeMode = false;
        isWindows = OSName.toLowerCase().startsWith("windows");
        isUnix = !isWindows && !isOSX;
        PAT_SPLIT_COMMAWORDS = Pattern.compile("\\s*,\\s*");
        PAT_SPLIT_COMMA = Pattern.compile(",");
        PAT_SPLIT_DOT = Pattern.compile("\\.");
        PAT_SPLIT_SPACE = Pattern.compile(" ");
        PAT_SPLIT_SLASH_N = Pattern.compile("\n");
        try {
            _is64Bit = System.getProperty("os.arch").contains("64");
        }
        catch (Throwable e) {
            _is64Bit = false;
        }
        is64Bit = _is64Bit;
        boolean bl = _isJava64Bit = "64".equals(System.getProperty("sun.arch.data.model")) || System.getProperty("os.arch").contains("64");
        if (isWindows && !_isJava64Bit) {
            try {
                String pa = System.getenv("PROCESSOR_ARCHITECTURE");
                String wow_pa = System.getenv("PROCESSOR_ARCHITEW6432");
                _isJava64Bit = pa != null && pa.endsWith("64") || wow_pa != null && wow_pa.endsWith("64");
            }
            catch (Throwable pa) {
                // empty catch block
            }
        }
        isJava64Bit = _isJava64Bit;
        if (isWindows) {
            boolean vista_sp2_or_higher;
            block47: {
                Float ver = null;
                try {
                    ver = new Float(System.getProperty("os.version"));
                }
                catch (Throwable wow_pa) {
                    // empty catch block
                }
                vista_sp2_or_higher = false;
                if (ver == null) {
                    isWindowsVista = false;
                    isWindowsVistaOrHigher = false;
                    isWindows7OrHigher = false;
                    isWindows8OrHigher = false;
                } else {
                    float f_ver = ver.floatValue();
                    isWindowsVista = f_ver == 6.0f;
                    isWindowsVistaOrHigher = f_ver >= 6.0f;
                    isWindows7OrHigher = f_ver >= 6.1f;
                    boolean bl2 = isWindows8OrHigher = f_ver >= 6.2f;
                    if (isWindowsVista) {
                        BufferedReader lnr = null;
                        try {
                            try {
                                String line;
                                Process p = Runtime.getRuntime().exec(new String[]{"reg", "query", "HKLM\\Software\\Microsoft\\Windows NT\\CurrentVersion", "/v", "CSDVersion"});
                                lnr = new LineNumberReader(new InputStreamReader(p.getInputStream()));
                                while ((line = ((LineNumberReader)lnr).readLine()) != null) {
                                    if (!line.matches(".*CSDVersion.*")) continue;
                                    vista_sp2_or_higher = line.matches(".*Service Pack [2-9]");
                                    break;
                                }
                            }
                            catch (Throwable p) {
                                if (lnr != null) {
                                    try {
                                        lnr.close();
                                    }
                                    catch (Throwable throwable) {}
                                }
                                break block47;
                            }
                        }
                        catch (Throwable throwable) {
                            if (lnr != null) {
                                try {
                                    lnr.close();
                                }
                                catch (Throwable throwable2) {
                                    // empty catch block
                                }
                            }
                            throw throwable;
                        }
                        if (lnr != null) {
                            try {
                                lnr.close();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
            isWindowsVistaSP2OrHigher = vista_sp2_or_higher;
        } else {
            isWindowsVista = false;
            isWindowsVistaSP2OrHigher = false;
            isWindowsVistaOrHigher = false;
            isWindows7OrHigher = false;
            isWindows8OrHigher = false;
        }
        if (isOSX) {
            int first_digit = 0;
            int second_digit = 0;
            try {
                String os_version = System.getProperty("os.version");
                String[] bits = os_version.split("\\.");
                first_digit = Integer.parseInt(bits[0]);
                if (bits.length > 1) {
                    second_digit = Integer.parseInt(bits[1]);
                }
            }
            catch (Throwable os_version) {
                // empty catch block
            }
            isOSX_10_5_OrHigher = first_digit > 10 || first_digit == 10 && second_digit >= 5;
            isOSX_10_6_OrHigher = first_digit > 10 || first_digit == 10 && second_digit >= 6;
            isOSX_10_7_OrHigher = first_digit > 10 || first_digit == 10 && second_digit >= 7;
            isOSX_10_8_OrHigher = first_digit > 10 || first_digit == 10 && second_digit >= 8;
        } else {
            isOSX_10_5_OrHigher = false;
            isOSX_10_6_OrHigher = false;
            isOSX_10_7_OrHigher = false;
            isOSX_10_8_OrHigher = false;
        }
        String vm_name = System.getProperty("java.vm.name", "");
        isAndroid = vm_name.equalsIgnoreCase("Dalvik");
        String java_version = isAndroid ? "1.6" : System.getProperty("java.version");
        int api_level = 0;
        if (isAndroid) {
            String sdk_int = System.getProperty("android.os.build.version.sdk_int", "0");
            try {
                api_level = Integer.parseInt(sdk_int);
                if (api_level > 0 && api_level <= 8) {
                    java_version = "1.5";
                }
            }
            catch (Throwable bits) {
                // empty catch block
            }
        }
        JAVA_VERSION = java_version;
        API_LEVEL = api_level;
        try {
            int pos = JAVA_VERSION.indexOf(45);
            if (pos == -1) {
                pos = JAVA_VERSION.indexOf(43);
            }
            String version = pos == -1 ? JAVA_VERSION : JAVA_VERSION.substring(0, pos);
            String[] bits = version.split("\\.");
            int first = Integer.parseInt(bits[0]);
            int second = bits.length == 1 ? 0 : Integer.parseInt(bits[1]);
            _7plus = first > 1 || second >= 7;
            _8plus = first > 1 || second >= 8;
            _9plus = first > 1 || second >= 9;
            _10plus = first >= 10;
        }
        catch (Throwable e) {
            System.err.println("Unparsable Java version: " + JAVA_VERSION);
            e.printStackTrace();
            _7plus = false;
            _8plus = false;
            _9plus = false;
            _10plus = false;
        }
        isJava7OrHigher = _7plus;
        isJava8OrHigher = _8plus;
        isJava9OrHigher = _9plus;
        isJava10OrHigher = _10plus;
        FILE_WILDCARD = isWindows ? "*.*" : "*";
    }

    public static String getCurrentVersion() {
        return AZUREUS_VERSION;
    }

    public static String getBaseVersion() {
        return Constants.getBaseVersion(AZUREUS_VERSION);
    }

    public static String getBaseVersion(String version) {
        int p1 = version.indexOf("_");
        if (p1 == -1) {
            return version;
        }
        return version.substring(0, p1);
    }

    public static boolean isCVSVersion() {
        return IS_CVS_VERSION;
    }

    public static boolean isCVSVersion(String version) {
        return version.contains("_");
    }

    public static int getIncrementalBuild() {
        return Constants.getIncrementalBuild(AZUREUS_VERSION);
    }

    public static int getIncrementalBuild(String version) {
        if (!Constants.isCVSVersion(version)) {
            return 0;
        }
        int p1 = version.indexOf("_B");
        if (p1 == -1) {
            return -1;
        }
        try {
            return Integer.parseInt(version.substring(p1 + 2));
        }
        catch (Throwable e) {
            System.out.println("can't parse version");
            return -1;
        }
    }

    public static boolean isCurrentVersionLT(String version) {
        return Constants.compareVersions(AZUREUS_VERSION, version) < 0;
    }

    public static boolean isCurrentVersionGE(String version) {
        return Constants.compareVersions(AZUREUS_VERSION, version) >= 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int compareVersions(String version_1, String version_2) {
        try {
            version_1 = version_1.replaceAll("_CVS", "_B100");
            version_2 = version_2.replaceAll("_CVS", "_B100");
            if (version_1.startsWith(".")) {
                version_1 = "0" + version_1;
            }
            if (version_2.startsWith(".")) {
                version_2 = "0" + version_2;
            }
            version_1 = version_1.replaceAll("[^0-9.]", ".");
            version_2 = version_2.replaceAll("[^0-9.]", ".");
            StringTokenizer tok1 = new StringTokenizer(version_1, ".");
            StringTokenizer tok2 = new StringTokenizer(version_2, ".");
            while (true) {
                int i1;
                if (tok1.hasMoreTokens() && tok2.hasMoreTokens()) {
                    int i2;
                    i1 = Integer.parseInt(tok1.nextToken());
                    if (i1 == (i2 = Integer.parseInt(tok2.nextToken()))) continue;
                    return i1 - i2;
                }
                if (tok1.hasMoreTokens()) {
                    i1 = Integer.parseInt(tok1.nextToken());
                    if (i1 == 0) continue;
                    return 1;
                }
                if (!tok2.hasMoreTokens()) {
                    return 0;
                }
                int i2 = Integer.parseInt(tok2.nextToken());
                if (i2 != 0) break;
            }
            return -1;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static boolean isValidVersionFormat(String version) {
        if (version == null || version.length() == 0) {
            return false;
        }
        int i = 0;
        while (i < version.length()) {
            char c = version.charAt(i);
            if (!Character.isDigit(c) && c != '.') {
                return false;
            }
            ++i;
        }
        return !version.startsWith(".") && !version.endsWith(".") && !version.contains("..");
    }

    public static boolean isAzureusDomain(String host) {
        host = host.toLowerCase();
        int i = 0;
        while (i < AZUREUS_DOMAINS.length) {
            String domain = AZUREUS_DOMAINS[i];
            if (domain.equals(host)) {
                return true;
            }
            if (host.endsWith("." + domain)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static void main(String[] args) {
        System.out.println(Constants.compareVersions("3.0.0.1", "3.0.0.0"));
        System.out.println(Constants.compareVersions("3.0.0.0_B1", "3.0.0.0"));
        System.out.println(Constants.compareVersions("3.0.0.0", "3.0.0.0_B1"));
        System.out.println(Constants.compareVersions("3.0.0.0_B1", "3.0.0.0_B4"));
        System.out.println(Constants.compareVersions("3.0.0.0..B1", "3.0.0.0_B4"));
    }
}

