/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;

public class DebugWeakList {
    static final boolean DEBUG = Constants.isCVSVersion();
    private final String name;
    final List list;

    public DebugWeakList(String _name) {
        this.name = _name;
        this.list = new ArrayList();
    }

    public DebugWeakList(String _name, DebugWeakList l) {
        this.name = _name;
        this.list = new ArrayList(l.list);
    }

    public void add(Object obj) {
        if (DEBUG) {
            this.list.add(new Object[]{obj.getClass(), new WeakReference<Object>(obj)});
        } else {
            this.list.add(obj);
        }
    }

    public void remove(Object obj) {
        if (DEBUG) {
            Iterator it = this.list.iterator();
            while (it.hasNext()) {
                Object[] entry = (Object[])it.next();
                WeakReference wr = (WeakReference)entry[1];
                Object target = wr.get();
                if (target == null) {
                    it.remove();
                    this.logRemoved((Class)entry[0]);
                    continue;
                }
                if (target != obj) continue;
                it.remove();
                return;
            }
        } else {
            this.list.remove(obj);
        }
    }

    public boolean contains(Object obj) {
        if (DEBUG) {
            Iterator it = this.list.iterator();
            while (it.hasNext()) {
                Object[] entry = (Object[])it.next();
                WeakReference wr = (WeakReference)entry[1];
                Object target = wr.get();
                if (target == null) {
                    it.remove();
                    this.logRemoved((Class)entry[0]);
                    continue;
                }
                if (target != obj) continue;
                return true;
            }
            return false;
        }
        return this.list.contains(obj);
    }

    protected void logRemoved(Class cla) {
        Debug.out("Object '" + cla + "' was not removed correctly from " + this.name);
    }

    public Iterator iterator() {
        if (DEBUG) {
            return new WeakListIterator();
        }
        return this.list.iterator();
    }

    public int estimatedSize() {
        return this.list.size();
    }

    protected class WeakListIterator
    implements Iterator {
        private Iterator it;
        private Object pending_result;
        private Object last_result;

        protected WeakListIterator() {
            this.it = DebugWeakList.this.list.iterator();
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public boolean hasNext() {
            if (this.pending_result == null) ** GOTO lbl12
            return true;
lbl-1000:
            // 1 sources

            {
                entry = (Object[])this.it.next();
                wr = (WeakReference)entry[1];
                target = wr.get();
                if (target == null) {
                    this.it.remove();
                    DebugWeakList.this.logRemoved((Class)entry[0]);
                    continue;
                }
                this.pending_result = target;
                return true;
lbl12:
                // 2 sources

                ** while (this.it.hasNext())
            }
lbl13:
            // 1 sources

            return false;
        }

        public Object next() throws NoSuchElementException {
            if (this.pending_result == null) {
                this.hasNext();
            }
            if (this.pending_result == null) {
                throw new NoSuchElementException();
            }
            this.last_result = this.pending_result;
            this.pending_result = null;
            return this.last_result;
        }

        @Override
        public void remove() {
            Object lr = this.last_result;
            if (lr == null) {
                throw new NoSuchElementException();
            }
            this.last_result = null;
            if (this.pending_result == null) {
                this.it.remove();
            } else {
                Iterator temp_it = DebugWeakList.this.list.iterator();
                while (temp_it.hasNext()) {
                    Object[] entry = (Object[])temp_it.next();
                    WeakReference wr = (WeakReference)entry[1];
                    Object target = wr.get();
                    if (target != lr) continue;
                    this.it = temp_it;
                    this.it.remove();
                    return;
                }
            }
        }
    }
}

