/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreOperationTask;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.gudy.azureus2.core3.config.COConfigurationListener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AETemporaryFileHandler;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.StringInterner;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerCapabilities;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.plugins.platform.PlatformManagerException;

public class FileUtil {
    private static final LogIDs LOGID = LogIDs.CORE;
    public static final String DIR_SEP = System.getProperty("file.separator");
    private static final int RESERVED_FILE_HANDLE_COUNT = 4;
    private static boolean first_reservation = true;
    private static boolean is_my_lock_file = false;
    private static final List reserved_file_handles = new ArrayList();
    private static final AEMonitor class_mon = new AEMonitor("FileUtil:class");
    private static Method reflectOnUsableSpace;
    private static char[] char_conversion_mapping;
    private static boolean sce_checked;
    private static String script_encoding;

    static {
        char_conversion_mapping = null;
        try {
            reflectOnUsableSpace = File.class.getMethod("getUsableSpace", null);
        }
        catch (Throwable e) {
            reflectOnUsableSpace = null;
        }
    }

    public static boolean isAncestorOf(File parent, File child) {
        if ((parent = FileUtil.canonise(parent)).equals(child = FileUtil.canonise(child))) {
            return true;
        }
        String parent_s = parent.getPath();
        String child_s = child.getPath();
        if (parent_s.charAt(parent_s.length() - 1) != File.separatorChar) {
            parent_s = String.valueOf(parent_s) + File.separatorChar;
        }
        return child_s.startsWith(parent_s);
    }

    public static File canonise(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException ioe) {
            return file;
        }
    }

    public static String getCanonicalFileName(String filename) {
        String canonicalFileName = filename;
        try {
            canonicalFileName = new File(filename).getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return canonicalFileName;
    }

    public static File getUserFile(String filename) {
        return new File(SystemProperties.getUserPath(), filename);
    }

    public static File getApplicationFile(String filename) {
        String path = SystemProperties.getApplicationPath();
        if (Constants.isOSX && !new File(path, "Azureus2.jar").exists()) {
            path = String.valueOf(path) + SystemProperties.getApplicationName() + ".app/Contents/";
        }
        return new File(path, filename);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean recursiveDelete(File f) {
        String defSaveDir = COConfigurationManager.getStringParameter("Default save path");
        String moveToDir = COConfigurationManager.getStringParameter("Completed Files Directory", "");
        try {
            moveToDir = new File(moveToDir).getCanonicalPath();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            defSaveDir = new File(defSaveDir).getCanonicalPath();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (f.getCanonicalPath().equals(moveToDir)) {
                System.out.println("FileUtil::recursiveDelete:: not allowed to delete the MoveTo dir !");
                return false;
            }
            if (f.getCanonicalPath().equals(defSaveDir)) {
                System.out.println("FileUtil::recursiveDelete:: not allowed to delete the default data dir !");
                return false;
            }
            if (f.isDirectory()) {
                File[] files = f.listFiles();
                int i = 0;
                while (i < files.length) {
                    if (!FileUtil.recursiveDelete(files[i])) {
                        return false;
                    }
                    ++i;
                }
                if (!f.delete()) {
                    return false;
                }
            } else if (!f.delete()) {
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean recursiveDeleteNoCheck(File f) {
        try {
            if (f.isDirectory()) {
                File[] files = f.listFiles();
                int i = 0;
                while (i < files.length) {
                    if (!FileUtil.recursiveDeleteNoCheck(files[i])) {
                        return false;
                    }
                    ++i;
                }
                if (!f.delete()) {
                    return false;
                }
            } else if (!f.delete()) {
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public static long getFileOrDirectorySize(File file) {
        if (file.isFile()) {
            return file.length();
        }
        long res = 0L;
        File[] files = file.listFiles();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                res += FileUtil.getFileOrDirectorySize(files[i]);
                ++i;
            }
        }
        return res;
    }

    protected static void recursiveEmptyDirDelete(File f, Set ignore_set, boolean log_warnings) {
        try {
            String defSaveDir = COConfigurationManager.getStringParameter("Default save path");
            String moveToDir = COConfigurationManager.getStringParameter("Completed Files Directory", "");
            if (defSaveDir.trim().length() > 0) {
                defSaveDir = new File(defSaveDir).getCanonicalPath();
            }
            if (moveToDir.trim().length() > 0) {
                moveToDir = new File(moveToDir).getCanonicalPath();
            }
            if (f.isDirectory()) {
                File[] files = f.listFiles();
                if (files == null) {
                    if (log_warnings) {
                        Debug.out("Empty folder delete:  failed to list contents of directory " + f);
                    }
                    return;
                }
                int i = 0;
                while (i < files.length) {
                    File x = files[i];
                    if (x.isDirectory()) {
                        FileUtil.recursiveEmptyDirDelete(files[i], ignore_set, log_warnings);
                    } else if (ignore_set.contains(x.getName().toLowerCase()) && !x.delete() && log_warnings) {
                        Debug.out("Empty folder delete: failed to delete file " + x);
                    }
                    ++i;
                }
                if (f.getCanonicalPath().equals(moveToDir)) {
                    if (log_warnings) {
                        Debug.out("Empty folder delete:  not allowed to delete the MoveTo dir !");
                    }
                    return;
                }
                if (f.getCanonicalPath().equals(defSaveDir)) {
                    if (log_warnings) {
                        Debug.out("Empty folder delete:  not allowed to delete the default data dir !");
                    }
                    return;
                }
                File[] files_inside = f.listFiles();
                if (files_inside.length == 0) {
                    if (!f.delete() && log_warnings) {
                        Debug.out("Empty folder delete:  failed to delete directory " + f);
                    }
                } else if (log_warnings) {
                    Debug.out("Empty folder delete:  " + files_inside.length + " file(s)/folder(s) still in \"" + f + "\" - first listed item is \"" + files_inside[0].getName() + "\". Not removing.");
                }
            }
        }
        catch (Exception e) {
            Debug.out(e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertOSSpecificChars(String file_name_in, boolean is_folder) {
        Class<FileUtil> clazz = FileUtil.class;
        synchronized (FileUtil.class) {
            char c;
            int i;
            if (char_conversion_mapping == null) {
                COConfigurationManager.addAndFireListener(new COConfigurationListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void configurationSaved() {
                        Class<FileUtil> clazz = FileUtil.class;
                        synchronized (FileUtil.class) {
                            String map = COConfigurationManager.getStringParameter("File.Character.Conversions");
                            String[] bits = map.split(",");
                            ArrayList<Character> chars = new ArrayList<Character>();
                            String[] stringArray = bits;
                            int n = bits.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String bit = stringArray[n2];
                                if ((bit = bit.trim()).length() == 3) {
                                    char from = bit.charAt(0);
                                    char to = bit.charAt(2);
                                    chars.add(Character.valueOf(from));
                                    chars.add(Character.valueOf(to));
                                }
                                ++n2;
                            }
                            char[] new_map = new char[chars.size()];
                            int i = 0;
                            while (i < new_map.length) {
                                new_map[i] = ((Character)chars.get(i)).charValue();
                                ++i;
                            }
                            char_conversion_mapping = new_map;
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return;
                        }
                    }
                });
            }
            char[] mapping = char_conversion_mapping;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            char[] chars = file_name_in.toCharArray();
            if (mapping.length == 2) {
                char from = mapping[0];
                char to = mapping[1];
                int i2 = 0;
                while (i2 < chars.length) {
                    if (chars[i2] == from) {
                        chars[i2] = to;
                    }
                    ++i2;
                }
            } else if (mapping.length > 0) {
                i = 0;
                while (i < chars.length) {
                    c = chars[i];
                    int j = 0;
                    while (j < mapping.length) {
                        if (c == mapping[j]) {
                            chars[i] = mapping[j + 1];
                        }
                        j += 2;
                    }
                    ++i;
                }
            }
            if (!Constants.isOSX) {
                if (Constants.isWindows) {
                    String not_allowed = "\\/:?*<>|";
                    int i3 = 0;
                    while (i3 < chars.length) {
                        if (not_allowed.indexOf(chars[i3]) != -1) {
                            chars[i3] = 95;
                        }
                        ++i3;
                    }
                    if (is_folder) {
                        i3 = chars.length - 1;
                        while (i3 >= 0 && (chars[i3] == '.' || chars[i3] == ' ')) {
                            chars[i3] = 95;
                            --i3;
                        }
                    }
                }
                i = 0;
                while (i < chars.length) {
                    c = chars[i];
                    if (c == '/' || c == '\r' || c == '\n') {
                        chars[i] = 32;
                    }
                    ++i;
                }
            }
            String file_name_out = new String(chars);
            try {
                if (Constants.isWindows) {
                    while (file_name_out.endsWith(" ")) {
                        file_name_out = file_name_out.substring(0, file_name_out.length() - 1);
                    }
                } else {
                    String str = new File(file_name_out).getCanonicalFile().toString();
                    int p = str.lastIndexOf(File.separator);
                    file_name_out = str.substring(p + 1);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return file_name_out;
        }
    }

    public static void writeResilientConfigFile(String file_name, Map data) {
        File parent_dir = new File(SystemProperties.getUserPath());
        boolean use_backups = COConfigurationManager.getBooleanParameter("Use Config File Backups");
        FileUtil.writeResilientFile(parent_dir, file_name, data, use_backups);
    }

    public static void writeResilientFile(File file, Map data) {
        FileUtil.writeResilientFile(file.getParentFile(), file.getName(), data, false);
    }

    public static boolean writeResilientFileWithResult(File parent_dir, String file_name, Map data) {
        return FileUtil.writeResilientFile(parent_dir, file_name, data);
    }

    public static void writeResilientFile(File parent_dir, String file_name, Map data, boolean use_backup) {
        FileUtil.writeResilientFile(parent_dir, file_name, data, use_backup, true);
    }

    public static void writeResilientFile(File parent_dir, String file_name, Map data, boolean use_backup, boolean copy_to_backup) {
        File originator;
        if (use_backup && (originator = new File(parent_dir, file_name)).exists()) {
            FileUtil.backupFile(originator, copy_to_backup);
        }
        FileUtil.writeResilientFile(parent_dir, file_name, data);
    }

    /*
     * Exception decompiling
     */
    private static boolean writeResilientFile(File parent_dir, String file_name, Map data) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean resilientConfigFileExists(String name) {
        File parent_dir = new File(SystemProperties.getUserPath());
        boolean use_backups = COConfigurationManager.getBooleanParameter("Use Config File Backups");
        return new File(parent_dir, name).exists() || use_backups && new File(parent_dir, String.valueOf(name) + ".bak").exists();
    }

    public static Map readResilientConfigFile(String file_name) {
        File parent_dir = new File(SystemProperties.getUserPath());
        boolean use_backups = COConfigurationManager.getBooleanParameter("Use Config File Backups");
        return FileUtil.readResilientFile(parent_dir, file_name, use_backups);
    }

    public static Map readResilientConfigFile(String file_name, boolean use_backups) {
        File parent_dir = new File(SystemProperties.getUserPath());
        if (!use_backups && new File(parent_dir, String.valueOf(file_name) + ".bak").exists()) {
            use_backups = true;
        }
        return FileUtil.readResilientFile(parent_dir, file_name, use_backups);
    }

    public static Map readResilientFile(File file) {
        return FileUtil.readResilientFile(file.getParentFile(), file.getName(), false, true);
    }

    public static Map readResilientFile(File parent_dir, String file_name, boolean use_backup) {
        return FileUtil.readResilientFile(parent_dir, file_name, use_backup, true);
    }

    public static Map readResilientFile(File parent_dir, String file_name, boolean use_backup, boolean intern_keys) {
        Map res;
        File backup_file = new File(parent_dir, String.valueOf(file_name) + ".bak");
        if (use_backup) {
            use_backup = backup_file.exists();
        }
        if ((res = FileUtil.readResilientFileSupport(parent_dir, file_name, !use_backup, intern_keys)) == null && use_backup) {
            res = FileUtil.readResilientFileSupport(parent_dir, String.valueOf(file_name) + ".bak", false, intern_keys);
            if (res != null) {
                Debug.out("Backup file '" + backup_file + "' has been used for recovery purposes");
                FileUtil.writeResilientFile(parent_dir, file_name, res, false);
            } else {
                res = FileUtil.readResilientFileSupport(parent_dir, file_name, true, true);
            }
        }
        if (res == null) {
            res = new HashMap();
        }
        return res;
    }

    private static Map readResilientFileSupport(File parent_dir, String file_name, boolean attempt_recovery, boolean intern_keys) {
        try {
            Map map;
            class_mon.enter();
            try {
                FileUtil.getReservedFileHandles();
                Map res = null;
                try {
                    res = FileUtil.readResilientFile(file_name, parent_dir, file_name, 0, false, intern_keys);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (res == null && attempt_recovery && (res = FileUtil.readResilientFile(file_name, parent_dir, file_name, 0, true, intern_keys)) != null) {
                    Debug.out("File '" + file_name + "' has been partially recovered, information may have been lost!");
                }
                map = res;
            }
            catch (Throwable e) {
                try {
                    Debug.printStackTrace(e);
                }
                catch (Throwable throwable) {
                    FileUtil.releaseReservedFileHandles();
                    throw throwable;
                }
                FileUtil.releaseReservedFileHandles();
                class_mon.exit();
                return null;
            }
            FileUtil.releaseReservedFileHandles();
            return map;
        }
        finally {
            class_mon.exit();
        }
    }

    private static Map readResilientFile(String original_file_name, File parent_dir, String file_name, int fail_count, boolean recovery_mode, boolean skip_key_intern) {
        boolean using_backup = file_name.endsWith(".saving");
        File file = new File(parent_dir, file_name);
        if (!file.exists() || file.length() <= 1L) {
            if (using_backup) {
                if (!recovery_mode && fail_count == 1) {
                    Debug.out("Load of '" + original_file_name + "' fails, no usable file or backup");
                }
                return null;
            }
            return FileUtil.readResilientFile(original_file_name, parent_dir, String.valueOf(file_name) + ".saving", 0, recovery_mode, true);
        }
        BufferedInputStream bin = null;
        try {
            int retry_limit = 5;
            while (true) {
                try {
                    bin = new BufferedInputStream(new FileInputStream(file), 16384);
                }
                catch (IOException e) {
                    if (--retry_limit == 0) {
                        throw e;
                    }
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "Failed to open '" + file.toString() + "', retrying", e));
                    }
                    Thread.sleep(500L);
                    continue;
                }
                break;
            }
            BDecoder decoder = new BDecoder();
            if (recovery_mode) {
                decoder.setRecoveryMode(true);
            }
            Map<String, Object> res = decoder.decodeStream(bin, !skip_key_intern);
            if (using_backup && !recovery_mode) {
                Debug.out("Load of '" + original_file_name + "' had to revert to backup file");
            }
            Map<String, Object> map = res;
            return map;
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            try {
                if (bin != null) {
                    bin.close();
                    bin = null;
                }
            }
            catch (Exception x) {
                Debug.printStackTrace(x);
            }
            if (!recovery_mode) {
                File test;
                int bad_id = 0;
                while (true) {
                    if (!(test = new File(parent_dir, String.valueOf(file.getName()) + ".bad" + (bad_id == 0 ? "" : "" + bad_id))).exists()) break;
                    ++bad_id;
                }
                File bad = test;
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, 1, "Read of '" + original_file_name + "' failed, decoding error. " + "Renaming to " + bad.getName()));
                }
                FileUtil.copyFile(file, bad);
            }
            if (using_backup) {
                if (!recovery_mode) {
                    Debug.out("Load of '" + original_file_name + "' fails, no usable file or backup");
                }
                return null;
            }
            Map map = FileUtil.readResilientFile(original_file_name, parent_dir, String.valueOf(file_name) + ".saving", 1, recovery_mode, true);
            return map;
        }
        finally {
            try {
                if (bin != null) {
                    bin.close();
                }
            }
            catch (Exception e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public static void deleteResilientFile(File file) {
        file.delete();
        new File(file.getParentFile(), String.valueOf(file.getName()) + ".bak").delete();
    }

    public static void deleteResilientConfigFile(String name) {
        File parent_dir = new File(SystemProperties.getUserPath());
        new File(parent_dir, name).delete();
        new File(parent_dir, String.valueOf(name) + ".bak").delete();
    }

    private static void getReservedFileHandles() {
        try {
            class_mon.enter();
            while (reserved_file_handles.size() > 0) {
                InputStream is = (InputStream)reserved_file_handles.remove(0);
                try {
                    is.close();
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
        finally {
            class_mon.exit();
        }
    }

    private static void releaseReservedFileHandles() {
        try {
            try {
                class_mon.enter();
                File lock_file = new File(String.valueOf(SystemProperties.getUserPath()) + ".lock");
                if (first_reservation) {
                    first_reservation = false;
                    lock_file.delete();
                    is_my_lock_file = lock_file.createNewFile();
                } else {
                    lock_file.createNewFile();
                }
                while (reserved_file_handles.size() < 4) {
                    FileInputStream is = new FileInputStream(lock_file);
                    reserved_file_handles.add(is);
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                class_mon.exit();
            }
        }
        finally {
            class_mon.exit();
        }
    }

    public static boolean isMyFileLock() {
        return is_my_lock_file;
    }

    public static void backupFile(String _filename, boolean _make_copy) {
        FileUtil.backupFile(new File(_filename), _make_copy);
    }

    public static void backupFile(File _file, boolean _make_copy) {
        if (_file.length() > 0L) {
            File bakfile = new File(String.valueOf(_file.getAbsolutePath()) + ".bak");
            if (bakfile.exists()) {
                bakfile.delete();
            }
            if (_make_copy) {
                FileUtil.copyFile(_file, bakfile);
            } else {
                _file.renameTo(bakfile);
            }
        }
    }

    public static boolean copyFile(String _source_name, String _dest_name) {
        return FileUtil.copyFile(new File(_source_name), new File(_dest_name));
    }

    public static boolean copyFile(File _source, File _dest) {
        try {
            FileUtil.copyFile((InputStream)new FileInputStream(_source), new FileOutputStream(_dest));
            return true;
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return false;
        }
    }

    public static void copyFileWithException(File _source, File _dest) throws IOException {
        FileUtil.copyFile((InputStream)new FileInputStream(_source), new FileOutputStream(_dest));
    }

    public static boolean copyFile(File _source, OutputStream _dest, boolean closeInputStream) {
        try {
            FileUtil.copyFile((InputStream)new FileInputStream(_source), _dest, closeInputStream);
            return true;
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return false;
        }
    }

    public static void copyFile(InputStream _source, File _dest) throws IOException {
        FileOutputStream dest = null;
        boolean close_input = true;
        try {
            dest = new FileOutputStream(_dest);
            close_input = false;
            FileUtil.copyFile(_source, (OutputStream)dest, true);
        }
        finally {
            try {
                if (close_input) {
                    _source.close();
                }
            }
            catch (IOException iOException) {}
            if (dest != null) {
                dest.close();
            }
        }
    }

    public static void copyFile(InputStream _source, File _dest, boolean _close_input_stream) throws IOException {
        FileOutputStream dest = null;
        boolean close_input = _close_input_stream;
        try {
            dest = new FileOutputStream(_dest);
            close_input = false;
            FileUtil.copyFile(_source, (OutputStream)dest, close_input);
        }
        finally {
            try {
                if (close_input) {
                    _source.close();
                }
            }
            catch (IOException iOException) {}
            if (dest != null) {
                dest.close();
            }
        }
    }

    public static void copyFile(InputStream is, OutputStream os) throws IOException {
        FileUtil.copyFile(is, os, true);
    }

    public static void copyFile(InputStream is, OutputStream os, boolean closeInputStream) throws IOException {
        try {
            int len;
            if (!(is instanceof BufferedInputStream)) {
                is = new BufferedInputStream(is, 131072);
            }
            byte[] buffer = new byte[131072];
            while ((len = is.read(buffer)) != -1) {
                os.write(buffer, 0, len);
            }
        }
        finally {
            try {
                if (closeInputStream) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
            os.close();
        }
    }

    public static void copyFileOrDirectory(File from_file_or_dir, File to_parent_dir) throws IOException {
        if (!from_file_or_dir.exists()) {
            throw new IOException("File '" + from_file_or_dir.toString() + "' doesn't exist");
        }
        if (!to_parent_dir.exists()) {
            throw new IOException("File '" + to_parent_dir.toString() + "' doesn't exist");
        }
        if (!to_parent_dir.isDirectory()) {
            throw new IOException("File '" + to_parent_dir.toString() + "' is not a directory");
        }
        if (from_file_or_dir.isDirectory()) {
            File[] files = from_file_or_dir.listFiles();
            File new_parent = new File(to_parent_dir, from_file_or_dir.getName());
            FileUtil.mkdirs(new_parent);
            int i = 0;
            while (i < files.length) {
                File from_file = files[i];
                FileUtil.copyFileOrDirectory(from_file, new_parent);
                ++i;
            }
        } else {
            File target = new File(to_parent_dir, from_file_or_dir.getName());
            if (!FileUtil.copyFile(from_file_or_dir, target)) {
                throw new IOException("File copy from " + from_file_or_dir + " to " + target + " failed");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static File getFileOrBackup(String _filename) {
        File bakfile;
        block3: {
            try {
                File file = new File(_filename);
                if (file.length() > 1L) return file;
                bakfile = new File(String.valueOf(_filename) + ".bak");
                if (bakfile.length() > 1L) break block3;
                return null;
            }
            catch (Exception e) {
                Debug.out(e);
                return null;
            }
        }
        return bakfile;
    }

    public static File getJarFileFromClass(Class cla) {
        try {
            File jar_file;
            String url_str;
            String str = cla.getName();
            str = String.valueOf(str.replace('.', '/')) + ".class";
            URL url = cla.getClassLoader().getResource(str);
            if (url != null && (url_str = url.toExternalForm()).startsWith("jar:file:") && (jar_file = FileUtil.getJarFileFromURL(url_str)) != null && jar_file.exists()) {
                return jar_file;
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        return null;
    }

    public static File getJarFileFromURL(String url_str) {
        if (url_str.startsWith("jar:file:")) {
            if (!(url_str = url_str.replaceAll(" ", "%20")).startsWith("jar:file:/")) {
                url_str = "jar:file:/".concat(url_str.substring(9));
            }
            try {
                URI uri;
                int posPling = url_str.lastIndexOf(33);
                String jarName = url_str.substring(4, posPling);
                try {
                    uri = URI.create(jarName);
                    if (!new File(uri).exists()) {
                        throw new FileNotFoundException();
                    }
                }
                catch (Throwable e) {
                    jarName = "file:/" + UrlUtils.encode(jarName.substring(6));
                    uri = URI.create(jarName);
                }
                File jar = new File(uri);
                return jar;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        return null;
    }

    public static boolean renameFile(File from_file, File to_file) {
        return FileUtil.renameFile(from_file, to_file, true);
    }

    public static boolean renameFile(File from_file, File to_file, boolean fail_on_existing_directory) {
        return FileUtil.renameFile(from_file, to_file, fail_on_existing_directory, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean renameFile(File from_file, File to_file, boolean fail_on_existing_directory, FileFilter file_filter) {
        boolean move_if_same_drive;
        if (!from_file.exists()) {
            Debug.out("renameFile: source file '" + from_file + "' doesn't exist, failing");
            return false;
        }
        if (to_file.exists() && (fail_on_existing_directory || from_file.isFile() || to_file.isFile())) {
            Debug.out("renameFile: target file '" + to_file + "' already exists, failing");
            return false;
        }
        File to_file_parent = to_file.getParentFile();
        if (!to_file_parent.exists()) {
            FileUtil.mkdirs(to_file_parent);
        }
        if (from_file.isDirectory()) {
            File tf;
            File ff;
            File[] files = null;
            files = file_filter != null ? from_file.listFiles(file_filter) : from_file.listFiles();
            if (files == null) {
                return true;
            }
            int last_ok = 0;
            if (!to_file.exists()) {
                to_file.mkdir();
            }
            int i = 0;
            while (i < files.length) {
                ff = files[i];
                tf = new File(to_file, ff.getName());
                try {
                    if (!FileUtil.renameFile(ff, tf, fail_on_existing_directory, file_filter)) break;
                    ++last_ok;
                }
                catch (Throwable e) {
                    Debug.out("renameFile: failed to rename file '" + ff.toString() + "' to '" + tf.toString() + "'", e);
                    break;
                }
                ++i;
            }
            if (last_ok == files.length) {
                File[] remaining = from_file.listFiles();
                if (remaining != null && remaining.length > 0) {
                    if (file_filter != null) return true;
                    Debug.out("renameFile: files remain in '" + from_file.toString() + "', not deleting");
                    return true;
                } else {
                    if (from_file.delete()) return true;
                    Debug.out("renameFile: failed to delete '" + from_file.toString() + "'");
                }
                return true;
            }
            i = 0;
            while (i < last_ok) {
                ff = files[i];
                tf = new File(to_file, ff.getName());
                try {
                    if (!FileUtil.renameFile(tf, ff, false, null)) {
                        Debug.out("renameFile: recovery - failed to move file '" + tf.toString() + "' to '" + ff.toString() + "'");
                    }
                }
                catch (Throwable e) {
                    Debug.out("renameFile: recovery - failed to move file '" + tf.toString() + "' to '" + ff.toString() + "'", e);
                }
                ++i;
            }
            return false;
        }
        boolean copy_and_delete = COConfigurationManager.getBooleanParameter("Copy And Delete Data Rather Than Move");
        if (copy_and_delete && (move_if_same_drive = COConfigurationManager.getBooleanParameter("Move If On Same Drive")) && Constants.isWindows) {
            try {
                String str1 = from_file.getCanonicalPath();
                String str2 = to_file.getCanonicalPath();
                int drive1 = 58;
                int drive2 = 32;
                if (str1.length() > 2 && str1.charAt(1) == ':') {
                    drive1 = Character.toLowerCase(str1.charAt(0));
                }
                if (str2.length() > 2 && str2.charAt(1) == ':') {
                    drive2 = Character.toLowerCase(str2.charAt(0));
                }
                if (drive1 == drive2) {
                    copy_and_delete = false;
                }
            }
            catch (Throwable str1) {
                // empty catch block
            }
        }
        if (!copy_and_delete && from_file.renameTo(to_file)) {
            return true;
        }
        boolean success = false;
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            int len;
            fis = new FileInputStream(from_file);
            fos = new FileOutputStream(to_file);
            byte[] buffer = new byte[65536];
            while ((len = fis.read(buffer)) > 0) {
                fos.write(buffer, 0, len);
            }
            fos.close();
            fos = null;
            fis.close();
            fis = null;
            if (!from_file.delete()) {
                Debug.out("renameFile: failed to delete '" + from_file.toString() + "'");
                throw new Exception("Failed to delete '" + from_file.toString() + "'");
            }
            success = true;
            return true;
        }
        catch (Throwable e) {
            Debug.out("renameFile: failed to rename '" + from_file.toString() + "' to '" + to_file.toString() + "'", e);
            return false;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Throwable throwable) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Throwable throwable) {}
            }
            if (!success && to_file.exists()) {
                to_file.delete();
            }
        }
    }

    public static boolean writeStringAsFile(File file, String text) {
        try {
            return FileUtil.writeBytesAsFile2(file.getAbsolutePath(), text.getBytes("UTF-8"));
        }
        catch (Throwable e) {
            Debug.out(e);
            return false;
        }
    }

    public static void writeBytesAsFile(String filename, byte[] file_data) {
        FileUtil.writeBytesAsFile2(filename, file_data);
    }

    public static boolean writeBytesAsFile2(String filename, byte[] file_data) {
        try {
            File file = new File(filename);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            FileOutputStream out = new FileOutputStream(file);
            try {
                out.write(file_data);
            }
            finally {
                out.close();
            }
        }
        catch (Throwable t) {
            Debug.out("writeBytesAsFile:: error: ", t);
            return false;
        }
    }

    public static boolean deleteWithRecycle(File file, boolean force_no_recycle) {
        if (COConfigurationManager.getBooleanParameter("Move Deleted Data To Recycle Bin") && !force_no_recycle) {
            block4: {
                try {
                    PlatformManager platform = PlatformManagerFactory.getPlatformManager();
                    if (!platform.hasCapability(PlatformManagerCapabilities.RecoverableFileDelete)) break block4;
                    platform.performRecoverableFileDelete(file.getAbsolutePath());
                    return true;
                }
                catch (PlatformManagerException e) {
                    return file.delete();
                }
            }
            return file.delete();
        }
        return file.delete();
    }

    public static String translateMoveFilePath(String old_root, String new_root, String file_to_move) {
        if (!file_to_move.startsWith(old_root)) {
            return null;
        }
        if (old_root.equals(new_root)) {
            return file_to_move;
        }
        if (new_root.equals(file_to_move)) {
            return file_to_move;
        }
        String file_suffix = file_to_move.substring(old_root.length());
        if (file_suffix.startsWith(File.separator)) {
            file_suffix = file_suffix.substring(1);
        } else if (new_root.endsWith(File.separator)) {
            Debug.out("Hmm, this is not going to work out well... " + old_root + ", " + new_root + ", " + file_to_move);
        } else {
            if (new_root.endsWith(file_suffix)) {
                return new_root;
            }
            return String.valueOf(new_root) + file_suffix;
        }
        if (new_root.endsWith(File.separator)) {
            new_root = new_root.substring(0, new_root.length() - 1);
        }
        return String.valueOf(new_root) + File.separator + file_suffix;
    }

    public static void runAsTask(AzureusCoreOperationTask task2) {
        AzureusCore core = AzureusCoreFactory.getSingleton();
        core.createOperation(2, task2);
    }

    public static boolean mkdirs(File f) {
        String sVolume;
        File fVolume;
        Pattern pat;
        Matcher matcher;
        if (Constants.isOSX && (matcher = (pat = Pattern.compile("^(/Volumes/[^/]+)")).matcher(f.getParent())).find() && !(fVolume = new File(sVolume = matcher.group())).isDirectory()) {
            Logger.log(new LogEvent(LOGID, 1, String.valueOf(sVolume) + " is not mounted or not available."));
            return false;
        }
        return f.mkdirs();
    }

    public static String getExtension(String fName) {
        int fileSepIndex = fName.lastIndexOf(File.separator);
        int fileDotIndex = fName.lastIndexOf(46);
        if (fileSepIndex == fName.length() - 1 || fileDotIndex == -1 || fileSepIndex > fileDotIndex) {
            return "";
        }
        return fName.substring(fileDotIndex);
    }

    public static String readFileAsString(File file, int size_limit, String charset) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        try {
            String string = FileUtil.readInputStreamAsString(fis, size_limit, charset);
            return string;
        }
        finally {
            fis.close();
        }
    }

    public static String readFileAsString(File file, int size_limit) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        try {
            String string = FileUtil.readInputStreamAsString(fis, size_limit);
            return string;
        }
        finally {
            fis.close();
        }
    }

    public static String readGZippedFileAsString(File file, int size_limit) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        try {
            GZIPInputStream zis = new GZIPInputStream(fis);
            String string = FileUtil.readInputStreamAsString(zis, size_limit);
            return string;
        }
        finally {
            fis.close();
        }
    }

    public static String readInputStreamAsString(InputStream is, int size_limit) throws IOException {
        return FileUtil.readInputStreamAsString(is, size_limit, "ISO-8859-1");
    }

    public static String readInputStreamAsString(InputStream is, int size_limit, String charSet) throws IOException {
        int len;
        StringBuilder result = new StringBuilder(1024);
        byte[] buffer = new byte[65536];
        while ((len = is.read(buffer)) > 0) {
            result.append(new String(buffer, 0, len, charSet));
            if (size_limit < 0 || result.length() <= size_limit) continue;
            result.setLength(size_limit);
            break;
        }
        return result.toString();
    }

    public static String readInputStreamAsStringWithTruncation(InputStream is, int size_limit) throws IOException {
        StringBuilder result = new StringBuilder(1024);
        byte[] buffer = new byte[65536];
        try {
            int len;
            while ((len = is.read(buffer)) > 0) {
                result.append(new String(buffer, 0, len, "ISO-8859-1"));
                if (size_limit < 0 || result.length() <= size_limit) continue;
                result.setLength(size_limit);
                break;
            }
        }
        catch (SocketTimeoutException socketTimeoutException) {
            // empty catch block
        }
        return result.toString();
    }

    public static String readFileEndAsString(File file, int size_limit) throws IOException {
        return FileUtil.readFileEndAsString(file, size_limit, "ISO-8859-1");
    }

    public static String readFileEndAsString(File file, int size_limit, String charset) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        try {
            int len;
            if (file.length() > (long)size_limit) {
                fis.skip(file.length() - (long)size_limit);
            }
            StringBuilder result = new StringBuilder(1024);
            byte[] buffer = new byte[65536];
            while ((len = fis.read(buffer)) > 0) {
                result.append(new String(buffer, 0, len, charset));
                if (result.length() <= size_limit) continue;
                result.setLength(size_limit);
                break;
            }
            String string = result.toString();
            return string;
        }
        finally {
            fis.close();
        }
    }

    public static byte[] readInputStreamAsByteArray(InputStream is) throws IOException {
        return FileUtil.readInputStreamAsByteArray(is, Integer.MAX_VALUE);
    }

    public static byte[] readInputStreamAsByteArray(InputStream is, int size_limit) throws IOException {
        int len;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(32768);
        byte[] buffer = new byte[32768];
        while ((len = is.read(buffer)) > 0) {
            baos.write(buffer, 0, len);
            if (baos.size() <= size_limit) continue;
            throw new IOException("size limit exceeded");
        }
        return baos.toByteArray();
    }

    public static byte[] readFileAsByteArray(File file) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream((int)file.length());
        byte[] buffer = new byte[32768];
        FileInputStream is = new FileInputStream(file);
        try {
            int len;
            while ((len = ((InputStream)is).read(buffer)) > 0) {
                baos.write(buffer, 0, len);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        finally {
            ((InputStream)is).close();
        }
    }

    public static final boolean getUsableSpaceSupported() {
        return reflectOnUsableSpace != null;
    }

    public static final long getUsableSpace(File f) {
        try {
            return (Long)reflectOnUsableSpace.invoke((Object)f, new Object[0]);
        }
        catch (Throwable e) {
            return -1L;
        }
    }

    public static boolean canReallyWriteToAppDirectory() {
        block16: {
            if (!FileUtil.getApplicationFile("bogus").getParentFile().canWrite()) {
                return false;
            }
            if (Constants.isWindowsVistaOrHigher) {
                try {
                    File[] files;
                    File write_test = FileUtil.getApplicationFile("_az_.dll");
                    FileOutputStream fos = new FileOutputStream(write_test);
                    try {
                        fos.write(32);
                    }
                    finally {
                        fos.close();
                    }
                    write_test.delete();
                    File rename_test = FileUtil.getApplicationFile("License.txt");
                    if (!rename_test.exists()) {
                        rename_test = FileUtil.getApplicationFile("GPL.txt");
                    }
                    if (!rename_test.exists() && (files = write_test.getParentFile().listFiles()) != null) {
                        File[] fileArray = files;
                        int n = files.length;
                        int n2 = 0;
                        while (n2 < n) {
                            File f = fileArray[n2];
                            String name = f.getName();
                            if (name.endsWith(".txt") || name.endsWith(".log")) {
                                rename_test = f;
                                break;
                            }
                            ++n2;
                        }
                    }
                    if (rename_test.exists()) {
                        File target = new File(rename_test.getParentFile(), String.valueOf(rename_test.getName()) + ".bak");
                        target.delete();
                        rename_test.renameTo(target);
                        if (rename_test.exists()) {
                        }
                        target.renameTo(rename_test);
                        break block16;
                    }
                    Debug.out("Failed to find a suitable file for the rename test");
                }
                finally {
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean canWriteToDirectory(File dir) {
        if (!dir.isDirectory()) {
            return false;
        }
        try {
            File temp = AETemporaryFileHandler.createTempFileInDir(dir);
            if (!temp.delete()) {
                temp.deleteOnExit();
            }
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getScriptCharsetEncoding() {
        Class<FileUtil> clazz = FileUtil.class;
        synchronized (FileUtil.class) {
            String jvm_encoding;
            String file_encoding;
            block8: {
                if (sce_checked) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return script_encoding;
                }
                sce_checked = true;
                file_encoding = System.getProperty("file.encoding", null);
                jvm_encoding = System.getProperty("sun.jnu.encoding", null);
                if (file_encoding != null && jvm_encoding != null && !file_encoding.equals(jvm_encoding)) break block8;
                // ** MonitorExit[var0] (shouldn't be in output)
                return null;
            }
            try {
                String test_str = SystemProperties.getUserPath();
                if (!new String(test_str.getBytes(file_encoding), file_encoding).equals(test_str) && new String(test_str.getBytes(jvm_encoding), jvm_encoding).equals(test_str)) {
                    Debug.out("Script encoding determined to be " + jvm_encoding + " instead of " + file_encoding);
                    script_encoding = jvm_encoding;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return script_encoding;
        }
    }

    public static InternedFile internFileComponents(File file) {
        if (file == null) {
            return null;
        }
        ArrayList<String> comps = new ArrayList<String>(100);
        File comp2 = file;
        while (comp2 != null) {
            String name = comp2.getName();
            if (name.length() > 0) {
                comps.add(StringInterner.intern(name));
            } else {
                String path = comp2.getPath();
                if (path.length() > 0) {
                    comps.add(StringInterner.intern(path));
                }
            }
            comp2 = comp2.getParentFile();
        }
        InternedFile res = new InternedFile(comps.toArray(new String[comps.size()]));
        if (!res.getFile().equals(file)) {
            Debug.out("intern failed for " + file + " (" + res.getFile() + ")");
        }
        return res;
    }

    public static class InternedFile {
        private final String[] comps;

        private InternedFile(String[] _comps) {
            this.comps = _comps;
        }

        public File getFile() {
            if (this.comps.length == 0) {
                return new File("");
            }
            if (this.comps.length == 1) {
                return new File(this.comps[0]);
            }
            StringBuilder b = new StringBuilder(256);
            int i = this.comps.length - 1;
            while (i >= 0) {
                if (b.length() > 0) {
                    b.append(File.separatorChar);
                }
                b.append(this.comps[i]);
                --i;
            }
            return new File(b.toString());
        }

        public boolean equals(Object other) {
            if (other instanceof InternedFile) {
                InternedFile o = (InternedFile)other;
                if (this.comps.length != o.comps.length) {
                    return false;
                }
                int i = this.comps.length - 1;
                while (i >= 0) {
                    if (!this.comps[i].equals(o.comps[i])) {
                        return false;
                    }
                    --i;
                }
                return true;
            }
            if (other instanceof File) {
                return this.getFile().equals(other);
            }
            return false;
        }

        public int hashCode() {
            int h = 0;
            String[] stringArray = this.comps;
            int n = this.comps.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                h += s.hashCode();
                ++n2;
            }
            return h;
        }
    }
}

