/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.proxy.AEProxyFactory;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.core.util.DNSUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.DiskManagerFactory;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.internat.LocaleTorrentUtil;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoder;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogRelation;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLGroup;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLSet;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.torrent.TOTorrentListener;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileIsADirectoryException;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.ThreadPool;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderFactoryImpl;

public class TorrentUtils {
    public static final long MAX_TORRENT_FILE_SIZE = 0x4000000L;
    private static final String NO_VALID_URL_URL = "http://no.valid.urls.defined/announce";
    public static final int TORRENT_FLAG_LOW_NOISE = 1;
    public static final int TORRENT_FLAG_METADATA_TORRENT = 2;
    private static final String TORRENT_AZ_PROP_DHT_BACKUP_ENABLE = "dht_backup_enable";
    private static final String TORRENT_AZ_PROP_DHT_BACKUP_REQUESTED = "dht_backup_requested";
    private static final String TORRENT_AZ_PROP_TORRENT_FLAGS = "torrent_flags";
    private static final String TORRENT_AZ_PROP_PLUGINS = "plugins";
    public static final String TORRENT_AZ_PROP_OBTAINED_FROM = "obtained_from";
    private static final String TORRENT_AZ_PROP_NETWORK_CACHE = "network_cache";
    private static final String TORRENT_AZ_PROP_TAG_CACHE = "tag_cache";
    private static final String TORRENT_AZ_PROP_PEER_CACHE = "peer_cache";
    private static final String TORRENT_AZ_PROP_PEER_CACHE_VALID = "peer_cache_valid";
    public static final String TORRENT_AZ_PROP_INITIAL_LINKAGE = "initial_linkage";
    public static final String TORRENT_AZ_PROP_INITIAL_LINKAGE2 = "initial_linkage2";
    private static final String MEM_ONLY_TORRENT_PATH = "?/\\!:mem_only:!\\/?";
    private static final long PC_MARKER;
    private static final List<byte[]> created_torrents;
    private static final Set<HashWrapper> created_torrents_set;
    private static final ThreadLocal<Map<String, Object>> tls;
    private static volatile Set<String> ignore_files_set;
    private static volatile Set<String> skip_extensions_set;
    private static boolean bSaveTorrentBackup;
    private static final CopyOnWriteList<torrentAttributeListener> torrent_attribute_listeners;
    static final CopyOnWriteList<TorrentAnnounceURLChangeListener> torrent_url_changed_listeners;
    private static final AsyncDispatcher dispatcher;
    private static boolean DNS_HANDLING_ENABLE;
    private static final boolean TRACE_DNS = false;
    private static final int DNS_HISTORY_TIMEOUT = 14400000;
    private static final Map<String, DNSTXTEntry> dns_mapping;
    private static volatile int dns_mapping_seq_count;
    private static final ThreadPool dns_threads;
    static final DNSUtils.DNSUtilsIntf dns_utils;
    static final AtomicLong torrent_delete_level;
    static long torrent_delete_time;
    private static final int PIECE_HASH_TIMEOUT = 180000;
    static final Map torrent_delegates;
    static final HashSet torrentFluffKeyset;
    static final Map fluffThombstone;
    private static final Pattern txt_pattern;

    static {
        AEDiagnostics.addEvidenceGenerator(new AEDiagnosticsEvidenceGenerator(){

            @Override
            public void generate(IndentWriter writer) {
                writer.println("DNS TXT Records");
                try {
                    writer.indent();
                    Set<String> names = COConfigurationManager.getDefinedParameters();
                    String prefix = "dns.txts.cache.";
                    for (String name : names) {
                        if (!name.startsWith(prefix)) continue;
                        try {
                            String tracker = new String(Base32.decode(name.substring(prefix.length())), "UTF-8");
                            String str = "";
                            List txts = COConfigurationManager.getListParameter(name, null);
                            if (txts != null) {
                                for (byte[] txt : txts) {
                                    str = String.valueOf(str) + (str.length() == 0 ? "" : ", ") + new String(txt, "UTF-8");
                                }
                            }
                            writer.println(String.valueOf(tracker) + " -> [" + str + "]");
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                }
                finally {
                    writer.exdent();
                }
            }
        });
        PC_MARKER = RandomUtils.nextLong();
        tls = new ThreadLocal<Map<String, Object>>(){

            @Override
            public Map<String, Object> initialValue() {
                return new HashMap<String, Object>();
            }
        };
        torrent_attribute_listeners = new CopyOnWriteList();
        torrent_url_changed_listeners = new CopyOnWriteList();
        dispatcher = new AsyncDispatcher();
        DNS_HANDLING_ENABLE = true;
        dns_mapping = new HashMap<String, DNSTXTEntry>();
        dns_threads = new ThreadPool("DNS:lookups", 16, true);
        SimpleTimer.addPeriodicEvent("TU:dnstimer", 0x6DDD00L, new TimerEventPerformer(){

            @Override
            public void perform(TimerEvent event2) {
                if (DNS_HANDLING_ENABLE) {
                    TorrentUtils.checkDNSTimeouts();
                }
            }
        });
        dns_utils = DNSUtils.getSingleton();
        COConfigurationManager.addAndFireParameterListeners(new String[]{"Save Torrent Backup", "Tracker DNS Records Enable", "Enable.Proxy"}, new ParameterListener(){

            @Override
            public void parameterChanged(String _name) {
                bSaveTorrentBackup = COConfigurationManager.getBooleanParameter("Save Torrent Backup");
                boolean enable_proxy = COConfigurationManager.getBooleanParameter("Enable.Proxy");
                DNS_HANDLING_ENABLE = dns_utils != null && COConfigurationManager.getBooleanParameter("Tracker DNS Records Enable") && !enable_proxy;
            }
        });
        created_torrents = COConfigurationManager.getListParameter("my.created.torrents", new ArrayList());
        created_torrents_set = new HashSet<HashWrapper>();
        Iterator<byte[]> it = created_torrents.iterator();
        while (it.hasNext()) {
            created_torrents_set.add(new HashWrapper(it.next()));
        }
        torrent_delete_level = new AtomicLong();
        torrent_delegates = new WeakHashMap();
        SimpleTimer.addPeriodicEvent("TorrentUtils:pieceDiscard", 90000L, new TimerEventPerformer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void perform(TimerEvent event2) {
                long now = SystemTime.getCurrentTime();
                Map map = torrent_delegates;
                synchronized (map) {
                    Iterator it = torrent_delegates.keySet().iterator();
                    while (it.hasNext()) {
                        ((torrentDelegate)it.next()).discardPieces(now, false);
                    }
                }
            }
        });
        torrentFluffKeyset = new HashSet(2);
        fluffThombstone = new HashMap(1);
        txt_pattern = Pattern.compile("(UDP|TCP):([0-9]+)");
    }

    public static TOTorrent readFromFile(File file, boolean create_delegate) throws TOTorrentException {
        return TorrentUtils.readFromFile(file, create_delegate, false);
    }

    public static ExtendedTorrent readDelegateFromFile(File file, boolean force_initial_discard) throws TOTorrentException {
        return (ExtendedTorrent)TorrentUtils.readFromFile(file, true, force_initial_discard);
    }

    public static TOTorrent readFromFile(File file, boolean create_delegate, boolean force_initial_discard) throws TOTorrentException {
        TOTorrent torrent;
        try {
            File torrent_file_bak;
            torrent = TOTorrentFactory.deserialiseFromBEncodedFile(file);
            if (bSaveTorrentBackup && !(torrent_file_bak = new File(file.getParent(), String.valueOf(file.getName()) + ".bak")).exists()) {
                try {
                    torrent.serialiseToBEncodedFile(torrent_file_bak);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
        catch (TOTorrentException e) {
            File torrentBackup = new File(file.getParent(), String.valueOf(file.getName()) + ".bak");
            if (torrentBackup.exists()) {
                torrent = TOTorrentFactory.deserialiseFromBEncodedFile(torrentBackup);
            }
            throw e;
        }
        torrent.setAdditionalStringProperty("torrent filename", file.toString());
        if (create_delegate) {
            torrentDelegate res = new torrentDelegate(torrent, file);
            if (force_initial_discard) {
                res.discardPieces(SystemTime.getCurrentTime(), true);
            }
            return res;
        }
        return torrent;
    }

    public static TOTorrent readFromBEncodedInputStream(InputStream is) throws TOTorrentException {
        TOTorrent torrent = TOTorrentFactory.deserialiseFromBEncodedInputStream(is);
        torrent.removeAdditionalProperties();
        return torrent;
    }

    public static TOTorrent cloneTorrent(TOTorrent torrent) throws TOTorrentException {
        return TOTorrentFactory.deserialiseFromMap(torrent.serialiseToMap());
    }

    public static void setMemoryOnly(TOTorrent torrent, boolean mem_only) {
        if (mem_only) {
            torrent.setAdditionalStringProperty("torrent filename", MEM_ONLY_TORRENT_PATH);
        } else {
            String s = torrent.getAdditionalStringProperty("torrent filename");
            if (s != null && s.equals(MEM_ONLY_TORRENT_PATH)) {
                torrent.removeAdditionalProperty("torrent filename");
            }
        }
    }

    public static void writeToFile(TOTorrent torrent) throws TOTorrentException {
        TorrentUtils.writeToFile(torrent, false);
    }

    public static void writeToFile(TOTorrent torrent, boolean force_backup) throws TOTorrentException {
        try {
            torrent.getMonitor().enter();
            String str = torrent.getAdditionalStringProperty("torrent filename");
            if (str == null) {
                throw new TOTorrentException("TorrentUtils::writeToFile: no 'torrent filename' attribute defined", 1);
            }
            if (str.equals(MEM_ONLY_TORRENT_PATH)) {
                return;
            }
            File torrent_file_tmp = new File(String.valueOf(str) + "._az");
            torrent.serialiseToBEncodedFile(torrent_file_tmp);
            File torrent_file = new File(str);
            if ((force_backup || COConfigurationManager.getBooleanParameter("Save Torrent Backup")) && torrent_file.exists()) {
                File torrent_file_bak = new File(String.valueOf(str) + ".bak");
                try {
                    torrent_file_bak.delete();
                    torrent_file.renameTo(torrent_file_bak);
                }
                catch (SecurityException e) {
                    Debug.printStackTrace(e);
                }
            }
            if (torrent_file.exists()) {
                torrent_file.delete();
            }
            torrent_file_tmp.renameTo(torrent_file);
        }
        finally {
            torrent.getMonitor().exit();
        }
    }

    public static void writeToFile(TOTorrent torrent, File file) throws TOTorrentException {
        TorrentUtils.writeToFile(torrent, file, false);
    }

    public static void writeToFile(TOTorrent torrent, File file, boolean force_backup) throws TOTorrentException {
        torrent.setAdditionalStringProperty("torrent filename", file.toString());
        TorrentUtils.writeToFile(torrent, force_backup);
    }

    public static String getTorrentFileName(TOTorrent torrent) throws TOTorrentException {
        String str = torrent.getAdditionalStringProperty("torrent filename");
        if (str == null) {
            throw new TOTorrentException("TorrentUtils::getTorrentFileName: no 'torrent filename' attribute defined", 1);
        }
        if (str.equals(MEM_ONLY_TORRENT_PATH)) {
            return null;
        }
        return str;
    }

    public static void copyToFile(TOTorrent torrent, File file) throws TOTorrentException {
        torrent.serialiseToBEncodedFile(file);
    }

    public static void delete(TOTorrent torrent) throws TOTorrentException {
        try {
            torrent.getMonitor().enter();
            String str = torrent.getAdditionalStringProperty("torrent filename");
            if (str == null) {
                throw new TOTorrentException("TorrentUtils::delete: no 'torrent filename' attribute defined", 1);
            }
            if (str.equals(MEM_ONLY_TORRENT_PATH)) {
                return;
            }
            File file = new File(str);
            if (!file.delete() && file.exists()) {
                throw new TOTorrentException("TorrentUtils::delete: failed to delete '" + str + "'", 5);
            }
            new File(String.valueOf(str) + ".bak").delete();
        }
        finally {
            torrent.getMonitor().exit();
        }
    }

    public static void delete(File torrent_file, boolean force_no_recycle) {
        if (!FileUtil.deleteWithRecycle(torrent_file, force_no_recycle) && torrent_file.exists()) {
            Debug.out("TorrentUtils::delete: failed to delete '" + torrent_file + "'");
        }
        new File(String.valueOf(torrent_file.toString()) + ".bak").delete();
    }

    public static boolean move(File from_torrent, File to_torrent) {
        if (!FileUtil.renameFile(from_torrent, to_torrent)) {
            return false;
        }
        if (new File(String.valueOf(from_torrent.toString()) + ".bak").exists()) {
            FileUtil.renameFile(new File(String.valueOf(from_torrent.toString()) + ".bak"), new File(String.valueOf(to_torrent.toString()) + ".bak"));
        }
        return true;
    }

    public static String exceptionToText(TOTorrentException e) {
        String msg;
        int reason = e.getReason();
        String errorDetail = reason == 1 ? MessageText.getString("DownloadManager.error.filenotfound") : (reason == 2 ? MessageText.getString("DownloadManager.error.fileempty") : (reason == 3 ? MessageText.getString("DownloadManager.error.filetoobig") : (reason == 6 ? MessageText.getString("DownloadManager.error.filewithouttorrentinfo") : (reason == 7 ? MessageText.getString("DownloadManager.error.unsupportedencoding") : (reason == 4 ? MessageText.getString("DownloadManager.error.ioerror") : (reason == 8 ? MessageText.getString("DownloadManager.error.sha1") : (reason == 9 ? MessageText.getString("DownloadManager.error.operationcancancelled") : Debug.getNestedExceptionMessage(e))))))));
        if (!errorDetail.contains(msg = Debug.getNestedExceptionMessage(e))) {
            errorDetail = String.valueOf(errorDetail) + " (" + msg + ")";
        }
        return errorDetail;
    }

    public static Set<String> getUniqueTrackerHosts(TOTorrent torrent) {
        HashSet<String> hosts = new HashSet<String>();
        if (torrent != null) {
            TOTorrentAnnounceURLSet[] sets;
            String host;
            URL announce_url = torrent.getAnnounceURL();
            if (announce_url != null && (host = announce_url.getHost()) != null) {
                hosts.add(host.toLowerCase(Locale.US));
            }
            TOTorrentAnnounceURLGroup group = torrent.getAnnounceURLGroup();
            TOTorrentAnnounceURLSet[] tOTorrentAnnounceURLSetArray = sets = group.getAnnounceURLSets();
            int n = sets.length;
            int n2 = 0;
            while (n2 < n) {
                URL[] urls;
                TOTorrentAnnounceURLSet set = tOTorrentAnnounceURLSetArray[n2];
                URL[] uRLArray = urls = set.getAnnounceURLs();
                int n3 = urls.length;
                int n4 = 0;
                while (n4 < n3) {
                    URL u = uRLArray[n4];
                    String host2 = u.getHost();
                    if (host2 != null) {
                        hosts.add(host2.toLowerCase(Locale.US));
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return hosts;
    }

    public static String announceGroupsToText(TOTorrent torrent) {
        URL announce_url = torrent.getAnnounceURL();
        String announce_url_str = announce_url == null ? "" : announce_url.toString().trim();
        TOTorrentAnnounceURLGroup group = torrent.getAnnounceURLGroup();
        TOTorrentAnnounceURLSet[] sets = group.getAnnounceURLSets();
        if (sets.length == 0) {
            return announce_url_str;
        }
        StringBuilder sb = new StringBuilder(1024);
        boolean announce_found = false;
        int i = 0;
        while (i < sets.length) {
            TOTorrentAnnounceURLSet set = sets[i];
            URL[] urls = set.getAnnounceURLs();
            if (urls.length > 0) {
                int j = 0;
                while (j < urls.length) {
                    String str = urls[j].toString().trim();
                    if (str.equals(announce_url_str)) {
                        announce_found = true;
                    }
                    sb.append(str);
                    sb.append("\r\n");
                    ++j;
                }
                sb.append("\r\n");
            }
            ++i;
        }
        String result = sb.toString().trim();
        if (!announce_found && announce_url_str.length() > 0) {
            result = result.length() == 0 ? announce_url_str : "\r\n\r\n" + announce_url_str;
        }
        return result;
    }

    public static String announceGroupsToText(List<List<String>> group) {
        StringBuilder sb = new StringBuilder(1024);
        for (List<String> urls : group) {
            if (sb.length() > 0) {
                sb.append("\r\n");
            }
            for (String str : urls) {
                sb.append(str);
                sb.append("\r\n");
            }
        }
        return sb.toString().trim();
    }

    public static List<List<String>> announceTextToGroups(String text) {
        ArrayList<List<String>> groups = new ArrayList<List<String>>();
        String[] lines = text.split("\n");
        ArrayList<String> current_group = new ArrayList<String>();
        HashSet<String> hits = new HashSet<String>();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if ((line = line.trim()).length() == 0) {
                if (current_group.size() > 0) {
                    groups.add(current_group);
                    current_group = new ArrayList();
                }
            } else {
                String lc_line = line.toLowerCase();
                if (!hits.contains(lc_line)) {
                    hits.add(lc_line);
                    current_group.add(line);
                }
            }
            ++n2;
        }
        if (current_group.size() > 0) {
            groups.add(current_group);
        }
        return groups;
    }

    public static List<List<String>> announceGroupsToList(TOTorrent torrent) {
        ArrayList<List<String>> groups = new ArrayList<List<String>>();
        TOTorrentAnnounceURLGroup group = torrent.getAnnounceURLGroup();
        TOTorrentAnnounceURLSet[] sets = group.getAnnounceURLSets();
        if (sets.length == 0) {
            ArrayList<String> s = new ArrayList<String>();
            s.add(UrlUtils.getCanonicalString(torrent.getAnnounceURL()));
            groups.add(s);
        } else {
            ArrayList<String> s;
            HashSet<String> all_urls = new HashSet<String>();
            int i = 0;
            while (i < sets.length) {
                s = new ArrayList<String>();
                TOTorrentAnnounceURLSet set = sets[i];
                URL[] urls = set.getAnnounceURLs();
                int j = 0;
                while (j < urls.length) {
                    String u = UrlUtils.getCanonicalString(urls[j]);
                    s.add(u);
                    all_urls.add(u);
                    ++j;
                }
                if (s.size() > 0) {
                    groups.add(s);
                }
                ++i;
            }
            String a = UrlUtils.getCanonicalString(torrent.getAnnounceURL());
            if (!all_urls.contains(a)) {
                s = new ArrayList();
                s.add(a);
                groups.add(0, s);
            }
        }
        return groups;
    }

    public static TOTorrentAnnounceURLSet[] listToAnnounceSets(List<List<String>> groups, TOTorrent torrent) {
        ArrayList<TOTorrentAnnounceURLSet> sets = new ArrayList<TOTorrentAnnounceURLSet>();
        for (List<String> group : groups) {
            ArrayList<URL> urls = new ArrayList<URL>(group.size());
            for (String s : group) {
                try {
                    urls.add(new URL(s));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (urls.size() <= 0) continue;
            sets.add(torrent.getAnnounceURLGroup().createAnnounceURLSet(urls.toArray(new URL[urls.size()])));
        }
        return sets.toArray(new TOTorrentAnnounceURLSet[sets.size()]);
    }

    public static void listToAnnounceGroups(List<List<String>> groups, TOTorrent torrent) {
        try {
            List<String> set;
            TOTorrentAnnounceURLGroup tg = torrent.getAnnounceURLGroup();
            if (groups.size() == 1 && (set = groups.get(0)).size() == 1) {
                torrent.setAnnounceURL(new URL(set.get(0)));
                tg.setAnnounceURLSets(new TOTorrentAnnounceURLSet[0]);
                return;
            }
            String announce_url = torrent.getAnnounceURL().toExternalForm();
            URL first_url = null;
            Vector<TOTorrentAnnounceURLSet> g = new Vector<TOTorrentAnnounceURLSet>();
            int i = 0;
            while (i < groups.size()) {
                List<String> set2 = groups.get(i);
                URL[] urls = new URL[set2.size()];
                int j = 0;
                while (j < set2.size()) {
                    String url_str = set2.get(j);
                    if (announce_url != null && url_str.equals(announce_url)) {
                        announce_url = null;
                    }
                    urls[j] = new URL(set2.get(j));
                    if (first_url == null) {
                        first_url = urls[j];
                    }
                    ++j;
                }
                if (urls.length > 0) {
                    g.add(tg.createAnnounceURLSet(urls));
                }
                ++i;
            }
            Object[] sets = new TOTorrentAnnounceURLSet[g.size()];
            if (sets.length == 0) {
                torrent.setAnnounceURL(new URL(NO_VALID_URL_URL));
            } else if (announce_url != null && first_url != null) {
                torrent.setAnnounceURL(first_url);
            }
            g.copyInto(sets);
            tg.setAnnounceURLSets((TOTorrentAnnounceURLSet[])sets);
        }
        catch (MalformedURLException e) {
            Debug.printStackTrace(e);
        }
    }

    public static void announceGroupsInsertFirst(TOTorrent torrent, String first_url) {
        try {
            TorrentUtils.announceGroupsInsertFirst(torrent, new URL(first_url));
        }
        catch (MalformedURLException e) {
            Debug.printStackTrace(e);
        }
    }

    public static void announceGroupsInsertFirst(TOTorrent torrent, URL first_url) {
        TorrentUtils.announceGroupsInsertFirst(torrent, new URL[]{first_url});
    }

    public static void announceGroupsInsertFirst(TOTorrent torrent, URL[] first_urls) {
        TOTorrentAnnounceURLGroup group = torrent.getAnnounceURLGroup();
        TOTorrentAnnounceURLSet[] sets = group.getAnnounceURLSets();
        TOTorrentAnnounceURLSet set1 = group.createAnnounceURLSet(first_urls);
        if (sets.length > 0) {
            TOTorrentAnnounceURLSet[] new_sets = new TOTorrentAnnounceURLSet[sets.length + 1];
            new_sets[0] = set1;
            System.arraycopy(sets, 0, new_sets, 1, sets.length);
            group.setAnnounceURLSets(new_sets);
        } else {
            TOTorrentAnnounceURLSet set2 = group.createAnnounceURLSet(new URL[]{torrent.getAnnounceURL()});
            group.setAnnounceURLSets(new TOTorrentAnnounceURLSet[]{set1, set2});
        }
    }

    public static void announceGroupsInsertLast(TOTorrent torrent, URL[] first_urls) {
        TOTorrentAnnounceURLGroup group = torrent.getAnnounceURLGroup();
        TOTorrentAnnounceURLSet[] sets = group.getAnnounceURLSets();
        TOTorrentAnnounceURLSet set1 = group.createAnnounceURLSet(first_urls);
        if (sets.length > 0) {
            TOTorrentAnnounceURLSet[] new_sets = new TOTorrentAnnounceURLSet[sets.length + 1];
            new_sets[sets.length] = set1;
            System.arraycopy(sets, 0, new_sets, 0, sets.length);
            group.setAnnounceURLSets(new_sets);
        } else {
            TOTorrentAnnounceURLSet set2 = group.createAnnounceURLSet(new URL[]{torrent.getAnnounceURL()});
            group.setAnnounceURLSets(new TOTorrentAnnounceURLSet[]{set2, set1});
        }
    }

    public static void announceGroupsSetFirst(TOTorrent torrent, String first_url) {
        List<List<String>> groups = TorrentUtils.announceGroupsToList(torrent);
        boolean found = false;
        int i = 0;
        block0: while (i < groups.size()) {
            List<String> set = groups.get(i);
            int j = 0;
            while (j < set.size()) {
                if (first_url.equals(set.get(j))) {
                    set.remove(j);
                    set.add(0, first_url);
                    groups.remove(set);
                    groups.add(0, set);
                    found = true;
                    break block0;
                }
                ++j;
            }
            ++i;
        }
        if (!found) {
            System.out.println("TorrentUtils::announceGroupsSetFirst - failed to find '" + first_url + "'");
        }
        TorrentUtils.listToAnnounceGroups(groups, torrent);
    }

    public static boolean announceGroupsContainsURL(TOTorrent torrent, String url) {
        List<List<String>> groups = TorrentUtils.announceGroupsToList(torrent);
        int i = 0;
        while (i < groups.size()) {
            List<String> set = groups.get(i);
            int j = 0;
            while (j < set.size()) {
                if (url.equals(set.get(j))) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean canMergeAnnounceURLs(TOTorrent new_torrent, TOTorrent dest_torrent) {
        try {
            List<List<String>> new_groups = TorrentUtils.announceGroupsToList(new_torrent);
            List<List<String>> dest_groups = TorrentUtils.announceGroupsToList(dest_torrent);
            HashSet<String> all_dest = new HashSet<String>();
            for (List<String> l : dest_groups) {
                all_dest.addAll(l);
            }
            for (List<String> l : new_groups) {
                for (String u : l) {
                    List<URL> mods = TorrentUtils.applyAllDNSMods(new URL(u));
                    if (mods == null) continue;
                    for (URL m : mods) {
                        if (all_dest.contains(UrlUtils.getCanonicalString(m))) continue;
                        return true;
                    }
                }
            }
            return false;
        }
        catch (Throwable e) {
            Debug.out(e);
        }
        return false;
    }

    public static boolean mergeAnnounceURLs(TOTorrent new_torrent, TOTorrent dest_torrent) {
        if (new_torrent == null || dest_torrent == null) {
            return false;
        }
        List<List<String>> new_groups = TorrentUtils.announceGroupsToList(new_torrent);
        List<List<String>> dest_groups = TorrentUtils.announceGroupsToList(dest_torrent);
        ArrayList<List<String>> groups_to_add = new ArrayList<List<String>>();
        int i = 0;
        while (i < new_groups.size()) {
            List<String> new_set = new_groups.get(i);
            boolean match = false;
            int j = 0;
            while (j < dest_groups.size()) {
                boolean same;
                List<String> dest_set = dest_groups.get(j);
                boolean bl = same = new_set.size() == dest_set.size();
                if (same) {
                    int k = 0;
                    while (k < new_set.size()) {
                        String new_url = new_set.get(k);
                        if (!dest_set.contains(new_url)) {
                            same = false;
                            break;
                        }
                        ++k;
                    }
                }
                if (same) {
                    match = true;
                    break;
                }
                ++j;
            }
            if (!match) {
                groups_to_add.add(new_set);
            }
            ++i;
        }
        if (groups_to_add.size() == 0) {
            return false;
        }
        i = 0;
        while (i < groups_to_add.size()) {
            dest_groups.add(i, (List<String>)groups_to_add.get(i));
            ++i;
        }
        TorrentUtils.listToAnnounceGroups(dest_groups, dest_torrent);
        return true;
    }

    public static List<List<String>> mergeAnnounceURLs(List<List<String>> base_urls, List<List<String>> merge_urls) {
        base_urls = TorrentUtils.getClone(base_urls);
        if (merge_urls == null) {
            return base_urls;
        }
        HashSet<String> mergesSet = new HashSet<String>();
        mergesSet.add(NO_VALID_URL_URL);
        for (List<String> l : merge_urls) {
            mergesSet.addAll(l);
        }
        Iterator<List<String>> it1 = base_urls.iterator();
        while (it1.hasNext()) {
            List<String> l = it1.next();
            Iterator<String> it2 = l.iterator();
            while (it2.hasNext()) {
                if (!mergesSet.contains(it2.next())) continue;
                it2.remove();
            }
            if (!l.isEmpty()) continue;
            it1.remove();
        }
        for (List<String> l : merge_urls) {
            if (l.isEmpty()) continue;
            base_urls.add(l);
        }
        return base_urls;
    }

    public static List<List<String>> removeAnnounceURLs(List<List<String>> base_urls, List<List<String>> remove_urls, boolean use_prefix_match) {
        base_urls = TorrentUtils.getClone(base_urls);
        if (remove_urls == null) {
            return base_urls;
        }
        HashSet<String> removeSet = new HashSet<String>();
        removeSet.add(NO_VALID_URL_URL);
        for (List<String> l : remove_urls) {
            for (String s : l) {
                removeSet.add(s.toLowerCase(Locale.US));
            }
        }
        Iterator<List<String>> it1 = base_urls.iterator();
        while (it1.hasNext()) {
            List<String> l = it1.next();
            Iterator<String> it2 = l.iterator();
            block3: while (it2.hasNext()) {
                String url = it2.next();
                if (url.equals(NO_VALID_URL_URL)) {
                    it2.remove();
                    continue;
                }
                url = url.toLowerCase(Locale.US);
                if (use_prefix_match) {
                    for (String s : removeSet) {
                        if (!url.startsWith(s)) continue;
                        it2.remove();
                        continue block3;
                    }
                    continue;
                }
                if (!removeSet.contains(url)) continue;
                it2.remove();
            }
            if (!l.isEmpty()) continue;
            it1.remove();
        }
        return base_urls;
    }

    public static List<List<String>> removeAnnounceURLs2(List<List<String>> base_urls, List<String> remove_urls, boolean use_prefix_match) {
        if (remove_urls == null) {
            return TorrentUtils.getClone(base_urls);
        }
        ArrayList<List<String>> temp = new ArrayList<List<String>>(1);
        temp.add(remove_urls);
        return TorrentUtils.removeAnnounceURLs(base_urls, temp, use_prefix_match);
    }

    public static List<List<String>> getClone(List<List<String>> lls) {
        if (lls == null) {
            return lls;
        }
        ArrayList<List<String>> result = new ArrayList<List<String>>(lls.size());
        for (List<String> l : lls) {
            result.add(new ArrayList<String>(l));
        }
        return result;
    }

    public static boolean replaceAnnounceURL(TOTorrent torrent, URL old_url, URL new_url) {
        boolean found = false;
        String old_str = old_url.toString();
        String new_str = new_url.toString();
        List<List<String>> l = TorrentUtils.announceGroupsToList(torrent);
        int i = 0;
        while (i < l.size()) {
            List<String> set = l.get(i);
            int j = 0;
            while (j < set.size()) {
                if (set.get(j).equals(old_str)) {
                    found = true;
                    set.set(j, new_str);
                }
                ++j;
            }
            ++i;
        }
        if (found) {
            TorrentUtils.listToAnnounceGroups(l, torrent);
        }
        if (torrent.getAnnounceURL().toString().equals(old_str)) {
            torrent.setAnnounceURL(new_url);
            found = true;
        }
        if (found) {
            try {
                TorrentUtils.writeToFile(torrent);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                return false;
            }
        }
        return found;
    }

    public static void setResumeDataCompletelyValid(DownloadManagerState download_manager_state) {
        DiskManagerFactory.setResumeDataCompletelyValid(download_manager_state);
    }

    public static String getLocalisedName(TOTorrent torrent) {
        if (torrent == null) {
            return "";
        }
        try {
            String utf8Name = torrent.getUTF8Name();
            if (utf8Name != null) {
                return utf8Name;
            }
            LocaleUtilDecoder decoder = LocaleTorrentUtil.getTorrentEncodingIfAvailable(torrent);
            if (decoder == null) {
                return new String(torrent.getName(), "UTF8");
            }
            return decoder.decodeString(torrent.getName());
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return new String(torrent.getName());
        }
    }

    public static void setTLSTorrentHash(HashWrapper hash) {
        tls.get().put("hash", hash);
    }

    public static HashWrapper getTLSTorrentHash() {
        return (HashWrapper)tls.get().get("hash");
    }

    public static TOTorrent getTLSTorrent() {
        HashWrapper hash = (HashWrapper)tls.get().get("hash");
        if (hash != null) {
            try {
                AzureusCore core = AzureusCoreFactory.getSingleton();
                DownloadManager dm = core.getGlobalManager().getDownloadManager(hash);
                if (dm != null) {
                    return dm.getTorrent();
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        return null;
    }

    public static void setTLSDescription(String desc) {
        tls.get().put("desc", desc);
    }

    public static String getTLSDescription() {
        return (String)tls.get().get("desc");
    }

    public static Object getTLS() {
        return new HashMap<String, Object>(tls.get());
    }

    public static void setTLS(Object obj) {
        Map m = (Map)obj;
        Map<String, Object> tls_map = tls.get();
        tls_map.clear();
        tls_map.putAll(m);
    }

    public static URL getDecentralisedEmptyURL() {
        try {
            return new URL("dht://");
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return null;
        }
    }

    public static URL getDecentralisedURL(byte[] hash) {
        try {
            return new URL("dht://" + ByteFormatter.encodeString(hash) + ".dht/announce");
        }
        catch (Throwable e) {
            Debug.out(e);
            return TorrentUtils.getDecentralisedEmptyURL();
        }
    }

    public static URL getDecentralisedURL(TOTorrent torrent) {
        try {
            return new URL("dht://" + ByteFormatter.encodeString(torrent.getHash()) + ".dht/announce");
        }
        catch (Throwable e) {
            Debug.out(e);
            return TorrentUtils.getDecentralisedEmptyURL();
        }
    }

    public static void setDecentralised(TOTorrent torrent) {
        torrent.setAnnounceURL(TorrentUtils.getDecentralisedURL(torrent));
    }

    public static boolean isDecentralised(TOTorrent torrent) {
        if (torrent == null) {
            return false;
        }
        return torrent.isDecentralised();
    }

    public static boolean isDecentralised(URL url) {
        if (url == null) {
            return false;
        }
        return url.getProtocol().equalsIgnoreCase("dht");
    }

    public static boolean isDecentralised(String host) {
        if (host == null) {
            return false;
        }
        return host.endsWith(".dht");
    }

    private static Map getAzureusProperties(TOTorrent torrent) {
        HashMap m = torrent.getAdditionalMapProperty("azureus_properties");
        if (m == null) {
            m = new HashMap();
            torrent.setAdditionalMapProperty("azureus_properties", m);
        }
        return m;
    }

    private static Map getAzureusPrivateProperties(TOTorrent torrent) {
        HashMap m = torrent.getAdditionalMapProperty("azureus_private_properties");
        if (m == null) {
            m = new HashMap();
            torrent.setAdditionalMapProperty("azureus_private_properties", m);
        }
        return m;
    }

    private static String getContentMapString(TOTorrent torrent, String key) {
        Map m = TorrentUtils.getAzureusProperties(torrent);
        Object content2 = m.get("Content");
        if (!(content2 instanceof Map)) {
            return null;
        }
        Map mapContent = (Map)content2;
        Object obj = mapContent.get(key);
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof byte[]) {
            try {
                return new String((byte[])obj, "UTF8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static boolean isFeaturedContent(TOTorrent torrent) {
        String content_type = TorrentUtils.getContentMapString(torrent, "Content Type");
        return content_type != null && content_type.equalsIgnoreCase("featured");
    }

    public static void setObtainedFrom(File file, String str) {
        try {
            TOTorrent torrent = TorrentUtils.readFromFile(file, false, false);
            TorrentUtils.setObtainedFrom(torrent, str);
            TorrentUtils.writeToFile(torrent);
        }
        catch (TOTorrentException torrent) {
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    public static void setObtainedFrom(TOTorrent torrent, String str) {
        Map m = TorrentUtils.getAzureusPrivateProperties(torrent);
        try {
            str = str.trim();
            if (str == null || str.length() == 0) {
                m.remove(TORRENT_AZ_PROP_OBTAINED_FROM);
            } else {
                m.put(TORRENT_AZ_PROP_OBTAINED_FROM, str.getBytes("UTF-8"));
            }
            TorrentUtils.fireAttributeListener(torrent, TORRENT_AZ_PROP_OBTAINED_FROM, str);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public static String getObtainedFrom(TOTorrent torrent) {
        Map m = TorrentUtils.getAzureusPrivateProperties(torrent);
        byte[] from = (byte[])m.get(TORRENT_AZ_PROP_OBTAINED_FROM);
        if (from != null) {
            try {
                return new String(from, "UTF-8");
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        return null;
    }

    public static void setNetworkCache(TOTorrent torrent, List<String> networks) {
        Map m = TorrentUtils.getAzureusPrivateProperties(torrent);
        try {
            m.put(TORRENT_AZ_PROP_NETWORK_CACHE, networks);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public static List<String> getNetworkCache(TOTorrent torrent) {
        ArrayList<String> result = new ArrayList<String>();
        Map m = TorrentUtils.getAzureusPrivateProperties(torrent);
        try {
            List l = (List)m.get(TORRENT_AZ_PROP_NETWORK_CACHE);
            if (l != null) {
                block2: for (Object o : l) {
                    if (o instanceof String) {
                        result.add((String)o);
                        continue;
                    }
                    if (!(o instanceof byte[])) continue;
                    String s = new String((byte[])o, "UTF-8");
                    String[] stringArray = AENetworkClassifier.AT_NETWORKS;
                    int n = AENetworkClassifier.AT_NETWORKS.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String x = stringArray[n2];
                        if (s.equals(x)) {
                            result.add(x);
                            continue block2;
                        }
                        ++n2;
                    }
                }
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        return result;
    }

    public static void setTagCache(TOTorrent torrent, List<String> networks) {
        Map m = TorrentUtils.getAzureusPrivateProperties(torrent);
        try {
            m.put(TORRENT_AZ_PROP_TAG_CACHE, networks);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public static List<String> getTagCache(TOTorrent torrent) {
        ArrayList<String> result = new ArrayList<String>();
        Map m = TorrentUtils.getAzureusPrivateProperties(torrent);
        try {
            List l = (List)m.get(TORRENT_AZ_PROP_TAG_CACHE);
            if (l != null) {
                for (Object o : l) {
                    if (o instanceof String) {
                        result.add((String)o);
                        continue;
                    }
                    if (!(o instanceof byte[])) continue;
                    String s = new String((byte[])o, "UTF-8");
                    result.add(s);
                }
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        return result;
    }

    public static void setPeerCache(TOTorrent torrent, Map pc) {
        Map m = TorrentUtils.getAzureusPrivateProperties(torrent);
        try {
            m.put(TORRENT_AZ_PROP_PEER_CACHE, pc);
            TorrentUtils.setPeerCacheValid(torrent);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public static void setPeerCacheValid(TOTorrent torrent) {
        Map m = TorrentUtils.getAzureusPrivateProperties(torrent);
        try {
            m.put(TORRENT_AZ_PROP_PEER_CACHE_VALID, new Long(PC_MARKER));
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public static Map getPeerCache(TOTorrent torrent) {
        try {
            Map m = TorrentUtils.getAzureusPrivateProperties(torrent);
            Long value = (Long)m.get(TORRENT_AZ_PROP_PEER_CACHE_VALID);
            if (value != null && value == PC_MARKER) {
                Map pc = (Map)m.get(TORRENT_AZ_PROP_PEER_CACHE);
                return pc;
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
        return null;
    }

    public static void setFlag(TOTorrent torrent, int flag, boolean value) {
        Map m = TorrentUtils.getAzureusProperties(torrent);
        Long flags = (Long)m.get(TORRENT_AZ_PROP_TORRENT_FLAGS);
        if (flags == null) {
            flags = new Long(0L);
        }
        m.put(TORRENT_AZ_PROP_TORRENT_FLAGS, new Long(flags.intValue() | flag));
    }

    public static boolean getFlag(TOTorrent torrent, int flag) {
        Map m = TorrentUtils.getAzureusProperties(torrent);
        Long flags = (Long)m.get(TORRENT_AZ_PROP_TORRENT_FLAGS);
        if (flags == null) {
            return false;
        }
        return (flags.intValue() & flag) != 0;
    }

    public static Map<Integer, File> getInitialLinkage(TOTorrent torrent) {
        HashMap<Integer, File> result = new HashMap<Integer, File>();
        try {
            byte[] g_data;
            Map<String, Object> _links;
            Map pp = torrent.getAdditionalMapProperty("azureus_private_properties");
            if (pp != null && (_links = (g_data = (byte[])pp.get(TORRENT_AZ_PROP_INITIAL_LINKAGE2)) == null ? (Map<String, Object>)pp.get(TORRENT_AZ_PROP_INITIAL_LINKAGE) : BDecoder.decode(new BufferedInputStream(new GZIPInputStream(new ByteArrayInputStream(g_data))))) != null) {
                Map links = BDecoder.decodeStrings(_links);
                for (Map.Entry entry : links.entrySet()) {
                    int file_index = Integer.parseInt((String)entry.getKey());
                    String file = (String)entry.getValue();
                    result.put(file_index, new File(file));
                }
            }
        }
        catch (Throwable e) {
            Debug.out("Failed to read linkage map", e);
        }
        return result;
    }

    public static void setPluginStringProperty(TOTorrent torrent, String name, String value) {
        HashMap<String, byte[]> p;
        Map m = TorrentUtils.getAzureusProperties(torrent);
        Object obj = m.get(TORRENT_AZ_PROP_PLUGINS);
        if (obj instanceof Map) {
            p = (HashMap<String, byte[]>)obj;
        } else {
            p = new HashMap<String, byte[]>();
            m.put(TORRENT_AZ_PROP_PLUGINS, p);
        }
        if (value == null) {
            p.remove(name);
        } else {
            p.put(name, value.getBytes());
        }
    }

    public static String getPluginStringProperty(TOTorrent torrent, String name) {
        Map p;
        Map m = TorrentUtils.getAzureusProperties(torrent);
        Object obj = m.get(TORRENT_AZ_PROP_PLUGINS);
        if (obj instanceof Map && (obj = (p = (Map)obj).get(name)) instanceof byte[]) {
            return new String((byte[])obj);
        }
        return null;
    }

    public static void setPluginMapProperty(TOTorrent torrent, String name, Map value) {
        HashMap<String, Map> p;
        Map m = TorrentUtils.getAzureusProperties(torrent);
        Object obj = m.get(TORRENT_AZ_PROP_PLUGINS);
        if (obj instanceof Map) {
            p = (HashMap<String, Map>)obj;
        } else {
            p = new HashMap<String, Map>();
            m.put(TORRENT_AZ_PROP_PLUGINS, p);
        }
        if (value == null) {
            p.remove(name);
        } else {
            p.put(name, value);
        }
    }

    public static Map getPluginMapProperty(TOTorrent torrent, String name) {
        Map p;
        Map m = TorrentUtils.getAzureusProperties(torrent);
        Object obj = m.get(TORRENT_AZ_PROP_PLUGINS);
        if (obj instanceof Map && (obj = (p = (Map)obj).get(name)) instanceof Map) {
            return (Map)obj;
        }
        return null;
    }

    public static void setDHTBackupEnabled(TOTorrent torrent, boolean enabled) {
        Map m = TorrentUtils.getAzureusProperties(torrent);
        m.put(TORRENT_AZ_PROP_DHT_BACKUP_ENABLE, new Long(enabled ? 1 : 0));
    }

    public static boolean getDHTBackupEnabled(TOTorrent torrent) {
        Map m = TorrentUtils.getAzureusProperties(torrent);
        Object obj = m.get(TORRENT_AZ_PROP_DHT_BACKUP_ENABLE);
        if (obj instanceof Long) {
            return (Long)obj == 1L;
        }
        return true;
    }

    public static boolean isDHTBackupRequested(TOTorrent torrent) {
        Map m = TorrentUtils.getAzureusProperties(torrent);
        Object obj = m.get(TORRENT_AZ_PROP_DHT_BACKUP_REQUESTED);
        if (obj instanceof Long) {
            return (Long)obj == 1L;
        }
        return false;
    }

    public static void setDHTBackupRequested(TOTorrent torrent, boolean requested) {
        Map m = TorrentUtils.getAzureusProperties(torrent);
        m.put(TORRENT_AZ_PROP_DHT_BACKUP_REQUESTED, new Long(requested ? 1 : 0));
    }

    public static boolean isReallyPrivate(TOTorrent torrent) {
        URL[] urls;
        TOTorrentAnnounceURLSet[] sets;
        if (torrent == null) {
            return false;
        }
        URL url = torrent.getAnnounceURL();
        if (url == null && (sets = torrent.getAnnounceURLGroup().getAnnounceURLSets()) != null && sets.length > 0 && (urls = sets[0].getAnnounceURLs()).length > 0) {
            url = urls[0];
        }
        if (url != null && UrlUtils.containsPasskey(url)) {
            return torrent.getPrivate();
        }
        return false;
    }

    public static boolean getPrivate(TOTorrent torrent) {
        if (torrent == null) {
            return false;
        }
        return torrent.getPrivate();
    }

    public static void setPrivate(TOTorrent torrent, boolean _private) {
        if (torrent == null) {
            return;
        }
        try {
            torrent.setPrivate(_private);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public static Set<String> getSkipExtensionsSet() {
        return TorrentUtils.getSkipExtensionsSetSupport(false);
    }

    private static synchronized Set<String> getSkipExtensionsSetSupport(boolean force) {
        if (skip_extensions_set == null || force) {
            int p1;
            HashSet<String> new_skip_set = new HashSet<String>();
            String skip_list = COConfigurationManager.getStringParameter("File.Torrent.AutoSkipExtensions");
            skip_list = skip_list.replace(',', ';');
            if (skip_extensions_set == null) {
                COConfigurationManager.addParameterListener("File.Torrent.AutoSkipExtensions", new ParameterListener(){

                    @Override
                    public void parameterChanged(String parameterName) {
                        TorrentUtils.getSkipExtensionsSetSupport(true);
                    }
                });
            }
            int pos = 0;
            do {
                String bit;
                if ((p1 = skip_list.indexOf(";", pos)) == -1) {
                    bit = skip_list.substring(pos);
                } else {
                    bit = skip_list.substring(pos, p1);
                    pos = p1 + 1;
                }
                String ext = bit.trim().toLowerCase();
                if (ext.startsWith(".")) {
                    ext = ext.substring(1);
                }
                if (ext.length() <= 0) continue;
                new_skip_set.add(ext);
            } while (p1 != -1);
            skip_extensions_set = new_skip_set;
        }
        return skip_extensions_set;
    }

    public static Set<String> getIgnoreSet() {
        return TorrentUtils.getIgnoreSetSupport(false);
    }

    private static synchronized Set<String> getIgnoreSetSupport(boolean force) {
        if (ignore_files_set == null || force) {
            int p1;
            HashSet<String> new_ignore_set = new HashSet<String>();
            String ignore_list = COConfigurationManager.getStringParameter("File.Torrent.IgnoreFiles", ".DS_Store;Thumbs.db;desktop.ini");
            if (ignore_files_set == null) {
                COConfigurationManager.addParameterListener("File.Torrent.IgnoreFiles", new ParameterListener(){

                    @Override
                    public void parameterChanged(String parameterName) {
                        TorrentUtils.getIgnoreSetSupport(true);
                    }
                });
            }
            int pos = 0;
            do {
                String bit;
                if ((p1 = ignore_list.indexOf(";", pos)) == -1) {
                    bit = ignore_list.substring(pos);
                } else {
                    bit = ignore_list.substring(pos, p1);
                    pos = p1 + 1;
                }
                new_ignore_set.add(bit.trim().toLowerCase());
            } while (p1 != -1);
            ignore_files_set = new_ignore_set;
        }
        return ignore_files_set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerMapFluff(String[] fluff) {
        Class<TorrentUtils> clazz = TorrentUtils.class;
        synchronized (TorrentUtils.class) {
            Collections.addAll(torrentFluffKeyset, fluff);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static File copyTorrentFileToSaveDir(File f, boolean persistent) throws IOException {
        saveTorrents = persistent != false && COConfigurationManager.getBooleanParameter("Save Torrent Files") != false;
        torrentDir = saveTorrents != false ? new File(COConfigurationManager.getDirectoryParameter("General_sDefaultTorrent_Directory")) : new File(f.getParent());
        moveWhenDone = COConfigurationManager.getBooleanParameter("Move Completed When Done");
        completedDir = COConfigurationManager.getStringParameter("Completed Files Directory", "");
        if (moveWhenDone && completedDir.length() > 0 && (cFile = new File(completedDir, f.getName())).exists()) {
            torrentDir = new File(completedDir);
        }
        FileUtil.mkdirs(torrentDir);
        fDest = new File(torrentDir, f.getName().replaceAll("%20", "."));
        if (!fDest.equals(f)) ** GOTO lbl13
        return f;
lbl-1000:
        // 1 sources

        {
            fDest = new File(torrentDir, "_" + fDest.getName());
lbl13:
            // 2 sources

            ** while (fDest.exists())
        }
lbl14:
        // 1 sources

        fDest.createNewFile();
        if (!FileUtil.copyFile(f, fDest)) {
            throw new IOException("File copy failed");
        }
        if (TorrentUtils.shouldDeleteTorrentFileAfterAdd(f, persistent)) {
            f.delete();
        }
        return fDest;
    }

    public static boolean shouldDeleteTorrentFileAfterAdd(File f, boolean persistent) {
        File active_dir;
        if (!persistent) {
            return false;
        }
        boolean delTorrents = COConfigurationManager.getBooleanParameter("Delete Original Torrent Files");
        if (!delTorrents) {
            return false;
        }
        boolean saveTorrents = COConfigurationManager.getBooleanParameter("Save Torrent Files");
        if (saveTorrents) {
            try {
                File torrentDir = new File(COConfigurationManager.getDirectoryParameter("General_sDefaultTorrent_Directory"));
                if (torrentDir.isDirectory() && torrentDir.equals(f.getParentFile())) {
                    return false;
                }
            }
            catch (Throwable e) {
                return false;
            }
        }
        return !(active_dir = FileUtil.getUserFile("active")).equals(f.getParentFile());
    }

    public static DownloadManager getDownloadManager(HashWrapper hash) {
        try {
            return AzureusCoreFactory.getSingleton().getGlobalManager().getDownloadManager(hash);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void recursiveEmptyDirDelete(File f) {
        TorrentUtils.recursiveEmptyDirDelete(f, true);
    }

    public static void recursiveEmptyDirDelete(File f, boolean log_warnings) {
        Set<String> ignore_map = TorrentUtils.getIgnoreSet();
        FileUtil.recursiveEmptyDirDelete(f, ignore_map, log_warnings);
    }

    public static String nicePrintTorrentHash(TOTorrent torrent) {
        return TorrentUtils.nicePrintTorrentHash(torrent, false);
    }

    public static String nicePrintTorrentHash(TOTorrent torrent, boolean tight) {
        byte[] hash;
        if (torrent == null) {
            hash = new byte[20];
        } else {
            try {
                hash = torrent.getHash();
            }
            catch (TOTorrentException e) {
                Debug.printStackTrace(e);
                hash = new byte[20];
            }
        }
        return ByteFormatter.nicePrint(hash, tight);
    }

    public static boolean isTorrentFile(String filename) throws FileNotFoundException, IOException {
        File check = new File(filename);
        if (!check.exists()) {
            throw new FileNotFoundException("File " + filename + " not found.");
        }
        if (!check.canRead()) {
            throw new IOException("File " + filename + " cannot be read.");
        }
        if (check.isDirectory()) {
            throw new FileIsADirectoryException("File " + filename + " is a directory.");
        }
        try {
            TOTorrentFactory.deserialiseFromBEncodedFile(check);
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addCreatedTorrent(TOTorrent torrent) {
        List<byte[]> list = created_torrents;
        synchronized (list) {
            try {
                byte[] hash = torrent.getHash();
                HashWrapper hw = new HashWrapper(hash);
                boolean dirty = false;
                long check = COConfigurationManager.getLongParameter("my.created.torrents.check", 0L);
                COConfigurationManager.setParameter("my.created.torrents.check", check + 1L);
                if (check % 200L == 0L) {
                    try {
                        List<DownloadManager> dms = AzureusCoreFactory.getSingleton().getGlobalManager().getDownloadManagers();
                        HashSet<HashWrapper> actual_hashes = new HashSet<HashWrapper>();
                        for (DownloadManager dm : dms) {
                            TOTorrent t = dm.getTorrent();
                            if (t == null) continue;
                            try {
                                actual_hashes.add(t.getHashWrapper());
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        Iterator<byte[]> it = created_torrents.iterator();
                        int deleted = 0;
                        while (it.hasNext()) {
                            HashWrapper existing_hw = new HashWrapper(it.next());
                            if (actual_hashes.contains(existing_hw) || existing_hw.equals(hw)) continue;
                            it.remove();
                            created_torrents_set.remove(existing_hw);
                            ++deleted;
                            dirty = true;
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (created_torrents.size() == 0) {
                    COConfigurationManager.setParameter("my.created.torrents", created_torrents);
                }
                if (!created_torrents_set.contains(hw)) {
                    created_torrents.add(hash);
                    created_torrents_set.add(hw);
                    dirty = true;
                }
                if (dirty) {
                    COConfigurationManager.setDirty();
                }
            }
            catch (TOTorrentException tOTorrentException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeCreatedTorrent(TOTorrent torrent) {
        List<byte[]> list = created_torrents;
        synchronized (list) {
            try {
                HashWrapper hw = torrent.getHashWrapper();
                byte[] hash = hw.getBytes();
                Iterator<byte[]> it = created_torrents.iterator();
                while (it.hasNext()) {
                    byte[] h = it.next();
                    if (!Arrays.equals(hash, h)) continue;
                    it.remove();
                }
                COConfigurationManager.setDirty();
                created_torrents_set.remove(hw);
            }
            catch (TOTorrentException tOTorrentException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isCreatedTorrent(TOTorrent torrent) {
        List<byte[]> list = created_torrents;
        synchronized (list) {
            try {
                HashWrapper hw = torrent.getHashWrapper();
                boolean res = created_torrents_set.contains(hw);
                if (!res) {
                    res = torrent.isCreated();
                }
                return res;
            }
            catch (TOTorrentException e) {
                Debug.printStackTrace(e);
                return false;
            }
        }
    }

    public static TOTorrent download(URL url) throws IOException {
        return TorrentUtils.download(url, 0L);
    }

    public static TOTorrent download(URL url, long timeout) throws IOException {
        AEProxyFactory.PluginProxy plugin_proxy = null;
        try {
            ResourceDownloader rd;
            if (AENetworkClassifier.categoriseAddress(url.getHost()) != "Public") {
                plugin_proxy = AEProxyFactory.getPluginProxy("torrent download", url);
            }
            if (plugin_proxy == null) {
                rd = new ResourceDownloaderFactoryImpl().create(url);
            } else {
                rd = new ResourceDownloaderFactoryImpl().create(plugin_proxy.getURL(), plugin_proxy.getProxy());
                rd.setProperty("URL_HOST", url.getHost());
            }
            if (timeout > 0L) {
                rd.setProperty("URL_Connect_Timeout", timeout);
                rd.setProperty("URL_Read_Timeout", timeout);
            }
            byte[] bytes = FileUtil.readInputStreamAsByteArray(rd.download(), 0x6400000);
            TOTorrent tOTorrent = TOTorrentFactory.deserialiseFromBEncodedByteArray(bytes);
            if (plugin_proxy != null) {
                plugin_proxy.setOK(true);
            }
            return tOTorrent;
        }
        catch (Throwable throwable) {
            try {
                if (plugin_proxy != null) {
                    plugin_proxy.setOK(true);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new IOException(Debug.getNestedExceptionMessage(e));
            }
        }
    }

    private static void fireAttributeListener(TOTorrent torrent, String attribute, Object value) {
        Iterator<torrentAttributeListener> it = torrent_attribute_listeners.iterator();
        while (it.hasNext()) {
            try {
                it.next().attributeSet(torrent, attribute, value);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public static void addTorrentAttributeListener(torrentAttributeListener listener) {
        torrent_attribute_listeners.add(listener);
    }

    public static void removeTorrentAttributeListener(torrentAttributeListener listener) {
        torrent_attribute_listeners.remove(listener);
    }

    public static void addTorrentURLChangeListener(TorrentAnnounceURLChangeListener listener) {
        torrent_url_changed_listeners.add(listener);
    }

    public static void removeTorrentURLChangeListener(TorrentAnnounceURLChangeListener listener) {
        torrent_url_changed_listeners.remove(listener);
    }

    private static DNSTXTEntry getDNSTXTEntry(URL url) {
        if (TorrentUtils.isDecentralised(url)) {
            return null;
        }
        String host = url.getHost();
        String tracker_network = AENetworkClassifier.categoriseAddress(host);
        if (tracker_network != "Public") {
            return null;
        }
        return TorrentUtils.getDNSTXTEntry(host, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkDNSTimeouts() {
        final ArrayList<String> hosts = new ArrayList<String>();
        long now = SystemTime.getMonotonousTime();
        Map<String, DNSTXTEntry> map = dns_mapping;
        synchronized (map) {
            for (Map.Entry<String, DNSTXTEntry> entry : dns_mapping.entrySet()) {
                DNSTXTEntry txt_entry = entry.getValue();
                if (now - txt_entry.getCreateTime() <= 14400000L) continue;
                hosts.add(entry.getKey());
            }
        }
        if (hosts.size() > 0) {
            new AEThread2("DNS:updates"){

                @Override
                public void run() {
                    for (String host : hosts) {
                        TorrentUtils.getDNSTXTEntry(host, true, null);
                    }
                }
            }.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static DNSTXTEntry getDNSTXTEntry(final String host, boolean force_update, final List<String> already_got_records) {
        is_new = false;
        var6_4 = TorrentUtils.dns_mapping;
        synchronized (var6_4) {
            old_txt_entry = txt_entry = TorrentUtils.dns_mapping.get(host);
            if (txt_entry != null && SystemTime.getMonotonousTime() - DNSTXTEntry.access$0(txt_entry) > 14400000L) {
                force_update = true;
            }
            if (force_update || txt_entry == null) {
                txt_entry = new DNSTXTEntry();
                TorrentUtils.dns_mapping.put(host, txt_entry);
                is_new = true;
            }
        }
        if (!is_new) ** GOTO lbl-1000
        _config_key = "";
        try {
            _config_key = "dns.txts.cache." + Base32.encode(host.getBytes("UTF-8"));
        }
        catch (Throwable e) {
            Debug.out(e);
        }
        config_key = _config_key;
        try {
            block25: {
                if (already_got_records == null) break block25;
                txts = already_got_records;
                ** GOTO lbl74
            }
            lookup_sem = new AESemaphore("DU:ls");
            result = new Object[2];
            f_txt_entry = txt_entry;
            TorrentUtils.dns_threads.run(new AERunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void runSupport() {
                    try {
                        List<String> txts = dns_utils.getTXTRecords(host);
                        Object[] objectArray = result;
                        synchronized (result) {
                            block17: {
                                if (result[0] != null) break block17;
                                result[1] = txts;
                                // ** MonitorExit[var2_2] (shouldn't be in output)
                                return;
                            }
                            // ** MonitorExit[var2_2] (shouldn't be in output)
                            try {
                                ArrayList<byte[]> txts_cache = new ArrayList<byte[]>();
                                for (String str : txts) {
                                    txts_cache.add(str.getBytes("UTF-8"));
                                }
                                List old_txts_cache = COConfigurationManager.getListParameter(config_key, null);
                                boolean same = false;
                                if (old_txts_cache != null) {
                                    boolean bl = same = old_txts_cache.size() == txts_cache.size();
                                    if (same) {
                                        int i = 0;
                                        while (i < old_txts_cache.size()) {
                                            if (!Arrays.equals((byte[])old_txts_cache.get(i), (byte[])txts_cache.get(i))) {
                                                same = false;
                                                break;
                                            }
                                            ++i;
                                        }
                                    }
                                }
                                if (!same) {
                                    COConfigurationManager.setParameter(config_key, txts_cache);
                                    f_txt_entry.getSemaphore().reserve();
                                    if (already_got_records == null) {
                                        TorrentUtils.getDNSTXTEntry(host, true, txts);
                                    }
                                }
                            }
                            catch (Throwable e) {
                                Debug.out(e);
                            }
                        }
                    }
                    finally {
                        lookup_sem.release();
                    }
                    {
                        return;
                    }
                }
            });
            txts_cache = COConfigurationManager.getListParameter(config_key, null);
            if (old_txt_entry != null || txts_cache == null || force_update) {
                lookup_sem.reserve(2500L);
            }
            var13_15 = result;
            synchronized (result) {
                block23: {
                    result[0] = "";
                    txts = (List)result[1];
                    // ** MonitorExit[var13_15] (shouldn't be in output)
                    try {
                        block26: {
                            if (txts != null) break block26;
                            txts = new ArrayList<E>();
                            if (txts_cache == null) break block23;
                            var14_23 = txts_cache.iterator();
                            if (true) ** GOTO lbl73
                        }
                        txts_cache = new ArrayList<byte[]>();
                        var14_23 = txts.iterator();
                        while (true) {
                            if (!var14_23.hasNext()) {
                                COConfigurationManager.setParameter(config_key, txts_cache);
                                break block23;
                            }
                            var13_19 = var14_23.next();
                            txts_cache.add(var13_19.getBytes("UTF-8"));
                        }
                    }
                    catch (Throwable var13_20) {
                        Debug.out(var13_20);
                        break block23;
                    }
                    do {
                        var13_17 = var14_23.next();
                        txts.add(new String((byte[])var13_17, "UTF-8"));
lbl73:
                        // 2 sources

                    } while (var14_23.hasNext());
                }
                found_bt = false;
                for (String txt : txts) {
                    if (!txt.startsWith("BITTORRENT")) continue;
                    found_bt = true;
                    matcher = TorrentUtils.txt_pattern.matcher(txt.substring(10));
                    while (matcher.find()) {
                        var13_22 = matcher.group(1).startsWith("T");
                        port = Integer.parseInt(matcher.group(2));
                        DNSTXTEntry.access$3(txt_entry, var13_22, port);
                    }
                }
                DNSTXTEntry.access$4(txt_entry, found_bt);
                if (old_txt_entry == null) {
                    ++TorrentUtils.dns_mapping_seq_count;
                    ** break block24
                }
                if (!DNSTXTEntry.access$5(old_txt_entry, txt_entry)) {
                    ++TorrentUtils.dns_mapping_seq_count;
                    TorrentUtils.dispatcher.dispatch(new AERunnable(){

                        @Override
                        public void runSupport() {
                            for (TorrentAnnounceURLChangeListener l : torrent_url_changed_listeners) {
                                try {
                                    l.changed();
                                }
                                catch (Throwable e) {
                                    Debug.out(e);
                                }
                            }
                        }
                    });
                }
            }
        }
        finally {
            DNSTXTEntry.access$2(txt_entry).releaseForever();
        }
lbl-1000:
        // 3 sources

        {
            DNSTXTEntry.access$2(txt_entry).reserve();
            return txt_entry;
        }
    }

    private static URL applyDNSMods(URL url) {
        if (DNS_HANDLING_ENABLE) {
            DNSTXTEntry txt_entry = TorrentUtils.getDNSTXTEntry(url);
            if (txt_entry != null && txt_entry.hasRecords()) {
                List ports;
                boolean url_is_tcp = url.getProtocol().toLowerCase().startsWith("http");
                int url_port = url.getPort();
                if (url_port == -1) {
                    url_port = url.getDefaultPort();
                }
                if ((ports = txt_entry.getPorts()).size() == 0) {
                    return UrlUtils.setHost(url, String.valueOf(url.getHost()) + ".disabled_by_tracker");
                }
                DNSTXTPortInfo first_port = (DNSTXTPortInfo)ports.get(0);
                if (url_port != first_port.getPort()) {
                    url = UrlUtils.setPort(url, first_port.getPort());
                }
                if (url_is_tcp == first_port.isTCP()) {
                    return url;
                }
                return UrlUtils.setProtocol(url, first_port.isTCP() ? "http" : "udp");
            }
            return url;
        }
        return url;
    }

    private static List<URL> applyAllDNSMods(URL url) {
        if (DNS_HANDLING_ENABLE) {
            DNSTXTEntry txt_entry = TorrentUtils.getDNSTXTEntry(url);
            if (txt_entry != null && txt_entry.hasRecords()) {
                List ports;
                boolean url_is_tcp = url.getProtocol().toLowerCase().startsWith("http");
                int url_port = url.getPort();
                if (url_port == -1) {
                    url_port = url.getDefaultPort();
                }
                if ((ports = txt_entry.getPorts()).size() == 0) {
                    return null;
                }
                ArrayList<URL> result = new ArrayList<URL>();
                for (DNSTXTPortInfo port : ports) {
                    URL mod_url = url;
                    if (url_port != port.getPort()) {
                        mod_url = UrlUtils.setPort(mod_url, port.getPort());
                    }
                    if (url_is_tcp != port.isTCP()) {
                        mod_url = UrlUtils.setProtocol(mod_url, port.isTCP() ? "http" : "udp");
                    }
                    result.add(mod_url);
                }
                return result;
            }
            return null;
        }
        return null;
    }

    private static TOTorrentAnnounceURLGroup applyDNSMods(URL announce_url, TOTorrentAnnounceURLGroup group) {
        if (DNS_HANDLING_ENABLE) {
            HashMap<String, Object[]> dns_maps = new HashMap<String, Object[]>();
            DNSTXTEntry announce_txt_entry = TorrentUtils.getDNSTXTEntry(announce_url);
            if (announce_txt_entry != null && announce_txt_entry.hasRecords()) {
                dns_maps.put(announce_url.getHost(), new Object[]{announce_url, announce_txt_entry});
            }
            TOTorrentAnnounceURLSet[] sets = group.getAnnounceURLSets();
            ArrayList<TOTorrentAnnounceURLSet> mod_sets = new ArrayList<TOTorrentAnnounceURLSet>();
            TOTorrentAnnounceURLSet[] tOTorrentAnnounceURLSetArray = sets;
            int n = sets.length;
            int n2 = 0;
            while (n2 < n) {
                TOTorrentAnnounceURLSet set = tOTorrentAnnounceURLSetArray[n2];
                URL[] urls = set.getAnnounceURLs();
                ArrayList<URL> mod_urls = new ArrayList<URL>();
                URL[] uRLArray = urls;
                int n3 = urls.length;
                int n4 = 0;
                while (n4 < n3) {
                    URL url = uRLArray[n4];
                    DNSTXTEntry txt_entry = TorrentUtils.getDNSTXTEntry(url);
                    if (txt_entry == null || !txt_entry.hasRecords()) {
                        mod_urls.add(url);
                    } else {
                        dns_maps.put(url.getHost(), new Object[]{url, txt_entry});
                    }
                    ++n4;
                }
                if (mod_urls.size() != urls.length) {
                    if (mod_urls.size() > 0) {
                        mod_sets.add(group.createAnnounceURLSet(mod_urls.toArray(new URL[mod_urls.size()])));
                    }
                } else {
                    mod_sets.add(set);
                }
                ++n2;
            }
            if (dns_maps.size() > 0) {
                for (Map.Entry entry : dns_maps.entrySet()) {
                    Object[] stuff = (Object[])entry.getValue();
                    URL url = (URL)stuff[0];
                    DNSTXTEntry dns = (DNSTXTEntry)stuff[1];
                    List ports = dns.getPorts();
                    if (ports.size() <= 0) continue;
                    ArrayList<URL> urls = new ArrayList<URL>();
                    for (DNSTXTPortInfo port : ports) {
                        int url_port = url.getPort();
                        boolean url_is_tcp = url.getProtocol().toLowerCase().startsWith("http");
                        if (url_port != port.getPort()) {
                            url = UrlUtils.setPort(url, port.getPort());
                        }
                        if (url_is_tcp != port.isTCP()) {
                            url = UrlUtils.setProtocol(url, port.isTCP() ? "http" : "udp");
                        }
                        urls.add(url);
                    }
                    if (urls.size() <= 0) continue;
                    mod_sets.add(group.createAnnounceURLSet(urls.toArray(new URL[urls.size()])));
                }
                return new URLGroup(group, mod_sets);
            }
            return group;
        }
        return group;
    }

    public static void startTorrentDelete() {
        long val = torrent_delete_level.incrementAndGet();
    }

    public static void endTorrentDelete() {
        long val = torrent_delete_level.decrementAndGet();
    }

    public static void runTorrentDelete(Runnable target) {
        try {
            TorrentUtils.startTorrentDelete();
            target.run();
        }
        finally {
            TorrentUtils.endTorrentDelete();
        }
    }

    public static boolean isTorrentDeleting() {
        return torrent_delete_level.get() > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setTorrentDeleted() {
        Class<TorrentUtils> clazz = TorrentUtils.class;
        synchronized (TorrentUtils.class) {
            torrent_delete_time = SystemTime.getMonotonousTime();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getMillisecondsSinceLastTorrentDelete() {
        Class<TorrentUtils> clazz = TorrentUtils.class;
        synchronized (TorrentUtils.class) {
            block4: {
                if (torrent_delete_time != 0L) break block4;
                // ** MonitorExit[var0] (shouldn't be in output)
                return Long.MAX_VALUE;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return SystemTime.getMonotonousTime() - torrent_delete_time;
        }
    }

    public static void main(String[] args) {
        try {
            URL url = new URL("http://inferno.demonoid.com:3413/announce");
            System.out.println(TorrentUtils.applyDNSMods(url));
            Thread.sleep(1000000L);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static class DNSTXTEntry {
        private final long create_time = SystemTime.getMonotonousTime();
        private final AESemaphore sem = new AESemaphore("DNSTXTEntry");
        private boolean has_records;
        private final List<DNSTXTPortInfo> ports = new ArrayList<DNSTXTPortInfo>();

        private DNSTXTEntry() {
        }

        private long getCreateTime() {
            return this.create_time;
        }

        private AESemaphore getSemaphore() {
            return this.sem;
        }

        private void setHasRecords(boolean has) {
            this.has_records = has;
        }

        private boolean hasRecords() {
            return this.has_records;
        }

        private void addPort(boolean is_tcp, int port) {
            this.ports.add(new DNSTXTPortInfo(is_tcp, port));
        }

        private List<DNSTXTPortInfo> getPorts() {
            return this.ports;
        }

        private boolean sameAs(DNSTXTEntry other) {
            if (this.has_records != other.has_records) {
                return false;
            }
            if (this.ports.size() != other.ports.size()) {
                return false;
            }
            int i = 0;
            while (i < this.ports.size()) {
                if (!this.ports.get(i).sameAs(other.ports.get(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        private String getString() {
            if (this.has_records) {
                if (this.ports.size() == 0) {
                    return "Deny all";
                }
                String res = "";
                for (DNSTXTPortInfo port : this.ports) {
                    res = String.valueOf(res) + (res.length() == 0 ? "" : ", ") + port.getString();
                }
                return "Permit " + res;
            }
            return "No records";
        }

        static /* synthetic */ void access$3(DNSTXTEntry dNSTXTEntry, boolean bl, int n) {
            dNSTXTEntry.addPort(bl, n);
        }

        static /* synthetic */ void access$4(DNSTXTEntry dNSTXTEntry, boolean bl) {
            dNSTXTEntry.setHasRecords(bl);
        }

        static /* synthetic */ boolean access$5(DNSTXTEntry dNSTXTEntry, DNSTXTEntry dNSTXTEntry2) {
            return dNSTXTEntry.sameAs(dNSTXTEntry2);
        }
    }

    private static class DNSTXTPortInfo {
        private final boolean is_tcp;
        private final int port;

        private DNSTXTPortInfo(boolean _is_tcp, int _port) {
            this.is_tcp = _is_tcp;
            this.port = _port;
        }

        private boolean sameAs(DNSTXTPortInfo other) {
            return this.is_tcp == other.is_tcp && this.port == other.port;
        }

        private boolean isTCP() {
            return this.is_tcp;
        }

        private int getPort() {
            return this.port;
        }

        private String getString() {
            return String.valueOf(this.is_tcp ? "TCP" : "UDP ") + this.port;
        }
    }

    public static interface ExtendedTorrent
    extends TOTorrent {
        public byte[][] peekPieces() throws TOTorrentException;

        public void setDiscardFluff(boolean var1);
    }

    public static interface TorrentAnnounceURLChangeListener {
        public void changed();
    }

    private static class URLGroup
    implements TOTorrentAnnounceURLGroup {
        private final TOTorrentAnnounceURLGroup delegate;
        private TOTorrentAnnounceURLSet[] sets;
        private boolean modified;

        private URLGroup(TOTorrentAnnounceURLGroup _delegate, List<TOTorrentAnnounceURLSet> mod_sets) {
            this.delegate = _delegate;
            this.sets = mod_sets.toArray(new TOTorrentAnnounceURLSet[mod_sets.size()]);
        }

        @Override
        public TOTorrentAnnounceURLSet[] getAnnounceURLSets() {
            return this.sets;
        }

        @Override
        public void setAnnounceURLSets(TOTorrentAnnounceURLSet[] _sets) {
            this.modified = true;
            this.sets = _sets;
            this.delegate.setAnnounceURLSets(_sets);
        }

        @Override
        public TOTorrentAnnounceURLSet createAnnounceURLSet(URL[] urls) {
            return this.delegate.createAnnounceURLSet(urls);
        }

        protected boolean hasBeenModified() {
            return this.modified;
        }
    }

    public static interface torrentAttributeListener {
        public void attributeSet(TOTorrent var1, String var2, Object var3);
    }

    public static class torrentDelegate
    extends LogRelation
    implements ExtendedTorrent {
        private final TOTorrent delegate;
        private final File file;
        private boolean fluff_dirty;
        private long last_pieces_read_time = SystemTime.getCurrentTime();
        private URL url_mod_last_pre;
        private URL url_mod_last_post;
        private int url_mod_last_seq;
        private List<URL> urlg_mod_last_pre;
        private TOTorrentAnnounceURLGroup urlg_mod_last_post;
        private int urlg_mod_last_seq;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected torrentDelegate(TOTorrent _delegate, File _file) {
            this.delegate = _delegate;
            this.file = _file;
            Map map = torrent_delegates;
            synchronized (map) {
                torrent_delegates.put(this, null);
            }
        }

        @Override
        public void setDiscardFluff(boolean discard) {
            if (discard && !torrentFluffKeyset.isEmpty()) {
                try {
                    this.getMonitor().enter();
                    try {
                        if (this.fluff_dirty) {
                            boolean[] restored = this.restoreState(true, true);
                            this.delegate.serialiseToBEncodedFile(this.file);
                            this.fluff_dirty = false;
                            if (restored[0]) {
                                this.discardPieces(SystemTime.getCurrentTime(), true);
                            }
                        }
                        Iterator it = torrentFluffKeyset.iterator();
                        while (it.hasNext()) {
                            this.delegate.setAdditionalMapProperty((String)it.next(), fluffThombstone);
                        }
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
                finally {
                    this.getMonitor().exit();
                }
            }
        }

        @Override
        public byte[] getName() {
            return this.delegate.getName();
        }

        @Override
        public boolean isSimpleTorrent() {
            return this.delegate.isSimpleTorrent();
        }

        @Override
        public byte[] getComment() {
            return this.delegate.getComment();
        }

        @Override
        public void setComment(String comment) {
            this.delegate.setComment(comment);
        }

        @Override
        public long getCreationDate() {
            return this.delegate.getCreationDate();
        }

        @Override
        public void setCreationDate(long date) {
            this.delegate.setCreationDate(date);
        }

        @Override
        public byte[] getCreatedBy() {
            return this.delegate.getCreatedBy();
        }

        @Override
        public void setCreatedBy(byte[] cb) {
            this.delegate.setCreatedBy(cb);
        }

        @Override
        public boolean isCreated() {
            return this.delegate.isCreated();
        }

        @Override
        public boolean isDecentralised() {
            URL url = this.getAnnounceURLSupport();
            return TorrentUtils.isDecentralised(url);
        }

        @Override
        public URL getAnnounceURL() {
            URL url = this.getAnnounceURLSupport();
            int seq = dns_mapping_seq_count;
            if (url == this.url_mod_last_pre && this.url_mod_last_post != null && seq == this.url_mod_last_seq) {
                return this.url_mod_last_post;
            }
            this.url_mod_last_post = TorrentUtils.applyDNSMods(url);
            this.url_mod_last_pre = url;
            this.url_mod_last_seq = seq;
            return this.url_mod_last_post;
        }

        @Override
        public TOTorrentAnnounceURLGroup getAnnounceURLGroup() {
            TOTorrentAnnounceURLSet[] sets;
            TOTorrentAnnounceURLGroup group = this.getAnnounceURLGroupSupport();
            int seq = dns_mapping_seq_count;
            if (seq == this.urlg_mod_last_seq && this.urlg_mod_last_pre != null && this.urlg_mod_last_post != null) {
                boolean match;
                boolean bl = match = !(this.urlg_mod_last_post instanceof URLGroup) || !((URLGroup)this.urlg_mod_last_post).hasBeenModified();
                if (match) {
                    sets = group.getAnnounceURLSets();
                    Iterator<URL> it = this.urlg_mod_last_pre.iterator();
                    int i = 0;
                    block0: while (i < sets.length) {
                        URL[] urls = sets[i].getAnnounceURLs();
                        int j = 0;
                        while (j < urls.length) {
                            if (!it.hasNext()) {
                                match = false;
                                break block0;
                            }
                            if (it.next() != urls[j]) {
                                match = false;
                                break;
                            }
                            ++j;
                        }
                        ++i;
                    }
                    if (it.hasNext()) {
                        match = false;
                    }
                }
                if (match) {
                    return this.urlg_mod_last_post;
                }
            }
            ArrayList<URL> url_list = new ArrayList<URL>();
            sets = group.getAnnounceURLSets();
            int i = 0;
            while (i < sets.length) {
                URL[] urls = sets[i].getAnnounceURLs();
                Collections.addAll(url_list, urls);
                ++i;
            }
            this.urlg_mod_last_post = TorrentUtils.applyDNSMods(this.getAnnounceURL(), group);
            this.urlg_mod_last_pre = url_list;
            this.urlg_mod_last_seq = seq;
            return this.urlg_mod_last_post;
        }

        public URL getAnnounceURLSupport() {
            return this.delegate.getAnnounceURL();
        }

        @Override
        public boolean setAnnounceURL(URL url) {
            return this.delegate.setAnnounceURL(url);
        }

        public TOTorrentAnnounceURLGroup getAnnounceURLGroupSupport() {
            return this.delegate.getAnnounceURLGroup();
        }

        protected void discardPieces(long now, boolean force) {
            block7: {
                if (now < this.last_pieces_read_time && !force) {
                    this.last_pieces_read_time = now;
                } else {
                    try {
                        if (now - this.last_pieces_read_time <= 180000L && !force || this.delegate.getPieces() == null) break block7;
                        try {
                            this.getMonitor().enter();
                            this.delegate.setPieces(null);
                        }
                        finally {
                            this.getMonitor().exit();
                        }
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
            }
        }

        @Override
        public byte[][] getPieces() throws TOTorrentException {
            byte[][] res = this.delegate.getPieces();
            this.last_pieces_read_time = SystemTime.getCurrentTime();
            if (res == null) {
                try {
                    this.getMonitor().enter();
                    this.restoreState(true, false);
                    res = this.delegate.getPieces();
                }
                finally {
                    this.getMonitor().exit();
                }
            }
            return res;
        }

        protected boolean[] restoreState(boolean do_pieces, boolean do_fluff) throws TOTorrentException {
            boolean had_pieces = this.delegate.getPieces() != null;
            boolean had_fluff = true;
            Iterator it = torrentFluffKeyset.iterator();
            while (it.hasNext()) {
                had_fluff &= this.delegate.getAdditionalMapProperty((String)it.next()) != fluffThombstone;
            }
            if (had_pieces) {
                do_pieces = false;
            }
            if (had_fluff) {
                do_fluff = false;
            }
            if (do_pieces || do_fluff) {
                TOTorrent temp = TorrentUtils.readFromFile(this.file, false);
                if (do_pieces) {
                    byte[][] res = temp.getPieces();
                    this.delegate.setPieces(res);
                }
                if (do_fluff) {
                    for (String fluffKey : torrentFluffKeyset) {
                        if (this.delegate.getAdditionalMapProperty(fluffKey) != fluffThombstone) continue;
                        this.delegate.setAdditionalMapProperty(fluffKey, temp.getAdditionalMapProperty(fluffKey));
                    }
                }
            }
            return new boolean[]{do_pieces, do_fluff};
        }

        @Override
        public byte[][] peekPieces() throws TOTorrentException {
            return this.delegate.getPieces();
        }

        @Override
        public void setPieces(byte[][] pieces) throws TOTorrentException {
            throw new TOTorrentException("Unsupported Operation", 5);
        }

        @Override
        public long getPieceLength() {
            return this.delegate.getPieceLength();
        }

        @Override
        public int getNumberOfPieces() {
            return this.delegate.getNumberOfPieces();
        }

        @Override
        public long getSize() {
            return this.delegate.getSize();
        }

        @Override
        public int getFileCount() {
            return this.delegate.getFileCount();
        }

        @Override
        public TOTorrentFile[] getFiles() {
            return this.delegate.getFiles();
        }

        @Override
        public byte[] getHash() throws TOTorrentException {
            return this.delegate.getHash();
        }

        @Override
        public HashWrapper getHashWrapper() throws TOTorrentException {
            return this.delegate.getHashWrapper();
        }

        @Override
        public void setHashOverride(byte[] hash) throws TOTorrentException {
            throw new TOTorrentException("Not supported", 8);
        }

        @Override
        public boolean getPrivate() {
            return this.delegate.getPrivate();
        }

        @Override
        public void setPrivate(boolean _private) throws TOTorrentException {
            throw new TOTorrentException("Can't amend private attribute", 5);
        }

        @Override
        public boolean hasSameHashAs(TOTorrent other) {
            return this.delegate.hasSameHashAs(other);
        }

        @Override
        public void setAdditionalStringProperty(String name, String value) {
            this.delegate.setAdditionalStringProperty(name, value);
        }

        @Override
        public String getAdditionalStringProperty(String name) {
            return this.delegate.getAdditionalStringProperty(name);
        }

        @Override
        public void setAdditionalByteArrayProperty(String name, byte[] value) {
            this.delegate.setAdditionalByteArrayProperty(name, value);
        }

        @Override
        public byte[] getAdditionalByteArrayProperty(String name) {
            return this.delegate.getAdditionalByteArrayProperty(name);
        }

        @Override
        public void setAdditionalLongProperty(String name, Long value) {
            this.delegate.setAdditionalLongProperty(name, value);
        }

        @Override
        public Long getAdditionalLongProperty(String name) {
            return this.delegate.getAdditionalLongProperty(name);
        }

        @Override
        public void setAdditionalListProperty(String name, List value) {
            this.delegate.setAdditionalListProperty(name, value);
        }

        @Override
        public List getAdditionalListProperty(String name) {
            return this.delegate.getAdditionalListProperty(name);
        }

        @Override
        public void setAdditionalMapProperty(String name, Map value) {
            if (torrentFluffKeyset.contains(name)) {
                try {
                    this.getMonitor().enter();
                    this.delegate.setAdditionalMapProperty(name, value);
                    this.fluff_dirty = true;
                }
                finally {
                    this.getMonitor().exit();
                }
            } else {
                this.delegate.setAdditionalMapProperty(name, value);
            }
        }

        @Override
        public Map getAdditionalMapProperty(String name) {
            block7: {
                if (torrentFluffKeyset.contains(name)) {
                    try {
                        this.getMonitor().enter();
                        Map result = this.delegate.getAdditionalMapProperty(name);
                        if (result != fluffThombstone) break block7;
                        try {
                            Map res;
                            this.restoreState(false, true);
                            Map map = res = this.delegate.getAdditionalMapProperty(name);
                            return map;
                        }
                        catch (Throwable e) {
                            Debug.out("Property '" + name + " lost due to torrent read error", e);
                        }
                    }
                    finally {
                        this.getMonitor().exit();
                    }
                }
            }
            return this.delegate.getAdditionalMapProperty(name);
        }

        @Override
        public Object getAdditionalProperty(String name) {
            block7: {
                if (torrentFluffKeyset.contains(name)) {
                    try {
                        this.getMonitor().enter();
                        Object result = this.delegate.getAdditionalProperty(name);
                        if (result != fluffThombstone) break block7;
                        try {
                            Object res;
                            this.restoreState(false, true);
                            Object object = res = this.delegate.getAdditionalProperty(name);
                            return object;
                        }
                        catch (Throwable e) {
                            Debug.out("Property '" + name + " lost due to torrent read error", e);
                        }
                    }
                    finally {
                        this.getMonitor().exit();
                    }
                }
            }
            return this.delegate.getAdditionalProperty(name);
        }

        @Override
        public void setAdditionalProperty(String name, Object value) {
            if (torrentFluffKeyset.contains(name)) {
                try {
                    this.getMonitor().enter();
                    this.delegate.setAdditionalProperty(name, value);
                    this.fluff_dirty = true;
                }
                finally {
                    this.getMonitor().exit();
                }
            } else {
                this.delegate.setAdditionalProperty(name, value);
            }
        }

        @Override
        public void removeAdditionalProperty(String name) {
            if (this.delegate.getAdditionalProperty(name) == null) {
                return;
            }
            if (torrentFluffKeyset.contains(name)) {
                try {
                    this.getMonitor().enter();
                    this.delegate.removeAdditionalProperty(name);
                    this.fluff_dirty = true;
                }
                finally {
                    this.getMonitor().exit();
                }
            } else {
                this.delegate.removeAdditionalProperty(name);
            }
        }

        @Override
        public void removeAdditionalProperties() {
            try {
                this.getMonitor().enter();
                this.delegate.removeAdditionalProperties();
                this.fluff_dirty = true;
            }
            finally {
                this.getMonitor().exit();
            }
        }

        @Override
        public void serialiseToBEncodedFile(File target_file) throws TOTorrentException {
            try {
                this.getMonitor().enter();
                boolean[] restored = this.restoreState(true, true);
                this.delegate.serialiseToBEncodedFile(target_file);
                if (target_file.equals(this.file)) {
                    this.fluff_dirty = false;
                }
                if (restored[0]) {
                    this.discardPieces(SystemTime.getCurrentTime(), true);
                }
                if (restored[1]) {
                    Iterator it = torrentFluffKeyset.iterator();
                    while (it.hasNext()) {
                        this.delegate.setAdditionalMapProperty((String)it.next(), fluffThombstone);
                    }
                }
            }
            finally {
                this.getMonitor().exit();
            }
        }

        @Override
        public Map serialiseToMap() throws TOTorrentException {
            try {
                this.getMonitor().enter();
                boolean[] restored = this.restoreState(true, true);
                Map result = this.delegate.serialiseToMap();
                if (restored[0]) {
                    this.discardPieces(SystemTime.getCurrentTime(), true);
                }
                if (restored[1]) {
                    Iterator it = torrentFluffKeyset.iterator();
                    while (it.hasNext()) {
                        this.delegate.setAdditionalMapProperty((String)it.next(), fluffThombstone);
                    }
                }
                Map map = result;
                return map;
            }
            finally {
                this.getMonitor().exit();
            }
        }

        @Override
        public void serialiseToXMLFile(File target_file) throws TOTorrentException {
            try {
                this.getMonitor().enter();
                boolean[] restored = this.restoreState(true, true);
                this.delegate.serialiseToXMLFile(target_file);
                if (restored[0]) {
                    this.discardPieces(SystemTime.getCurrentTime(), true);
                }
                if (restored[1]) {
                    Iterator it = torrentFluffKeyset.iterator();
                    while (it.hasNext()) {
                        this.delegate.setAdditionalMapProperty((String)it.next(), fluffThombstone);
                    }
                }
            }
            finally {
                this.getMonitor().exit();
            }
        }

        @Override
        public void addListener(TOTorrentListener l) {
            this.delegate.addListener(l);
        }

        @Override
        public void removeListener(TOTorrentListener l) {
            this.delegate.removeListener(l);
        }

        @Override
        public AEMonitor getMonitor() {
            return this.delegate.getMonitor();
        }

        @Override
        public void print() {
            this.delegate.print();
        }

        @Override
        public String getRelationText() {
            if (this.delegate instanceof LogRelation) {
                return ((LogRelation)((Object)this.delegate)).getRelationText();
            }
            return this.delegate.toString();
        }

        @Override
        public Object[] getQueryableInterfaces() {
            if (this.delegate instanceof LogRelation) {
                return ((LogRelation)((Object)this.delegate)).getQueryableInterfaces();
            }
            return super.getQueryableInterfaces();
        }

        @Override
        public String getUTF8Name() {
            return this.delegate.getUTF8Name();
        }
    }
}

