/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.sharing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.plugins.sharing.ShareException;
import org.gudy.azureus2.plugins.sharing.ShareResource;
import org.gudy.azureus2.pluginsimpl.local.sharing.ShareManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.sharing.ShareResourceImpl;

public class ShareConfigImpl {
    protected ShareManagerImpl manager;
    protected int suspend_level;
    protected boolean save_outstanding;
    protected AEMonitor this_mon = new AEMonitor("ShareConfig");

    protected void loadConfig(ShareManagerImpl _manager) {
        this.manager = _manager;
        try {
            Map map = FileUtil.readResilientConfigFile("sharing.config");
            List resources = (List)map.get("resources");
            if (resources == null) {
                return;
            }
            for (Map r_map : resources) {
                this.manager.deserialiseResource(r_map);
            }
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
        }
    }

    protected void saveConfig() throws ShareException {
        try {
            this.this_mon.enter();
            if (this.suspend_level > 0) {
                this.save_outstanding = true;
                return;
            }
            HashMap map = new HashMap();
            ArrayList list = new ArrayList();
            map.put("resources", list);
            ShareResource[] shares = this.manager.getShares();
            int i = 0;
            while (i < shares.length) {
                HashMap m = new HashMap();
                ((ShareResourceImpl)shares[i]).serialiseResource(m);
                list.add(m);
                ++i;
            }
            FileUtil.writeResilientConfigFile("sharing.config", map);
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected void suspendSaving() {
        try {
            this.this_mon.enter();
            ++this.suspend_level;
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected void resumeSaving() throws ShareException {
        try {
            this.this_mon.enter();
            --this.suspend_level;
            if (this.suspend_level == 0 && this.save_outstanding) {
                this.save_outstanding = false;
                this.saveConfig();
            }
        }
        finally {
            this.this_mon.exit();
        }
    }
}

