/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader;

import java.io.InputStream;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderCancelledException;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderException;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderListener;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderBaseImpl;

public class ResourceDownloaderTimeoutImpl
extends ResourceDownloaderBaseImpl
implements ResourceDownloaderListener {
    protected ResourceDownloaderBaseImpl delegate;
    protected int timeout_millis;
    protected boolean cancelled;
    protected ResourceDownloaderBaseImpl current_downloader;
    protected Object result;
    protected AESemaphore done_sem = new AESemaphore("RDTimeout");
    protected long size = -2L;

    public ResourceDownloaderTimeoutImpl(ResourceDownloaderBaseImpl _parent, ResourceDownloader _delegate, int _timeout_millis) {
        super(_parent);
        this.delegate = (ResourceDownloaderBaseImpl)_delegate;
        this.delegate.setParent(this);
        this.timeout_millis = _timeout_millis;
    }

    @Override
    public String getName() {
        return String.valueOf(this.delegate.getName()) + ": timeout=" + this.timeout_millis;
    }

    @Override
    public long getSize() throws ResourceDownloaderException {
        if (this.size != -2L) {
            return this.size;
        }
        try {
            ResourceDownloaderTimeoutImpl x = new ResourceDownloaderTimeoutImpl(this.getParent(), this.delegate.getClone(this), this.timeout_millis);
            this.addReportListener(x);
            this.size = x.getSizeSupport();
            this.setProperties(x);
        }
        finally {
            if (this.size == -2L) {
                this.size = -1L;
            }
            this.setSize(this.size);
        }
        return this.size;
    }

    @Override
    protected void setSize(long l) {
        this.size = l;
        if (this.size >= 0L) {
            this.delegate.setSize(this.size);
        }
    }

    @Override
    public void setProperty(String name, Object value) throws ResourceDownloaderException {
        this.setPropertySupport(name, value);
        this.delegate.setProperty(name, value);
    }

    @Override
    public ResourceDownloaderBaseImpl getClone(ResourceDownloaderBaseImpl parent) {
        ResourceDownloaderTimeoutImpl c = new ResourceDownloaderTimeoutImpl(this.getParent(), this.delegate.getClone(parent), this.timeout_millis);
        c.setSize(this.size);
        c.setProperties(this);
        return c;
    }

    @Override
    public InputStream download() throws ResourceDownloaderException {
        this.asyncDownload();
        this.done_sem.reserve();
        if (this.result instanceof InputStream) {
            return (InputStream)this.result;
        }
        throw (ResourceDownloaderException)this.result;
    }

    @Override
    public void asyncDownload() {
        try {
            this.this_mon.enter();
            if (!this.cancelled) {
                this.current_downloader = this.delegate.getClone(this);
                this.informActivity(String.valueOf(this.getLogIndent()) + "Downloading: " + this.getName());
                this.current_downloader.addListener(this);
                this.current_downloader.asyncDownload();
                AEThread t = new AEThread("ResourceDownloaderTimeout"){

                    @Override
                    public void runSupport() {
                        try {
                            Thread.sleep(ResourceDownloaderTimeoutImpl.this.timeout_millis);
                            ResourceDownloaderTimeoutImpl.this.cancel(new ResourceDownloaderException(ResourceDownloaderTimeoutImpl.this, "Download timeout"));
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                };
                t.setDaemon(true);
                t.start();
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected long getSizeSupport() throws ResourceDownloaderException {
        this.asyncGetSize();
        this.done_sem.reserve();
        if (this.result instanceof Long) {
            return (Long)this.result;
        }
        throw (ResourceDownloaderException)this.result;
    }

    public void asyncGetSize() {
        try {
            this.this_mon.enter();
            if (!this.cancelled) {
                this.current_downloader = this.delegate.getClone(this);
                AEThread size_thread = new AEThread("ResourceDownloader:size getter"){

                    @Override
                    public void runSupport() {
                        try {
                            long res = ResourceDownloaderTimeoutImpl.this.current_downloader.getSize();
                            ResourceDownloaderTimeoutImpl.this.result = new Long(res);
                            ResourceDownloaderTimeoutImpl.this.setProperties(ResourceDownloaderTimeoutImpl.this.current_downloader);
                            ResourceDownloaderTimeoutImpl.this.done_sem.release();
                        }
                        catch (ResourceDownloaderException e) {
                            ResourceDownloaderTimeoutImpl.this.failed(ResourceDownloaderTimeoutImpl.this.current_downloader, e);
                        }
                    }
                };
                size_thread.setDaemon(true);
                size_thread.start();
                AEThread t = new AEThread("ResourceDownloaderTimeout"){

                    @Override
                    public void runSupport() {
                        try {
                            Thread.sleep(ResourceDownloaderTimeoutImpl.this.timeout_millis);
                            ResourceDownloaderTimeoutImpl.this.cancel(new ResourceDownloaderException(ResourceDownloaderTimeoutImpl.this, "getSize timeout"));
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                };
                t.setDaemon(true);
                t.start();
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void cancel() {
        this.cancel(new ResourceDownloaderCancelledException(this));
    }

    protected void cancel(ResourceDownloaderException reason) {
        this.setCancelled();
        try {
            this.this_mon.enter();
            this.result = reason;
            this.cancelled = true;
            this.informFailed((ResourceDownloaderException)this.result);
            if (this.current_downloader != null) {
                this.current_downloader.cancel();
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public boolean completed(ResourceDownloader downloader, InputStream data) {
        if (this.informComplete(data)) {
            this.result = data;
            this.done_sem.release();
            return true;
        }
        return false;
    }

    @Override
    public void failed(ResourceDownloader downloader, ResourceDownloaderException e) {
        this.result = e;
        this.done_sem.release();
        this.informFailed(e);
    }
}

