/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.bouncycastle.asn1.x509;

import org.gudy.bouncycastle.asn1.ASN1Choice;
import org.gudy.bouncycastle.asn1.ASN1Encodable;
import org.gudy.bouncycastle.asn1.ASN1OctetString;
import org.gudy.bouncycastle.asn1.ASN1Sequence;
import org.gudy.bouncycastle.asn1.ASN1TaggedObject;
import org.gudy.bouncycastle.asn1.DEREncodable;
import org.gudy.bouncycastle.asn1.DERIA5String;
import org.gudy.bouncycastle.asn1.DERObject;
import org.gudy.bouncycastle.asn1.DERObjectIdentifier;
import org.gudy.bouncycastle.asn1.DEROctetString;
import org.gudy.bouncycastle.asn1.DERTaggedObject;
import org.gudy.bouncycastle.asn1.x509.X509Name;
import org.gudy.bouncycastle.util.IPAddress;
import org.gudy.bouncycastle.util.Strings;

public class GeneralName
extends ASN1Encodable
implements ASN1Choice {
    public static final int otherName = 0;
    public static final int rfc822Name = 1;
    public static final int dNSName = 2;
    public static final int x400Address = 3;
    public static final int directoryName = 4;
    public static final int ediPartyName = 5;
    public static final int uniformResourceIdentifier = 6;
    public static final int iPAddress = 7;
    public static final int registeredID = 8;
    DEREncodable obj;
    int tag;

    public GeneralName(X509Name dirName) {
        this.obj = dirName;
        this.tag = 4;
    }

    public GeneralName(DERObject name, int tag) {
        this.obj = name;
        this.tag = tag;
    }

    public GeneralName(int tag, ASN1Encodable name) {
        this.obj = name;
        this.tag = tag;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GeneralName(int tag, String name) {
        this.tag = tag;
        if (tag == 1 || tag == 2 || tag == 6) {
            this.obj = new DERIA5String(name);
            return;
        } else if (tag == 8) {
            this.obj = new DERObjectIdentifier(name);
            return;
        } else if (tag == 4) {
            this.obj = new X509Name(name);
            return;
        } else {
            if (tag != 7) throw new IllegalArgumentException("can't process String for tag: " + tag);
            if (!IPAddress.isValid(name)) throw new IllegalArgumentException("IP Address is invalid");
            this.obj = new DEROctetString(Strings.toUTF8ByteArray(name));
        }
    }

    public static GeneralName getInstance(Object obj) {
        if (obj == null || obj instanceof GeneralName) {
            return (GeneralName)obj;
        }
        if (obj instanceof ASN1TaggedObject) {
            ASN1TaggedObject tagObj = (ASN1TaggedObject)obj;
            int tag = tagObj.getTagNo();
            switch (tag) {
                case 0: {
                    return new GeneralName(tag, ASN1Sequence.getInstance(tagObj, false));
                }
                case 1: {
                    return new GeneralName(tag, DERIA5String.getInstance(tagObj, false));
                }
                case 2: {
                    return new GeneralName(tag, DERIA5String.getInstance(tagObj, false));
                }
                case 3: {
                    throw new IllegalArgumentException("unknown tag: " + tag);
                }
                case 4: {
                    return new GeneralName(tag, ASN1Sequence.getInstance(tagObj, true));
                }
                case 5: {
                    return new GeneralName(tag, ASN1Sequence.getInstance(tagObj, false));
                }
                case 6: {
                    return new GeneralName(tag, DERIA5String.getInstance(tagObj, false));
                }
                case 7: {
                    return new GeneralName(tag, ASN1OctetString.getInstance(tagObj, false));
                }
                case 8: {
                    return new GeneralName(tag, DERObjectIdentifier.getInstance(tagObj, false));
                }
            }
        }
        throw new IllegalArgumentException("unknown object in getInstance");
    }

    public static GeneralName getInstance(ASN1TaggedObject tagObj, boolean explicit) {
        return GeneralName.getInstance(ASN1TaggedObject.getInstance(tagObj, true));
    }

    public int getTagNo() {
        return this.tag;
    }

    public DEREncodable getName() {
        return this.obj;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.tag);
        buf.append(": ");
        switch (this.tag) {
            case 1: 
            case 2: 
            case 6: {
                buf.append(DERIA5String.getInstance(this.obj).getString());
                break;
            }
            case 4: {
                buf.append(X509Name.getInstance(this.obj).toString());
                break;
            }
            default: {
                buf.append(this.obj.toString());
            }
        }
        return buf.toString();
    }

    @Override
    public DERObject toASN1Object() {
        if (this.tag == 4) {
            return new DERTaggedObject(true, this.tag, this.obj);
        }
        return new DERTaggedObject(false, this.tag, this.obj);
    }
}

