/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.stmt.mapped;

import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.stmt.mapped.BaseMappedStatement;
import com.j256.ormlite.table.TableInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappedUpdate<T, ID>
extends BaseMappedStatement<T, ID> {
    private MappedUpdate(TableInfo<T> tableInfo, String statement, List<FieldType> argFieldTypeList) {
        super(tableInfo, statement, argFieldTypeList);
    }

    public static <T, ID> MappedUpdate<T, ID> build(DatabaseType databaseType, TableInfo<T> tableInfo) throws SQLException {
        FieldType idField = tableInfo.getIdField();
        if (idField == null) {
            throw new SQLException("Cannot update " + tableInfo.getDataClass() + " because it doesn't have an id field");
        }
        if (tableInfo.getFieldTypes().length == 1) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        ArrayList<FieldType> argFieldTypeList = new ArrayList<FieldType>();
        MappedUpdate.appendTableName(databaseType, sb, "UPDATE ", tableInfo.getTableName());
        boolean first = true;
        for (FieldType fieldType : tableInfo.getFieldTypes()) {
            if (fieldType == idField) continue;
            if (first) {
                sb.append("SET ");
                first = false;
            } else {
                sb.append(", ");
            }
            MappedUpdate.appendFieldColumnName(databaseType, sb, fieldType, argFieldTypeList);
            sb.append("= ?");
        }
        sb.append(' ');
        MappedUpdate.appendWhereId(databaseType, idField, sb, argFieldTypeList);
        return new MappedUpdate<T, ID>(tableInfo, sb.toString(), argFieldTypeList);
    }
}

