package com.webworxshop.swallowcatcher;

import android.app.Activity;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.view.View;
import android.app.Dialog;
import android.app.ProgressDialog;
import android.app.AlertDialog;
import android.content.DialogInterface;

public class OpmlImportActivity extends Activity 
{
	@Override
    public void onCreate(Bundle savedInstanceState)
    {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.opml_import_view);
        
        View button = findViewById(R.id.opml_do_import);
        button.setOnClickListener(listener);
        
        setTitle("OPML Import");
    }
    
    private final View.OnClickListener listener = new View.OnClickListener()
    {
    	public void onClick(View v)
    	{
    		progress_dialog = ProgressDialog.show(OpmlImportActivity.this, "", getString(R.string.opml_in_progress), true);
    		worker = new OpmlImportThread(handler, OpmlImportActivity.this);
    		worker.start();
    	}
    };
    
    public final Handler handler = new Handler()
    {
		public void handleMessage(Message msg)
		{
			progress_dialog.dismiss();
			int status = msg.getData().getInt("status");
			String status_msg = "";
			String status_title = "";
			switch(status)
			{
				case SUCCESS_IMPORT_COMPLETE:
					// show the success dialog
					OpmlImportActivity.this.success = true;
					int subs = msg.getData().getInt("saved");
					status_msg = "OPML import was succesful, " + subs + " subscriptions were added.";
					status_title = getString(R.string.success_alert_title);
					break;
				case ERROR_MEDIA_UNAVAILABLE:
					status_msg = getString(R.string.opml_media_unavailable);
					status_title = getString(R.string.err_alert_title);
					break;
				case ERROR_FILE_NO_EXIST:
					status_msg = getString(R.string.opml_file_no_exist);
					status_title = getString(R.string.err_alert_title);
					break;
				case ERROR_FILE_NOT_READABLE:
					status_msg = getString(R.string.opml_file_not_readable);
					status_title = getString(R.string.err_alert_title);
					break;
				case ERROR_PARSE:
					status_msg = getString(R.string.opml_cant_parse);
					status_title = getString(R.string.err_alert_title);
					break;
				case ERROR_SQL:
					status_msg = getString(R.string.opml_sql_error);
					status_title = getString(R.string.err_alert_title);
					break;
			}
			AlertDialog.Builder builder = new AlertDialog.Builder(OpmlImportActivity.this);
			builder.setTitle(status_title).setMessage(status_msg).setCancelable(false).setPositiveButton(getString(R.string.ok), new DialogInterface.OnClickListener()
			{
				public void onClick(DialogInterface dialog, int id)
				{
    				dialog.dismiss();
    				if(OpmlImportActivity.this.success)
    				{
    					AlertDialog.Builder builder = new AlertDialog.Builder(OpmlImportActivity.this);
						builder.setTitle("Refresh Feeds?").setMessage("Do you wish to download all feed information now?").setPositiveButton("Charge!", new DialogInterface.OnClickListener()
						{
							public void onClick(DialogInterface dialog, int id)
							{
								OpmlImportActivity.this.finish();
								Message msg = main_activity.menu_handler.obtainMessage();
								Bundle b = new Bundle();
								b.putInt("item", MainActivity.ITEM_REFRESH);
								b.putLong("feed", -1);
								msg.setData(b);
								main_activity.menu_handler.sendMessage(msg);
							}
						}).setNegativeButton("Run Away!", new DialogInterface.OnClickListener()
						{
							public void onClick(DialogInterface dialog, int id)
							{
								OpmlImportActivity.this.finish();
							}
						});
						AlertDialog alert = builder.create();
						alert.show();
					}
				}
			});
			AlertDialog alert = builder.create();
			alert.show();
		}
	};

	public static void setMainActivity(MainActivity m)
	{
		main_activity = m;
	}
    
    private static MainActivity main_activity;
	private ProgressDialog progress_dialog;
	private OpmlImportThread worker;
	private boolean success = false;
	
	public final static int SUCCESS_IMPORT_COMPLETE = 0;
	public final static int ERROR_MEDIA_UNAVAILABLE = 1;
	public final static int ERROR_FILE_NO_EXIST = 2;
	public final static int ERROR_FILE_NOT_READABLE = 3;
	public final static int ERROR_PARSE = 4;
	public final static int ERROR_SQL = 5;
}
