package com.webworxshop.swallowcatcher;

import android.app.ListActivity;
import android.os.Bundle;
import android.os.Message;
import android.view.View;
import android.content.Intent;
import android.widget.ArrayAdapter;
import android.widget.ListView;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.AdapterView.AdapterContextMenuInfo;
import android.view.MenuItem;
import android.view.MenuInflater;
import android.view.ContextMenu;
import android.view.ContextMenu.ContextMenuInfo;
import android.content.DialogInterface;
import android.app.AlertDialog;
import android.app.AlertDialog.Builder;
import android.util.Log;

import java.util.List;
import java.sql.SQLException;

import com.j256.ormlite.android.apptools.OpenHelperManager;
import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.stmt.DeleteBuilder;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.PreparedQuery;

import com.webworxshop.swallowcatcher.db.Subscription;
import com.webworxshop.swallowcatcher.db.Episode;
import com.webworxshop.swallowcatcher.db.DatabaseHelper;

public class PodcastsListActivity extends ListActivity 
{
	/** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState)
    {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.podcasts_list_view);
        
        View opml_button = findViewById(R.id.opml_import);
        opml_button.setOnClickListener(opml_listener);
        View add_button = findViewById(R.id.add_podcast);
        add_button.setOnClickListener(add_listener);
        
        ListView lv = getListView();
        lv.setTextFilterEnabled(true);
		
		lv.setOnItemClickListener(new OnItemClickListener()
		{
			public void onItemClick(AdapterView<?> parent, View view, int position, long id)
			{
				Log.i("SwallowCatcher", "position: " + position);
				int feed_id = adapter.getItem(position).getID();
				Log.i("SwallowCatcher", "feed id: " + feed_id);
				
				Intent i = new Intent(PodcastsListActivity.this, EpisodesListActivity.class);
				i.putExtra("feed_id", feed_id);
				startActivity(i);
			}
		});
		
		registerForContextMenu(getListView());
    }
    
    @Override
    public void onResume()
    {
    	super.onResume();
    	
    	try
    	{
    		int position = getListView().getFirstVisiblePosition();
    	
			helper = (DatabaseHelper)OpenHelperManager.getHelper(this);
			dao = helper.getSubscriptionDao();
			QueryBuilder<Subscription, Object> queryBuilder = dao.queryBuilder();
			queryBuilder.orderBy(Subscription.COL_NAME, true);
			PreparedQuery<Subscription> preparedQuery = queryBuilder.prepare();
			subs = dao.query(preparedQuery);
			
			if(subs.size() > 0)
			{
				adapter = new ArrayAdapter(this, android.R.layout.simple_list_item_1, subs); 
				setListAdapter(adapter);
			}
			
			main_activity.setTitle("SwallowCatcher (" + subs.size() + ")");
			
			getListView().setSelection(position);
		}
		catch(SQLException e)
		{
			Log.e("SwallowCatcher", "Error getting podcasts from db", e);
		}
    }
    
    @Override
    protected void onPause()
    {
    	super.onPause();
    	OpenHelperManager.release();
   		helper = null;
    }
    
    private final View.OnClickListener opml_listener = new View.OnClickListener()
    {
    	public void onClick(View v)
    	{
    		Intent opmlIntent = new Intent().setClass(getApplicationContext(), OpmlImportActivity.class);
    		startActivity(opmlIntent);
    	}
    };
    
    private final View.OnClickListener add_listener = new View.OnClickListener()
    {
    	public void onClick(View v)
    	{
    		final CharSequence[] items = {getString(R.string.add_by_url), getString(R.string.add_by_barcode)};
    		
    		AlertDialog.Builder builder = new AlertDialog.Builder(PodcastsListActivity.this);
			builder.setTitle("Add Feed").setItems(items, new DialogInterface.OnClickListener() 
			{
				public void onClick(DialogInterface dialog, int item)
				{
					Message msg = main_activity.menu_handler.obtainMessage();
					Bundle b = new Bundle();
					switch(item)
					{
						case 0:
							b.putInt("item", MainActivity.ITEM_URL);
							break;
						case 1:
							b.putInt("item", MainActivity.ITEM_BARCODE);
							break;
					}
					msg.setData(b);
					main_activity.menu_handler.sendMessage(msg);	
					dialog.dismiss();
				}
			});
			AlertDialog alert = builder.create();
			alert.show();
    	}
    };
    
    @Override
	public void onCreateContextMenu(ContextMenu menu, View v, ContextMenuInfo menuInfo)
	{
		super.onCreateContextMenu(menu, v, menuInfo);
		MenuInflater inflater = getMenuInflater();
		inflater.inflate(R.menu.podcasts_context_menu, menu);
	}
	
	@Override
	public boolean onContextItemSelected(MenuItem item)
	{
		AdapterContextMenuInfo info = (AdapterContextMenuInfo) item.getMenuInfo();
		switch (item.getItemId())
		{
			case R.id.refresh_podcast_feed:
				refreshFeed(info.id);
				return true;
			case R.id.share_podcast_feed:
				sharePodcast(info.id);
				return true;
			case R.id.delete_podcast_feed:
				deletePodcast(info.id);
				return true;
			default:
				return super.onContextItemSelected(item);
		}
	}
	
	public void refreshFeed(long id)
	{
		Message msg = main_activity.menu_handler.obtainMessage();
		Bundle b = new Bundle();
		b.putInt("item", MainActivity.ITEM_REFRESH);
		
		Subscription s = subs.get((int)id);
		b.putLong("feed", s.getID());
		msg.setData(b);
		main_activity.menu_handler.sendMessage(msg);
	}
	
	public void sharePodcast(long id)
	{
		Subscription s = subs.get((int)id);
		Intent i = new Intent(Intent.ACTION_SEND);
		i.setType("text/plain");
		i.putExtra(Intent.EXTRA_TEXT, "Awesome podcast recommendation: " + s.getName() + " " + s.getURL());
		startActivity(i);
	}
	
	public void deletePodcast(long id)
	{
		try
		{
			Subscription s = subs.get((int)id);
			Dao<Episode, Object> ep_dao = helper.getEpisodeDao();
			DeleteBuilder<Episode, Object> db = ep_dao.deleteBuilder();
			db.where().eq(Episode.COL_SUB, s);
			ep_dao.delete(db.prepare());
			dao.delete(s);
			subs.remove(s);
			adapter.notifyDataSetChanged();
		}
		catch(SQLException e)
		{
			// TODO: handle this better!
			Log.e("SwallowCatcher", "Unable to delete subscription!", e);
		}
	}
	
	public static void setMainActivity(MainActivity m)
	{
		main_activity = m;
	}
    
    private static MainActivity main_activity;
    private DatabaseHelper helper = null;
    private Dao<Subscription, Object> dao = null;
    private List<Subscription> subs = null;
    private ArrayAdapter<Subscription> adapter = null;
}

