package com.webworxshop.swallowcatcher.db;

import java.sql.SQLException;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.util.Log;

import com.j256.ormlite.android.apptools.OrmLiteSqliteOpenHelper;
import com.j256.ormlite.dao.BaseDaoImpl;
import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.table.TableUtils;

import com.webworxshop.swallowcatcher.downloads.Download;

public class DatabaseHelper extends OrmLiteSqliteOpenHelper
{
	public DatabaseHelper(Context context)
	{
		super(context, DB_NAME, null, DB_VERSION);
	}
	
	@Override
	public void onCreate(SQLiteDatabase db, ConnectionSource connectionSource)
	{
		try
		{
			Log.i(DatabaseHelper.class.getName(), "onCreate");
			TableUtils.createTable(connectionSource, Subscription.class);
			TableUtils.createTable(connectionSource, Episode.class);
			TableUtils.createTable(connectionSource, Download.class);
		} 
		catch (SQLException e)
		{
			Log.e(DatabaseHelper.class.getName(), "Can't create database", e);
			throw new RuntimeException(e);
		}
	}
	
	@Override
	public void onUpgrade(SQLiteDatabase db, ConnectionSource connectionSource, int oldVersion, int newVersion)
	{
		try
		{
			Log.i(DatabaseHelper.class.getName(), "onUpgrade");
			if(oldVersion == 1 && newVersion == 2)
			{
				TableUtils.createTable(connectionSource, Download.class);
			}
		}
		catch (SQLException e)
		{
			Log.e(DatabaseHelper.class.getName(), "Can't upgrade databases", e);
			throw new RuntimeException(e);
		}
	}
	
	public Dao<Subscription, Object> getSubscriptionDao() throws SQLException
	{
		if (subscriptionDao == null)
		{
			subscriptionDao = BaseDaoImpl.createDao(getConnectionSource(), Subscription.class);
		}
		return subscriptionDao;
	}
	
	public Dao<Episode, Object> getEpisodeDao() throws SQLException
	{
		if (episodeDao == null)
		{
			episodeDao = BaseDaoImpl.createDao(getConnectionSource(), Episode.class);
		}
		return episodeDao;
	}

	@Override
	public void close()
	{
		super.close();
		subscriptionDao = null;
		episodeDao = null;
	}
	
	private Dao<Subscription, Object> subscriptionDao = null;
	private Dao<Episode, Object> episodeDao = null;
	public static final String DB_NAME = "swallowcatcher.db";
	public static final int DB_VERSION = 2;
}

