
package com.webworxshop.swallowcatcher.downloads;

import android.widget.ArrayAdapter;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.view.LayoutInflater;
import android.widget.TextView;
import android.widget.ProgressBar;

import java.util.ArrayList;

import com.webworxshop.swallowcatcher.R;

public class DownloadListAdapter extends ArrayAdapter<Download>
{
	private ArrayList<Download> items;
	private ArrayList<ProgressBar> progress_bars = new ArrayList<ProgressBar>();
	private Context context;
	
	public DownloadListAdapter(Context context, int textViewResourceId, ArrayList<Download> items)
	{
		super(context, textViewResourceId, items);
		this.context = context;
		this.items = items;
	}
	
	@Override
	public View getView(int position, View convertView, ViewGroup parent)
	{
		View v = convertView;
		if(v == null)
		{
			LayoutInflater vi = (LayoutInflater)context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
			v = vi.inflate(R.layout.downloads_list_item, null);
		}
		Download d = items.get(position);
		if(d != null)
		{
			TextView tt = (TextView)v.findViewById(R.id.download_text);
			if(tt != null)
			{
				tt.setText(d.toString());
			}
			ProgressBar pb = (ProgressBar)v.findViewById(R.id.download_progress);
			if(pb != null)
			{
				pb.setProgress(d.getProgress());
				progress_bars.add(pb);
			}
		}
		return v;
	}
	
	public void updateProgress()
	{
		for(int i = 0; i < progress_bars.size(); i++)
		{
			if(items.size() > i)
			{
				progress_bars.get(i).setProgress(items.get(i).getProgress());
			}
		}
	}
}
