package com.webworxshop.swallowcatcher.feeds;

import android.os.Handler;
import android.os.Message;
import android.os.Bundle;
import android.content.Context;
import android.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.sql.SQLException;
import java.util.List;
import org.w3c.dom.*;
import org.w3c.tidy.Tidy;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.DocumentBuilder;
import org.xml.sax.SAXException;

import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.HttpResponse;
import org.apache.http.HttpEntity;

import com.webworxshop.swallowcatcher.db.Subscription;
import com.webworxshop.swallowcatcher.db.Episode;
import com.webworxshop.swallowcatcher.db.DatabaseHelper;

import com.j256.ormlite.android.apptools.OpenHelperManager;
import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.PreparedQuery;

public class FeedDownloadThread extends Thread
{
	public FeedDownloadThread(Handler h, Context c, Subscription s)
	{
		handler = h;
		context = c;
		sub = s;
	}
	
	public void run()
	{
		try
		{
			List<Subscription> subs;
			DatabaseHelper helper = (DatabaseHelper)OpenHelperManager.getHelper(context);
			Dao<Subscription, Object> sub_dao = helper.getSubscriptionDao();
			if(sub == null)
			{
				// get list of feeds from database
				subs = sub_dao.queryForAll();
			}
			else
			{
				subs = new ArrayList<Subscription>();
				subs.add(sub);
			}
			
			// calculate progress increment
			increment = 100/subs.size();
			
			// grab the feed urls
			DefaultHttpClient client = new DefaultHttpClient();
			for(int i = 0; i < subs.size(); i++)
			{
				HttpGet method = new HttpGet(subs.get(i).getURL());
				Log.i("SwallowCatcher", "Getting feed: " + subs.get(i).getURL());
				
				try
				{
					HttpResponse response = client.execute(method);
					HttpEntity entity = response.getEntity();
					
					if(entity != null)
					{
						Log.i("SwallowCatcher", "Fetching feed: " + subs.get(i).getURL());
						// do something with the response
						InputStream instream = entity.getContent();
						
						ArrayList<Episode> data;
						try
						{
							data = parseRSS(instream, subs.get(i), sub_dao);
							Dao<Episode, Object> ep_dao = helper.getEpisodeDao();
							boolean first = true;
							for(Episode e : data)
							{
								QueryBuilder<Episode, Object> qb = ep_dao.queryBuilder();
								qb.where().eq(Episode.COL_GUID, e.getGUID());
								PreparedQuery p = qb.prepare();
								//Log.i("SwallowCatcher", "Query: " + p.getStatement());
								if(ep_dao.queryForFirst(p) == null)
								{
									if(subs.get(i).getNew() && !first)
									{
										e.setStatus("old");
									}
									else
									{
										e.setStatus("new");
									}
									//Log.i("SwallowCatcher", "Found New Episode: " + e);
									ep_dao.create(e);
								}
								first = false;
							}
							subs.get(i).setNew(false);
							sub_dao.update(subs.get(i));
						}
						catch(RuntimeException e)
						{
							Log.e("SwallowCatcher", "RSS parsing error!", e);
						}
						catch(SQLException e)
						{
							Log.e("SwallowCatcher", "Error inserting episode in database!", e);
						}
						instream.close();
						Log.i("SwallowCatcher", "Fetch complete");
					}
					else
					{
						// handle this!
						Log.i("SwallowCatcher", "Unable to fetch feed");
					}
				}
				catch(IOException e)
				{
					// handle error better than this
					Log.e("SwallowCatcher", "HTTP error!", e);
				}
				
				Log.i("SwallowCatcher", "read feed");
				setProgress(increment);
			}
			OpenHelperManager.release();
			setProgress(100);
		}
		catch(SQLException e)
		{
			// TODO: handle this better
			Log.e("SwallowCatcher", "Cannot retrieve subscriptions!", e);
		}
	}
	
	protected void setProgress(int p)
	{
		Message msg = handler.obtainMessage();
		Bundle b = new Bundle();
		b.putInt("progress", p);
		msg.setData(b);
		handler.sendMessage(msg);
	}
	
	protected ArrayList<Episode> parseRSS(InputStream input, Subscription sub, Dao<Subscription, Object> sub_dao)
	{
		try
		{
			Document dom;
			try
			{
				// try and parse with the standard parser first
				DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
				DocumentBuilder builder = factory.newDocumentBuilder();
				dom = builder.parse(input);
			}
			catch(SAXException ex)
			{
				// hmmm, bad xml. Fall back to using JTidy.
				// This is slower, but will adjust for bad XML
				Log.i("SwallowCatcher", "Problem with feed XML falling back to JTidy parser.");
				Tidy tidy = new Tidy();
				tidy.setXmlTags(true);
				dom = tidy.parseDOM(input, null);
			}
			
			Node channel = dom.getDocumentElement().getElementsByTagName("channel").item(0);
			NodeList items = channel.getChildNodes();
			
			ArrayList<Episode> data = new ArrayList<Episode>();
			for(int i = 0; i < items.getLength(); i++)
			{
				Node item = items.item(i);
				// update subscription details
				if(item.getNodeName().equals("title"))
				{
					sub.setName(item.getFirstChild().getNodeValue());
					continue;
				}
				else if(item.getNodeName().equals("description"))
				{
					// fix lo feed fail!
					if(item.getFirstChild() != null)
					{
						sub.setDescription(item.getFirstChild().getNodeValue());
					}
					continue;
				}
				else if(!item.getNodeName().equals("item"))
				{
					continue;
				}
				
				Episode e = new Episode();
				e.setSubscription(sub);
				Log.i("SwallowCatcher", "subscription: " + sub.getID());
				
				NodeList children = item.getChildNodes();
				for(int j = 0; j < children.getLength(); j++)
				{
					Node child = children.item(j);
					if(child.getNodeName().equals("title"))
					{
						e.setTitle(child.getFirstChild().getNodeValue());
						Log.i("SwallowCatcher", "title: " + child.getFirstChild().getNodeValue());
					}
					else if(child.getNodeName().equals("guid"))
					{
						e.setGUID(child.getFirstChild().getNodeValue());
						Log.i("SwallowCatcher", "guid: " + child.getFirstChild().getNodeValue());
					}
					else if(child.getNodeName().equals("link"))
					{
						e.setLink(child.getFirstChild().getNodeValue());
						//Log.i("SwallowCatcher", "link: " + child.getFirstChild().getNodeValue());
					}
					else if(child.getNodeName().equals("description"))
					{
						e.setDescription(child.getFirstChild().getNodeValue());
						//Log.i("SwallowCatcher", "desc: " + child.getFirstChild().getNodeValue());
					}
					else if(child.getNodeName().equals("pubDate"))
					{
						e.setDate(child.getFirstChild().getNodeValue());
						Log.i("SwallowCatcher", "date: " + child.getFirstChild().getNodeValue());
					}
					else if(child.getNodeName().equals("enclosure"))
					{
						NamedNodeMap attmap = child.getAttributes();
						e.setFileLink(attmap.getNamedItem("url").getNodeValue());
						//Log.i("SwallowCatcher", "file link: " + attmap.getNamedItem("url").getNodeValue());
					}
				}
				if(e.getGUID() == null)
				{
					Log.i("SwallowCatcher", "GUID was null, setting to link!");
					e.setGUID(e.getLink());
				}
				data.add(e);
			}
			sub_dao.update(sub);
			return data;
		}
		catch(Exception e)
		{
			throw new RuntimeException(e);
		}
	}

	private int increment;
	private Handler handler;
	private Context context;
	private Subscription sub = null;
}
