/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.support;

import com.j256.ormlite.logger.Logger;
import com.j256.ormlite.support.DatabaseConnection;
import java.sql.SQLException;

public abstract class BaseConnectionSource {
    protected boolean usedSpecialConnection = false;
    private ThreadLocal<NestedConnection> specialConnection = new ThreadLocal();

    protected DatabaseConnection getSavedConnection() throws SQLException {
        if (!this.usedSpecialConnection) {
            return null;
        }
        NestedConnection nested = this.specialConnection.get();
        if (nested == null) {
            return null;
        }
        return nested.connection;
    }

    protected boolean isSavedConnection(DatabaseConnection connection) throws SQLException {
        if (!this.usedSpecialConnection) {
            return false;
        }
        NestedConnection currentSaved = this.specialConnection.get();
        if (currentSaved == null) {
            return false;
        }
        return currentSaved.connection == connection;
    }

    protected boolean saveSpecial(DatabaseConnection connection) {
        NestedConnection currentSaved = this.specialConnection.get();
        if (currentSaved == null) {
            this.usedSpecialConnection = true;
            this.specialConnection.set(new NestedConnection(connection));
            return true;
        }
        if (currentSaved.connection != connection) {
            throw new IllegalStateException("trying to save connection " + connection + " but already have saved connection " + currentSaved.connection);
        }
        currentSaved.increment();
        return false;
    }

    protected void clearSpecial(DatabaseConnection connection, Logger logger) {
        NestedConnection currentSaved = this.specialConnection.get();
        if (currentSaved == null) {
            logger.error("no connection has been saved when clear() called", new Object[0]);
        } else if (currentSaved.connection != connection) {
            logger.error("connection saved {} is not the one being cleared {}", currentSaved.connection, connection);
        } else if (currentSaved.decrementAndGet() == 0) {
            this.specialConnection.set(null);
        }
    }

    private class NestedConnection {
        public final DatabaseConnection connection;
        private int nestedC;

        public NestedConnection(DatabaseConnection connection) {
            this.connection = connection;
            this.nestedC = 1;
        }

        public void increment() {
            ++this.nestedC;
        }

        public int decrementAndGet() {
            --this.nestedC;
            return this.nestedC;
        }
    }
}

